/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.common.icons.CommonIcon;
import com.mathworks.html.RequestHandler;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlwidgets.html.CharsetDetectionStrategy;
import com.mathworks.mlwidgets.html.HTMLAcceleratorHelper;
import com.mathworks.mlwidgets.html.HTMLCallbackProvider;
import com.mathworks.mlwidgets.html.HTMLPrefs;
import com.mathworks.mlwidgets.html.HTMLRendererActions;
import com.mathworks.mlwidgets.html.HTMLRendererSupport;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mlwidgets.html.ICERenderer;
import com.mathworks.mlwidgets.html.JarFileLinkListener;
import com.mathworks.mlwidgets.html.LinkClickedHandler;
import com.mathworks.mlwidgets.html.PageChangedListener;
import com.mathworks.mlwidgets.html.WebRenderer;
import com.mathworks.mwswing.FileExtensionFilter;
import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.services.FontListener;
import com.mathworks.services.FontPrefs;
import com.mathworks.util.FileUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.PostVMInit;
import com.mathworks.widgets.CloseableMessageBar;
import com.mathworks.widgets.HyperlinkTextLabel;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.widgets.find.FindClientInterface;
import com.mathworks.widgets.find.FindClientRegistry;
import com.mathworks.widgets.find.FindDialog;
import com.mathworks.widgets.find.FindEvent;
import com.mathworks.widgets.find.FindParentListener;
import com.mathworks.widgets.text.xml.XMLKit;
import com.mathworks.widgets.text.xml.XMLLanguage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.text.EditorKit;

public class HTMLRenderer
extends MJPanel
implements HTMLCallbackProvider {
    private static final int MAX_URL_LENGTH = 4096;
    private static String sMatlabRoot = null;
    private ActionListener fMouseOverLinkListener;
    private String fFileNotFoundTemplate;
    private String fHomeUrl;
    private JarFileLinkListener fJarFileLinkListener;
    private LinkClickedHandler fLinkClickedHandler;
    private HTMLFontListener fFontListener;
    private List<RequestHandler> fRequestHandlers = new ArrayList<RequestHandler>();
    private HTMLFindClientInterface fFindClientInterface;
    private FindParentListener fFindListener;
    private HTMLRendererActions fActions;
    private ActionListener fReloadActionListener = null;
    private boolean fNavigationEnabled = true;
    private boolean fUseSystemBrowserForExternalLinks = false;
    private boolean fDontClearMainStatusBar = false;
    private boolean fShowTitleWhenUrlNotFound = true;
    private HTMLAcceleratorHelper fAccelHelper;
    protected HTMLRendererSupport fBrowser = null;
    private WebRendererCreationListener fCreationListener;
    private static boolean sUseWebRenderer = HTMLRenderer.getUseWebRenderer();
    private List<PageChangedListener> fPageChangedListeners = new Vector<PageChangedListener>();
    private InfoMessageBar fInfoMessageBar;
    private int fBrowserId = -1;
    public static final String POPUP_FRAME_NAME = "HtmlPopupFrame";

    public static String[] getClassNames() {
        if (sUseWebRenderer) {
            return WebRenderer.getClassNames();
        }
        return ICERenderer.getClassNames();
    }

    public static void setUseWebRenderer(boolean bl) {
        if (HTMLRenderer.isWebRendererSupported()) {
            HTMLPrefs.setUseWebRenderer(bl);
        } else {
            bl = false;
        }
        sUseWebRenderer = bl;
    }

    public static boolean getUseWebRenderer() {
        if (HTMLRenderer.isWebRendererSupported()) {
            return HTMLPrefs.getUseWebRenderer();
        }
        return false;
    }

    private static boolean isWebRendererSupported() {
        return PlatformInfo.isLinux() && !PlatformInfo.isLinux64();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.fBrowser.setVisible(bl);
    }

    public String getLocalhostPrefix() {
        return this.fBrowser.getLocalhostPrefix();
    }

    public static HTMLRenderer createRenderer() {
        if (!Matlab.isMatlabAvailable()) {
            PostVMInit.perform((boolean)true, (boolean)false);
        }
        HTMLRenderer hTMLRenderer = new HTMLRenderer();
        MJFrame mJFrame = new MJFrame("HTML Renderer");
        hTMLRenderer.addPageChangedListener(new MyPageChangedListener(mJFrame));
        mJFrame.getContentPane().setLayout(new BorderLayout());
        mJFrame.getContentPane().add((Component)((Object)hTMLRenderer), "Center");
        mJFrame.setSize(800, 600);
        mJFrame.setLocation(20, 40);
        mJFrame.setVisible(true);
        mJFrame.setDefaultCloseOperation(2);
        return hTMLRenderer;
    }

    public HTMLRenderer() {
        this(false);
    }

    public HTMLRenderer(boolean bl) {
        HTMLRendererSupport hTMLRendererSupport;
        this.fActions = new HTMLRendererActions(this, this.fNavigationEnabled);
        if (sUseWebRenderer && !bl) {
            this.fCreationListener = new WebRendererCreationListener();
            hTMLRendererSupport = new WebRenderer(this.fCreationListener);
        } else {
            hTMLRendererSupport = new ICERenderer();
        }
        ((HTMLRendererSupport)hTMLRendererSupport).createRenderer(this);
        this.setLayout(new BorderLayout());
        this.addBrowser(hTMLRendererSupport);
    }

    public void addInfoMessageBar(String string) {
        this.addInfoMessageBar(string, new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                HTMLRenderer.this.setCurrentLocation(string);
            }
        });
    }

    public void addInfoMessageBar(String string, HyperlinkTextLabel.HyperlinkHandler hyperlinkHandler) {
        if (this.fInfoMessageBar != null) {
            this.fInfoMessageBar.remove();
        }
        this.fInfoMessageBar = new InfoMessageBar(string, hyperlinkHandler);
        this.add(this.fInfoMessageBar.getComponent(), "North");
        this.revalidate();
    }

    public void removeInfoMessageBar() {
        if (this.fInfoMessageBar != null) {
            this.fInfoMessageBar.remove();
        }
    }

    public void addRequestHandler(RequestHandler requestHandler) {
        this.fRequestHandlers.add(requestHandler);
    }

    public List<RequestHandler> getRequestHandlers() {
        return this.fRequestHandlers;
    }

    private void addBrowser(HTMLRendererSupport hTMLRendererSupport) {
        boolean bl;
        boolean bl2 = bl = this.fBrowser == null;
        if (!bl) {
            this.remove((Component)((Object)this.fBrowser));
        }
        this.fBrowser = hTMLRendererSupport;
        this.add((Component)((Object)this.fBrowser), "Center");
        Font font = FontPrefs.getHtmlProportionalFont();
        this.setHTMLFont(font);
        if (bl) {
            this.fFontListener = new HTMLFontListener();
            FontPrefs.addFontListener((String)FontPrefs.HTML_FONT_COMPONENT_NAME, (FontListener)this.fFontListener);
            this.fFileNotFoundTemplate = HTMLUtils.DEFAULT_FILE_NOT_FOUND_TEMPLATE;
            this.fAccelHelper = new HTMLAcceleratorHelper((JComponent)((Object)this));
            List<MJAbstractAction> list = this.getActions().getAllActions();
            for (MJAbstractAction mJAbstractAction : list) {
                this.fAccelHelper.addAction((Action)mJAbstractAction);
            }
        }
    }

    HTMLRendererSupport getRendererBrowser() {
        return this.fBrowser;
    }

    HTMLAcceleratorHelper getAcceleratorHelper() {
        return this.fAccelHelper;
    }

    static void setMatlabRoot(String string) {
        sMatlabRoot = string;
    }

    static String getMatlabRoot() {
        if (sMatlabRoot != null) {
            return sMatlabRoot;
        }
        if (Matlab.isMatlabAvailable()) {
            return Matlab.matlabRoot();
        }
        return null;
    }

    public void addNotify() {
        super.addNotify();
        if (this.fFindClientInterface != null) {
            this.setupFindInterface();
        }
    }

    public HTMLRendererActions getActions() {
        return this.fActions;
    }

    void setupFindInterface() {
        if (this.fFindClientInterface == null) {
            this.fFindClientInterface = new HTMLFindClientInterface();
        }
        this.registerWithFindDialog();
    }

    public void removeNotify() {
        if (this.fFindListener != null) {
            try {
                this.fFindListener.closing((FindClientInterface)this.fFindClientInterface);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.fFindClientInterface != null) {
            try {
                FindClientRegistry.unregister((FindClientInterface)this.fFindClientInterface);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.removeNotify();
    }

    public void addMouseOverLinkListener(ActionListener actionListener) {
        this.fMouseOverLinkListener = actionListener;
    }

    public void removeMouseOverLinkListener(ActionListener actionListener) {
        if (this.fMouseOverLinkListener != null && this.fMouseOverLinkListener.equals(actionListener)) {
            this.fMouseOverLinkListener = null;
        }
    }

    public void addPageChangedListener(PageChangedListener pageChangedListener) {
        this.fPageChangedListeners.add(pageChangedListener);
    }

    public void removePageChangedListener(PageChangedListener pageChangedListener) {
        for (int i = 0; i < this.fPageChangedListeners.size(); ++i) {
            PageChangedListener pageChangedListener2 = this.fPageChangedListeners.get(i);
            if (!pageChangedListener2.equals(pageChangedListener)) continue;
            this.fPageChangedListeners.remove(i);
            return;
        }
    }

    public void addJarFileLinkListener(JarFileLinkListener jarFileLinkListener) {
        this.fJarFileLinkListener = jarFileLinkListener;
    }

    public void removeJarFileLinkListener(JarFileLinkListener jarFileLinkListener) {
        if (this.fJarFileLinkListener != null && this.fJarFileLinkListener.equals(jarFileLinkListener)) {
            this.fJarFileLinkListener = null;
        }
    }

    JarFileLinkListener getJarFileLinkListener() {
        return this.fJarFileLinkListener;
    }

    public void setLinkClickedHandler(LinkClickedHandler linkClickedHandler) {
        this.fLinkClickedHandler = linkClickedHandler;
    }

    public void removeLinkClickedHandler(LinkClickedHandler linkClickedHandler) {
        if (this.fLinkClickedHandler != null && this.fLinkClickedHandler.equals(linkClickedHandler)) {
            this.fLinkClickedHandler = null;
        }
    }

    LinkClickedHandler getLinkClickedHandler() {
        return this.fLinkClickedHandler;
    }

    public void disableNavigation() {
        this.fNavigationEnabled = false;
        this.fBrowser.disableNavigation();
    }

    public void clearHistory() {
        this.fBrowser.clearHistory();
        this.enableDisableEvents();
    }

    private void setHTMLFont(Font font) {
        Font font2 = font;
        if (!FontUtils.validateFont((Font)font)) {
            font2 = FontPrefs.DEFAULT_TEXT_FONT;
        }
        this.fBrowser.setHTMLFont(font2);
    }

    @Override
    public void setHtmlText(final String string) {
        WebRendererCreationListener webRendererCreationListener = this.getWebRendererCreationListener();
        if (webRendererCreationListener != null) {
            this.addCreationFailureRunnable(new Runnable(){

                @Override
                public void run() {
                    HTMLRenderer.this.setHtmlText(string);
                }
            });
        }
        this.fBrowser.setHtmlText(string);
    }

    public void setHtmlText(final String string, final String string2) {
        WebRendererCreationListener webRendererCreationListener = this.getWebRendererCreationListener();
        if (webRendererCreationListener != null) {
            this.addCreationFailureRunnable(new Runnable(){

                @Override
                public void run() {
                    HTMLRenderer.this.setHtmlText(string, string2);
                }
            });
        }
        this.fBrowser.setHtmlText(string, string2);
    }

    public void setHtmlText(final String string, final String string2, final boolean bl) {
        WebRendererCreationListener webRendererCreationListener = this.getWebRendererCreationListener();
        if (webRendererCreationListener != null) {
            this.addCreationFailureRunnable(new Runnable(){

                @Override
                public void run() {
                    HTMLRenderer.this.setHtmlText(string, string2, bl);
                }
            });
        }
        this.fBrowser.setHtmlText(string, string2, bl);
    }

    public void setHtmlTextAndHighlightKeywords(String string, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this.setHtmlText(string);
        } else if (string != null) {
            this.setHtmlText(HTMLUtils.highlightHtml(string, stringArray));
        }
    }

    public void setHomeUrl(String string) {
        this.fHomeUrl = string;
        this.fActions.fHomeAction.setEnabled(true);
    }

    String getHomeUrl() {
        return this.fHomeUrl;
    }

    @Override
    public void setCurrentLocation(String string) {
        String string2;
        if (string == null || string.length() == 0) {
            return;
        }
        boolean bl = string.startsWith("text:");
        if (!bl && string.length() > 4096) {
            String string3 = "<!-- URL TOO LONG -->\n" + HTMLUtils.sRes.getString("url_too_long_error");
            this.showLinkErrPage(string.substring(0, 50) + "...", string3);
            return;
        }
        WebRendererCreationListener webRendererCreationListener = this.getWebRendererCreationListener();
        if (webRendererCreationListener != null) {
            string2 = string;
            this.addCreationFailureRunnable(new Runnable(){

                @Override
                public void run() {
                    HTMLRenderer.this.setCurrentLocation(string2);
                }
            });
        }
        string2 = string;
        if (!bl && !HTMLUtils.isValidUrl(string)) {
            try {
                File file;
                String string4;
                int n = string.indexOf(35);
                String string5 = string4 = n > -1 ? string.substring(0, n) : string;
                if (HTMLUtils.needsDecoding(string)) {
                    string4 = HTMLUtils.decodeUrl(string4);
                }
                if ((file = new File(string4)).exists()) {
                    string2 = "file:///" + string.replaceAll("\\\\", "/");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl && HTMLUtils.isValidUrl(string2) && HTMLUtils.needsEncoding(string2)) {
            string2 = HTMLUtils.encodeUrl(string2);
        }
        this.fBrowser.setCurrentLocation(string2);
    }

    public void setCurrentLocationAndHighlightKeywords(String string, String[] stringArray) {
        this.setCurrentLocationAndHighlightKeywords(string, CharsetDetectionStrategy.getDefaultCharsetStrategy(), stringArray);
    }

    public void setCurrentLocationAndHighlightKeywords(String string, final CharsetDetectionStrategy charsetDetectionStrategy, final String[] stringArray) {
        String string2;
        WebRendererCreationListener webRendererCreationListener = this.getWebRendererCreationListener();
        if (webRendererCreationListener != null) {
            string2 = string;
            this.addCreationFailureRunnable(new Runnable(){

                @Override
                public void run() {
                    HTMLRenderer.this.setCurrentLocationAndHighlightKeywords(string2, charsetDetectionStrategy, stringArray);
                }
            });
        }
        string2 = string;
        if (!HTMLUtils.isValidUrl(string) && FileUtils.fileExists((String)string)) {
            string2 = HTMLUtils.getUrlStringFromLocation(string);
        }
        if (stringArray == null || stringArray.length == 0) {
            this.setCurrentLocation(string2);
            return;
        }
        String string3 = HTMLUtils.getSource(string2, charsetDetectionStrategy);
        if (string3 != null) {
            string3 = HTMLUtils.highlightHtml(string3, stringArray);
            this.setHtmlText(string2, string3);
        } else {
            this.showLinkErrPage(string2);
        }
    }

    private void registerWithFindDialog() {
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        if (window != null) {
            Window window2;
            String string = "";
            String string2 = this.getCurrentPageTitle();
            if (window instanceof Frame) {
                window2 = (Frame)window;
                string = string2 == null ? ((Frame)window2).getTitle() : string2;
            } else if (window instanceof Dialog) {
                window2 = (Dialog)window;
                string = string2 == null ? ((Dialog)window2).getTitle() : string2;
            }
            if (string != null) {
                window2 = new String[]{string};
                assert (this.fFindClientInterface != null);
                FindClientRegistry.register((FindClientInterface)this.fFindClientInterface, (String[])window2, (boolean)false);
            }
        }
    }

    void resetFindDialogTitle(String string) {
        if (string.length() > 0 && this.isShowing()) {
            String[] stringArray = new String[]{string};
            if (this.fFindClientInterface != null) {
                FindClientRegistry.register((FindClientInterface)this.fFindClientInterface, (String[])stringArray, (boolean)false);
            }
        }
    }

    public void setUseSystemBrowserForExternalLinks(boolean bl) {
        this.fUseSystemBrowserForExternalLinks = bl;
    }

    public boolean getUseSystemBrowserForExternalLinks() {
        return this.fUseSystemBrowserForExternalLinks;
    }

    public HTMLRenderer getRenderer() {
        return this;
    }

    public void dispose() {
        if (this.fFontListener != null) {
            FontPrefs.removeFontListener((String)FontPrefs.HTML_FONT_COMPONENT_NAME, (FontListener)this.fFontListener);
        }
        this.fBrowser.dispose();
    }

    public String getCurrentPageTitle() {
        return this.fBrowser.getCurrentPageTitle();
    }

    @Override
    public String getCurrentLocation() {
        return this.fBrowser.getCurrentLocation();
    }

    public String getCurrentFilename() {
        String string = this.getCurrentLocation();
        if (string != null && string.length() != 0) {
            string = HTMLUtils.getFilenameFromURL(string);
        }
        return string;
    }

    void doCopy() {
        this.fBrowser.copySelection();
    }

    boolean canGoBack() {
        return this.fBrowser.canGoBack(this.fBrowser.getViewportName());
    }

    void goBack() {
        this.fBrowser.goBack();
    }

    boolean canGoForward() {
        return this.fBrowser.canGoForward(this.fBrowser.getViewportName());
    }

    void goForward() {
        this.fBrowser.goForward();
    }

    public void reload() {
        if (this.fReloadActionListener != null) {
            this.fReloadActionListener.actionPerformed(new ActionEvent(this, 0, ""));
        } else {
            this.fBrowser.reload();
        }
    }

    @Override
    public boolean canExecuteScripts() {
        return this.fBrowser.canExecuteScripts();
    }

    public boolean isInitialized() {
        return this.canExecuteScripts();
    }

    @Override
    public void executeScript(String string) throws UnsupportedOperationException {
        this.fBrowser.executeScript(string);
    }

    @Override
    public String executeScriptWithReturn(String string) throws UnsupportedOperationException {
        return this.fBrowser.executeScriptWithReturn(string);
    }

    @Override
    public boolean canModifyDom() {
        return this.fBrowser.canModifyDom();
    }

    @Override
    public void setElementText(String string, String string2) {
        this.fBrowser.setElementText(string, string2);
    }

    @Override
    public String getElementText(String string) {
        return this.fBrowser.getElementText(string);
    }

    void goHome() {
        if (this.fHomeUrl != null) {
            this.setCurrentLocation(this.fHomeUrl);
        }
    }

    void doFindDialog() {
        if (this.fFindClientInterface != null) {
            try {
                FindDialog.invoke((FindClientInterface)this.fFindClientInterface, (String)this.getSelectedText(), (int)0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void doFind(String string, int n, boolean bl) {
        boolean bl2;
        boolean bl3 = (n & 1) != 0;
        boolean bl4 = (n & 2) != 0;
        boolean bl5 = bl2 = (n & 4) != 0;
        if (string != null && string.length() > 0) {
            this.search(string, bl, bl3, bl2, bl4);
        }
    }

    boolean search(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return this.fBrowser.search(string, bl, bl2, bl3, bl4);
    }

    public static void printHtml(String string, String string2) {
        HTMLRenderer hTMLRenderer = new HTMLRenderer();
        JDialog jDialog = new JDialog();
        jDialog.add((Component)((Object)hTMLRenderer));
        jDialog.setTitle(string);
        jDialog.setLocation(new Point(-100, -100));
        jDialog.setVisible(true);
        DoPrintHTML doPrintHTML = hTMLRenderer.getPrintHTML();
        doPrintHTML.setDummyFrame(jDialog);
        hTMLRenderer.addPageChangedListener(doPrintHTML);
        hTMLRenderer.setHtmlText(string2);
    }

    public void saveAs() {
        String string = this.getDefaultFilenameForSaveAs();
        MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform(MatlabPath.getCWD());
        mJFileChooserPerPlatform.setSelectedFile(new File(string));
        mJFileChooserPerPlatform.addChoosableFileFilter((FilePatternFilter)new FileExtensionFilter(HTMLUtils.sRes.getString("filetype.html"), new String[]{"html", "htm"}, true));
        mJFileChooserPerPlatform.showSaveDialog((Component)SwingUtilities.windowForComponent((Component)((Object)this)));
        File file = mJFileChooserPerPlatform.getSelectedFile();
        if (mJFileChooserPerPlatform.getState() == 0) {
            this.fBrowser.saveAs(file);
        }
    }

    private void saveAs(String string) {
        if (string != null) {
            this.fBrowser.saveAs(new File(string));
        }
    }

    private String getDefaultFilenameForSaveAs() {
        String string;
        String string2 = null;
        String string3 = this.fBrowser.getCurrentLocation();
        if (string3 != null) {
            if (string3.startsWith("text:")) {
                string = this.fBrowser.getCurrentPageTitle();
                if (string != null) {
                    string2 = string + ".html";
                }
            } else {
                string2 = string3.substring(string3.lastIndexOf(47) + 1);
            }
        }
        if (string2 == null || string2.length() == 0) {
            string = this.fBrowser.getCurrentPageTitle();
            string2 = string != null ? string + ".html" : "newfile.html";
        }
        return string2;
    }

    private DoPrintHTML getPrintHTML() {
        return new DoPrintHTML();
    }

    public void doPrint() {
        this.fBrowser.print(null);
    }

    public void viewSource() {
        String string = this.fBrowser.getCurrentLocation();
        if (string != null) {
            String string2;
            this.setWaitCursor(true);
            SyntaxTextPane syntaxTextPane = new SyntaxTextPane();
            syntaxTextPane.registerEditorKit(XMLLanguage.INSTANCE.getMimeType(), (EditorKit)((Object)new PreviewKitClass()));
            syntaxTextPane.setContentType(XMLLanguage.INSTANCE.getMimeType());
            syntaxTextPane.setEditable(false);
            syntaxTextPane.setName("HelpPageSourceTextPane");
            syntaxTextPane.setText(this.getHtmlText());
            syntaxTextPane.setCaretPosition(0);
            syntaxTextPane.setSyntaxHighlightingEnabled(XMLLanguage.INSTANCE, true);
            MJScrollPane mJScrollPane = new MJScrollPane((Component)syntaxTextPane);
            String string3 = HTMLUtils.getFilenameFromURL(string);
            if (string3.startsWith("text://")) {
                string2 = this.fBrowser.getCurrentPageTitle();
                string3 = string2 != null && string2.equals(string3) ? HTMLUtils.sRes.getString("icecontainer.address_box_untitled") : string2;
            }
            string2 = new MJFrame(string3);
            string2.setDefaultCloseOperation(2);
            string2.setName("HelpPageSourceFrame");
            string2.getContentPane().add((Component)mJScrollPane);
            string2.addWindowListener((WindowListener)new WindowAdapter((MJFrame)string2, syntaxTextPane){
                final /* synthetic */ MJFrame val$frame;
                final /* synthetic */ SyntaxTextPane val$textPane;
                {
                    this.val$frame = mJFrame;
                    this.val$textPane = syntaxTextPane;
                }

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    this.val$frame.setVisible(false);
                    this.val$textPane.cleanup();
                    this.val$frame.dispose();
                }
            });
            string2.setSize(800, 600);
            string2.setVisible(true);
            this.setWaitCursor(false);
        } else {
            MJOptionPane.showMessageDialog((Component)((Object)this), (Object)HTMLUtils.sRes.getString("alert.unable_to_view_source"), (String)HTMLUtils.sRes.getString("alert.alert_title"), (int)2);
        }
    }

    void doEvalSelection() {
        this.setWaitCursor(true);
        MLExecuteServices.executeCommand((String)this.getSelectedText());
        this.setWaitCursor(false);
    }

    void doOpenSelection() {
        this.setWaitCursor(true);
        MLExecuteServices.consoleEval((String)("open " + this.getSelectedText()));
        this.setWaitCursor(false);
    }

    void doHelpOnSelection() {
        this.setWaitCursor(true);
        MLExecuteServices.consoleEval((String)("doc " + this.getSelectedText()));
        this.setWaitCursor(false);
    }

    public void showLinkErrPage(String string) {
        this.showLinkErrPage(string, null);
    }

    public void showLinkErrPage(String string, String string2) {
        String string3 = this.getFileNotFoundText(string, string2);
        this.setHtmlText(string3);
    }

    public void setShowTitleWhenUrlNotFound(boolean bl) {
        this.fShowTitleWhenUrlNotFound = bl;
    }

    public void setFileNotFoundTemplate(String string) {
        this.fFileNotFoundTemplate = string;
    }

    public String getFileNotFoundText(String string) {
        return this.getFileNotFoundText(string, null);
    }

    private String getFileNotFoundText(String string, String string2) {
        return HTMLUtils.getFileNotFoundText(this.fFileNotFoundTemplate, string, string2, this.fShowTitleWhenUrlNotFound);
    }

    public String getSelectedText() {
        return this.fBrowser.getSelectedText();
    }

    @Override
    public String getHtmlText() {
        return this.fBrowser.getHtmlText();
    }

    void updateStatusBar(String string) {
        if (this.fMouseOverLinkListener != null) {
            if (string.length() == 0 && this.fDontClearMainStatusBar) {
                return;
            }
            this.fMouseOverLinkListener.actionPerformed(new ActionEvent(this, 0, string));
        }
    }

    public static String getLocalizedFilename(String string) {
        return HTMLUtils.getLocalizedFilename(string);
    }

    public void setWaitCursor(final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setAllWaitCursors(bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HTMLRenderer.this.setAllWaitCursors(bl);
                }
            });
        }
    }

    private void setAllWaitCursors(boolean bl) {
        if (bl) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.fBrowser.setWaitCursor(true);
        } else {
            this.setCursor(Cursor.getDefaultCursor());
            this.fBrowser.setWaitCursor(false);
        }
    }

    protected MJPopupMenu createPopupMenu() {
        MJPopupMenu mJPopupMenu = new MJPopupMenu();
        if (Matlab.isMatlabAvailable()) {
            mJPopupMenu.add((Action)((Object)this.fActions.fEvalSelectionAction));
            mJPopupMenu.add((Action)((Object)this.fActions.fOpenSelectionAction));
            mJPopupMenu.add((Action)((Object)this.fActions.fHelpSelectionAction));
            mJPopupMenu.addSeparator();
        }
        if (this.fNavigationEnabled) {
            mJPopupMenu.add((Action)((Object)this.fActions.fGoBackAction));
            mJPopupMenu.add((Action)((Object)this.fActions.fGoForwardAction));
            mJPopupMenu.add((Action)((Object)this.fActions.fReloadAction));
            mJPopupMenu.addSeparator();
        } else {
            mJPopupMenu.add((Action)((Object)this.fActions.fReloadAction));
            mJPopupMenu.addSeparator();
        }
        mJPopupMenu.add((Action)((Object)this.fActions.fCopyAction));
        mJPopupMenu.addSeparator();
        mJPopupMenu.add((Action)((Object)this.fActions.fViewSourceAction));
        mJPopupMenu.addSeparator();
        mJPopupMenu.add((Action)((Object)this.fActions.fPrintAction));
        mJPopupMenu.setLightWeightPopupEnabled(false);
        return mJPopupMenu;
    }

    void enableDisableEvents() {
        this.enableDisableEvents(true);
    }

    void enableDisableEvents(boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.enableEventsMethod(bl);
        } else {
            SwingUtilities.invokeLater(new EnableEventsThread(bl));
        }
    }

    private void enableEventsMethod(boolean bl) {
        boolean bl2 = true;
        String string = this.fBrowser.getCurrentLocation();
        if (string == null || string.length() == 0) {
            bl2 = false;
        }
        if (this.fNavigationEnabled) {
            String string2 = this.fBrowser.getViewportName();
            this.fActions.fGoBackAction.setEnabled(this.fBrowser.canGoBack(string2));
            this.fActions.fGoForwardAction.setEnabled(this.fBrowser.canGoForward(string2));
            this.fActions.fReloadAction.setEnabled(bl2);
        }
        if (bl) {
            this.enableTextSelectionActions();
        }
        this.fActions.fPrintAction.setEnabled(bl2);
        this.fActions.fViewSourceAction.setEnabled(bl2);
        this.fActions.fSaveAsAction.setEnabled(bl2);
        this.fActions.fFindAction.setEnabled(bl2 && this.fBrowser.isFindSupported());
    }

    void enableTextSelectionActions() {
        boolean bl;
        boolean bl2 = bl = this.getSelectedText().length() != 0;
        if (Matlab.isMatlabAvailable()) {
            this.fActions.fEvalSelectionAction.setEnabled(bl);
            this.fActions.fOpenSelectionAction.setEnabled(bl);
            this.fActions.fHelpSelectionAction.setEnabled(bl);
        }
        this.fActions.fCopyAction.setEnabled(bl);
    }

    public void scrollToBottom() {
        this.fBrowser.scrollToBottom();
    }

    public void scrollToTarget(String string) {
        this.fBrowser.scrollToTarget(string);
    }

    public int getVerticalScrollPosition() {
        return this.fBrowser.getVerticalScrollPosition();
    }

    public void setVerticalScrollPosition(int n) {
        this.fBrowser.setVerticalScrollPosition(n);
    }

    public void setReloadActionListener(ActionListener actionListener) {
        this.fReloadActionListener = actionListener;
    }

    public boolean requestFocusInWindow() {
        if (this.fBrowser != null) {
            return this.fBrowser.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    public void clearBrowser() {
        this.fBrowser.clearBrowser();
    }

    void notifyPageChangedListeners(final String string, String string2, final boolean bl) {
        if (!this.fPageChangedListeners.isEmpty()) {
            final String string3 = string2 != null && HTMLUtils.needsDecoding(string2) ? HTMLUtils.decodeUrl(string2) : string2;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PageChangedListener.PageChangedEvent pageChangedEvent = new PageChangedListener.PageChangedEvent(string, string3, bl);
                    for (PageChangedListener pageChangedListener : HTMLRenderer.this.fPageChangedListeners) {
                        pageChangedListener.pageChanged(pageChangedEvent);
                    }
                }
            });
        }
    }

    public static void main(String[] stringArray) {
        HTMLRenderer.createRenderer();
    }

    private synchronized WebRendererCreationListener getWebRendererCreationListener() {
        return this.fCreationListener;
    }

    private synchronized void clearWebRendererCreationListener() {
        this.fCreationListener = null;
    }

    private synchronized void addCreationFailureRunnable(Runnable runnable) {
        WebRendererCreationListener webRendererCreationListener = this.getWebRendererCreationListener();
        if (webRendererCreationListener != null) {
            webRendererCreationListener.addAfterFailure(runnable);
        }
    }

    private synchronized void handleWebRendererCreationFailure() {
        ICERenderer iCERenderer = new ICERenderer();
        ((HTMLRendererSupport)iCERenderer).createRenderer(this);
        this.addBrowser(iCERenderer);
        this.clearWebRendererCreationListener();
    }

    private boolean isFocusInRenderer() {
        return this.fBrowser.isFocusInRenderer();
    }

    public void disableDefaultDropTarget() {
        this.fBrowser.disableDefaultDropTarget();
    }

    int getBrowserId() {
        return this.fBrowserId;
    }

    void setBrowserId(int n) {
        this.fBrowserId = n;
    }

    private class WebRendererCreationListener
    implements WebRenderer.BrowserCreationListener {
        private List<Runnable> iAfterFailure;

        private WebRendererCreationListener() {
        }

        @Override
        public void creationFailed() {
            HTMLRenderer.this.handleWebRendererCreationFailure();
            if (this.iAfterFailure != null) {
                List<Runnable> list = Collections.unmodifiableList(this.iAfterFailure);
                for (Runnable runnable : list) {
                    runnable.run();
                }
            }
        }

        @Override
        public void creationSucceeded() {
            HTMLRenderer.this.clearWebRendererCreationListener();
        }

        private void addAfterFailure(Runnable runnable) {
            if (this.iAfterFailure == null) {
                this.iAfterFailure = new ArrayList<Runnable>();
            }
            this.iAfterFailure.add(runnable);
        }
    }

    private class HTMLFindClientInterface
    implements FindClientInterface {
        private HTMLFindClientInterface() {
        }

        public void addFindParentListener(FindParentListener findParentListener) {
            HTMLRenderer.this.fFindListener = findParentListener;
        }

        public void removeFindParentListener(FindParentListener findParentListener) {
            HTMLRenderer.this.fFindListener = null;
        }

        public void findForward(FindEvent findEvent) {
            HTMLRenderer.this.doFind(findEvent.getFindString(), findEvent.getOptions(), false);
        }

        public void findBack(FindEvent findEvent) {
            HTMLRenderer.this.doFind(findEvent.getFindString(), findEvent.getOptions(), true);
        }

        public void replace(FindEvent findEvent) {
        }

        public void replaceAll(FindEvent findEvent) {
        }

        public Component getInvoker() {
            return HTMLRenderer.this;
        }

        public void bringForward() {
            Desktop desktop;
            SwingUtilities.windowForComponent(this.getInvoker()).toFront();
            Component component = Desktop.getClientComponentAncestor((Component)((Object)HTMLRenderer.this));
            if (component != null && (desktop = Desktop.getContainingDesktop((Component)component)) != null) {
                desktop.toFront(component);
            }
        }
    }

    private class EnableEventsThread
    implements Runnable {
        private boolean iBackForwardOnly;

        private EnableEventsThread(boolean bl) {
            this.iBackForwardOnly = bl;
        }

        @Override
        public void run() {
            HTMLRenderer.this.enableEventsMethod(this.iBackForwardOnly);
        }
    }

    public static class PreviewKitClass
    extends XMLKit {
        public String getContentType() {
            return XMLLanguage.INSTANCE.getMimeType();
        }
    }

    private class DoPrintHTML
    implements PageChangedListener {
        private JDialog fDummyDialog;

        private DoPrintHTML() {
        }

        public void setDummyFrame(JDialog jDialog) {
            this.fDummyDialog = jDialog;
        }

        @Override
        public void pageChanged(PageChangedListener.PageChangedEvent pageChangedEvent) {
            HTMLRenderer.this.fBrowser.print(new PrintingCompletedListener());
        }

        private class PrintingCompletedListener
        implements ActionListener {
            private PrintingCompletedListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final DoPrintHTML doPrintHTML = DoPrintHTML.this;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HTMLRenderer.this.removePageChangedListener(doPrintHTML);
                        HTMLRenderer.this.dispose();
                        DoPrintHTML.this.fDummyDialog.dispose();
                    }
                });
            }
        }
    }

    private static class MyPageChangedListener
    implements PageChangedListener {
        private MJFrame fFrame;

        MyPageChangedListener(MJFrame mJFrame) {
            this.fFrame = mJFrame;
        }

        @Override
        public void pageChanged(PageChangedListener.PageChangedEvent pageChangedEvent) {
            if (this.fFrame != null) {
                this.fFrame.setTitle(pageChangedEvent.getTitle());
            }
        }
    }

    private class HTMLFontListener
    implements FontListener {
        private HTMLFontListener() {
        }

        public void fontChanged(Font font) {
            HTMLRenderer.this.setHTMLFont(font);
        }
    }

    private class InfoMessageBar {
        private JComponent fMsgBar;

        InfoMessageBar(String string, HyperlinkTextLabel.HyperlinkHandler hyperlinkHandler) {
            HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(string, hyperlinkHandler, false, "HTMLInfoMessageBar", HTMLUtils.sRes.getString("infobar.access_name"));
            this.fMsgBar = new CloseableMessageBar(hyperlinkTextLabel.getComponent(), (Icon)CommonIcon.INFO.getIcon(), (ActionListener)new MessageBarClosedListener()).getComponent();
            this.fMsgBar.setName("HTMLRendererInfoMessageBarPanel");
        }

        public JComponent getComponent() {
            return this.fMsgBar;
        }

        public void remove() {
            HTMLRenderer.this.remove(this.fMsgBar);
            this.fMsgBar = null;
            HTMLRenderer.this.revalidate();
            HTMLRenderer.this.fInfoMessageBar = null;
        }

        private class MessageBarClosedListener
        implements ActionListener {
            private MessageBarClosedListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InfoMessageBar.this.remove();
            }
        }
    }
}

