/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search.lucene;

import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Searcher;

public class MWHitCollector
extends HitCollector {
    private static final HitInfo[] EMPTY_ARRAY = new HitInfo[0];
    private SortedSet<HitInfo> fHitSet = new TreeSet<HitInfo>();
    private HitInfo[] fInfos = EMPTY_ARRAY;

    public void collect(int n, float f) {
        if (this.finishedCollecting()) {
            throw new IllegalStateException("Cannot add more search results.");
        }
        this.fHitSet.add(new HitInfo(n, f));
    }

    private void finishCollecting() {
        if (this.fHitSet != null) {
            this.fInfos = this.fHitSet.toArray(this.fInfos);
            this.fHitSet = null;
        }
    }

    private boolean finishedCollecting() {
        return this.fHitSet == null;
    }

    int getNumResults() {
        this.finishCollecting();
        return this.fInfos.length;
    }

    Document getDocument(Searcher searcher, int n) throws IOException {
        this.finishCollecting();
        return searcher.doc(this.getDocId(n));
    }

    int getDocId(int n) {
        this.finishCollecting();
        return this.fInfos[n].getDocNum();
    }

    float getScore(int n) {
        this.finishCollecting();
        return this.fInfos[n].getScore();
    }

    private class HitInfo
    implements Comparable<HitInfo> {
        private int iDocNum;
        private float iScore;

        private HitInfo(int n, float f) {
            this.iDocNum = n;
            this.iScore = f;
        }

        private int getDocNum() {
            return this.iDocNum;
        }

        private float getScore() {
            return this.iScore;
        }

        @Override
        public int compareTo(HitInfo hitInfo) {
            int n = new Float(hitInfo.getScore()).compareTo(Float.valueOf(this.getScore()));
            if (n == 0) {
                return hitInfo.getDocNum() - this.getDocNum();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof HitInfo) {
                HitInfo hitInfo = (HitInfo)object;
                return hitInfo.getDocNum() == this.getDocNum();
            }
            return false;
        }
    }
}

