/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search;

import com.mathworks.mlwidgets.help.search.BooleanSearchOperator;
import com.mathworks.mlwidgets.help.search.SearchField;

public class WeightedSearchField {
    private SearchField fField;
    private float fWeight;
    private BooleanSearchOperator fOperator;

    public WeightedSearchField(SearchField searchField) {
        this(searchField, 1.0f, BooleanSearchOperator.SHOULD_OCCUR);
    }

    public WeightedSearchField(SearchField searchField, float f) {
        this(searchField, f, BooleanSearchOperator.SHOULD_OCCUR);
    }

    public WeightedSearchField(SearchField searchField, BooleanSearchOperator booleanSearchOperator) {
        this(searchField, 1.0f, booleanSearchOperator);
    }

    public WeightedSearchField(SearchField searchField, float f, BooleanSearchOperator booleanSearchOperator) {
        this.fField = searchField;
        this.fWeight = f;
        this.fOperator = booleanSearchOperator;
    }

    public String getFieldName() {
        return this.fField.getFieldName();
    }

    public float getWeight() {
        return this.fWeight;
    }

    public BooleanSearchOperator getBooleanOperator() {
        return this.fOperator;
    }

    public SearchField getSearchField() {
        return this.fField;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.fOperator) {
            case MUST_OCCUR: {
                stringBuilder.append("+(");
                break;
            }
            case MUST_NOT_OCCUR: {
                stringBuilder.append("-(");
                break;
            }
            case SHOULD_OCCUR: {
                stringBuilder.append("(");
            }
        }
        stringBuilder.append(this.fField.toString()).append(':').append(this.fWeight).append(')');
        return stringBuilder.toString();
    }
}

