/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search;

import com.mathworks.mlwidgets.help.HelpInfo;
import com.mathworks.mlwidgets.help.HelpInfoItem;
import com.mathworks.mlwidgets.help.ReferencePageInfo;
import com.mathworks.mlwidgets.help.search.BooleanSearchOperator;
import com.mathworks.mlwidgets.help.search.CompoundSearchExpression;
import com.mathworks.mlwidgets.help.search.DocPageType;
import com.mathworks.mlwidgets.help.search.DocSearchEngine;
import com.mathworks.mlwidgets.help.search.DocSearchField;
import com.mathworks.mlwidgets.help.search.DocSearchResult;
import com.mathworks.mlwidgets.help.search.EmptySearchResults;
import com.mathworks.mlwidgets.help.search.PartialWordSearchExpression;
import com.mathworks.mlwidgets.help.search.RankedSearchResult;
import com.mathworks.mlwidgets.help.search.RefEntityType;
import com.mathworks.mlwidgets.help.search.ReferencePageComparator;
import com.mathworks.mlwidgets.help.search.ResultType;
import com.mathworks.mlwidgets.help.search.SearchCriteria;
import com.mathworks.mlwidgets.help.search.SearchException;
import com.mathworks.mlwidgets.help.search.SearchExpression;
import com.mathworks.mlwidgets.help.search.SearchResult;
import com.mathworks.mlwidgets.help.search.SearchResults;
import com.mathworks.mlwidgets.help.search.SimpleSearchExpression;
import com.mathworks.mlwidgets.help.search.SortedSearchResults;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public class SearchUtils {
    private static final Pattern REF_PAGE_NAME_VALIDATOR = Pattern.compile("[a-zA-Z0-9]");

    private SearchUtils() {
    }

    public static ReferencePageInfo[] findReferencePages(String string, String string2, boolean bl) throws SearchException {
        ReferencePageInfo[] referencePageInfoArray;
        Object object;
        Object object2;
        SearchResults<Object> searchResults;
        if (!REF_PAGE_NAME_VALIDATOR.matcher(string).lookingAt()) {
            searchResults = new EmptySearchResults();
        } else {
            object2 = bl ? RefEntityType.METHOD : null;
            object = SearchUtils.buildRefPageCriteria(string, object2, false, string2);
            referencePageInfoArray = DocSearchEngine.getInstance();
            searchResults = referencePageInfoArray.synchronousSearch((SearchCriteria)object);
        }
        object2 = searchResults;
        if (bl) {
            object2 = new RefPageResults(searchResults, string);
        }
        object = new SortedSearchResults<DocSearchResult>((SearchResults<DocSearchResult>)object2, new ReferencePageComparator(string));
        referencePageInfoArray = new ReferencePageInfo[object.getNumResults()];
        for (int i = 0; i < referencePageInfoArray.length; ++i) {
            DocSearchResult docSearchResult = (DocSearchResult)object.getResult(i);
            HelpInfoItem helpInfoItem = HelpInfo.getHelpInfoItemByName(docSearchResult.getProduct());
            String string3 = helpInfoItem == null ? null : helpInfoItem.getShortName();
            String string4 = docSearchResult.getFullUrl();
            String string5 = docSearchResult.getReferenceEntity();
            referencePageInfoArray[i] = new ReferencePageInfo(string3, string4, string5);
        }
        return referencePageInfoArray;
    }

    private static String getRefPageName(String string) {
        String string2 = string;
        if (string.indexOf(46) > -1) {
            if (!string.endsWith(".html")) {
                string2 = string2 + ".html";
            }
        } else {
            string2 = string2 + ".html";
        }
        return string2;
    }

    public static String findDocCommandArg(String string, String string2, boolean bl) throws SearchException {
        Object object;
        String string3 = string2;
        HelpInfoItem helpInfoItem = null;
        int n = HelpInfo.getNumProductsInstalled();
        if (string2 != null && (helpInfoItem = HelpInfo.getHelpInfoItemByShortName(string2)) != null) {
            n = helpInfoItem.getPathPosition();
            string3 = helpInfoItem.getShortName();
        }
        String string4 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i <= n; ++i) {
            object = HelpInfo.getHelpInfoItemAtPathPos(i);
            if (object == null || !((HelpInfoItem)object).hasRefPages()) continue;
            arrayList.add(((HelpInfoItem)object).getShortName());
            if (string3 == null || !string3.equals(((HelpInfoItem)object).getShortName())) continue;
            string4 = ((HelpInfoItem)object).getProductName();
            break;
        }
        RefEntityType refEntityType = bl ? RefEntityType.METHOD : null;
        object = SearchUtils.buildRefPageCriteria(string, refEntityType, false, null);
        ((SearchCriteria)object).setProducts(arrayList.toArray(new String[arrayList.size()]));
        DocSearchEngine docSearchEngine = DocSearchEngine.getInstance();
        SearchResults<DocSearchResult> searchResults = docSearchEngine.synchronousSearch((SearchCriteria)object);
        Iterator iterator = searchResults.iterator();
        boolean bl2 = false;
        boolean bl3 = false;
        while (iterator.hasNext()) {
            SearchResult searchResult = (SearchResult)iterator.next();
            if (string4 != null && searchResult.getProduct().equals(string4)) {
                bl2 = true;
                continue;
            }
            bl3 = true;
        }
        if (helpInfoItem != null) {
            if (!bl2) {
                return null;
            }
            if (bl3) {
                return string3 + "/" + string;
            }
            return string;
        }
        if (bl3) {
            return string;
        }
        return null;
    }

    public static SearchExpression getRefPageExpression() {
        SimpleSearchExpression simpleSearchExpression = new SimpleSearchExpression(DocPageType.NOT_REFERENCE_PAGE.getIndexString(), BooleanSearchOperator.MUST_NOT_OCCUR);
        simpleSearchExpression.addSearchField(DocSearchField.REFERENCE_PAGE);
        return simpleSearchExpression;
    }

    private static boolean isMethodOrProperty(RefEntityType refEntityType) {
        return refEntityType != null && (refEntityType == RefEntityType.METHOD || refEntityType == RefEntityType.PROPERTY);
    }

    private static SearchCriteria buildRefPageCriteria(String string, RefEntityType refEntityType, boolean bl, String string2) {
        SearchExpression searchExpression = SearchUtils.buildRefPageExpression(string, bl ? refEntityType : null);
        SearchExpression searchExpression2 = SearchUtils.isMethodOrProperty(refEntityType) ? SearchUtils.buildOldMethodRefPageExpr(string) : SearchUtils.buildOldRefPageExpr(string);
        SearchCriteria searchCriteria = new SearchCriteria(new CompoundSearchExpression(searchExpression, searchExpression2));
        if (string2 != null) {
            searchCriteria.setProducts(string2);
        } else {
            searchCriteria.setUseProductFilter(false);
        }
        return searchCriteria;
    }

    private static SearchExpression buildRefPageExpression(String string, RefEntityType refEntityType) {
        SearchExpression searchExpression = SearchUtils.buildTopicExpression(string, refEntityType);
        searchExpression.setBooleanOperator(BooleanSearchOperator.MUST_OCCUR);
        SimpleSearchExpression simpleSearchExpression = new SimpleSearchExpression(DocPageType.REFERENCE_PAGE_TYPE_KNOWN.getIndexString(), BooleanSearchOperator.MUST_OCCUR);
        simpleSearchExpression.addSearchField(DocSearchField.REFERENCE_PAGE);
        CompoundSearchExpression compoundSearchExpression = new CompoundSearchExpression(searchExpression, simpleSearchExpression);
        compoundSearchExpression.setBooleanOperator(BooleanSearchOperator.SHOULD_OCCUR);
        return compoundSearchExpression;
    }

    private static SearchExpression buildTopicExpression(String string, RefEntityType refEntityType) {
        if (refEntityType == null) {
            List<String> list = SearchUtils.getReferenceSearchStrings(string);
            ArrayList<SearchExpression> arrayList = new ArrayList<SearchExpression>();
            for (String string2 : list) {
                PartialWordSearchExpression partialWordSearchExpression = new PartialWordSearchExpression(string2, BooleanSearchOperator.SHOULD_OCCUR);
                partialWordSearchExpression.addSearchField(DocSearchField.REFPAGE_ENTITY);
                arrayList.add(partialWordSearchExpression);
            }
            return new CompoundSearchExpression(arrayList);
        }
        String string3 = SearchUtils.getIndexString(refEntityType, string);
        SimpleSearchExpression simpleSearchExpression = new SimpleSearchExpression(string3, BooleanSearchOperator.MUST_OCCUR);
        simpleSearchExpression.addSearchField(DocSearchField.REFPAGE_ENTITY);
        return simpleSearchExpression;
    }

    private static SearchExpression buildOldRefPageExpr(String string) {
        String string2 = SearchUtils.getRefPageName(string).toLowerCase(Locale.ENGLISH);
        SimpleSearchExpression simpleSearchExpression = new SimpleSearchExpression(string2, BooleanSearchOperator.MUST_OCCUR);
        simpleSearchExpression.addSearchField(DocSearchField.FILENAME);
        SimpleSearchExpression simpleSearchExpression2 = new SimpleSearchExpression(DocPageType.REFERENCE_PAGE_TYPE_UNKNOWN.getIndexString(), BooleanSearchOperator.MUST_OCCUR);
        simpleSearchExpression2.addSearchField(DocSearchField.REFERENCE_PAGE);
        CompoundSearchExpression compoundSearchExpression = new CompoundSearchExpression(simpleSearchExpression, simpleSearchExpression2);
        compoundSearchExpression.setBooleanOperator(BooleanSearchOperator.SHOULD_OCCUR);
        return compoundSearchExpression;
    }

    private static SearchExpression buildOldMethodRefPageExpr(String string) {
        String string2 = SearchUtils.getRefPageName(string).toLowerCase(Locale.ENGLISH);
        String string3 = string2.replaceFirst("[^\\.]*\\.html", "html");
        SimpleSearchExpression simpleSearchExpression = new SimpleSearchExpression(string2, BooleanSearchOperator.SHOULD_OCCUR);
        SimpleSearchExpression simpleSearchExpression2 = new SimpleSearchExpression(string3, BooleanSearchOperator.SHOULD_OCCUR);
        CompoundSearchExpression compoundSearchExpression = new CompoundSearchExpression(simpleSearchExpression, simpleSearchExpression2);
        compoundSearchExpression.addSearchField(DocSearchField.FILENAME);
        compoundSearchExpression.setBooleanOperator(BooleanSearchOperator.MUST_OCCUR);
        SimpleSearchExpression simpleSearchExpression3 = new SimpleSearchExpression(DocPageType.REFERENCE_PAGE_TYPE_UNKNOWN.getIndexString(), BooleanSearchOperator.MUST_OCCUR);
        simpleSearchExpression3.addSearchField(DocSearchField.REFERENCE_PAGE);
        CompoundSearchExpression compoundSearchExpression2 = new CompoundSearchExpression(compoundSearchExpression, simpleSearchExpression3);
        compoundSearchExpression2.setBooleanOperator(BooleanSearchOperator.SHOULD_OCCUR);
        return compoundSearchExpression2;
    }

    public static String getIndexString(RefEntityType refEntityType, String string) {
        StringBuilder stringBuilder = new StringBuilder(SearchUtils.getEntityString(string));
        stringBuilder.append(':');
        if (refEntityType != null) {
            stringBuilder.append(refEntityType.getIndexSuffix());
        }
        return stringBuilder.toString();
    }

    public static String getEntityNameFromIndexString(String string) {
        if (string != null && string.indexOf(58) > 0) {
            String string2 = string.substring(0, string.lastIndexOf(58));
            String[] stringArray = string2.split("/");
            StringBuilder stringBuilder = new StringBuilder();
            for (String string3 : stringArray) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.insert(0, '.');
                }
                stringBuilder.insert(0, string3);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    private static List<String> getReferenceSearchStrings(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string2 = SearchUtils.getEntityString(string);
        linkedList.add(string2 + ":");
        linkedList.add(string2 + "/");
        return linkedList;
    }

    private static String getEntityString(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray) {
            stringBuilder.insert(0, '/').insert(0, string2);
        }
        return stringBuilder.deleteCharAt(stringBuilder.length() - 1).toString();
    }

    private static class MethodRefPageResult
    implements DocSearchResult {
        private DocSearchResult iRealResult;
        private String iMethodName;

        private MethodRefPageResult(DocSearchResult docSearchResult, String string) {
            this.iRealResult = docSearchResult;
            this.iMethodName = string;
        }

        @Override
        public String getTitle() {
            return this.iRealResult.getTitle();
        }

        @Override
        public String getSection() {
            return this.iRealResult.getSection();
        }

        @Override
        public boolean isReferencePage() {
            return this.iRealResult.isReferencePage();
        }

        @Override
        public String getRefPageSummary() {
            return null;
        }

        @Override
        public String getRefPageFunction() {
            return this.iMethodName;
        }

        @Override
        public String getProduct() {
            return this.iRealResult.getProduct();
        }

        @Override
        public String getFullUrl() {
            return this.iRealResult.getFullUrl() + "#" + this.iMethodName;
        }

        @Override
        public String getFilename() {
            return this.iRealResult.getFilename();
        }

        @Override
        public String getBody() {
            return this.iRealResult.getBody();
        }

        @Override
        public ResultType getResultType() {
            return this.iRealResult.getResultType();
        }

        @Override
        public float getScore() {
            return this.iRealResult.getScore();
        }

        @Override
        public String getFileEncoding() {
            return this.iRealResult.getFileEncoding();
        }

        @Override
        public RefEntityType getReferenceEntityType() {
            return this.iRealResult.getReferenceEntityType();
        }

        @Override
        public String getReferenceEntity() {
            return this.iRealResult.getReferenceEntity();
        }

        @Override
        public int compareTo(RankedSearchResult rankedSearchResult) {
            return new Float(this.getScore()).compareTo(Float.valueOf(rankedSearchResult.getScore()));
        }
    }

    private static class RefPageResults
    implements SearchResults<DocSearchResult> {
        private List<DocSearchResult> iFilteredResults;

        private RefPageResults(SearchResults<DocSearchResult> searchResults, String string) {
            String string2 = string.substring(string.lastIndexOf(46) + 1);
            HashMap<String, DocSearchResult> hashMap = new HashMap<String, DocSearchResult>();
            for (DocSearchResult docSearchResult : searchResults) {
                DocSearchResult docSearchResult2 = docSearchResult;
                if (docSearchResult2.getFilename().equals(string.toLowerCase(Locale.getDefault()) + ".html")) {
                    hashMap.put(docSearchResult2.getProduct(), docSearchResult2);
                    continue;
                }
                if (hashMap.containsKey(docSearchResult2.getProduct())) continue;
                hashMap.put(docSearchResult2.getProduct(), new MethodRefPageResult(docSearchResult2, string2));
            }
            this.iFilteredResults = new ArrayList(hashMap.values());
        }

        @Override
        public Iterator<DocSearchResult> iterator() {
            return this.iFilteredResults.iterator();
        }

        @Override
        public DocSearchResult getResult(int n) {
            return this.iFilteredResults.get(n);
        }

        @Override
        public int getNumResults() {
            return this.iFilteredResults.size();
        }
    }
}

