/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search;

import com.mathworks.mlwidgets.help.HelpInfo;
import com.mathworks.mlwidgets.help.HelpInfoItem;
import com.mathworks.mlwidgets.help.search.DocSearchResult;
import com.mathworks.mlwidgets.help.search.RefEntityType;
import java.util.Comparator;

public class ReferencePageComparator
implements Comparator<DocSearchResult> {
    private final String fFunctionName;

    protected ReferencePageComparator(String string) {
        this.fFunctionName = string;
    }

    @Override
    public int compare(DocSearchResult docSearchResult, DocSearchResult docSearchResult2) {
        int n = this.compareByEntityNameMatch(docSearchResult, docSearchResult2);
        if (n == 0) {
            n = ReferencePageComparator.compareByEntityType(docSearchResult, docSearchResult2);
        }
        if (n == 0) {
            n = this.compareByPathPosition(docSearchResult, docSearchResult2);
        }
        if (n == 0) {
            n = this.compareByFileNameMatch(docSearchResult, docSearchResult2);
        }
        return n;
    }

    private int compareByEntityNameMatch(DocSearchResult docSearchResult, DocSearchResult docSearchResult2) {
        String string = docSearchResult.getReferenceEntity();
        String string2 = docSearchResult2.getReferenceEntity();
        if (string == null || string2 == null) {
            return 0;
        }
        int n = string.equalsIgnoreCase(this.fFunctionName) ? 1 : 0;
        int n2 = string2.equalsIgnoreCase(this.fFunctionName) ? 1 : 0;
        return n2 - n;
    }

    private static int compareByEntityType(DocSearchResult docSearchResult, DocSearchResult docSearchResult2) {
        RefEntityType refEntityType = docSearchResult.getReferenceEntityType();
        RefEntityType refEntityType2 = docSearchResult2.getReferenceEntityType();
        if (refEntityType != null && refEntityType2 != null && !refEntityType.equals((Object)refEntityType2)) {
            if (refEntityType == RefEntityType.FUNCTION) {
                return -1;
            }
            if (refEntityType2 == RefEntityType.FUNCTION) {
                return 1;
            }
        }
        return 0;
    }

    private int compareByPathPosition(DocSearchResult docSearchResult, DocSearchResult docSearchResult2) {
        HelpInfoItem helpInfoItem = this.getHelpInfoItem(docSearchResult);
        HelpInfoItem helpInfoItem2 = this.getHelpInfoItem(docSearchResult2);
        if (helpInfoItem != null && helpInfoItem2 != null) {
            int n;
            int n2 = helpInfoItem.getPathPosition();
            if (n2 != (n = helpInfoItem2.getPathPosition())) {
                return helpInfoItem.getPathPosition() - helpInfoItem2.getPathPosition();
            }
            if (helpInfoItem.isAncestorOf(helpInfoItem2)) {
                return -1;
            }
            if (helpInfoItem.isDescendentOf(helpInfoItem2)) {
                return 1;
            }
            return 0;
        }
        if (helpInfoItem != null) {
            return -1;
        }
        if (helpInfoItem2 != null) {
            return 1;
        }
        return 0;
    }

    protected HelpInfoItem getHelpInfoItem(DocSearchResult docSearchResult) {
        return HelpInfo.getHelpInfoItemByName(docSearchResult.getProduct());
    }

    private int compareByFileNameMatch(DocSearchResult docSearchResult, DocSearchResult docSearchResult2) {
        if (this.fFunctionName == null) {
            return 0;
        }
        boolean bl = this.resultFileNameMatchesFunctionName(docSearchResult);
        boolean bl2 = this.resultFileNameMatchesFunctionName(docSearchResult2);
        if (bl && !bl2) {
            return -1;
        }
        if (bl2 && !bl) {
            return 1;
        }
        return 0;
    }

    private boolean resultFileNameMatchesFunctionName(DocSearchResult docSearchResult) {
        String string = docSearchResult.getFilename();
        return string != null && string.equalsIgnoreCase(this.fFunctionName + ".html");
    }
}

