/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.common.icons.DialogIcon;
import com.mathworks.help.helpui.DocLocation;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.ProductBaseCodeMap;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.help.DocCenterProductPrefs;
import com.mathworks.mlwidgets.help.DocCenterRoot;
import com.mathworks.mlwidgets.help.DocCenterSearchHelper;
import com.mathworks.mlwidgets.help.DocCenterSelectedProducts;
import com.mathworks.mlwidgets.help.HelpLocale;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.html.HtmlComponentFactory;
import com.mathworks.mlwidgets.html.LanguageLocale;
import com.mathworks.mlwidgets.util.productinfo.ProductInfoUtils;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.product.AbstractProduct;
import com.mathworks.product.Product;
import com.mathworks.product.dao.DaoFactory;
import com.mathworks.product.dao.DaoStrategyType;
import com.mathworks.product.dao.DefaultDaoFactory;
import com.mathworks.product.dao.ProductDao;
import com.mathworks.product.dao.config.DaoConfig;
import com.mathworks.product.dao.config.file.AbstractFileDaoConfig;
import com.mathworks.product.util.ProductIdentifier;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.util.LanguageUtils;
import com.mathworks.webproxy.WebproxyFactory;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;

public class HelpPrefs {
    public static final String DEFAULT_DOC_RELEASE = InstutilResourceKeys.RELEASE.getString(new Object[0]);
    public static final String FILTER_ENABLED = "FilterEnabled";
    public static final String USE_DOC_CENTER_BROWSER = "UseDocCenterBrowser";
    public static final String DOC_CENTER_LOCATION = "DocCenterLocation";
    public static final String DOC_LANGUAGE = "DocLanguage";
    private static final String SHOW_HELP_BROWSER = "PopupShowsBrowser";
    private static final int JAVA_PINGER_TIMEOUT_MILLIS = 5000;
    private static final DocCenterRoot sDocCenterRoot = new DocCenterRoot();
    private static String[] sSelectedProducts;
    private static boolean sProductFilterEnabled;
    private static DocInstalledState sDocInstalled;
    private static Collection<ProductIdentifier> sInstalledProductIdentifiers;
    private static Collection<ProductIdentifier> sUninstalledProductIdentifiers;
    private static Collection<DocProduct> sInstalledDocProducts;
    private static DocCenterSelectedProducts sDocCenterSelectedProducts;
    private static final ResourceBundle BUNDLE;
    private static HelpPrefsDependencyProvider sDependencyProvider;

    private HelpPrefs() {
    }

    public static boolean setDocRoot(String string) {
        sDocCenterRoot.setDocRoot(string);
        if (sDependencyProvider.isMatlabAvailable()) {
            if (!HelpPrefs.isUsingDocCenterBrowser()) {
                ProductInfoUtils.clearAndReparseProducts();
            }
            HelpPrefs.updateDocInstalled();
        } else {
            HelpPrefs.setDocInstalled(DocInstalledState.DOC_INSTALLED);
        }
        return HelpPrefs.isDocInstalled();
    }

    public static void addProduct(String string) {
        ProductInfoUtils.addProduct(string);
    }

    public static boolean useEnglishDoc(boolean bl) {
        Locale locale = bl ? Locale.ENGLISH : LanguageUtils.getHelpLocale();
        return HelpPrefs.setDocLocale(locale);
    }

    public static boolean setDocLocale(Locale locale) {
        LanguageLocale languageLocale;
        Locale locale2;
        if (locale == null || !locale.equals(LanguageUtils.getHelpLocale()) && !HelpPrefs.isLocalizedDocInstalled(locale)) {
            return false;
        }
        boolean bl = HelpPrefs.setLanguageInHelp(locale);
        if (bl && !(locale2 = (languageLocale = HelpUtils.getLanguageLocale()).getLocale()).equals(HelpPrefs.getDocLocale())) {
            HelpPrefs.setStringPref("HelpDocLanguage", languageLocale.getLocaleString());
        }
        return bl;
    }

    public static Locale getDocLocale() {
        String string = HelpPrefs.getStringPref("HelpDocLanguage", "");
        if (string.length() > 0) {
            return LanguageUtils.createLocaleForLangLocaleString((String)string);
        }
        return null;
    }

    private static boolean setLanguageInHelp(Locale locale) {
        HelpUtils.setLanguageLocale(locale);
        if (!sDependencyProvider.isUsingDocCenterBrowser()) {
            ProductInfoUtils.clearAndReparseProducts();
        }
        HelpPrefs.updateDocInstalled();
        return HelpPrefs.isDocInstalled();
    }

    private static void updateDocInstalled() {
        DocInstalledState docInstalledState = !sDependencyProvider.isMatlabAvailable() ? DocInstalledState.DOC_INSTALLED : DocInstalledState.DOC_NOT_INSTALLED;
        String string = sDocCenterRoot.getDocRoot();
        if (!HelpPrefs.isUsingDocCenterBrowser()) {
            if ((string = HelpUtils.getLocalizedFilename(string)) != null) {
                docInstalledState = DocInstalledState.DOC_INSTALLED;
            }
        } else {
            File file = new File(string, "docset.xml");
            if (file.exists()) {
                docInstalledState = DocInstalledState.DOC_INSTALLED;
            }
        }
        HelpPrefs.setDocInstalled(docInstalledState);
    }

    static synchronized boolean isDocInstalled() {
        if (sDocInstalled.equals((Object)DocInstalledState.UNKNOWN)) {
            HelpPrefs.updateDocInstalled();
        }
        return sDocInstalled.equals((Object)DocInstalledState.DOC_INSTALLED);
    }

    private static synchronized void setDocInstalled(DocInstalledState docInstalledState) {
        sDocInstalled = docInstalledState;
    }

    public static boolean isLocalizedDocInstalled(Locale locale) {
        return locale != null && LanguageLocale.isSupported(locale) && HelpPrefs.isLocalizedDocInstalled(LanguageLocale.getSupportedLanguageLocale(locale));
    }

    private static boolean isLocalizedDocInstalled(LanguageLocale languageLocale) {
        if (languageLocale == null) {
            return false;
        }
        if (sDocCenterRoot.getDocRoot() == null) {
            return false;
        }
        return HelpPrefs.isUsingDocCenterBrowser() ? HelpPrefs.isLocalizedDocCenterDocInstalled(languageLocale) : HelpPrefs.isLocalizedClassicDocInstalled(languageLocale);
    }

    private static boolean isLocalizedClassicDocInstalled(LanguageLocale languageLocale) {
        String string = sDocCenterRoot.getDocRoot() + File.separator + HelpLocale.getDocDirectoryName(languageLocale);
        boolean bl = new File(string).exists();
        if (!bl && languageLocale.equals((Object)LanguageLocale.ENGLISH)) {
            bl = new File(sDocCenterRoot.getDocRoot()).exists();
        }
        return bl;
    }

    private static boolean isLocalizedDocCenterDocInstalled(LanguageLocale languageLocale) {
        boolean bl = new File(sDocCenterRoot.getDocRoot()).exists();
        if (!languageLocale.equals((Object)LanguageLocale.ENGLISH)) {
            String string = sDocCenterRoot.getDocRoot() + File.separator + "matlab" + File.separator + "index_" + languageLocale.getLocaleString() + ".html";
            bl = new File(string).exists();
        }
        return bl;
    }

    public static String getDocRoot() {
        return sDocCenterRoot.getDocRoot();
    }

    public static boolean setDocCenterRoot(String string) {
        sDocCenterRoot.setContentDocRoot(string);
        if (sDependencyProvider.isMatlabAvailable()) {
            if (!HelpPrefs.isUsingDocCenterBrowser()) {
                ProductInfoUtils.clearAndReparseProducts();
            }
            HelpPrefs.updateDocInstalled();
        } else {
            HelpPrefs.setDocInstalled(DocInstalledState.DOC_INSTALLED);
        }
        return HelpPrefs.isDocInstalled();
    }

    public static String getDocCenterRoot() {
        return sDocCenterRoot.getContentDocRoot();
    }

    public static String getDocCenterWebRoot() {
        return sDocCenterRoot.getDocWebRoot();
    }

    public static String getDocCenterSearchPath() {
        return sDocCenterRoot.getDocCenterSearchPath();
    }

    public static boolean enableDocCenterBrowser() {
        if (HelpPrefs.isDocCenterBrowserSupported()) {
            HelpPrefs.setUsingDocCenterBrowser(true);
            return true;
        }
        return false;
    }

    public static void disableDocCenterBrowser() {
        HelpPrefs.setUsingDocCenterBrowser(false);
    }

    private static void setUsingDocCenterBrowser(boolean bl) {
        HelpPrefs.setBooleanPref("HelpUseDocCenterBrowser", bl);
    }

    public static boolean isUsingDocCenterBrowser() {
        return sDependencyProvider.isUsingDocCenterBrowser();
    }

    public static boolean isDocCenterBrowserSupported() {
        return true;
    }

    public static boolean setDocCenterDomain(String string) {
        return sDocCenterRoot.setDocCenterDomain(string);
    }

    public static String getDocCenterDomain() {
        return sDocCenterRoot.getDocCenterDomain();
    }

    public static void setDocCenterLocation(String string) {
        DocLocation docLocation = HelpPrefs.getDocLocation(string);
        HelpPrefs.setDocCenterLocation(docLocation);
    }

    private static void setDocCenterLocation(DocLocation docLocation) {
        if (docLocation != null) {
            HelpPrefs.setStringPref("HelpDocCenterLocation", docLocation.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isWebDocOffline() {
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(HelpPrefs.getDocCenterDomain());
            Proxy proxy = WebproxyFactory.findProxyForURL((URL)uRL);
            httpURLConnection = proxy != null ? (HttpURLConnection)uRL.openConnection(proxy) : (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setConnectTimeout(5000);
            httpURLConnection.connect();
            boolean bl = httpURLConnection.getResponseCode() >= 400;
            return bl;
        }
        catch (MalformedURLException malformedURLException) {
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    public static DocLocation getDocCenterLocation() {
        String string = HelpPrefs.getStringPref("HelpDocCenterLocation", "");
        DocLocation docLocation = HelpPrefs.getDocLocation(string);
        if (docLocation != null && docLocation == DocLocation.WEB) {
            if (HelpPrefs.isWebDocOffline()) {
                HelpPrefs.setDocCenterLocation(DocLocation.INSTALLED);
                docLocation = DocLocation.INSTALLED;
                MJOptionPane.showMessageDialog(null, (Object)BUNDLE.getString("prefs.web_doccenter_notreachable.text"), (String)BUNDLE.getString("prefs.web_doccenter_notreachable.title"), (int)0, (Icon)DialogIcon.INFO_32x32.getIcon());
            } else if (!HelpPrefs.isDocLocationOnWebSupported()) {
                HelpPrefs.setDocCenterLocation(DocLocation.INSTALLED);
                docLocation = DocLocation.INSTALLED;
            }
        }
        return docLocation != null ? docLocation : DocLocation.INSTALLED;
    }

    private static DocLocation getDocLocation(String string) {
        if (string != null) {
            try {
                return DocLocation.valueOf((String)string.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public static boolean isDocLocationOnWebSupported() {
        HtmlComponentFactory.HtmlComponentType htmlComponentType = HtmlComponentFactory.getExpectedHtmlComponentType(HtmlComponentFactory.HtmlComponentType.FOLLOW_PREFERENCE, HtmlComponentFactory.HtmlComponentType.HTMLPANEL, HtmlComponentFactory.HtmlComponentType.HTMLRENDERER);
        return htmlComponentType == HtmlComponentFactory.HtmlComponentType.HTMLPANEL;
    }

    public static String replacePathWithDocCenterPath(String string) {
        String string2 = string;
        if (!HelpPrefs.getDocRoot().equals(HelpPrefs.getDocCenterRoot())) {
            string2 = string2.replace(File.separatorChar, '/').replace(HelpPrefs.getDocRoot(), HelpPrefs.getDocCenterRoot());
        }
        return string2;
    }

    public static String replacePathWithInstalledDocPath(String string) {
        String string2 = string;
        if (!HelpPrefs.getDocRoot().equals(HelpPrefs.getDocCenterRoot())) {
            StringBuilder stringBuilder;
            boolean bl;
            StringBuilder stringBuilder2 = new StringBuilder(HelpPrefs.getDocCenterRoot());
            boolean bl2 = stringBuilder2.toString().endsWith("/");
            if (bl2 != (bl = (stringBuilder = new StringBuilder(HelpPrefs.getDocRoot())).toString().endsWith("/"))) {
                if (!bl2) {
                    stringBuilder2.append("/");
                } else {
                    stringBuilder.append("/");
                }
            }
            string2 = string2.replace(File.separatorChar, '/').replace(stringBuilder2.toString(), stringBuilder.toString());
        }
        return string2;
    }

    public static String replacePathWithWebDocCenterLink(String string) {
        String string2 = string;
        String string3 = HelpPrefs.getDocCenterRoot();
        int n = string2.lastIndexOf(string3);
        if (n != -1) {
            String string4 = HelpPrefs.getDocCenterWebRoot();
            String string5 = string2.substring(n + string3.length());
            string2 = string4.endsWith("/") && string5.startsWith("/") ? string4 + string5.substring(1) : string4 + string5;
        }
        return string2;
    }

    public static boolean getProductFilterEnabled() {
        return sProductFilterEnabled;
    }

    public static void setProductFilterEnabled(boolean bl) {
        if (bl != sProductFilterEnabled) {
            sProductFilterEnabled = bl;
            HelpPrefs.setBooleanPref("HelpFilterEnabled", bl);
        }
    }

    public static boolean shouldShowProduct(String string) {
        boolean bl = true;
        if (sProductFilterEnabled && !HelpPrefs.isProductSelected(string)) {
            bl = false;
        }
        return bl;
    }

    public static boolean isProductSelected(String string) {
        for (String string2 : sSelectedProducts) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private static String[] getSelectedProducts() {
        HelpPrefs.updateSelectedProducts();
        String[] stringArray = new String[sSelectedProducts.length];
        System.arraycopy(sSelectedProducts, 0, stringArray, 0, sSelectedProducts.length);
        return stringArray;
    }

    private static void updateSelectedProducts() {
        String string = HelpPrefs.getSelectedProductsFromPref();
        sSelectedProducts = HelpPrefs.convertIDsToProductNames(string);
    }

    private static String[] convertIDsToProductNames(String string) {
        String[] stringArray = string.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() == 0) continue;
            try {
                int n = Integer.parseInt(stringArray[i]);
                ProductIdentifier productIdentifier = ProductIdentifier.get((int)n);
                if (productIdentifier == null) continue;
                stringArray[i] = productIdentifier.getName();
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return stringArray;
    }

    private static Collection<ProductIdentifier> convertIDsToProductIdentifiers(String string) {
        String[] stringArray = string.split(";");
        ArrayList<ProductIdentifier> arrayList = new ArrayList<ProductIdentifier>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() == 0) continue;
            try {
                int n = Integer.parseInt(stringArray[i]);
                ProductIdentifier productIdentifier = ProductIdentifier.get((int)n);
                if (productIdentifier == null) continue;
                arrayList.add(productIdentifier);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    private static String getSelectedProductsFromPref() {
        if (sDependencyProvider.isMatlabAvailable()) {
            String string = Prefs.getStringPref((String)"HelpSelectedProducts", (String)"");
            if (string.length() == 0) {
                string = "1";
            }
            return string;
        }
        return "";
    }

    public static void saveSelectedProducts(String string) {
        String[] stringArray = string.split(";");
        String string2 = HelpPrefs.convertProductsToIDs(stringArray);
        HelpPrefs.setSelectedProductsPref(string2);
        sSelectedProducts = stringArray;
    }

    private static void setSelectedProductsPref(String string) {
        HelpPrefs.setStringPref("HelpSelectedProducts", string);
    }

    private static String convertProductsToIDs(String string) {
        if (string != null && string.length() > 0) {
            String[] stringArray = string.split(";");
            return HelpPrefs.convertProductsToIDs(stringArray);
        }
        return "";
    }

    private static String convertProductsToIDs(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (string.length() == 0) continue;
            ProductIdentifier productIdentifier = ProductIdentifier.get((String)string);
            if (productIdentifier != null) {
                string = String.valueOf(productIdentifier.getBitNum());
            }
            stringBuilder.append(";").append(string);
        }
        return stringBuilder.toString();
    }

    public static boolean isInstalledProductSelected(String string) {
        String[] stringArray;
        for (String string2 : stringArray = HelpPrefs.getSelectedInstalledProducts()) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDocCenterProductFilterEnabled() {
        return HelpPrefs.getDocCenterSelectedProducts().isFilterEnabled();
    }

    public static String[] getSelectedInstalledProducts() {
        String string = HelpPrefs.getDocCenterSelectedProducts().getInstalledProductIDs();
        String[] stringArray = HelpPrefs.convertIDsToProductNames(string);
        return stringArray;
    }

    private static Collection<String> getSelectedInstalledBaseCodes() {
        String string = HelpPrefs.getDocCenterSelectedProducts().getInstalledProductIDs();
        Collection<ProductIdentifier> collection = HelpPrefs.convertIDsToProductIdentifiers(string);
        ArrayList<ProductIdentifier> arrayList = new ArrayList<ProductIdentifier>(collection);
        LinkedList<String> linkedList = new LinkedList<String>();
        for (ProductIdentifier productIdentifier : arrayList) {
            linkedList.add(productIdentifier.getBaseCode());
        }
        return linkedList;
    }

    public static Collection<String> getSelectedBaseCodes() {
        Object object;
        String string = HelpPrefs.getDocCenterSelectedProducts().getInstalledProductIDs();
        Collection<ProductIdentifier> collection = HelpPrefs.convertIDsToProductIdentifiers(string);
        ArrayList<ProductIdentifier> arrayList = new ArrayList<ProductIdentifier>(collection);
        if (HelpPrefs.getDocCenterLocation() == DocLocation.WEB && HelpPrefs.isShowUninstalledProducts()) {
            object = HelpPrefs.getDocCenterSelectedProducts().getUninstalledProductIDs();
            arrayList.addAll(HelpPrefs.convertIDsToProductIdentifiers((String)object));
        }
        object = new LinkedList();
        for (ProductIdentifier productIdentifier : arrayList) {
            object.add(productIdentifier.getBaseCode());
        }
        return object;
    }

    private static Collection<Integer> getInstalledProductIds() {
        return HelpPrefs.getProductIDs(HelpPrefs.getInstalledProducts());
    }

    private static Collection<Integer> getUnInstalledProductIds() {
        return HelpPrefs.getProductIDs(HelpPrefs.getUninstalledProducts());
    }

    private static Collection<String> convertStringToCollection(String string) {
        String[] stringArray = string.split(";");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() == 0) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    private static String convertCollectionToString(Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : collection) {
            stringBuilder = stringBuilder.append(";").append(string);
        }
        return stringBuilder.toString();
    }

    public static void saveSelectedDocCenterProducts(boolean bl, String string, String string2) {
        DocCenterProductPrefs.setShowUninstalledProducts(bl);
        String string3 = HelpPrefs.convertProductsToIDs(string);
        Collection<Integer> collection = HelpPrefs.convertIDsToIntegerCollection(string3);
        boolean bl2 = !HelpPrefs.isAllProductIDsSelected(HelpPrefs.getProductIDs(HelpPrefs.getInstalledProducts()), collection);
        String string4 = "";
        boolean bl3 = false;
        if (bl) {
            string4 = HelpPrefs.convertProductsToIDs(string2);
            Collection<Integer> collection2 = HelpPrefs.convertIDsToIntegerCollection(string3);
            bl3 = !HelpPrefs.isAllProductIDsSelected(HelpPrefs.getProductIDs(HelpPrefs.getUninstalledProducts()), collection2);
        }
        HelpPrefs.setSelectedProductsAndUpdatePreferences(bl2 || bl3, string3, string4);
    }

    private static Collection<Integer> convertIDsToIntegerCollection(String string) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        if (string.length() > 0) {
            String[] stringArray = string.split(";");
            List<String> list = Arrays.asList(stringArray);
            for (String string2 : list) {
                if (string2.length() <= 0) continue;
                linkedList.add(Integer.parseInt(string2));
            }
        }
        return linkedList;
    }

    private static boolean isAllProductIDsSelected(Collection<Integer> collection, Collection<Integer> collection2) {
        return collection.size() == collection2.size() && collection.containsAll(collection2);
    }

    public static boolean isUninstalledProductSelected(String string) {
        String[] stringArray;
        for (String string2 : stringArray = HelpPrefs.getSelectedUninstalledProducts()) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String[] getSelectedUninstalledProducts() {
        String string = HelpPrefs.getDocCenterSelectedProducts().getUninstalledProductIDs();
        String[] stringArray = HelpPrefs.convertIDsToProductNames(string);
        return stringArray;
    }

    private static void setSelectedProductsAndUpdatePreferences(boolean bl, String string, String string2) {
        DocCenterSelectedProducts docCenterSelectedProducts = new DocCenterSelectedProducts(string, string2, bl);
        HelpPrefs.setDocCenterSelectedProducts(docCenterSelectedProducts);
        DocCenterProductPrefs.setSelectedProductPreferences(docCenterSelectedProducts);
    }

    private static void setDocCenterSelectedProducts(boolean bl, String string, String string2) {
        HelpPrefs.setDocCenterSelectedProducts(new DocCenterSelectedProducts(string, string2, bl));
    }

    private static synchronized void setDocCenterSelectedProducts(DocCenterSelectedProducts docCenterSelectedProducts) {
        sDocCenterSelectedProducts = docCenterSelectedProducts;
    }

    private static synchronized DocCenterSelectedProducts getDocCenterSelectedProducts() {
        if (sDocCenterSelectedProducts == null) {
            HelpPrefs.resolveSelectedProducts();
        }
        return sDocCenterSelectedProducts;
    }

    private static void resolveSelectedProducts() {
        DocCenterSelectedProducts docCenterSelectedProducts = DocCenterProductPrefs.getSelectedProductPreferences();
        if (!docCenterSelectedProducts.isFilterEnabled()) {
            HelpPrefs.populateDisabledProductFilter();
        } else {
            HelpPrefs.validateProductFilter(docCenterSelectedProducts);
        }
    }

    private static void populateDisabledProductFilter() {
        LinkedList<String> linkedList = new LinkedList<String>();
        Collection<Integer> collection = HelpPrefs.getInstalledProductIds();
        Object object = collection.iterator();
        while (object.hasNext()) {
            int n = object.next();
            linkedList.add(Integer.toString(n));
        }
        object = HelpPrefs.convertCollectionToString(linkedList);
        LinkedList<String> linkedList2 = new LinkedList<String>();
        Collection<Integer> collection2 = HelpPrefs.getUnInstalledProductIds();
        Object object2 = collection2.iterator();
        while (object2.hasNext()) {
            int n = object2.next();
            linkedList2.add(Integer.toString(n));
        }
        object2 = HelpPrefs.convertCollectionToString(linkedList2);
        HelpPrefs.setDocCenterSelectedProducts(false, (String)object, (String)object2);
    }

    private static void validateProductFilter(DocCenterSelectedProducts docCenterSelectedProducts) {
        String string4;
        String string2 = docCenterSelectedProducts.getInstalledProductIDs();
        String string3 = docCenterSelectedProducts.getUninstalledProductIDs();
        ArrayList<String> arrayList = new ArrayList<String>(HelpPrefs.convertStringToCollection(string2));
        arrayList.addAll(HelpPrefs.convertStringToCollection(string3));
        Collection<Integer> collection = HelpPrefs.getInstalledProductIds();
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        for (String string4 : arrayList) {
            try {
                int n = Integer.parseInt(string4);
                if (collection.contains(n)) {
                    linkedList.add(string4);
                    continue;
                }
                linkedList2.add(string4);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String string5 = HelpPrefs.convertCollectionToString(linkedList);
        string4 = HelpPrefs.convertCollectionToString(linkedList2);
        HelpPrefs.setSelectedProductsAndUpdatePreferences(true, string5, string4);
    }

    public static boolean isShowUninstalledProducts() {
        return DocCenterProductPrefs.isShowUninstalledProducts();
    }

    static void setShowHelpBrowserPreference(boolean bl) {
        HelpPrefs.setBooleanPref("HelpPopupShowsBrowser", bl);
    }

    static boolean getShowHelpBrowserPreference() {
        return HelpPrefs.getBooleanPref("HelpPopupShowsBrowser", false);
    }

    public static void addPrefsListeners(PrefListener prefListener, String ... stringArray) {
        if (sDependencyProvider.isMatlabAvailable()) {
            for (String string : stringArray) {
                Prefs.addListener((PrefListener)prefListener, (String)string);
            }
        }
    }

    public static void removePrefsListeners(PrefListener prefListener, String ... stringArray) {
        if (sDependencyProvider.isMatlabAvailable()) {
            for (String string : stringArray) {
                Prefs.removeListener((PrefListener)prefListener, (String)string);
            }
        }
    }

    private static void setBooleanPref(String string, boolean bl) {
        if (sDependencyProvider.isMatlabAvailable()) {
            Prefs.setBooleanPref((String)string, (boolean)bl);
        }
    }

    private static boolean getBooleanPref(String string, boolean bl) {
        return sDependencyProvider.isMatlabAvailable() ? Prefs.getBooleanPref((String)string, (boolean)bl) : bl;
    }

    private static void setStringPref(String string, String string2) {
        if (sDependencyProvider.isMatlabAvailable()) {
            Prefs.setStringPref((String)string, (String)string2);
        }
    }

    private static String getStringPref(String string, String string2) {
        return sDependencyProvider.isMatlabAvailable() ? Prefs.getStringPref((String)string, (String)string2) : string2;
    }

    private static Collection<Integer> getProductIDs(Collection<ProductIdentifier> collection) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (ProductIdentifier productIdentifier : collection) {
            hashSet.add(productIdentifier.getBitNum());
        }
        return Collections.unmodifiableCollection(hashSet);
    }

    public static synchronized Collection<ProductIdentifier> getInstalledProducts() {
        if (sInstalledProductIdentifiers == null) {
            DaoConfiguration daoConfiguration = new DaoConfiguration(Matlab.matlabRoot());
            DaoFactory daoFactory = DefaultDaoFactory.getDao((DaoConfig)daoConfiguration);
            ProductDao productDao = daoFactory.getProductDao();
            Collection collection = productDao.getInstalledProducts();
            TreeSet treeSet = new TreeSet(collection);
            LinkedList<ProductIdentifier> linkedList = new LinkedList<ProductIdentifier>();
            for (Product product : treeSet) {
                ProductIdentifier productIdentifier = ProductIdentifier.get((int)product.getBitNumber());
                if (productIdentifier == null) continue;
                linkedList.add(productIdentifier);
            }
            if (linkedList.isEmpty()) {
                linkedList.add(ProductIdentifier.MATLAB);
            }
            sInstalledProductIdentifiers = linkedList;
        }
        return Collections.unmodifiableCollection(sInstalledProductIdentifiers);
    }

    public static synchronized Collection<ProductIdentifier> getUninstalledProducts() {
        if (sUninstalledProductIdentifiers == null) {
            Collection<ProductIdentifier> collection = HelpPrefs.getInstalledProducts();
            HashSet<String> hashSet = new HashSet<String>();
            for (ProductIdentifier object2 : collection) {
                hashSet.add(object2.getName());
            }
            LinkedList linkedList = new LinkedList();
            List<ProductIdentifier> list = HelpPrefs.getSortedProductIdentifiers();
            for (ProductIdentifier productIdentifier : list) {
                if (hashSet.contains(productIdentifier.getName())) continue;
                linkedList.add(productIdentifier);
            }
            sUninstalledProductIdentifiers = !linkedList.isEmpty() ? linkedList : new LinkedList<ProductIdentifier>();
        }
        return Collections.unmodifiableCollection(sUninstalledProductIdentifiers);
    }

    /*
     * WARNING - void declaration
     */
    private static List<ProductIdentifier> getSortedProductIdentifiers() {
        ProductIdentifier productIdentifier;
        void product;
        ProductIdentifier[] productIdentifierArray = ProductIdentifier.values();
        TreeSet<ProdIdentifierProduct> treeSet = new TreeSet<ProdIdentifierProduct>();
        Object linkedList = productIdentifierArray;
        int n = ((ProductIdentifier[])linkedList).length;
        boolean bl = false;
        while (product < n) {
            productIdentifier = linkedList[product];
            treeSet.add(new ProdIdentifierProduct(productIdentifier.getBitNum(), productIdentifier.getName()));
            ++product;
        }
        linkedList = new LinkedList();
        for (Product product2 : treeSet) {
            productIdentifier = ProductIdentifier.get((int)product2.getBitNumber());
            if (productIdentifier == null) continue;
            linkedList.add(productIdentifier);
        }
        return linkedList;
    }

    public static synchronized Collection<DocProduct> getInstalledDocProducts() {
        if (sInstalledDocProducts == null) {
            DocCenterSearchHelper docCenterSearchHelper = DocCenterSearchHelper.getInstance();
            DocumentationSet documentationSet = docCenterSearchHelper.getDocumentationSet();
            List list = documentationSet.getAllProducts();
            sInstalledDocProducts = HelpPrefs.getDocProductsWithDocInstalled(list);
        }
        return Collections.unmodifiableCollection(sInstalledDocProducts);
    }

    private static Collection<DocProduct> getDocProductsWithDocInstalled(Collection<DocProduct> collection) {
        LinkedList<DocProduct> linkedList = new LinkedList<DocProduct>();
        if (collection != null && !collection.isEmpty()) {
            for (DocProduct docProduct : collection) {
                if (!HelpPrefs.isDocInstalledForDocProduct(docProduct)) continue;
                linkedList.add(docProduct);
            }
        }
        return linkedList;
    }

    private static boolean isDocInstalledForDocProduct(DocProduct docProduct) {
        File file = new File(new File(HelpPrefs.getDocRoot(), docProduct.getHelpLocation()), "doccenter.properties");
        return file.exists();
    }

    public static boolean isInstalledDocProductSelected(DocProduct docProduct) {
        DocCenterSearchHelper docCenterSearchHelper = DocCenterSearchHelper.getInstance();
        DocumentationSet documentationSet = docCenterSearchHelper.getDocumentationSet();
        return HelpPrefs.isInstalledDocProductSelected(docProduct, documentationSet);
    }

    public static boolean isInstalledDocProductSelected(DocProduct docProduct, DocumentationSet documentationSet) {
        if (docProduct == null || documentationSet == null) {
            return false;
        }
        ProductBaseCodeMap productBaseCodeMap = documentationSet.getBaseCodeMap();
        Collection<String> collection = HelpPrefs.getSelectedInstalledBaseCodes();
        Set set = productBaseCodeMap.getDocProductsForBaseCodes(new HashSet<String>(collection));
        for (DocProduct docProduct2 : set) {
            if (!docProduct.getShortName().equalsIgnoreCase(docProduct2.getShortName())) continue;
            return true;
        }
        return false;
    }

    private static synchronized void setDependencyProvider(HelpPrefsDependencyProvider helpPrefsDependencyProvider) {
        sDependencyProvider = helpPrefsDependencyProvider;
    }

    private static synchronized HelpPrefsDependencyProvider getDependencyProvider() {
        return sDependencyProvider;
    }

    static {
        sDocInstalled = DocInstalledState.UNKNOWN;
        sDocCenterSelectedProducts = null;
        BUNDLE = ResourceBundle.getBundle("com.mathworks.mlwidgets.help.resources.RES_HelpInfo");
        sDependencyProvider = new DefaultDependencyProvider();
        sProductFilterEnabled = HelpPrefs.getBooleanPref("HelpFilterEnabled", false);
        HelpPrefs.updateSelectedProducts();
        HelpPrefs.addPrefsListeners(new HelpDocLangPrefListener(), "HelpDocLanguage");
        HelpPrefs.addPrefsListeners(new HelpUseDocCenterPrefListener(), "HelpUseDocCenterBrowser");
    }

    private static class DefaultDependencyProvider
    implements HelpPrefsDependencyProvider {
        private DefaultDependencyProvider() {
        }

        @Override
        public boolean isMatlabAvailable() {
            return Matlab.isMatlabAvailable();
        }

        @Override
        public boolean isUsingDocCenterBrowser() {
            if (HelpPrefs.isDocCenterBrowserSupported()) {
                return HelpPrefs.getBooleanPref("HelpUseDocCenterBrowser", true);
            }
            return false;
        }
    }

    public static interface HelpPrefsDependencyProvider {
        public boolean isMatlabAvailable();

        public boolean isUsingDocCenterBrowser();
    }

    private static class ProdIdentifierProduct
    extends AbstractProduct {
        private final int iBitNumber;
        private final String iName;

        private ProdIdentifierProduct(int n, String string) {
            this.iBitNumber = n;
            this.iName = string;
        }

        public Integer getBitNumber() {
            return this.iBitNumber;
        }

        public String getName() {
            return this.iName;
        }

        public String getVersion() {
            return null;
        }

        public String getRelease() {
            return null;
        }

        public String getDate() {
            return null;
        }
    }

    private static class DaoConfiguration
    extends AbstractFileDaoConfig {
        private DaoConfiguration(String string) {
            super(string);
        }

        public DaoStrategyType getType() {
            return DaoStrategyType.WRAPPER;
        }
    }

    private static class HelpUseDocCenterPrefListener
    implements PrefListener {
        private HelpUseDocCenterPrefListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            HelpPrefs.updateSelectedProducts();
        }
    }

    private static class HelpDocLangPrefListener
    implements PrefListener {
        private HelpDocLangPrefListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            HelpPrefs.setLanguageInHelp(HelpPrefs.getDocLocale());
        }
    }

    private static enum DocInstalledState {
        DOC_INSTALLED,
        DOC_NOT_INSTALLED,
        UNKNOWN;

    }
}

