/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.help.helpui.DocLocation;
import com.mathworks.help.helpui.DocSearchPageChangedListener;
import com.mathworks.help.helpui.SearchHelper;
import com.mathworks.help.helpui.suggestions.DocSuggestionProtocolHandler;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.PageChangedListener;
import com.mathworks.html.RequestHandler;
import com.mathworks.mlwidgets.help.CSHelpTopicMap;
import com.mathworks.mlwidgets.help.DocCenterSearchHelper;
import com.mathworks.mlwidgets.help.HelpInfo;
import com.mathworks.mlwidgets.help.HelpInfoItem;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.help.ProductFilterRequestHandler;
import com.mathworks.mlwidgets.html.DocSearchRequestHandler;
import com.mathworks.mlwidgets.html.HTMLRenderer;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mlwidgets.html.HtmlComponentFactory;
import com.mathworks.mlwidgets.html.HtmlConversionUtils;
import com.mathworks.mlwidgets.html.MJHtmlPanel;
import com.mathworks.mlwidgets.html.MatlabHtmlActions;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.io.File;
import java.io.UnsupportedEncodingException;

public class HelpPanel
extends MJPanel {
    private HtmlComponent<MatlabHtmlActions> fHtmlComponent;
    private boolean fSuppressLoadForCurrentLocation = false;
    private static HtmlComponentFactory.HtmlComponentType DEFAULT_COMPONENT_TYPE = HelpPrefs.isUsingDocCenterBrowser() && !PlatformInfo.isLinux() ? HtmlComponentFactory.HtmlComponentType.HTMLPANEL : HtmlComponentFactory.HtmlComponentType.HTMLRENDERER;

    public HelpPanel() {
        this(DEFAULT_COMPONENT_TYPE);
    }

    public HelpPanel(HtmlComponentFactory.HtmlComponentType htmlComponentType) {
        this.setLayout(new BorderLayout());
        this.fHtmlComponent = htmlComponentType == HtmlComponentFactory.HtmlComponentType.HTMLPANEL ? HtmlComponentFactory.buildHtmlComponent(HtmlComponentFactory.HtmlComponentType.FOLLOW_PREFERENCE, HtmlComponentFactory.HtmlComponentType.HTMLPANEL, HtmlComponentFactory.HtmlComponentType.HTMLRENDERER) : HtmlComponentFactory.buildHtmlComponent(htmlComponentType);
        CSHelpViewerVisitor cSHelpViewerVisitor = new CSHelpViewerVisitor();
        HtmlConversionUtils.visitBrowser(this.fHtmlComponent, cSHelpViewerVisitor);
        this.add(this.fHtmlComponent.getComponent(), "Center");
    }

    private static void addHandlersForInstalledDoc(MJHtmlPanel mJHtmlPanel) {
        DocCenterSearchHelper docCenterSearchHelper = DocCenterSearchHelper.getInstance();
        mJHtmlPanel.addPageChangedListener((PageChangedListener)new DocSearchPageChangedListener((HtmlComponent)mJHtmlPanel, (SearchHelper)docCenterSearchHelper, HelpPrefs.DEFAULT_DOC_RELEASE));
        mJHtmlPanel.addRequestHandler((RequestHandler)new DocSuggestionProtocolHandler((HtmlComponent)mJHtmlPanel, (SearchHelper)docCenterSearchHelper, HelpPrefs.getDocCenterRoot()));
        mJHtmlPanel.addRequestHandler((RequestHandler)new ProductFilterRequestHandler(mJHtmlPanel, docCenterSearchHelper.getDocumentationSet()));
    }

    public HtmlComponent<MatlabHtmlActions> getHTMLRenderer() {
        return this.fHtmlComponent;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.fHtmlComponent.getComponent().setVisible(bl);
    }

    public void dispose() {
        this.fHtmlComponent.dispose();
    }

    public void setSuppressLoadForCurrentLocation(boolean bl) {
        this.fSuppressLoadForCurrentLocation = bl;
    }

    public void setCurrentLocation(String string) {
        String string2 = string;
        if (HelpPrefs.isUsingDocCenterBrowser()) {
            if (HelpPrefs.getDocCenterLocation().equals((Object)DocLocation.INSTALLED)) {
                string2 = HelpUtils.getLocalizedFilename(string2);
            }
        } else {
            string2 = HelpUtils.getPrefixForHtmlPath(string);
        }
        string2 = HelpPanel.encodeUrlIfNecessary(string2);
        if (this.fSuppressLoadForCurrentLocation && HTMLUtils.compareFiles(string2, this.fHtmlComponent.getCurrentLocation())) {
            return;
        }
        this.fHtmlComponent.setCurrentLocation(string2);
    }

    public boolean showHelpPage(String string, String string2) {
        String string3 = null;
        if (HelpPrefs.isUsingDocCenterBrowser()) {
            string3 = HelpPrefs.getDocCenterRoot() + File.separator + string + File.separator + string2;
        } else {
            String string4;
            HelpInfoItem helpInfoItem = HelpInfo.getHelpInfoItemByShortName(string);
            if (helpInfoItem != null && (string4 = HelpUtils.getProductHelpPage(helpInfoItem, string2)) != null) {
                string3 = string4;
            }
        }
        if (string3 != null) {
            this.setCurrentLocation(string3);
            return true;
        }
        return false;
    }

    public String getCurrentLocation() {
        return this.fHtmlComponent.getCurrentLocation();
    }

    public void setHtmlText(String string) {
        this.fHtmlComponent.setHtmlText(string);
    }

    public String getHtmlText() {
        return this.fHtmlComponent.getHtmlText();
    }

    public void displayTopic(String string, String string2) {
        if (string != null) {
            CSHelpTopicMap cSHelpTopicMap = new CSHelpTopicMap(string);
            if (cSHelpTopicMap.exists()) {
                String string3 = cSHelpTopicMap.mapID(string2);
                if (string3 != null) {
                    this.setCurrentLocation(string3);
                } else {
                    this.fHtmlComponent.setHtmlText("<html><body>Topic " + string2 + " in " + cSHelpTopicMap.getFilePath() + " not found.</body></html>");
                }
            } else {
                this.fHtmlComponent.setHtmlText("<html><body>Mapfile not found: " + cSHelpTopicMap.getFilePath() + "</body></html>");
            }
        }
    }

    private static String encodeUrlIfNecessary(String string) {
        block3: {
            if (HTMLUtils.needsEncoding(string)) {
                try {
                    return HTMLUtils.encodeUrl(string, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)"We should always be able to encode URLs using UTF-8");
                }
            }
        }
        return string;
    }

    private static class CSHelpViewerVisitor
    implements HtmlConversionUtils.BrowserVisitor {
        private CSHelpViewerVisitor() {
        }

        @Override
        public void visitMJHtmlPanel(MJHtmlPanel mJHtmlPanel) {
            if (HelpPrefs.getDocCenterLocation() == DocLocation.INSTALLED) {
                HelpPanel.addHandlersForInstalledDoc(mJHtmlPanel);
            }
        }

        @Override
        public void visitHTMLRenderer(HTMLRenderer hTMLRenderer) {
            hTMLRenderer.addRequestHandler(new DocSearchRequestHandler(hTMLRenderer, (SearchHelper)DocCenterSearchHelper.getInstance(), HelpPrefs.DEFAULT_DOC_RELEASE));
        }
    }
}

