/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import java.io.InputStream;
import javax.swing.tree.DefaultMutableTreeNode;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public final class FunctionCategoryXMLParser {
    public static DefaultMutableTreeNode parse(InputStream inputStream) {
        return FunctionCategoryXMLParser.parse(inputStream, "^[a-zA-Z0-9._]+$");
    }

    public static DefaultMutableTreeNode parse(InputStream inputStream, String string) {
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            CatagoryHandler catagoryHandler = new CatagoryHandler();
            catagoryHandler.setFunctionNameRegexp(string);
            xMLReader.setContentHandler(catagoryHandler);
            xMLReader.parse(new InputSource(inputStream));
            return catagoryHandler.fCurrentCategoryNode;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static class Category
    extends DefaultMutableTreeNode {
        private String iPath;

        public Category(String string, String string2) {
            super(string, true);
            this.iPath = string2;
        }

        public String getRefPagePath() {
            return this.iPath;
        }
    }

    public static class FunctionItem
    extends DefaultMutableTreeNode {
        private String iH1Line;
        private String iPath;

        public FunctionItem(String string, String string2, String string3) {
            super(string, false);
            this.iH1Line = string2;
            this.iPath = string3;
        }

        public String getH1Line() {
            return this.iH1Line;
        }

        public String getRefPagePath() {
            return this.iPath;
        }
    }

    private static class CatagoryHandler
    extends DefaultHandler {
        private boolean fInCategoryTag = false;
        private boolean fInFunctionTag = false;
        private String fCategoryName = "";
        private String fFunctionName = "";
        private boolean fInLabelTag = false;
        private DefaultMutableTreeNode fCurrentCategoryNode;
        private String fH1Line = "";
        private String fFile = "";
        private int fVersion = 1;
        private String fFunctionNameRegexp;
        private boolean fV2InTokenTag = false;
        private boolean fV2InNameTag = false;
        private boolean fV2InPurposeTag = false;
        private int fV2toctagDepth = 0;

        private CatagoryHandler() {
        }

        private void setFunctionNameRegexp(String string) {
            this.fFunctionNameRegexp = string;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.fVersion == 1 && "toc".equals(string2)) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!"version".equalsIgnoreCase(attributes.getLocalName(i))) continue;
                    try {
                        this.fVersion = (int)Double.parseDouble(attributes.getValue(i));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.fVersion = 1;
                    }
                }
            }
            if (this.fVersion == 1) {
                this.startElement_v1(string2, attributes);
            } else if (this.fVersion == 2) {
                this.startElement_v2(string2, attributes);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.fVersion == 1) {
                this.endElement_v1(string2);
            } else if (this.fVersion == 2) {
                this.endElement_v2(string2);
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.fVersion == 1) {
                this.characters_v1(cArray, n, n2);
            } else if (this.fVersion == 2) {
                this.characters_v2(cArray, n, n2);
            }
        }

        private void startElement_v1(String string, Attributes attributes) {
            if ("functionsection".equals(string) || "functionsbycategory".equals(string)) {
                this.fInCategoryTag = true;
            } else if ("functionitem".equals(string)) {
                this.fInFunctionTag = true;
                this.fFunctionName = "";
                this.fH1Line = "";
                this.fFile = "";
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if ("name".equals(attributes.getLocalName(i))) {
                        this.fFunctionName = attributes.getValue(i);
                        continue;
                    }
                    if (!"file".equals(attributes.getLocalName(i))) continue;
                    this.fFile = attributes.getValue(i);
                }
            }
            if (this.fInCategoryTag && "label".equals(string)) {
                this.fInLabelTag = true;
            }
        }

        private void endElement_v1(String string) {
            if ("functionsection".equals(string) || "functionsbycategory".equals(string)) {
                this.fInCategoryTag = false;
                if (this.fCurrentCategoryNode != null && this.fCurrentCategoryNode.getParent() != null) {
                    this.fCurrentCategoryNode = (DefaultMutableTreeNode)this.fCurrentCategoryNode.getParent();
                }
            } else if ("functionitem".equals(string)) {
                this.fInFunctionTag = false;
                if (this.fFunctionName != null && this.fFunctionName.matches(this.fFunctionNameRegexp)) {
                    FunctionItem functionItem = new FunctionItem(this.fFunctionName, this.fH1Line, this.fFile);
                    if (this.fCurrentCategoryNode != null) {
                        this.fCurrentCategoryNode.add(functionItem);
                    }
                }
                this.fFunctionName = "";
                this.fH1Line = "";
                this.fFile = "";
            } else if ("label".equals(string)) {
                this.fInLabelTag = false;
                if (this.fInCategoryTag) {
                    DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.fCategoryName, true);
                    if (this.fCurrentCategoryNode != null) {
                        this.fCurrentCategoryNode.add(defaultMutableTreeNode);
                    }
                    this.fCurrentCategoryNode = defaultMutableTreeNode;
                    this.fCategoryName = "";
                }
            }
        }

        private void characters_v1(char[] cArray, int n, int n2) {
            char[] cArray2 = new char[n2];
            System.arraycopy(cArray, n, cArray2, 0, n2);
            if (this.fInLabelTag && this.fInCategoryTag) {
                this.fCategoryName = this.fCategoryName + new String(cArray2);
            } else if (this.fInFunctionTag) {
                this.fH1Line = this.fH1Line + new String(cArray2);
            }
        }

        private void startElement_v2(String string, Attributes attributes) {
            if ("tocitem".equals(string)) {
                ++this.fV2toctagDepth;
                if (this.fV2InTokenTag && this.isValidCategoryName(this.fCategoryName)) {
                    Category category = new Category(this.fCategoryName.trim(), this.fFile);
                    if (this.fCurrentCategoryNode != null) {
                        this.fCurrentCategoryNode.add(category);
                    }
                    this.fCurrentCategoryNode = category;
                    this.fCategoryName = "";
                }
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!"target".equals(attributes.getLocalName(i))) continue;
                    this.fFile = attributes.getValue(i);
                }
                this.fV2InTokenTag = true;
                return;
            }
            if (!this.fV2InTokenTag) {
                return;
            }
            if ("name".equals(string)) {
                this.fV2InNameTag = true;
            }
            if ("purpose".equals(string)) {
                this.fV2InPurposeTag = true;
            }
        }

        private boolean isValidCategoryName(String string) {
            if (string != null) {
                return string.trim().length() > 0;
            }
            return false;
        }

        private void endElement_v2(String string) {
            if (!this.fV2InTokenTag) {
                return;
            }
            if ("tocitem".equals(string)) {
                --this.fV2toctagDepth;
                if (this.fFunctionName != null && this.fFunctionName.trim().length() > 0) {
                    if (this.fFunctionName.matches(this.fFunctionNameRegexp)) {
                        FunctionItem functionItem = new FunctionItem(this.fFunctionName, this.fH1Line, this.fFile);
                        if (this.fCurrentCategoryNode != null) {
                            this.fCurrentCategoryNode.add(functionItem);
                        }
                    }
                    this.fFunctionName = "";
                    this.fH1Line = "";
                    this.fFile = "";
                } else if (this.fCurrentCategoryNode != null && this.fCurrentCategoryNode.getParent() != null && !this.isValidCategoryName(this.fCategoryName)) {
                    this.fCurrentCategoryNode = (DefaultMutableTreeNode)this.fCurrentCategoryNode.getParent();
                } else {
                    this.fCategoryName = "";
                }
                this.fV2InNameTag = false;
                this.fV2InPurposeTag = false;
                if (this.fV2toctagDepth == 0) {
                    this.fV2InTokenTag = false;
                }
                return;
            }
            if ("name".equals(string)) {
                this.fV2InNameTag = false;
            }
            if ("purpose".equals(string)) {
                this.fV2InPurposeTag = false;
            }
        }

        private void characters_v2(char[] cArray, int n, int n2) {
            char[] cArray2 = new char[n2];
            System.arraycopy(cArray, n, cArray2, 0, n2);
            String string = new String(cArray2);
            string = string.replaceAll("[\n|\t]", "");
            if (this.fV2InNameTag) {
                this.fFunctionName = this.fFunctionName + string;
            } else if (this.fV2InPurposeTag) {
                this.fH1Line = this.fH1Line + string;
            } else if (this.fV2InTokenTag) {
                this.fCategoryName = this.fCategoryName + string;
            }
        }
    }
}

