/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.graphics;

import com.mathworks.mlwidgets.actionbrowser.TearOffDialog;
import com.mathworks.mlwidgets.graphics.PlotPicker;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

class WindowDropdownButton
extends MJButton
implements ActionListener {
    static Color DEFAULT_BACKGROUND_COLOR = new Color(249, 249, 249);
    private TearOffDialog fFrame;
    private PlotPicker fPlotPicker;
    private Component fComponentToAlignWith = this;
    private static int MAX_AUTO_WIDTH = 400;

    WindowDropdownButton(PlotPicker plotPicker) {
        this.fPlotPicker = plotPicker;
        this.setupButton();
        this.setIcon(null);
    }

    static Color getPopupSelectionColor() {
        return PlatformInfo.isMacintosh() ? UIManager.getColor("TextField.selectionBackground") : UIManager.getColor("InternalFrame.activeTitleBackground");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isEnabled()) {
            if (this.fFrame != null && this.fFrame.isVisible()) {
                this.hideMenu();
            } else {
                this.doPostMenu();
            }
        }
    }

    void setActive(boolean bl) {
        this.removeActionListener(this);
        if (bl) {
            this.addActionListener(this);
        }
    }

    private void setupButton() {
        this.setFocusPainted(false);
        this.addActionListener(this);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (WindowDropdownButton.this.isEnabled() && keyEvent.getKeyCode() == 40) {
                    WindowDropdownButton.this.doPostMenu();
                    keyEvent.consume();
                }
            }
        });
        if (PlatformInfo.isWindowsClassicAppearance()) {
            this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        }
    }

    boolean isShowingContent() {
        return this.fFrame != null && this.fFrame.isVisible();
    }

    void doPostMenu() {
        Point point;
        if (this.fFrame != null) {
            if (this.fFrame.isVisible()) {
                return;
            }
            this.fFrame.close();
            this.fFrame = null;
        }
        this.fFrame = this.fPlotPicker.createPlotPickerDialog();
        Component component = this.getComponentToAlignWith();
        Rectangle rectangle = component.getBounds();
        try {
            point = component.getLocationOnScreen();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            point = MouseInfo.getPointerInfo().getLocation();
        }
        point.y += rectangle.height;
        Rectangle rectangle2 = WindowUtils.getVirtualScreenBounds();
        if (point.y + this.fFrame.getSize().height > rectangle2.y + rectangle2.height) {
            point.y = point.y - rectangle.height - this.fFrame.getSize().height;
        }
        if (point.x + this.fFrame.getSize().width > rectangle2.x + rectangle2.width) {
            point.x = point.x + rectangle.width - this.fFrame.getSize().width;
        }
        this.fFrame.setLocation(new Point(point.x, point.y));
        if (this.fFrame.getPreferredSize().width == this.fFrame.getMinimumSize().width) {
            int n;
            int n2 = n = component.getWidth() < MAX_AUTO_WIDTH ? component.getWidth() : MAX_AUTO_WIDTH;
            if (n > this.fFrame.getWidth()) {
                this.fFrame.setSize(new Dimension(n, this.fFrame.getHeight()));
            }
        }
        if (!WindowUtils.isEntirelyOnSingleScreen((Rectangle)this.fFrame.getBounds())) {
            WindowUtils.ensureOnSingleScreen((Window)((Object)this.fFrame));
        }
        this.fFrame.open();
    }

    public Component getComponentToAlignWith() {
        return this.fComponentToAlignWith;
    }

    public void setComponentToAlignWith(Component component) {
        this.fComponentToAlignWith = component;
    }

    private void hideMenu() {
        if (this.fFrame != null) {
            this.fFrame.close();
            this.fFrame = null;
        }
    }

    public void setIcon(Icon icon) {
        ArrowIcon arrowIcon = new ArrowIcon(icon);
        super.setIcon((Icon)arrowIcon);
    }

    public void setDisabledIcon(Icon icon) {
        ArrowIcon arrowIcon = new ArrowIcon(icon);
        super.setDisabledIcon((Icon)arrowIcon);
    }

    private static Icon getEnabledArrowIcon() {
        Color color = UIManager.getColor("control");
        return MJUtilities.isHighContrast() && ColorUtils.isDark((Color)color) ? new ImageIcon(WindowDropdownButton.class.getResource("resources/arrow_down_highcontrast.png")) : new ImageIcon(WindowDropdownButton.class.getResource("resources/arrow_down_default.png"));
    }

    private static Icon getDisabledArrowIcon() {
        return new ImageIcon(WindowDropdownButton.class.getResource("resources/arrow_down_disabled.png"));
    }

    private class ArrowIcon
    implements Icon {
        private final Icon fBaseIcon;
        private static final int SPACE_BETWEEN = 2;

        ArrowIcon(Icon icon) {
            this.fBaseIcon = icon;
        }

        private Icon getArrowIcon() {
            return WindowDropdownButton.this.isEnabled() ? WindowDropdownButton.getEnabledArrowIcon() : WindowDropdownButton.getDisabledArrowIcon();
        }

        @Override
        public int getIconHeight() {
            return this.fBaseIcon == null ? this.getArrowIcon().getIconHeight() : Math.max(this.fBaseIcon.getIconHeight(), this.getArrowIcon().getIconWidth());
        }

        @Override
        public int getIconWidth() {
            return this.fBaseIcon == null ? this.getArrowIcon().getIconWidth() : this.fBaseIcon.getIconWidth() + 2 + this.getArrowIcon().getIconWidth();
        }

        private int getArrowX() {
            return this.fBaseIcon == null ? 0 : this.fBaseIcon.getIconWidth() + 2;
        }

        private int getArrowY() {
            return this.fBaseIcon == null ? 0 : this.getIconHeight() / 2 - this.getArrowIcon().getIconHeight() / 2;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.fBaseIcon != null) {
                this.fBaseIcon.paintIcon(component, graphics, n, n2);
            }
            this.getArrowIcon().paintIcon(component, graphics, n + this.getArrowX(), n2 + this.getArrowY());
        }
    }
}

