/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.graphics;

import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.actionbrowser.AbstractActionTable;
import com.mathworks.mlwidgets.actionbrowser.TearOffCloser;
import com.mathworks.mlwidgets.actionbrowser.TearOffDialog;
import com.mathworks.mlwidgets.actionbrowser.TransparentDialog;
import com.mathworks.mlwidgets.graphics.PlotPickerDialog;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.Desktop;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.SwingUtilities;

class PlotPickerCloser
extends WindowAdapter
implements TearOffCloser,
DTClientListener {
    private boolean fBlockClose = false;
    private PlotPickerDialog fPlotPickerDialog;
    private MouseManager fMouseManager;

    PlotPickerCloser() {
    }

    public void clientActivating(DTClientEvent dTClientEvent) {
    }

    public void clientClosed(DTClientEvent dTClientEvent) {
    }

    public void clientClosing(DTClientEvent dTClientEvent) {
    }

    public void clientDeactivated(DTClientEvent dTClientEvent) {
    }

    public void clientDocked(DTClientEvent dTClientEvent) {
    }

    public void clientDocking(DTClientEvent dTClientEvent) {
    }

    public void clientOpened(DTClientEvent dTClientEvent) {
    }

    public void clientRelocated(DTClientEvent dTClientEvent) {
    }

    public void clientUndocked(DTClientEvent dTClientEvent) {
    }

    public void clientUndocking(DTClientEvent dTClientEvent) {
    }

    @Override
    public void uninstall(TearOffDialog tearOffDialog) {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.fMouseManager);
        this.fMouseManager = null;
        MatlabDesktopServices.getDesktop().removeClientListener((DTClientListener)this);
        tearOffDialog.removeWindowListener(this);
    }

    @Override
    public void install(TearOffDialog tearOffDialog) {
        this.initMouseManager();
        Toolkit.getDefaultToolkit().addAWTEventListener(this.fMouseManager, 131088L);
        MatlabDesktopServices.getDesktop().addClientListener((DTClientListener)this);
        tearOffDialog.addWindowListener(this);
        assert (tearOffDialog instanceof PlotPickerDialog);
        this.fPlotPickerDialog = (PlotPickerDialog)tearOffDialog;
    }

    private void initMouseManager() {
        this.fMouseManager = new MouseManager();
    }

    void setBlockClose(boolean bl) {
        this.fBlockClose = bl;
    }

    public void clientActivated(DTClientEvent dTClientEvent) {
        Window[] windowArray;
        Component component = dTClientEvent.getClient();
        if (component != null && "com.mathworks.hg.peer.FigureClientProxy$FigureDTClientBase".equals(component.getClass().getName().trim())) {
            return;
        }
        if (dTClientEvent.getClient() != null) {
            windowArray = SwingUtilities.windowForComponent(dTClientEvent.getClient());
            Window[] windowArray2 = MouseInfo.getPointerInfo().getLocation();
            if (windowArray2 != null && windowArray != null) {
                SwingUtilities.convertPointFromScreen((Point)windowArray2, (Component)windowArray);
                Component component2 = SwingUtilities.getDeepestComponentAt((Component)windowArray, windowArray2.x, windowArray2.y);
                if (component2 != null && component2 instanceof MJButton && "plot-picker".equals(component2.getName())) {
                    return;
                }
            }
        }
        if (!this.fBlockClose) {
            windowArray = null;
            if (PlatformInfo.isMacOSLeopardOrLater()) {
                windowArray = AbstractActionTable.getFloatingTooltips(dTClientEvent.getClient());
            }
            this.closePlotPicker();
            if (windowArray != null) {
                for (Window window : windowArray) {
                    window.toFront();
                }
            }
        }
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        if (windowEvent.getOppositeWindow() != null && windowEvent.getOppositeWindow() instanceof MJDialog && !windowEvent.getOppositeWindow().isAlwaysOnTop()) {
            WindowListener[] windowListenerArray;
            MJDialog mJDialog = (MJDialog)windowEvent.getOppositeWindow();
            if (this.fPlotPickerDialog.getOwner() != mJDialog.getOwner() || mJDialog == this.fPlotPickerDialog) {
                return;
            }
            for (WindowListener windowListener : windowListenerArray = mJDialog.getWindowListeners()) {
                if (!(windowListener instanceof DependentDialogWindowListener)) continue;
                return;
            }
            mJDialog.addWindowListener((WindowListener)new DependentDialogWindowListener());
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        this.setBlockClose(false);
        if (PlatformInfo.isMacOSLeopardOrLater()) {
            Window[] windowArray;
            for (Window window : windowArray = AbstractActionTable.getFloatingTooltips(this.fPlotPickerDialog.getOwner())) {
                if (!(window instanceof TransparentDialog)) continue;
                window.toFront();
            }
        }
    }

    public void clientResized(DTClientEvent dTClientEvent) {
        this.clientActivated(dTClientEvent);
    }

    private void closePlotPicker() {
        this.fBlockClose = false;
        if (this.fPlotPickerDialog != null && this.fPlotPickerDialog.isVisible()) {
            this.fPlotPickerDialog.close();
            this.fPlotPickerDialog.dispose();
        }
    }

    private static boolean isFigureComponent(Object object) {
        if (!(object instanceof Component)) {
            return false;
        }
        Component component = (Component)object;
        return "com.mathworks.hg.peer.FigureClientProxy$FigureDTClientBase".equals(component.getClass().getName().trim());
    }

    private class MouseManager
    implements AWTEventListener {
        private MouseManager() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            if (aWTEvent instanceof MouseEvent && (aWTEvent.getID() == 501 || aWTEvent.getID() == 506)) {
                Object object;
                Object object2 = aWTEvent.getSource();
                if (PlotPickerCloser.this.fPlotPickerDialog != null) {
                    object = PlotPickerCloser.this.fPlotPickerDialog.getExcludedClickTargets();
                    for (Component component : object) {
                        if (object2 != component) continue;
                        return;
                    }
                }
                if (!(object2 instanceof Component)) {
                    return;
                }
                if (PlatformInfo.isLinux() && (object = object2 instanceof Window ? (Window)object2 : SwingUtilities.getWindowAncestor((Component)object2)) != null && ((Window)object).isAlwaysOnTop()) {
                    return;
                }
                if (PlotPickerCloser.this.fPlotPickerDialog != null) {
                    if (!(!SwingUtilities.isDescendingFrom((Component)object2, (Component)((Object)PlotPickerCloser.this.fPlotPickerDialog)) && !SwingUtilities.isDescendingFrom((Component)object2, PlotPickerCloser.this.fPlotPickerDialog.getOwner()) || (object = Desktop.getClientComponentAncestor((Component)((Component)object2))) != null && PlotPickerCloser.isFigureComponent(object))) {
                        return;
                    }
                    PlotPickerCloser.this.fPlotPickerDialog.close();
                }
            } else if (PlotPickerCloser.this.fPlotPickerDialog != null && !PlotPickerCloser.this.fPlotPickerDialog.isFocused() && aWTEvent.getSource() instanceof Component && !SwingUtilities.isDescendingFrom((Component)aWTEvent.getSource(), (Component)((Object)PlotPickerCloser.this.fPlotPickerDialog)) && aWTEvent instanceof MouseWheelEvent) {
                if (aWTEvent.getSource() != null && !PlotPickerCloser.isFigureComponent(aWTEvent.getSource())) {
                    return;
                }
                PlotPickerCloser.this.fPlotPickerDialog.dispatchWheelEvent((MouseWheelEvent)aWTEvent);
            }
        }
    }

    private class DependentDialogWindowListener
    extends WindowAdapter {
        private DependentDialogWindowListener() {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            PlotPickerCloser.this.setBlockClose(true);
            PlotPickerCloser.this.fPlotPickerDialog.requestFocus();
            windowEvent.getWindow().removeWindowListener(this);
        }
    }
}

