/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.graphics;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlservices.MLExecutionEvent;
import com.mathworks.mlservices.MLExecutionListener;
import com.mathworks.mlwidgets.graphics.PlotPicker;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.Log;
import com.mathworks.xml.XMLUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;

public final class PlotAction
implements Cloneable {
    private String fFunctionName;
    private String fExecutionTextFcn;
    private String fDescription;
    private String fShortDescription;
    private String fVisibilityFunc;
    private String fLabelFunc;
    private String fIconPath;
    private ImageIcon fIcon;
    private ImageIcon fSmallIcon;
    private String fSmallIconPath;
    private String fRuleDescription;
    private boolean fIsFavorite = false;
    private String fID;
    private String fProductHelp;
    private String fRefPagePath;
    private String fMethodOf;
    private boolean fAllowSwap = true;
    private boolean fIsGUI;
    private static boolean sPathChecked = false;
    static boolean sNeedPathRehash = false;
    private static volatile boolean sMatlabProcessing = false;
    private static ExecutionWorker sWorker = new ExecutionWorker();

    public PlotAction(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15) {
        this.fFunctionName = string4;
        this.fDescription = string2;
        this.fShortDescription = string3;
        this.fVisibilityFunc = string5;
        this.fIcon = PlotAction.loadIcon(string9, "resources/plottype-default.png");
        this.fSmallIcon = null;
        if (string10 != null && string10.trim().length() > 0) {
            this.fSmallIcon = PlotAction.loadIcon(string10, null);
        }
        if (this.fSmallIcon == null) {
            this.fSmallIcon = PlotAction.createIcon(this.fIcon);
        }
        this.fSmallIconPath = string10;
        this.fIconPath = string9;
        this.fRuleDescription = string7;
        this.fExecutionTextFcn = string6;
        this.fLabelFunc = string8;
        this.fID = string;
        this.fProductHelp = string11;
        this.fRefPagePath = string12;
        this.fMethodOf = string13;
        this.fAllowSwap = "yes".equals(string14);
        this.fIsGUI = "yes".equals(string15);
    }

    public String getPlotLabel(String[] stringArray) {
        if (this.fShortDescription != null && this.fShortDescription.length() > 0) {
            return this.fShortDescription;
        }
        return this.getFunctionName() + PlotAction.createArgumentString(stringArray);
    }

    String getSwappedPlotLabel(String[] stringArray) {
        return this.getFunctionName() + PlotAction.createSwappedArgumentString(stringArray);
    }

    public String getExecutionString(String[] stringArray) {
        return this.getExecutionString(stringArray, false);
    }

    private String getExecutionString(String[] stringArray, boolean bl) {
        if (bl) {
            return "figure;" + this.getFunctionName() + PlotAction.createArgumentString(stringArray) + ";";
        }
        return this.getFunctionName() + PlotAction.createArgumentString(stringArray) + ";figure(gcf);";
    }

    private String getSwappedExecutionString(String[] stringArray, boolean bl) {
        if (bl) {
            return "figure;" + this.getFunctionName() + PlotAction.createSwappedArgumentString(stringArray) + ";";
        }
        return this.getFunctionName() + PlotAction.createSwappedArgumentString(stringArray) + ";figure(gcf);";
    }

    String getSwappedExecutionString(String[] stringArray) {
        return this.getSwappedExecutionString(stringArray, false);
    }

    String getProductHelp() {
        return this.fProductHelp;
    }

    String getRefPagePath() {
        return this.fRefPagePath;
    }

    String getMethodOf() {
        return this.fMethodOf;
    }

    public String toString() {
        return this.fID;
    }

    boolean isFavorite() {
        return this.fIsFavorite;
    }

    void setFavorite(boolean bl) {
        this.fIsFavorite = bl;
    }

    String getLabelFunction() {
        return this.fLabelFunc;
    }

    boolean hasCustomLabelFunction() {
        return this.fLabelFunc != null && this.fLabelFunc.length() > 0;
    }

    boolean hasCustomExecutionFunction() {
        return this.fExecutionTextFcn != null && this.fExecutionTextFcn.length() > 0;
    }

    public String getRuleDescription() {
        if (this.fRuleDescription == null || this.fRuleDescription.length() == 0) {
            return PlotPicker.getResourceString("PlotAction", "SeeDoc");
        }
        return this.fRuleDescription;
    }

    String getFunctionName() {
        return this.fFunctionName;
    }

    String getDescription() {
        return this.fDescription;
    }

    String getShortDescription() {
        return this.fShortDescription;
    }

    ImageIcon getIcon() {
        return this.fIcon;
    }

    ImageIcon getSmallIcon() {
        return this.fSmallIcon;
    }

    String getSelectionMCode() {
        return this.fVisibilityFunc;
    }

    String getExecutionTextFcn() {
        return this.fExecutionTextFcn;
    }

    void setRuleDescription(String string) {
        this.fRuleDescription = string;
    }

    void setExecutionTextFcn(String string) {
        this.fExecutionTextFcn = string;
    }

    String getLargeIconPath() {
        return this.fIconPath;
    }

    String getSmallIconPath() {
        return this.fSmallIconPath;
    }

    String getID() {
        return this.fID;
    }

    boolean allowSwap() {
        return this.fAllowSwap;
    }

    void setAllowSwap(boolean bl) {
        this.fAllowSwap = bl;
    }

    boolean isGUI() {
        return this.fIsGUI;
    }

    void setProductHelp(String string) {
        this.fProductHelp = string;
    }

    void setRefPagePath(String string) {
        this.fRefPagePath = string;
    }

    static URL getIconURL(String string) {
        Object object;
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.matches("\\s*\\(\\s*matlabroot\\s*\\).*")) {
            object = Matlab.matlabRoot().replace(File.separatorChar, '/');
            String string2 = string.replaceAll("\\(\\s*matlabroot\\s*\\)", (String)object);
            string = XMLUtils.filePathAsUrl((String)string2);
        }
        try {
            object = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            object = PlotPicker.class.getResource(string);
        }
        return object;
    }

    private static ImageIcon loadIcon(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            if (string2 != null) {
                return new ImageIcon(PlotPicker.class.getResource(string2));
            }
            return null;
        }
        URL uRL = PlotAction.getIconURL(string);
        if (uRL == null) {
            if (string2 != null) {
                return new ImageIcon(PlotPicker.class.getResource(string2));
            }
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(uRL);
        if (imageIcon.getImage() == null) {
            if (string2 != null) {
                return new ImageIcon(PlotPicker.class.getResource(string2));
            }
            return null;
        }
        return imageIcon;
    }

    static String createArgumentString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        if (stringArray.length == 1) {
            return "(" + stringArray[0] + ")";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(",");
            stringBuilder.append(stringArray[i]);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private static String createSwappedArgumentString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        if (stringArray.length == 1) {
            return "(" + stringArray[stringArray.length - 1] + ")";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(stringArray[stringArray.length - 1]);
        for (int i = stringArray.length - 2; i >= 0; --i) {
            stringBuilder.append(",");
            stringBuilder.append(stringArray[i]);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private static void insertToCommandWindow(final String string) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Method method;
                    Class<?> clazz = Class.forName("com.mathworks.mde.functionbrowser.TargetDialog");
                    if (clazz != null && (method = clazz.getMethod("insertToCommandWindow", String.class)) != null) {
                        method.invoke(clazz, string);
                    }
                }
                catch (Exception exception) {
                    Log.log((String)exception.toString());
                }
            }
        });
    }

    void execute(String[] stringArray, boolean bl, Object object) {
        this.invoke(stringArray, bl, object, false, false);
    }

    void executeInNewFigure(String[] stringArray, boolean bl, Object object) {
        this.invoke(stringArray, bl, object, false, true);
    }

    void execute(String[] stringArray, Object object) {
        this.invoke(stringArray, object, false, false);
    }

    void executeInNewFigure(String[] stringArray, Object object) {
        this.invoke(stringArray, object, false, true);
    }

    void insert(String[] stringArray, boolean bl) {
        this.invoke(stringArray, bl, null, true, false);
    }

    void insert(String string) {
        PlotAction.invokeMCode(string, null, true);
    }

    private void invoke(String[] stringArray, boolean bl, Object object, boolean bl2, boolean bl3) {
        if (this.hasCustomExecutionFunction()) {
            WorkerParameters workerParameters = new WorkerParameters(stringArray, this, bl2, bl3, object, bl);
            sWorker.invoke(workerParameters);
            return;
        }
        String string = bl ? this.getSwappedExecutionString(stringArray, bl3) : this.getExecutionString(stringArray, bl3);
        PlotAction.invokeMCode(string, object, bl2);
    }

    private void invoke(String[] stringArray, Object object, boolean bl, boolean bl2) {
        if (this.hasCustomExecutionFunction()) {
            WorkerParameters workerParameters = new WorkerParameters(stringArray, this, bl, bl2, object, false);
            sWorker.invoke(workerParameters);
        } else {
            PlotAction.invokeMCode(this.getExecutionString(stringArray, bl2), object, bl);
        }
    }

    private static void invokeMCode(String string, Object object, boolean bl) {
        Cursor cursor;
        Cursor cursor2 = cursor = object instanceof Component ? ((Component)object).getCursor() : null;
        if (bl) {
            PlotAction.insertToCommandWindow(string);
        } else {
            MLExecuteServices.executeCommand((String)string);
            if (object instanceof Component) {
                PlotAction.resetCursor((Component)object, cursor);
            }
        }
    }

    private static void resetCursor(final Component component, final Cursor cursor) {
        component.setCursor(new Cursor(3));
        sMatlabProcessing = true;
        MLExecuteServices.addMLExecutionListener((MLExecutionListener)new MLExecutionListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (!(changeEvent instanceof MLExecutionEvent)) {
                    return;
                }
                MLExecutionEvent mLExecutionEvent = (MLExecutionEvent)changeEvent;
                if (mLExecutionEvent.isCommandBusy()) {
                    return;
                }
                MLExecuteServices.removeMLExecutionListener((MLExecutionListener)this);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (cursor != null) {
                            component.setCursor(cursor);
                        }
                        sMatlabProcessing = false;
                    }
                });
            }
        });
    }

    public static boolean getMATLABProcessingState() {
        return sMatlabProcessing;
    }

    boolean isSearchResult(String string, boolean bl) {
        String string2 = string.trim().toLowerCase();
        if (string2.matches(".*\\s.*")) {
            String[] stringArray;
            for (String string3 : stringArray = string.split("\\s")) {
                boolean bl2;
                if ((string3 = string3.trim()).length() == 0 || !(bl2 = this.isSearchResult(string3, bl))) continue;
                return true;
            }
            return false;
        }
        if (bl) {
            return (this.fDescription.toLowerCase().matches(".*" + string2 + ".*") || this.fFunctionName.toLowerCase().matches(".*" + string2 + ".*")) && !this.isSearchResult(string, false);
        }
        return this.fDescription.toLowerCase().matches(".*\\b" + string + "\\b.*") || this.fFunctionName.toLowerCase().matches(".*\\b" + string + "\\b.*");
    }

    private static String getArgumentStringCellArray(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{'");
        stringBuilder.append(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append("','");
            stringBuilder.append(stringArray[i]);
        }
        stringBuilder.append("'}");
        return stringBuilder.toString();
    }

    static String getArgumentCellArray(String[] stringArray) {
        if (stringArray.length == 1 && stringArray[0].matches("^cell2mat\\s*\\(.*\\)")) {
            String string = stringArray[0].replaceAll("^cell2mat\\s*\\(", "");
            string = string.replaceAll("\\)$", "");
            return "internal.matlab.plotpicker.inputPreProc('cell2mat',{" + string + "})";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        stringBuilder.append(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(",");
            stringBuilder.append(stringArray[i]);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    String evalCustomLabelFunc(String[] stringArray) {
        if (this.fLabelFunc == null || this.fLabelFunc.trim().length() == 0) {
            return null;
        }
        try {
            return (String)Matlab.mtEvalNoBreakpoints((String)("feval(" + this.fLabelFunc + "," + PlotAction.getArgumentStringCellArray(stringArray) + "," + PlotAction.getArgumentCellArray(stringArray) + ")"), (int)1);
        }
        catch (Exception exception) {
            return null;
        }
    }

    String evalCustomExecutionFunc(String[] stringArray, boolean bl) {
        if (bl && stringArray != null && stringArray.length == 2) {
            return this.evalCustomExecutionFunc(new String[]{stringArray[1], stringArray[0]});
        }
        return this.evalCustomExecutionFunc(stringArray);
    }

    private String evalCustomExecutionFunc(String[] stringArray) {
        assert (NativeMatlab.nativeIsMatlabThread());
        if (this.fExecutionTextFcn == null || this.fExecutionTextFcn.trim().length() == 0) {
            return null;
        }
        try {
            if (PlotAction.getAnonymousInputCount(this.fExecutionTextFcn) == 1) {
                return (String)Matlab.mtEval((String)("feval(" + this.fExecutionTextFcn + "," + PlotAction.getArgumentStringCellArray(stringArray) + ")"), (int)1);
            }
            return (String)Matlab.mtEval((String)("feval(" + this.fExecutionTextFcn + "," + PlotAction.getArgumentStringCellArray(stringArray) + "," + PlotAction.getArgumentCellArray(stringArray) + ")"), (int)1);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static int getAnonymousInputCount(String string) {
        if (string == null || !string.matches("^@\\(.+\\).+")) {
            return 0;
        }
        int n = string.indexOf(40);
        int n2 = string.indexOf(41);
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            if (string.charAt(i) != ',') continue;
            ++n3;
        }
        return n3 + 1;
    }

    static void setNeedsRehash(boolean bl) {
        sNeedPathRehash = bl;
    }

    String getMatlabEvalFunction(String[] stringArray) {
        if (this.fVisibilityFunc != null) {
            return "feval(" + this.fVisibilityFunc + "," + PlotAction.getArgumentCellArray(stringArray) + ")";
        }
        return "plotpickerfunc('defaultshow','" + this.getID() + "',{}," + PlotAction.getArgumentCellArray(stringArray) + ")";
    }

    String getMatlabSwappedEvalFunction(String[] stringArray) {
        if (stringArray == null || stringArray.length != 2) {
            return null;
        }
        String string = stringArray[1] + "," + stringArray[0];
        String[] stringArray2 = new String[]{stringArray[1], stringArray[0]};
        if (this.fVisibilityFunc != null) {
            return "feval(" + this.fVisibilityFunc + "," + PlotAction.getArgumentCellArray(stringArray2) + ")";
        }
        return "plotpickerfunc('defaultshow','" + this.getID() + "',{},{" + string + "})";
    }

    boolean isEnabledBySelectedVars(String[] stringArray) {
        boolean[] blArray;
        try {
            blArray = (boolean[])Matlab.mtEvalNoBreakpoints((String)this.getMatlabEvalFunction(stringArray), (int)1);
        }
        catch (Exception exception) {
            if (!sPathChecked) {
                sPathChecked = true;
                try {
                    double[] dArray = (double[])Matlab.mtFeval((String)"exist", (Object[])new Object[]{"plotpickerfunc"}, (int)1);
                    if (dArray == null || dArray.length < 1 || !(dArray[0] >= 1.0)) {
                        PlotAction.setNeedsRehash(true);
                    }
                }
                catch (Exception exception2) {
                    Log.log((String)exception2.toString());
                }
            }
            return false;
        }
        return blArray != null && blArray.length > 0 && blArray[0];
    }

    boolean isEnabledBySwappedVars(String[] stringArray) {
        boolean[] blArray;
        if (stringArray == null || stringArray.length != 2) {
            return false;
        }
        try {
            blArray = (boolean[])Matlab.mtEvalNoBreakpoints((String)this.getMatlabSwappedEvalFunction(stringArray), (int)1);
        }
        catch (Exception exception) {
            return false;
        }
        return blArray != null && blArray.length > 0 && blArray[0];
    }

    String[] getAlternativeSelectedVars(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = new String[stringArray.length];
            System.arraycopy(stringArray, i, stringArray2, 0, stringArray.length - i);
            if (i >= 1) {
                System.arraycopy(stringArray, 0, stringArray2, stringArray.length - i, i - 1);
            }
            if (this.isEnabledBySelectedVars(stringArray2)) continue;
            return stringArray2;
        }
        return null;
    }

    private static ImageIcon createIcon(ImageIcon imageIcon) {
        BufferedImage bufferedImage = new BufferedImage(20, 16, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawImage(imageIcon.getImage(), 0, 0, 20, 16, null);
        ImageIcon imageIcon2 = new ImageIcon(bufferedImage);
        graphics2D.dispose();
        imageIcon2.setDescription(null);
        return imageIcon2;
    }

    public PlotAction clone() throws CloneNotSupportedException {
        PlotAction plotAction = (PlotAction)super.clone();
        plotAction.fID = this.getID();
        plotAction.fFunctionName = this.getFunctionName();
        plotAction.fDescription = this.getDescription();
        plotAction.fShortDescription = this.getShortDescription();
        plotAction.fVisibilityFunc = this.getSelectionMCode();
        plotAction.fIcon = this.getIcon();
        plotAction.fSmallIcon = this.getSmallIcon();
        plotAction.fRuleDescription = this.getRuleDescription();
        plotAction.fExecutionTextFcn = this.getExecutionTextFcn();
        plotAction.fLabelFunc = this.getLabelFunction();
        plotAction.fIsFavorite = this.isFavorite();
        plotAction.fProductHelp = this.getProductHelp();
        plotAction.fRefPagePath = this.getRefPagePath();
        plotAction.fMethodOf = this.getMethodOf();
        return plotAction;
    }

    private static class ExecutionWorker
    extends MatlabWorker<String> {
        private WorkerParameters iWorkerParameters;
        private WorkerParameters iQueuedWorkerParameters;
        private boolean iIsRunning;

        private ExecutionWorker() {
        }

        public String runOnMatlabThread() {
            return this.iWorkerParameters.createCustomExecutionFcn();
        }

        public void runOnAWTEventDispatchThread(String string) {
            this.iWorkerParameters.evalCustomExecutionFcn(string);
            if (this.iQueuedWorkerParameters != null) {
                this.iWorkerParameters = this.iQueuedWorkerParameters;
                this.iQueuedWorkerParameters = null;
                this.start();
            } else {
                this.iIsRunning = false;
            }
        }

        void queueWorkerParamaters(WorkerParameters workerParameters) {
            this.iQueuedWorkerParameters = workerParameters;
        }

        void invoke(WorkerParameters workerParameters) {
            if (!this.iIsRunning) {
                this.iWorkerParameters = workerParameters;
                this.iIsRunning = true;
                this.start();
            } else {
                this.queueWorkerParamaters(workerParameters);
            }
        }
    }

    private static class WorkerParameters {
        private String[] iSelectedVars;
        private PlotAction iPlotAction;
        private boolean iInsertOnlyFlag;
        private boolean iCreateNewFigure;
        private Object iSrc;
        private boolean iSwapped = false;

        WorkerParameters(String[] stringArray, PlotAction plotAction, boolean bl, boolean bl2, Object object, boolean bl3) {
            this.iSelectedVars = stringArray;
            this.iPlotAction = plotAction;
            this.iInsertOnlyFlag = bl;
            this.iCreateNewFigure = bl2;
            this.iSrc = object;
            this.iSwapped = bl3;
        }

        private String createCustomExecutionFcn() {
            boolean bl;
            assert (NativeMatlab.nativeIsMatlabThread());
            boolean bl2 = this.iSelectedVars != null && this.iSelectedVars.length == 2;
            boolean bl3 = bl = bl2 && (this.iSwapped || this.iPlotAction.isEnabledBySwappedVars(this.iSelectedVars) && !this.iPlotAction.isEnabledBySelectedVars(this.iSelectedVars));
            if (bl) {
                String[] stringArray = this.iSelectedVars;
                return this.iPlotAction.evalCustomExecutionFunc(new String[]{stringArray[1], stringArray[0]});
            }
            return this.iPlotAction.evalCustomExecutionFunc(this.iSelectedVars);
        }

        private void evalCustomExecutionFcn(String string) {
            assert (SwingUtilities.isEventDispatchThread());
            if (string != null && string.length() > 0) {
                if (this.iCreateNewFigure) {
                    PlotAction.invokeMCode("figure;" + string.replaceAll("\\s*figure\\(gcf\\);*\\s*$", ""), this.iSrc, this.iInsertOnlyFlag);
                } else {
                    PlotAction.invokeMCode(string, this.iSrc, this.iInsertOnlyFlag);
                }
            } else {
                String string2 = this.iPlotAction.getExecutionString(this.iSelectedVars, this.iCreateNewFigure);
                PlotAction.invokeMCode(string2, this.iSrc, this.iInsertOnlyFlag);
            }
        }
    }
}

