/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.widgets.address;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.SearchCriteria;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.navigation.InvalidLocationException;
import com.mathworks.mlwidgets.explorer.model.navigation.NavigationListener;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBar;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBarButton;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBarButtonPanel;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBarButtonUtils;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBarMode;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBarModeComponent;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBarTextFieldUtils;
import com.mathworks.mlwidgets.explorer.widgets.address.DocumentIntelliHints;
import com.mathworks.mlwidgets.explorer.widgets.address.IconLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.PopupMenuCustomizer;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingManagerRegistrant;
import com.mathworks.mwswing.text.TextContextMenu;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

final class LocationTypingModeComponent
implements AddressBarModeComponent {
    private final AddressBar fAddressBar;
    private final MJPanel fComponent;
    private final MJTextField fTextField;
    private final IconLabel fIconLabel;
    private final CustomTextContextMenu fContextMenu;
    private boolean fSuppressFocusLostReaction;

    LocationTypingModeComponent(AddressBar addressBar) {
        this.fAddressBar = addressBar;
        this.fComponent = new MJPanel((LayoutManager)new FormLayout("center:20px, fill:d:grow, fill:d", "p"));
        this.fTextField = new MJTextField();
        MJUtilities.registerWithKeyBindingManager((KeyBindingManagerRegistrant)this.fTextField, (KeyBindingManager)MatlabKeyBindings.getManager(), (String)"Explorer");
        this.fTextField.setName("AddressBarTextField");
        this.fIconLabel = new IconLabel();
        this.fIconLabel.getComponent().setName("CurrentLocationIcon");
        this.fContextMenu = new CustomTextContextMenu(addressBar.getContextMenuCustomizer());
        this.fTextField.addContextMenu((JPopupMenu)((Object)this.fContextMenu));
        this.fTextField.setBorder(null);
        AddressBarButtonPanel addressBarButtonPanel = new AddressBarButtonPanel();
        AddressBarButton addressBarButton = AddressBarButtonUtils.createHistoryButton((JComponent)this.fComponent, this.fAddressBar);
        addressBarButtonPanel.add(addressBarButton);
        CellConstraints cellConstraints = new CellConstraints();
        this.fComponent.setBackground(UIManager.getColor("TextArea.background"));
        this.fComponent.add((Component)this.fIconLabel.getComponent(), (Object)cellConstraints.xy(1, 1));
        this.fComponent.add((Component)this.fTextField, (Object)cellConstraints.xy(2, 1));
        this.fComponent.add((Component)addressBarButtonPanel.getComponent(), (Object)cellConstraints.xy(3, 1));
        this.navigateAndSwitchModeOnEnterPress();
        AddressBarTextFieldUtils.switchModeOnEscapePress(this.fTextField, this.fAddressBar);
        this.switchModeOnFocusLoss();
        this.installHints();
        this.updateTextAndSwitchModeOnNavigationChange();
        this.updateDisplay();
    }

    @Override
    public JComponent getComponent() {
        return this.fComponent;
    }

    @Override
    public void notifyResized() {
    }

    @Override
    public void notifyDataChanged() {
    }

    @Override
    public void notifyActivating(final MouseEvent mouseEvent) {
        this.fSuppressFocusLostReaction = true;
        this.updateDisplay();
        if (mouseEvent != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (MJUtilities.isMacintoshPopupTrigger((MouseEvent)mouseEvent) || !PlatformInfo.isMacintosh() && SwingUtilities.isRightMouseButton(mouseEvent)) {
                        final Point point = mouseEvent.getPoint();
                        SwingUtilities.convertPoint((Component)LocationTypingModeComponent.this.fComponent, point, (Component)LocationTypingModeComponent.this.fTextField);
                        LocationTypingModeComponent.this.fTextField.addCaretListener(new CaretListener(){

                            @Override
                            public void caretUpdate(CaretEvent caretEvent) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (LocationTypingModeComponent.this.fTextField.isShowing()) {
                                            LocationTypingModeComponent.this.fContextMenu.show((Component)LocationTypingModeComponent.this.fTextField, (int)point.getX(), (int)point.getY());
                                        }
                                    }
                                });
                                LocationTypingModeComponent.this.fTextField.removeCaretListener((CaretListener)this);
                            }
                        });
                    }
                }
            });
        }
    }

    @Override
    public void notifyActivated(boolean bl) {
        this.fTextField.requestFocus();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LocationTypingModeComponent.this.fTextField.requestFocus();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LocationTypingModeComponent.this.fSuppressFocusLostReaction = false;
            }
        });
    }

    private boolean isCurrentTextForSearching() {
        return this.fAddressBar.isModeSupported(AddressBarMode.SEARCH_MODE) && !FileLocation.isPathString((String)this.fTextField.getText()) && !FileLocation.isUrlString((String)this.fTextField.getText());
    }

    private void navigateAndSwitchModeOnEnterPress() {
        this.fTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (LocationTypingModeComponent.this.isCurrentTextForSearching()) {
                        LocationTypingModeComponent.this.fAddressBar.setMode(AddressBarMode.SEARCH_MODE, true);
                        LocationTypingModeComponent.this.fAddressBar.setSearchText(LocationTypingModeComponent.this.fTextField.getText());
                    } else if (FileLocation.isUrlString((String)LocationTypingModeComponent.this.fTextField.getText())) {
                        LocationTypingModeComponent.this.changeDirError();
                    } else {
                        try {
                            LocationTypingModeComponent.this.fAddressBar.getContext().setLocation(new FileLocation(LocationTypingModeComponent.this.fTextField.getText()));
                            LocationTypingModeComponent.this.fAddressBar.setMode(LocationTypingModeComponent.this.fAddressBar.getDefaultMode());
                        }
                        catch (InvalidLocationException invalidLocationException) {
                            LocationTypingModeComponent.this.changeDirError();
                        }
                    }
                }
            }
        });
    }

    private void changeDirError() {
        this.fSuppressFocusLostReaction = true;
        MJOptionPane.showMessageDialog((Component)this.fComponent, (Object)MessageFormat.format(ExplorerResources.getString("changedir.error"), "'" + this.fTextField.getText() + "'"), (String)ExplorerResources.getString("changedir.error.title"), (int)2);
        this.fSuppressFocusLostReaction = false;
    }

    private void switchModeOnFocusLoss() {
        this.fTextField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!LocationTypingModeComponent.this.fSuppressFocusLostReaction && LocationTypingModeComponent.this.fTextField.getParent() != null && LocationTypingModeComponent.this.fAddressBar.getMode() == AddressBarMode.LOCATION_TYPING_MODE) {
                    LocationTypingModeComponent.this.fAddressBar.setMode(LocationTypingModeComponent.this.fAddressBar.getDefaultMode());
                }
            }
        });
    }

    private void installHints() {
        DocumentIntelliHints.install(this.fAddressBar.getContext(), this.fTextField, new ParameterRunnable<String>(){

            public void run(final String string) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LocationTypingModeComponent.this.fAddressBar.setMode(LocationTypingModeComponent.this.fAddressBar.getDefaultMode());
                        try {
                            LocationTypingModeComponent.this.fAddressBar.getContext().setLocation(new FileLocation(string));
                        }
                        catch (InvalidLocationException invalidLocationException) {
                            // empty catch block
                        }
                    }
                });
            }
        });
    }

    private void updateTextAndSwitchModeOnNavigationChange() {
        this.fAddressBar.getContext().addNavigationListener(new NavigationListener(){

            @Override
            public void navigationChange(FileLocation fileLocation, FileLocation fileLocation2) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LocationTypingModeComponent.this.updateDisplay();
                        if (LocationTypingModeComponent.this.fAddressBar.getMode().equals((Object)AddressBarMode.LOCATION_TYPING_MODE)) {
                            LocationTypingModeComponent.this.fAddressBar.setMode(LocationTypingModeComponent.this.fAddressBar.getDefaultMode());
                        }
                    }
                });
            }

            @Override
            public void searchStarted(SearchCriteria searchCriteria) {
            }

            @Override
            public void searchEnded() {
            }
        });
    }

    private void updateDisplay() {
        FileLocation fileLocation = this.fAddressBar.getContext().getLocation();
        this.fIconLabel.setIcon(AddressBarButtonUtils.getCurrentLocationIcon(this.fAddressBar));
        this.fTextField.setText(fileLocation.toString());
    }

    private class CustomTextContextMenu
    extends TextContextMenu {
        CustomTextContextMenu(PopupMenuCustomizer popupMenuCustomizer) {
            super(MatlabKeyBindings.getManager(), "Explorer", popupMenuCustomizer);
        }

        public void show(Component component, int n, int n2) {
            LocationTypingModeComponent.this.fSuppressFocusLostReaction = true;
            super.show(component, n, n2);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LocationTypingModeComponent.this.fSuppressFocusLostReaction = false;
                }
            });
        }
    }
}

