/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.util;

import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.FileSystemTransaction;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.model.vfs.VirtualFileSystem;
import com.mathworks.mlwidgets.explorer.util.FileSystemFilter;
import com.mathworks.mlwidgets.explorer.util.NonStrictList;
import com.mathworks.mlwidgets.explorer.util.TransactionLogic;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.Holder;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import com.mathworks.util.ThrowableClosure;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public final class FileSystemUtils {
    private FileSystemUtils() {
    }

    public static Map<FileLocation, FileSystemEntry> mapByLocation(Collection<FileSystemEntry> collection) {
        HashMap<FileLocation, FileSystemEntry> hashMap = new HashMap<FileLocation, FileSystemEntry>();
        for (FileSystemEntry fileSystemEntry : collection) {
            hashMap.put(fileSystemEntry.getLocation(), fileSystemEntry);
        }
        return hashMap;
    }

    public static AsyncReceiver<FileSystemEntry> createEntryAdapter(final AsyncReceiver<FileLocation> asyncReceiver) {
        return new AsyncReceiver<FileSystemEntry>(){

            public boolean receive(FileSystemEntry fileSystemEntry) {
                return asyncReceiver.receive((Object)fileSystemEntry.getLocation());
            }

            public void finished() {
                asyncReceiver.finished();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withTransaction(FileSystem fileSystem, TransactionLogic transactionLogic) throws IOException {
        FileSystemTransaction fileSystemTransaction = fileSystem.createTransaction();
        try {
            transactionLogic.run(fileSystemTransaction);
        }
        finally {
            fileSystemTransaction.close();
            transactionLogic.afterClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withInputStream(FileSystemEntry fileSystemEntry, ThrowableClosure<T, InputStream, IOException> throwableClosure) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = fileSystemEntry.getSystem().getInputStream(fileSystemEntry.getLocation());
            Object object = throwableClosure.run((Object)inputStream);
            return (T)object;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static void move(final FileSystem fileSystem, final FileLocation fileLocation, FileSystem fileSystem2, final FileLocation fileLocation2) throws IOException {
        FileSystemUtils.withTransaction(fileSystem2, new TransactionLogic(){

            @Override
            public void run(FileSystemTransaction fileSystemTransaction) throws IOException {
                FileSystemUtils.move(fileSystem, fileLocation, fileSystemTransaction, fileLocation2);
            }
        });
    }

    public static void move(FileSystemEntry fileSystemEntry, FileSystemTransaction fileSystemTransaction, FileLocation fileLocation) throws IOException {
        FileSystemUtils.move(fileSystemEntry.getSystem(), fileSystemEntry.getLocation(), fileSystemTransaction, fileLocation);
    }

    public static void move(final FileSystem fileSystem, final FileLocation fileLocation, final FileSystemTransaction fileSystemTransaction, final FileLocation fileLocation2) throws IOException {
        if (fileSystem.equals(fileSystemTransaction.getSystem())) {
            fileSystemTransaction.move(fileLocation, fileLocation2);
        } else {
            FileSystemUtils.withTransaction(fileSystem, new TransactionLogic(){

                @Override
                public void run(FileSystemTransaction fileSystemTransaction2) throws IOException {
                    FileSystemUtils.copy(fileSystem, fileLocation, fileSystemTransaction, fileLocation2);
                    fileSystemTransaction2.delete(fileLocation, false);
                }
            });
        }
    }

    public static void copy(FileSystemEntry fileSystemEntry, FileSystemTransaction fileSystemTransaction, FileLocation fileLocation) throws IOException {
        FileSystemUtils.copy(fileSystemEntry.getSystem(), fileSystemEntry.getLocation(), fileSystemTransaction, fileLocation);
    }

    public static void copy(final FileSystem fileSystem, final FileLocation fileLocation, FileSystem fileSystem2, final FileLocation fileLocation2) throws IOException {
        FileSystemUtils.withTransaction(fileSystem2, new TransactionLogic(){

            @Override
            public void run(FileSystemTransaction fileSystemTransaction) throws IOException {
                FileSystemUtils.copy(fileSystem, fileLocation, fileSystemTransaction, fileLocation2);
            }
        });
    }

    public static void copy(FileSystem fileSystem, FileLocation fileLocation, FileSystemTransaction fileSystemTransaction, FileLocation fileLocation2) throws IOException {
        FileSystemUtils.copy(fileSystem, fileLocation, fileSystemTransaction, fileLocation2, null);
    }

    public static void copy(FileSystem fileSystem, FileLocation fileLocation, FileSystemTransaction fileSystemTransaction, FileLocation fileLocation2, Predicate<FileLocation> predicate) throws IOException {
        if (fileSystem.equals(fileSystemTransaction.getSystem())) {
            fileSystemTransaction.copy(fileLocation, fileLocation2);
        } else {
            FileSystemUtils.copy(fileSystem, fileSystem.getEntry(fileLocation), fileSystemTransaction, fileLocation2, predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(Component component, List<FileSystemEntry> list, boolean bl, Predicate<FileSystemEntry> predicate, AsyncReceiver<FileLocation> asyncReceiver) throws IOException {
        Map<FileSystem, List<FileLocation>> map = FileSystemUtils.getLocationsBySystem(list);
        HashMap<FileSystemTransaction, List<FileLocation>> hashMap = new HashMap<FileSystemTransaction, List<FileLocation>>();
        for (Map.Entry<FileSystem, List<FileLocation>> fileSystemTransaction : map.entrySet()) {
            hashMap.put(fileSystemTransaction.getKey().createTransaction(), fileSystemTransaction.getValue());
        }
        try {
            FileSystemUtils.delete(component, hashMap, bl, predicate, asyncReceiver);
        }
        finally {
            for (FileSystemTransaction fileSystemTransaction : hashMap.keySet()) {
                fileSystemTransaction.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(Component component, Map<FileSystemTransaction, List<FileLocation>> map, boolean bl, Predicate<FileSystemEntry> predicate, AsyncReceiver<FileLocation> asyncReceiver) throws IOException {
        if (map.size() == 1) {
            Map.Entry<FileSystemTransaction, List<FileLocation>> entry = map.entrySet().iterator().next();
            FileSystemTransaction fileSystemTransaction = entry.getKey();
            List<FileLocation> list = entry.getValue();
            fileSystemTransaction.delete(component, list, bl, predicate, asyncReceiver);
        } else {
            try {
                for (Map.Entry<FileSystemTransaction, List<FileLocation>> entry : map.entrySet()) {
                    FileSystemTransaction fileSystemTransaction = entry.getKey();
                    for (FileLocation fileLocation : entry.getValue()) {
                        if (!predicate.accept((Object)fileSystemTransaction.getSystem().getEntry(fileLocation))) continue;
                        fileSystemTransaction.delete(fileLocation, bl);
                        if (asyncReceiver.receive((Object)fileLocation)) continue;
                        return;
                    }
                }
            }
            finally {
                asyncReceiver.finished();
            }
        }
    }

    public static Map<FileSystem, List<FileLocation>> getLocationsBySystem(List<FileSystemEntry> list) {
        HashMap<FileSystem, List<FileLocation>> hashMap = new HashMap<FileSystem, List<FileLocation>>();
        for (FileSystemEntry fileSystemEntry : list) {
            FileSystem fileSystem = fileSystemEntry.getSystem();
            ArrayList<FileLocation> arrayList = (ArrayList<FileLocation>)hashMap.get(fileSystem);
            if (arrayList == null) {
                arrayList = new ArrayList<FileLocation>();
                hashMap.put(fileSystem, arrayList);
            }
            arrayList.add(fileSystemEntry.getLocation());
        }
        return hashMap;
    }

    public static List<FileSystemEntry> readFolders(FileList fileList) throws IOException {
        final ArrayList<FileSystemEntry> arrayList = new ArrayList<FileSystemEntry>();
        fileList.readFolders((AsyncReceiver)new AsyncReceiver<FileSystemEntry>(){

            public boolean receive(FileSystemEntry fileSystemEntry) {
                arrayList.add(fileSystemEntry);
                return true;
            }
        });
        return arrayList;
    }

    public static List<FileSystemEntry> readFilesAndFolders(FileList fileList) throws IOException {
        final ArrayList<FileSystemEntry> arrayList = new ArrayList<FileSystemEntry>();
        fileList.readFilesAndFolders((AsyncReceiver)new AsyncReceiver<FileSystemEntry>(){

            public boolean receive(FileSystemEntry fileSystemEntry) {
                arrayList.add(fileSystemEntry);
                return true;
            }
        });
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(FileSystem fileSystem, FileSystemEntry fileSystemEntry, FileSystemTransaction fileSystemTransaction, FileLocation fileLocation, Predicate<FileLocation> predicate) throws IOException {
        if (predicate != null && !predicate.accept((Object)fileSystemEntry.getLocation())) {
            return;
        }
        if (fileSystemEntry.isFolder()) {
            fileSystemTransaction.createDirectory(fileLocation);
            List<FileSystemEntry> list = FileSystemUtils.readFilesAndFolders(fileSystem.getList(fileSystemEntry.getLocation()));
            for (FileSystemEntry fileSystemEntry2 : list) {
                FileSystemUtils.copy(fileSystem, fileSystemEntry2, fileSystemTransaction, new FileLocation(fileLocation, fileSystemEntry2.getLocation().getName()), predicate);
            }
        } else {
            OutputStream outputStream = null;
            try {
                outputStream = fileSystemTransaction.getOutputStream(fileLocation);
                FileSystemUtils.copy(fileSystemEntry, outputStream);
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(FileSystemEntry fileSystemEntry, OutputStream outputStream) throws IOException {
        InputStream inputStream = null;
        try {
            int n;
            FileSystem fileSystem = fileSystemEntry.getSystem();
            if (fileSystemEntry.isReal()) {
                fileSystem = RealFileSystem.getInstance();
            }
            inputStream = fileSystem.getInputStream(fileSystemEntry.getLocation());
            byte[] byArray = new byte[65536];
            while ((n = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static String readText(FileSystemEntry fileSystemEntry) throws IOException {
        return FileSystemUtils.readText(fileSystemEntry.getSystem(), fileSystemEntry.getLocation());
    }

    public static String readText(FileSystemEntry fileSystemEntry, String string) throws IOException {
        return FileSystemUtils.readText(fileSystemEntry.getSystem(), fileSystemEntry.getLocation(), string);
    }

    public static String readText(FileSystem fileSystem, FileLocation fileLocation) throws IOException {
        return new String(FileSystemUtils.readBytes(fileSystem, fileLocation));
    }

    public static String readText(FileSystem fileSystem, FileLocation fileLocation, String string) throws IOException {
        return new String(FileSystemUtils.readBytes(fileSystem, fileLocation), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(FileSystem fileSystem, FileLocation fileLocation) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream = null;
        try {
            int n;
            inputStream = fileSystem.getInputStream(fileLocation);
            byte[] byArray = new byte[65536];
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static List<File> getRealFiles(Collection<FileSystemEntry> collection) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (FileSystemEntry fileSystemEntry : collection) {
            if (!fileSystemEntry.isReal()) continue;
            arrayList.add(new File(fileSystemEntry.getLocation().toString()));
        }
        return arrayList;
    }

    public static boolean checkWritePermission(FileSystemEntry fileSystemEntry) {
        return true;
    }

    public static void addSubfoldersRecursively(Collection<FileSystemEntry> collection, Collection<FileSystemEntry> collection2) {
        HashSet<FileSystemEntry> hashSet = new HashSet<FileSystemEntry>(collection);
        HashSet<FileSystemEntry> hashSet2 = new HashSet<FileSystemEntry>();
        for (FileSystemEntry fileSystemEntry : hashSet) {
            if (!fileSystemEntry.isFolder()) continue;
            FileSystemUtils.addSubfoldersRecursively(fileSystemEntry, hashSet2);
        }
        collection2.addAll(hashSet2);
    }

    public static void addSubfoldersRecursively(FileSystemEntry fileSystemEntry, Collection<FileSystemEntry> collection) {
        try {
            FileList fileList = fileSystemEntry.getSystem().getList(fileSystemEntry.getLocation());
            List<FileSystemEntry> list = FileSystemUtils.readFolders(fileList);
            collection.addAll(list);
            for (FileSystemEntry fileSystemEntry2 : list) {
                FileSystemUtils.addSubfoldersRecursively(fileSystemEntry2, collection);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Set<FileLocation> getParents(Collection<FileSystemEntry> collection) {
        HashSet<FileLocation> hashSet = new HashSet<FileLocation>();
        for (FileSystemEntry fileSystemEntry : collection) {
            hashSet.add(fileSystemEntry.getLocation().getParent());
        }
        return hashSet;
    }

    public static FileLocation getNextUntitledFile(FileSystem fileSystem, FileLocation fileLocation, String string, FileSystemFilter ... fileSystemFilterArray) {
        assert (string != null) : "An extension is required";
        String string2 = !string.contains(".") ? "." + string : string;
        return FileSystemUtils.getNextNamedFile(fileSystem, fileLocation, "Untitled", string2, fileSystemFilterArray);
    }

    public static FileLocation getNextNamedFile(FileSystem fileSystem, FileLocation fileLocation, String string, String string2, FileSystemFilter ... fileSystemFilterArray) {
        return FileSystemUtils.getNextNamedFile(fileSystem, fileLocation, string, string2, true, "", fileSystemFilterArray);
    }

    public static FileLocation getNextNamedFile(FileSystem fileSystem, FileLocation fileLocation, String string, String string2, boolean bl, String string3, final FileSystemFilter ... fileSystemFilterArray) {
        FileLocation fileLocation2;
        assert (fileLocation != null) : "A folder is required";
        assert (string != null) : "A prefix is required";
        assert (string2 != null) : "A suffix is required; use an empty string if it does not matter";
        FileSystemFilter fileSystemFilter = new FileSystemFilter(){

            @Override
            public boolean accept(FileSystem fileSystem, FileLocation fileLocation) {
                if (fileSystem.exists(fileLocation)) {
                    return false;
                }
                for (FileSystemFilter fileSystemFilter : fileSystemFilterArray) {
                    if (fileSystemFilter.accept(fileSystem, fileLocation)) continue;
                    return false;
                }
                return true;
            }
        };
        int n = 1;
        do {
            if (n == 0) {
                throw new IllegalArgumentException("all possible file numbers were exhausted without a match");
            }
            String string4 = !bl && n == 1 ? string3 : string3 + n + string3;
            fileLocation2 = new FileLocation(fileLocation, string + string4 + string2);
            ++n;
        } while (!fileSystemFilter.accept(fileSystem, fileLocation2));
        return fileLocation2;
    }

    public static void setWritableRecursively(FileSystemEntry fileSystemEntry, final boolean bl) throws IOException {
        FileSystemUtils.traverse(fileSystemEntry, TraversalMode.ITERATIVE, new ThrowableClosure<Void, FileSystemEntry, IOException>(){

            public Void run(FileSystemEntry fileSystemEntry) throws IOException {
                fileSystemEntry.getLocation().toFile().setWritable(bl);
                return null;
            }
        });
    }

    public static <T> void traverse(FileSystemEntry fileSystemEntry, TraversalMode traversalMode, ThrowableClosure<T, FileSystemEntry, IOException> throwableClosure) throws IOException {
        FileSystemUtils.traverse(fileSystemEntry, traversalMode, new Predicate<FileSystemEntry>(){

            public boolean accept(FileSystemEntry fileSystemEntry) {
                return true;
            }
        }, throwableClosure);
    }

    public static <T> void traverse(FileSystemEntry fileSystemEntry, final TraversalMode traversalMode, final Predicate<FileSystemEntry> predicate, final ThrowableClosure<T, FileSystemEntry, IOException> throwableClosure) throws IOException {
        boolean bl;
        boolean bl2 = bl = !fileSystemEntry.isFolder() || predicate.accept((Object)fileSystemEntry);
        if (traversalMode == TraversalMode.PARENTS_FIRST || traversalMode == TraversalMode.CHILDREN_FIRST) {
            if (traversalMode == TraversalMode.PARENTS_FIRST && bl) {
                throwableClosure.run((Object)fileSystemEntry);
            }
            FileList fileList = fileSystemEntry.getSystem().getList(fileSystemEntry.getLocation());
            final Holder holder = new Holder();
            fileList.readFilesAndFolders((AsyncReceiver)new AsyncReceiver<FileSystemEntry>(){

                public boolean receive(FileSystemEntry fileSystemEntry) {
                    try {
                        if (traversalMode == TraversalMode.PARENTS_FIRST && !fileSystemEntry.isFolder()) {
                            throwableClosure.run((Object)fileSystemEntry);
                        }
                        if (fileSystemEntry.isFolder() && predicate.accept((Object)fileSystemEntry)) {
                            FileSystemUtils.traverse(fileSystemEntry, traversalMode, (Predicate<FileSystemEntry>)predicate, throwableClosure);
                        }
                        if (traversalMode == TraversalMode.CHILDREN_FIRST && !fileSystemEntry.isFolder()) {
                            throwableClosure.run((Object)fileSystemEntry);
                        }
                        return true;
                    }
                    catch (IOException iOException) {
                        holder.set((Object)iOException);
                        return false;
                    }
                }
            });
            if (holder.get() != null) {
                throw (IOException)holder.get();
            }
            if (traversalMode == TraversalMode.CHILDREN_FIRST && bl) {
                throwableClosure.run((Object)fileSystemEntry);
            }
        } else if (traversalMode == TraversalMode.ITERATIVE) {
            final LinkedList<FileSystemEntry> linkedList = new LinkedList<FileSystemEntry>();
            if (bl) {
                linkedList.offer(fileSystemEntry);
            }
            while (!linkedList.isEmpty()) {
                FileSystemEntry fileSystemEntry2 = (FileSystemEntry)linkedList.poll();
                throwableClosure.run((Object)fileSystemEntry2);
                if (!fileSystemEntry2.isFolder() || !predicate.accept((Object)fileSystemEntry2)) continue;
                FileList fileList = fileSystemEntry2.getSystem().getList(fileSystemEntry2.getLocation());
                fileList.readFilesAndFolders((AsyncReceiver)new AsyncReceiver<FileSystemEntry>(){

                    public boolean receive(FileSystemEntry fileSystemEntry) {
                        linkedList.offer(fileSystemEntry);
                        return true;
                    }
                });
            }
        } else {
            throw new IllegalArgumentException("Unknown mode: " + (Object)((Object)traversalMode));
        }
    }

    public static List<FileSystemEntry> getParents(List<FileSystemEntry> list) {
        HashMap<FileLocation, FileSystem> hashMap = new HashMap<FileLocation, FileSystem>();
        for (FileSystemEntry object : list) {
            hashMap.put(object.getLocation().getParent(), object.getSystem());
        }
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : hashMap.entrySet()) {
            FileSystem fileSystem = (FileSystem)entry.getValue();
            FileLocation fileLocation = (FileLocation)entry.getKey();
            try {
                arrayList.add(fileSystem.getEntry(fileLocation));
            }
            catch (IOException iOException) {}
        }
        return arrayList;
    }

    public static File getClosestRealAncestor(FileSystemEntry fileSystemEntry) {
        return FileSystemUtils.getClosestRealAncestor(fileSystemEntry, false);
    }

    public static File getClosestRealAncestor(FileSystemEntry fileSystemEntry, boolean bl) {
        try {
            for (FileLocation fileLocation = fileSystemEntry.getLocation().getParent(); fileLocation != null; fileLocation = fileLocation.getParent()) {
                FileSystemEntry fileSystemEntry2;
                FileSystemEntry fileSystemEntry3 = fileSystemEntry.getSystem().getEntry(fileLocation);
                if (fileSystemEntry3.isReal()) {
                    return fileSystemEntry3.getLocation().toFile();
                }
                if (!bl || !(fileSystemEntry2 = VirtualFileSystem.getUnderlyingEntryIfMountPoint(fileSystemEntry3)).isReal()) continue;
                return fileSystemEntry2.getLocation().toFile();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static Map<FileSystemEntry, FileSystemEntry> getUnderlyingEntriesToOriginalEntries(List<FileSystemEntry> list) {
        LinkedHashMap<FileSystemEntry, FileSystemEntry> linkedHashMap = new LinkedHashMap<FileSystemEntry, FileSystemEntry>();
        for (FileSystemEntry fileSystemEntry : list) {
            linkedHashMap.put(VirtualFileSystem.getUnderlyingEntryIfMountPoint(fileSystemEntry), fileSystemEntry);
        }
        return linkedHashMap;
    }

    public static List<FileSystemEntry> getUnderlyingEntries(List<FileSystemEntry> list) {
        ArrayList<FileSystemEntry> arrayList = new ArrayList<FileSystemEntry>();
        for (FileSystemEntry fileSystemEntry : list) {
            arrayList.add(VirtualFileSystem.getUnderlyingEntryIfMountPoint(fileSystemEntry));
        }
        return arrayList;
    }

    public static FileLocation findZipParent(FileSystemEntry fileSystemEntry) {
        File file = FileSystemUtils.getClosestRealAncestor(fileSystemEntry, true);
        if (file != null) {
            FileLocation fileLocation = new FileLocation(file);
            if (fileLocation.checkExtension(new String[]{"zip", "jar"})) {
                return fileLocation;
            }
        }
        return null;
    }

    public static String decodeLocation(FileSystem fileSystem, FileLocation fileLocation) {
        Object object;
        Stack<String> stack = new Stack<String>();
        for (object = fileLocation; object != null; object = object.getParent()) {
            stack.push(fileSystem.decodeName(object.getName()));
        }
        object = new StringBuilder();
        while (!stack.empty()) {
            ((StringBuilder)object).append((String)stack.pop());
            if (stack.empty()) continue;
            ((StringBuilder)object).append(File.separator);
        }
        if (PlatformInfo.isWindows() && ((StringBuilder)object).toString().startsWith(File.separator)) {
            ((StringBuilder)object).deleteCharAt(0);
        } else if (PlatformInfo.isUnix()) {
            if (!((StringBuilder)object).toString().startsWith(File.separator)) {
                ((StringBuilder)object).insert(0, File.separator);
            }
            while (((StringBuilder)object).toString().startsWith(File.separator + File.separator)) {
                ((StringBuilder)object).deleteCharAt(0);
            }
        }
        return ((StringBuilder)object).toString();
    }

    public static FileList getNonStrictList(FileSystem fileSystem, FileLocation fileLocation) {
        return new NonStrictList(fileSystem, fileLocation);
    }

    public static enum TraversalMode {
        CHILDREN_FIRST,
        PARENTS_FIRST,
        ITERATIVE;

    }
}

