/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.vfs;

import com.mathworks.matlab.api.explorer.FileLocation;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class LocationMap<T> {
    private final Node fRoot;
    private final Set<FileLocation> fKeys;

    public LocationMap() {
        this.fRoot = new Node(' ');
        this.fKeys = new HashSet<FileLocation>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocationMap(LocationMap<T> locationMap) {
        LocationMap<T> locationMap2 = locationMap;
        synchronized (locationMap2) {
            this.fRoot = new Node(locationMap.fRoot);
            this.fKeys = new HashSet<FileLocation>(locationMap.fKeys);
        }
    }

    public boolean isEmpty() {
        return this.fKeys.isEmpty();
    }

    public synchronized Set<FileLocation> getKeys() {
        return new HashSet<FileLocation>(this.fKeys);
    }

    public synchronized Set<T> getValues() {
        HashSet<T> hashSet = new HashSet<T>();
        for (FileLocation fileLocation : this.getKeys()) {
            hashSet.add(this.get(fileLocation, true));
        }
        return hashSet;
    }

    public synchronized T get(FileLocation fileLocation, boolean bl) {
        Map.Entry<FileLocation, T> entry = this.getEntry(fileLocation, bl, null);
        return entry == null ? null : (T)entry.getValue();
    }

    public synchronized Map.Entry<FileLocation, T> getNearestEntry(FileLocation fileLocation) {
        return this.getNearestEntry(fileLocation, null);
    }

    public synchronized Map.Entry<FileLocation, T> getNearestEntry(FileLocation fileLocation, FileLocation fileLocation2) {
        return this.getEntry(fileLocation, false, fileLocation2);
    }

    private synchronized Map.Entry<FileLocation, T> getEntry(FileLocation fileLocation, boolean bl, FileLocation fileLocation2) {
        Node node;
        char c;
        String string = fileLocation.toString();
        Object t = null;
        String string2 = null;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        Node node2 = this.fRoot;
        for (int i = 0; i < string.length() && (node2 = node2.getChild(c = string.charAt(i))) != null; ++i) {
            stringBuilder.append(c);
            if (node2.getValue() == null) continue;
            if (fileLocation2 != null && new FileLocation(stringBuilder.toString()).hasPrefix(fileLocation2)) break;
            t = node2.getValue();
            string2 = stringBuilder.toString();
        }
        if (!(node2 == null || (node = node2.getChild(File.separatorChar)) == null || node.getValue() == null || fileLocation2 != null && fileLocation.equals((Object)fileLocation2))) {
            return new ImmutableEntry(fileLocation, node.getValue());
        }
        if (bl || t == null) {
            return null;
        }
        return new ImmutableEntry(new FileLocation(string2), t);
    }

    public synchronized T put(FileLocation fileLocation, T t) {
        return this.put(fileLocation, t, false);
    }

    public synchronized T putExclusively(FileLocation fileLocation, T t) {
        return this.put(fileLocation, t, true);
    }

    private synchronized T put(FileLocation fileLocation, T t, boolean bl) {
        String string = fileLocation.toString();
        Node node = this.fRoot;
        for (int i = 0; i < string.length(); ++i) {
            node = node.getOrAddChild(string.charAt(i));
            if (!bl || node.getValue() == null) continue;
            return node.getValue();
        }
        node = node.getOrAddChild(File.separatorChar);
        Object t2 = node.getValue();
        node.setValue(t);
        this.fKeys.add(fileLocation);
        if (bl) {
            LinkedList<Node> linkedList = new LinkedList<Node>();
            LinkedList<String> linkedList2 = new LinkedList<String>();
            linkedList.offer(node);
            linkedList2.offer(fileLocation.toString() + File.separatorChar);
            while (!linkedList.isEmpty()) {
                Node node2 = (Node)linkedList.poll();
                String string2 = (String)linkedList2.poll();
                for (Node node3 : node2.getChildren()) {
                    linkedList.offer(node3);
                    linkedList2.offer(string2 + node3.getKeyChar());
                }
                node2.removeAllChildren();
                if (node == node2 || node2.getValue() == null) continue;
                this.fKeys.remove(new FileLocation(string2));
            }
        }
        return t2;
    }

    public synchronized T remove(FileLocation fileLocation) {
        Node node = this.fRoot;
        Stack<Node> stack = new Stack<Node>();
        stack.push(this.fRoot);
        String string = fileLocation.toString();
        for (int i = 0; i < string.length(); ++i) {
            if ((node = node.getChild(string.charAt(i))) == null) {
                return null;
            }
            stack.push(node);
        }
        Node node2 = node.getChild(File.separatorChar);
        if (node2 == null) {
            return null;
        }
        stack.push(node2);
        Object t = node2.getValue();
        node2.setValue(null);
        this.fKeys.remove(fileLocation);
        while (stack.peek() != this.fRoot) {
            Node node3 = (Node)stack.pop();
            if (node3.hasChildren() || node3.getValue() != null) continue;
            ((Node)stack.peek()).removeChild(node3);
        }
        return t;
    }

    private class Node
    implements Comparable<Node> {
        private final char fKeyChar;
        private char fMinChildChar;
        private char fMaxChildChar;
        private T fValue;
        private List<Node> fChildren;

        Node(char c) {
            this.fKeyChar = c;
        }

        Node(Node node) {
            this.fKeyChar = node.fKeyChar;
            this.fMinChildChar = node.fMinChildChar;
            this.fMaxChildChar = node.fMaxChildChar;
            this.fValue = node.fValue;
            this.fChildren = new ArrayList<Node>(node.fChildren == null ? 0 : node.fChildren.size());
            if (node.fChildren != null) {
                for (Node node2 : node.fChildren) {
                    this.fChildren.add(new Node(node2));
                }
            }
        }

        public List<Node> getChildren() {
            return this.fChildren == null ? new ArrayList<Node>(0) : new ArrayList<Node>(this.fChildren);
        }

        public void removeAllChildren() {
            this.fChildren = null;
            this.fMinChildChar = '\u0000';
            this.fMaxChildChar = '\u0000';
        }

        public char getKeyChar() {
            return this.fKeyChar;
        }

        public T getValue() {
            return this.fValue;
        }

        public void setValue(T t) {
            this.fValue = t;
        }

        @Override
        public int compareTo(Node node) {
            return this.fKeyChar - node.fKeyChar;
        }

        public Node getChild(char c) {
            if (this.fChildren == null || c < this.fMinChildChar || c > this.fMaxChildChar) {
                return null;
            }
            Node node = new Node(c);
            int n = Collections.binarySearch(this.fChildren, node);
            return n < 0 ? null : this.fChildren.get(n);
        }

        public Node getOrAddChild(char c) {
            Node node = new Node(c);
            if (this.fChildren == null) {
                this.fChildren = new ArrayList<Node>(2);
                this.fChildren.add(node);
                this.fMinChildChar = c;
                this.fMaxChildChar = c;
                return node;
            }
            if (c < this.fMinChildChar) {
                this.fMinChildChar = c;
                this.fChildren.add(node);
                Collections.sort(this.fChildren);
                return node;
            }
            if (c > this.fMaxChildChar) {
                this.fMaxChildChar = c;
                this.fChildren.add(node);
                Collections.sort(this.fChildren);
                return node;
            }
            int n = Collections.binarySearch(this.fChildren, node);
            if (n < 0) {
                this.fChildren.add(node);
                Collections.sort(this.fChildren);
                return node;
            }
            return this.fChildren.get(n);
        }

        public boolean hasChildren() {
            return this.fChildren != null && !this.fChildren.isEmpty();
        }

        public void removeChild(Node node) {
            this.fChildren.remove(node);
        }
    }

    private class ImmutableEntry
    implements Map.Entry<FileLocation, T> {
        private final FileLocation fKey;
        private final T fValue;

        ImmutableEntry(FileLocation fileLocation, T t) {
            this.fKey = fileLocation;
            this.fValue = t;
        }

        @Override
        public FileLocation getKey() {
            return this.fKey;
        }

        @Override
        public T getValue() {
            return this.fValue;
        }

        @Override
        public T setValue(T t) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.fKey + ":" + this.fValue;
        }
    }
}

