/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.table;

import com.mathworks.jmi.MatlabPath;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.ReturnRunnable;
import com.mathworks.widgets.ClosableToolTipData;
import com.mathworks.widgets.grouptable.Affordance;
import com.mathworks.widgets.grouptable.DisplayEffects;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class LocationAffordance
implements Affordance<FileSystemEntry> {
    private final MulticastChangeListener fListener = new MulticastChangeListener();
    private final boolean fExcludeCurrentFolder;

    public LocationAffordance(boolean bl) {
        this.fExcludeCurrentFolder = bl;
        MatlabPath.addActionListener((ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LocationAffordance.this.fListener.stateChanged(new ChangeEvent(this));
            }
        });
    }

    public Map<FileSystemEntry, DisplayEffects> getDisplayEffects(List<FileSystemEntry> list) {
        HashMap<FileSystemEntry, DisplayEffects> hashMap = new HashMap<FileSystemEntry, DisplayEffects>();
        if (MatlabPath.getCWD() == null || MatlabPath.getCWD().trim().length() == 0) {
            return hashMap;
        }
        FileLocation fileLocation = new FileLocation(MatlabPath.getCurrentDirectory());
        for (FileSystemEntry fileSystemEntry : list) {
            if (fileSystemEntry.getLocation().getParent() != null && this.fExcludeCurrentFolder && fileSystemEntry.getLocation().getParent().equals((Object)fileLocation)) continue;
            hashMap.put(fileSystemEntry, new DisplayEffects((ReturnRunnable)new LocationToolTipGenerator(fileSystemEntry), null));
        }
        return hashMap;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fListener.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fListener.removeChangeListener(changeListener);
    }

    private static class LocationToolTipGenerator
    implements ReturnRunnable<ClosableToolTipData> {
        private final WeakReference<FileSystemEntry> fDocument;

        LocationToolTipGenerator(FileSystemEntry fileSystemEntry) {
            this.fDocument = new WeakReference<FileSystemEntry>(fileSystemEntry);
        }

        public ClosableToolTipData run() {
            FileSystemEntry fileSystemEntry = (FileSystemEntry)this.fDocument.get();
            return fileSystemEntry == null ? null : new ClosableToolTipData(fileSystemEntry.getLocation().toString());
        }
    }
}

