/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.editorfs;

import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorApplication;
import com.mathworks.matlab.api.editor.EditorApplicationListener;
import com.mathworks.matlab.api.editor.EditorEvent;
import com.mathworks.matlab.api.editor.EditorEventListener;
import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.FileSystemTransaction;
import com.mathworks.matlab.api.explorer.SearchCriteria;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mlwidgets.explorer.model.DefaultRecursiveSearchList;
import com.mathworks.mlwidgets.explorer.model.editorfs.EditorFileList;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.util.Predicate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

public class EditorFileSystem
implements FileSystem {
    private final Map<FileLocation, EditorConnection> fEditorConnections = new HashMap<FileLocation, EditorConnection>();
    private final Object fLock = new Object();
    private Set<FileLocation> fCompleteSetOfFilesAndFolders;
    private static final EditorApplication EDITOR = MLEditorServices.getEditorApplication();
    private static final EditorFileSystem EDITOR_FILE_SYSTEM = new EditorFileSystem();

    private EditorFileSystem() {
        this.initializeEditorFileMap();
    }

    public static EditorFileSystem getInstance() {
        return EDITOR_FILE_SYSTEM;
    }

    private void initializeEditorFileMap() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                List list = EDITOR == null ? new ArrayList() : EDITOR.getOpenEditors();
                for (Editor editor : list) {
                    EditorFileSystem.this.addToMapOfOpenEditors(editor);
                }
            }
        });
        if (EDITOR != null) {
            EDITOR.addEditorApplicationListener(new EditorApplicationListener(){

                public void editorOpened(Editor editor) {
                    EditorFileSystem.this.addToMapOfOpenEditors(editor);
                }

                public void editorClosed(Editor editor) {
                    EditorFileSystem.this.removeFromSetOfOpenEditors(editor);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToMapOfOpenEditors(Editor editor) {
        Object object = this.fLock;
        synchronized (object) {
            EditorConnection editorConnection = new EditorConnection(editor);
            this.fEditorConnections.put(editorConnection.getLocation(), editorConnection);
            this.invalidateFileListCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Editor getEditor(FileLocation fileLocation) {
        Object object = this.fLock;
        synchronized (object) {
            EditorConnection editorConnection = this.fEditorConnections.get(fileLocation);
            return editorConnection == null ? null : editorConnection.getEditor();
        }
    }

    private void invalidateFileListCache() {
        this.fCompleteSetOfFilesAndFolders = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromSetOfOpenEditors(FileLocation fileLocation) {
        Object object = this.fLock;
        synchronized (object) {
            this.fEditorConnections.remove(fileLocation);
            this.invalidateFileListCache();
        }
    }

    private void removeFromSetOfOpenEditors(Editor editor) {
        this.removeFromSetOfOpenEditors(new FileLocation(editor.getLongName()));
    }

    public boolean exists(FileLocation fileLocation) {
        try {
            return fileLocation.equals((Object)FileLocation.ROOT) || this.getCompleteSetOfFilesAndFolders().contains(fileLocation);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public FileSystemEntry getEntry(FileLocation fileLocation) throws IOException {
        Object object = this.fLock;
        synchronized (object) {
            if (fileLocation.equals((Object)FileLocation.ROOT)) {
                return new FileSystemEntry((FileSystem)this, fileLocation, false, true, 0L, 0L, 0L);
            }
            if (this.getCompleteSetOfFilesAndFolders().contains(fileLocation)) {
                if (this.getOpenEditorFileLocations().contains(fileLocation)) {
                    return new FileSystemEntry((FileSystem)this, fileLocation, true, false, this.getEditorTextLength(fileLocation), this.getDateOfLastStateChange(fileLocation), 0L);
                }
                return new FileSystemEntry((FileSystem)this, fileLocation, true, true, 0L, 0L, 0L);
            }
            throw new IOException(fileLocation + " does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<FileLocation> getOpenEditorFileLocations() {
        Object object = this.fLock;
        synchronized (object) {
            return new HashSet<FileLocation>(this.fEditorConnections.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getDateOfLastStateChange(FileLocation fileLocation) {
        Object object = this.fLock;
        synchronized (object) {
            EditorConnection editorConnection = this.fEditorConnections.get(fileLocation);
            return editorConnection == null ? 0L : editorConnection.getLastStateChangeTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getEditorTextLength(FileLocation fileLocation) throws IOException {
        Editor editor = this.getEditor(fileLocation);
        if (editor != null && editor.lockIfOpen()) {
            try {
                long l = editor.getLength();
                return l;
            }
            finally {
                editor.unlock();
            }
        }
        return RealFileSystem.getInstance().getEntry(fileLocation).getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEditorText(FileLocation fileLocation) {
        Editor editor;
        if (EDITOR != null && (editor = this.getEditor(fileLocation)) != null && editor.lockIfOpen()) {
            try {
                String string = editor.getText();
                return string;
            }
            finally {
                editor.unlock();
            }
        }
        return null;
    }

    public InputStream getInputStream(FileLocation fileLocation) throws IOException {
        String string = this.getEditorText(fileLocation);
        if (string == null) {
            return RealFileSystem.getInstance().getInputStream(fileLocation);
        }
        byte[] byArray = string.getBytes();
        return new ByteArrayInputStream(byArray, 0, byArray.length);
    }

    public FileSystemEntry followShortcutOrLink(FileSystemEntry fileSystemEntry) throws IOException {
        return fileSystemEntry;
    }

    public FileList getList(FileLocation fileLocation) throws IOException {
        return new EditorFileList(this, this.exists(fileLocation) ? this.getEntry(fileLocation) : RealFileSystem.getInstance().getEntry(fileLocation));
    }

    public FileList search(FileLocation fileLocation, SearchCriteria searchCriteria, Predicate<FileSystemEntry> predicate) throws IOException {
        return new DefaultRecursiveSearchList((FileSystem)this, this.exists(fileLocation) ? this.getEntry(fileLocation) : RealFileSystem.getInstance().getEntry(fileLocation), searchCriteria, predicate);
    }

    public boolean isReadOnly(FileLocation fileLocation) {
        return false;
    }

    public FileSystemTransaction createTransaction() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String encodeName(String string) {
        return string;
    }

    public String decodeName(String string) {
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty(FileLocation fileLocation) {
        if (!this.exists(fileLocation)) {
            return false;
        }
        Object object = this.fLock;
        synchronized (object) {
            EditorConnection editorConnection = this.fEditorConnections.get(fileLocation);
            return editorConnection != null && editorConnection.isDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<FileLocation> getCompleteSetOfFilesAndFolders() {
        Object object = this.fLock;
        synchronized (object) {
            if (this.fCompleteSetOfFilesAndFolders == null) {
                this.fCompleteSetOfFilesAndFolders = new HashSet<FileLocation>();
                this.fCompleteSetOfFilesAndFolders.add(FileLocation.ROOT);
                for (FileLocation fileLocation : this.getOpenEditorFileLocations()) {
                    while (fileLocation.getParent() != null && this.fCompleteSetOfFilesAndFolders.add(fileLocation)) {
                        fileLocation = fileLocation.getParent();
                    }
                }
            }
            return new HashSet<FileLocation>(this.fCompleteSetOfFilesAndFolders);
        }
    }

    public Predicate<FileLocation> getDirtyPredicate() {
        return new Predicate<FileLocation>(){

            public boolean accept(FileLocation fileLocation) {
                return EditorFileSystem.this.isDirty(fileLocation);
            }
        };
    }

    private class EditorConnection {
        private final Editor iEditor;
        private FileLocation iLocation;
        private boolean iDirty;
        private long iLastStateChangeTime;

        EditorConnection(Editor editor) {
            this.iEditor = editor;
            this.iLocation = new FileLocation(editor.getLongName());
            this.iDirty = editor.isDirty();
            this.iEditor.addEventListener(new EditorEventListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void eventOccurred(EditorEvent editorEvent) {
                    if (editorEvent.equals((Object)EditorEvent.DIRTY_STATE_CHANGED)) {
                        EditorConnection.this.updateState();
                    } else if (editorEvent.equals((Object)EditorEvent.RENAMED)) {
                        Object object = EditorFileSystem.this.fLock;
                        synchronized (object) {
                            FileLocation fileLocation = new FileLocation(EditorConnection.this.iEditor.getLongName());
                            if (EditorFileSystem.this.fEditorConnections.containsKey(EditorConnection.this.iLocation) && ((EditorConnection)EditorFileSystem.this.fEditorConnections.get(EditorConnection.this.iLocation)).equals(EditorConnection.this)) {
                                EditorFileSystem.this.fEditorConnections.remove(EditorConnection.this.iLocation);
                            }
                            EditorConnection.this.iLocation = fileLocation;
                            EditorFileSystem.this.fEditorConnections.put(EditorConnection.this.iLocation, EditorConnection.this);
                            EditorFileSystem.this.invalidateFileListCache();
                            EditorConnection.this.updateState();
                        }
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateState() {
            Object object = EditorFileSystem.this.fLock;
            synchronized (object) {
                this.iDirty = this.iEditor.isDirty();
                this.iLastStateChangeTime = new Date().getTime();
            }
        }

        FileLocation getLocation() {
            return this.iLocation;
        }

        Editor getEditor() {
            return this.iEditor;
        }

        long getLastStateChangeTime() {
            return this.iLastStateChangeTime;
        }

        boolean isDirty() {
            return this.iDirty;
        }
    }
}

