/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.mlwidgets.explorer.model.WritablePathModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class MatlabPathModel
implements WritablePathModel {
    private final PropertyChangeSupport fPropertySupport;
    private final Set<FileLocation> fPath = new HashSet<FileLocation>();
    private FileLocation fCurrentFolder;
    private static final MatlabPathModel sInstance = new MatlabPathModel();

    public static MatlabPathModel getInstance() {
        return sInstance;
    }

    private MatlabPathModel() {
        this.fPropertySupport = new PropertyChangeSupport(this);
        MatlabPath.addActionListener((ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("CWD_CHANGE")) {
                    MatlabPathModel.this.updateCurrentFolder();
                } else {
                    MatlabPathModel.this.updatePath();
                }
            }
        });
    }

    @Override
    public boolean isActive() {
        return MatlabPath.getCWD() != null && MatlabPath.getCWD().length() > 0;
    }

    @Override
    public synchronized boolean contains(FileLocation fileLocation, boolean bl) {
        return bl && this.getCurrentFolder().equals((Object)fileLocation) || this.fPath.contains(fileLocation);
    }

    @Override
    public synchronized FileLocation getCurrentFolder() {
        if (this.fCurrentFolder == null && this.isActive()) {
            this.updateCurrentFolder();
        }
        return this.fCurrentFolder;
    }

    @Override
    public synchronized List<FileLocation> getPath() {
        if (this.fPath.isEmpty()) {
            this.updatePath();
        }
        return new ArrayList<FileLocation>(this.fPath);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    private synchronized void updatePath() {
        ArrayList<FileLocation> arrayList = new ArrayList<FileLocation>(this.fPath);
        this.fPath.clear();
        for (MatlabPath.PathEntry pathEntry : MatlabPath.getPathEntries()) {
            this.fPath.add(new FileLocation(pathEntry.getCurrentlyResolvedPath()));
        }
        this.fPropertySupport.firePropertyChange("path", arrayList, new ArrayList<FileLocation>(this.fPath));
    }

    private synchronized void updateCurrentFolder() {
        FileLocation fileLocation = this.fCurrentFolder;
        String string = MatlabPath.getCWD();
        this.fCurrentFolder = string == null || string.length() == 0 ? null : new FileLocation(string);
        this.fPropertySupport.firePropertyChange("current-folder", fileLocation, this.fCurrentFolder);
    }

    private static String[] toStrings(Collection<FileLocation> collection) {
        String[] stringArray = new String[collection.size()];
        Iterator<FileLocation> iterator = collection.iterator();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = iterator.next().toString();
        }
        return stringArray;
    }

    @Override
    public void prepend(Collection<FileLocation> collection, Runnable runnable) {
        MatlabPath.prepend((String[])MatlabPathModel.toStrings(collection), (CompletionObserver)new CompletionWrapper(runnable));
    }

    @Override
    public void remove(Collection<FileLocation> collection, Runnable runnable) {
        MatlabPath.remove((String[])MatlabPathModel.toStrings(collection), (CompletionObserver)new CompletionWrapper(runnable));
    }

    private static class CompletionWrapper
    implements CompletionObserver {
        private final Runnable fCompletion;

        CompletionWrapper(Runnable runnable) {
            this.fCompletion = runnable;
        }

        public void completed(int n, Object object) {
            this.fCompletion.run();
        }
    }
}

