/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model;

import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.AsyncReceiverUtils;
import com.mathworks.util.EmptyCheckReceiver;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.Predicate;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractFileList
implements FileList {
    private final FileSystem fSystem;
    private final FileLocation fLocation;
    private final FileSystemEntry fLocationEntry;
    private final AtomicBoolean fClosed;

    protected AbstractFileList(FileSystem fileSystem, FileSystemEntry fileSystemEntry) {
        this.fSystem = fileSystem;
        this.fLocation = fileSystemEntry.getLocation();
        this.fLocationEntry = fileSystemEntry;
        this.fClosed = new AtomicBoolean(false);
    }

    protected AbstractFileList(FileSystem fileSystem, FileLocation fileLocation) throws IOException {
        this(fileSystem, fileSystem.getEntry(fileLocation));
    }

    public FileLocation getLocation() {
        return this.fLocation;
    }

    public final FileSystemEntry getLocationEntry() {
        return this.fLocationEntry;
    }

    public final boolean exists(FileLocation fileLocation) {
        return this.fSystem.exists(fileLocation);
    }

    public boolean hasFolders() throws IOException {
        EmptyCheckReceiver emptyCheckReceiver = new EmptyCheckReceiver();
        this.readFolders((AsyncReceiver<FileSystemEntry>)emptyCheckReceiver);
        return !emptyCheckReceiver.isEmpty();
    }

    public boolean isEmpty() throws IOException {
        EmptyCheckReceiver emptyCheckReceiver = new EmptyCheckReceiver();
        this.readFilesAndFolders((AsyncReceiver)emptyCheckReceiver);
        return emptyCheckReceiver.isEmpty();
    }

    public void readFolders(AsyncReceiver<FileSystemEntry> asyncReceiver) throws IOException {
        this.readFilesAndFolders(AsyncReceiverUtils.filter(asyncReceiver, (Predicate)new Predicate<FileSystemEntry>(){

            public boolean accept(FileSystemEntry fileSystemEntry) {
                return fileSystemEntry.isFolder();
            }
        }));
    }

    public void close() {
        this.fClosed.set(true);
    }

    protected AtomicBoolean getClosedFlag() {
        return this.fClosed;
    }

    public void pause(ParameterRunnable<Runnable> parameterRunnable) {
    }
}

