/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.basic;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.explorer.DetailPanel;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.mlwidgets.explorer.extensions.basic.ImageFileDetailPanelData;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.util.MLFileSystemUtils;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MouseUtils;
import com.mathworks.util.Holder;
import com.mathworks.util.RequestFilter;
import com.mathworks.util.StringUtils;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public final class ImageFileDetailPanel
implements DetailPanel {
    private static final Matlab MATLAB = new Matlab();
    private final MJPanel fComponent;
    private boolean fInValid = true;
    private final boolean fSimpleMode;
    private final double fOpacity;
    private RequestFilter fRequestFilter;
    private final FileSystemEntry fFile;

    public ImageFileDetailPanel(ImageFileDetailPanelData imageFileDetailPanelData, Boolean bl, Double d) {
        this.fSimpleMode = bl;
        this.fOpacity = d;
        this.fComponent = imageFileDetailPanelData == null ? null : new PanelWithImageIcon(imageFileDetailPanelData);
        this.fFile = imageFileDetailPanelData == null ? null : imageFileDetailPanelData.getFile();
    }

    public JComponent getComponent() {
        if (this.fRequestFilter != null && this.fInValid) {
            this.fRequestFilter.request();
        }
        return this.fComponent;
    }

    public Status getLoadStatus() {
        return Status.COMPLETED;
    }

    public boolean isScrollBarNeeded() {
        return false;
    }

    private static Status importData(String string) {
        ArrayList<Status> arrayList = new ArrayList<Status>();
        String string2 = "uiimport('" + StringUtils.quoteSingleQuotes((String)string) + "')";
        final Status status = new Status();
        arrayList.add(status);
        MATLAB.evalConsoleOutput(string2, new CompletionObserver(){

            public void completed(int n, Object object) {
                status.markCompleted();
            }
        });
        return new Status(arrayList);
    }

    public static Image getSmoothScaledInstance(Image image, int n, int n2) {
        return image.getScaledInstance(n, n2, 2);
    }

    private Image getScaledInstance(Image image, int n, int n2) {
        return image.getScaledInstance(n, n2, this.fSimpleMode ? 4 : 2);
    }

    private class PanelWithImageIcon
    extends MJPanel {
        private MJButton iButton;
        private final ImageFileDetailPanelData iData;
        private boolean iSuppressAutoButtonFocus;

        private PanelWithImageIcon(ImageFileDetailPanelData imageFileDetailPanelData) {
            this.iData = imageFileDetailPanelData;
            Dimension dimension = imageFileDetailPanelData.getOriginalImageDimension();
            String string = "1dlu:grow,CENTER:pref,2dlu:grow";
            String string2 = "1dlu:grow,pref,7px,pref,1dlu:grow";
            FormLayout formLayout = new FormLayout(string, string2);
            CellConstraints cellConstraints = new CellConstraints();
            this.setLayout((LayoutManager)formLayout);
            final ImageIcon imageIcon = new ImageIcon();
            this.createButton(imageIcon);
            ImageFileDetailPanel.this.fRequestFilter = new RequestFilter(new Runnable(){

                @Override
                public void run() {
                    final Holder holder = new Holder((Object)false);
                    final Holder holder2 = new Holder();
                    try {
                        AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (ImageFileDetailPanel.this.fComponent != null && ImageFileDetailPanel.this.fComponent.isShowing()) {
                                    holder.set((Object)true);
                                    holder2.set((Object)ImageFileDetailPanel.this.fComponent.getSize());
                                }
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        if (!((Boolean)holder.get()).booleanValue()) {
                            ImageFileDetailPanel.this.fInValid = true;
                            return;
                        }
                        final ImageFileDetailPanelData.ImageSubSampleReader imageSubSampleReader = new ImageFileDetailPanelData.ImageSubSampleReader((Dimension)holder2.get());
                        imageSubSampleReader.readSampledImage(ImageFileDetailPanel.this.fFile);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Dimension dimension = imageSubSampleReader.getIdealDimension();
                                if (imageSubSampleReader.getSampledImage() != null) {
                                    imageIcon.setImage(ImageFileDetailPanel.this.getScaledInstance(imageSubSampleReader.getSampledImage(), dimension.width, dimension.height));
                                }
                                PanelWithImageIcon.this.revalidate();
                                PanelWithImageIcon.this.repaint();
                                ImageFileDetailPanel.this.fInValid = false;
                            }
                        });
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }, 1000);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    ImageFileDetailPanel.this.fRequestFilter.request();
                }
            });
            if (ImageFileDetailPanel.this.fSimpleMode) {
                this.add((Component)new MJLabel(imageIcon){

                    public void paintComponent(Graphics graphics) {
                        Graphics2D graphics2D = (Graphics2D)graphics.create();
                        graphics2D.setComposite(AlphaComposite.getInstance(3, (float)ImageFileDetailPanel.this.fOpacity));
                        super.paintComponent((Graphics)graphics2D);
                        graphics2D.dispose();
                    }
                }, cellConstraints.xywh(1, 1, 3, 5));
            } else {
                this.add((Component)this.iButton, cellConstraints.xy(2, 2));
            }
            if (dimension != null && !ImageFileDetailPanel.this.fSimpleMode) {
                MJPanel mJPanel = new MJPanel();
                mJPanel.add((Component)new MJLabel(MessageFormat.format(ExplorerResources.getString("preview.width"), dimension.width)));
                mJPanel.add((Component)new MJLabel(MessageFormat.format(ExplorerResources.getString("preview.height"), dimension.height)));
                this.add((Component)mJPanel, cellConstraints.xy(2, 4));
            }
            if (!ImageFileDetailPanel.this.fSimpleMode) {
                this.setFocusable(true);
                this.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        if (!PanelWithImageIcon.this.iSuppressAutoButtonFocus && focusEvent.getOppositeComponent() != PanelWithImageIcon.this.iButton) {
                            PanelWithImageIcon.this.iButton.requestFocus();
                        }
                    }
                });
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        PanelWithImageIcon.this.iSuppressAutoButtonFocus = true;
                        PanelWithImageIcon.this.requestFocus();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                PanelWithImageIcon.this.iSuppressAutoButtonFocus = false;
                            }
                        });
                    }
                });
            }
        }

        private void createButton(final ImageIcon imageIcon) {
            this.iButton = new MJButton(imageIcon){

                public Dimension getPreferredSize() {
                    return new Dimension(imageIcon.getIconWidth() + 2, imageIcon.getIconHeight() + 2);
                }

                public void paint(Graphics graphics) {
                    graphics.setColor(PanelWithImageIcon.this.getBackground());
                    graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                    imageIcon.paintIcon((Component)((Object)this), graphics, 1, 1);
                    if (this.hasFocus()) {
                        Border border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                        if (border == null) {
                            border = UIManager.getBorder("Table.focusCellHighlightBorder");
                        }
                        if (border != null) {
                            border.paintBorder((Component)((Object)this), graphics, 0, 0, this.getWidth(), this.getHeight());
                        }
                    }
                }
            };
            this.iButton.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (MouseUtils.isDoubleClickEvent((MouseEvent)mouseEvent)) {
                        PanelWithImageIcon.this.doImport();
                    }
                }
            });
            this.iButton.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        PanelWithImageIcon.this.doImport();
                    }
                }
            });
        }

        private void doImport() {
            try {
                FileSystemEntry fileSystemEntry = MLFileSystemUtils.getMatlabAccessibleEntry(this.iData.getFile());
                Status status = ImageFileDetailPanel.importData(fileSystemEntry.getLocation().toString());
                this.iButton.setCursor(Cursor.getPredefinedCursor(3));
                status.addCompletionOrCancellationRunnable(new Runnable(){

                    @Override
                    public void run() {
                        PanelWithImageIcon.this.iButton.setCursor(Cursor.getDefaultCursor());
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

