/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.basic;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.CoreActionID;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SelectionMode;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.matlab.api.explorer.StatusRunnable;
import com.mathworks.mlwidgets.explorer.extensions.basic.CoreActionProvider;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.actions.ActionPredicates;
import com.mathworks.mlwidgets.explorer.util.FileSystemUtils;
import com.mathworks.mlwidgets.explorer.util.MLFileSystemUtils;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.util.Converter;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import com.mathworks.util.StringUtils;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CoreExternalActionProvider
implements ActionProvider {
    private static final Matlab sMatlab = new Matlab();

    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return true;
    }

    public void configureActions(ActionRegistry actionRegistry) {
        actionRegistry.getAction(CoreActionID.OPEN_OUTSIDE_MATLAB).setVisibleOnContextMenu(ActionPredicates.and(ActionPredicates.NO_DIRECTORIES, ActionPredicates.NOT_X_WINDOWS));
        actionRegistry.getAction(CoreActionID.OPEN_OUTSIDE_MATLAB).setEnabled((Predicate)ActionPredicates.NOT_X_WINDOWS);
        actionRegistry.getAction(CoreActionID.OPEN_OUTSIDE_MATLAB).setCode(SelectionMode.MULTIPLE_SELECTION_OR_CURRENT_LOCATION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                return CoreExternalActionProvider.openOutsideMatlab(actionInput);
            }
        });
        actionRegistry.getAction(CoreActionID.OPEN_OUTSIDE_MATLAB).setLabel((Converter)new Converter<ActionInput, String>(){

            public String convert(ActionInput actionInput) {
                if (actionInput.getSelection().isEmpty()) {
                    return ExplorerResources.getString("context.openCurrentFolderOutsideMatlab." + (PlatformInfo.isWindows() ? "windows" : "mac"));
                }
                return ExplorerResources.getString("context.openOutsideMatlab");
            }
        });
        actionRegistry.getAction(CoreActionID.LOCATE_ON_DISK).setEnabled((Predicate)ActionPredicates.NOT_X_WINDOWS);
        actionRegistry.getAction(CoreActionID.LOCATE_ON_DISK).setCode(SelectionMode.EXPLICIT_MULTIPLE_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                return CoreExternalActionProvider.locateOnDisk(actionInput);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Status openOutsideMatlab(ActionInput actionInput) {
        ArrayList<Status> arrayList = new ArrayList<Status>();
        List<FileSystemEntry> list = CoreExternalActionProvider.getSelectionOrCurrentLocation(actionInput);
        String string = CoreActionProvider.formatLabel("progress.open", "progress.open.multiple", list);
        for (FileSystemEntry fileSystemEntry : FileSystemUtils.getUnderlyingEntries(list)) {
            Status status = new Status(string, true);
            arrayList.add(status);
            try {
                fileSystemEntry = fileSystemEntry.getSystem().followShortcutOrLink(fileSystemEntry);
                fileSystemEntry = MLFileSystemUtils.getMatlabAccessibleEntry(fileSystemEntry);
                CoreExternalActionProvider.openOutsideMatlab(actionInput.getComponent(), new File(fileSystemEntry.getLocation().toString()), status);
            }
            catch (IOException iOException) {}
            continue;
            finally {
                status.markCompleted();
            }
        }
        return new Status(arrayList);
    }

    private static void openOutsideMatlab(final Component component, final File file, final Status status) {
        if (!file.exists()) {
            status.markCompleted();
            return;
        }
        if (PlatformInfo.isWindows()) {
            String string = "winopen('" + StringUtils.quoteSingleQuotes((String)file.getAbsolutePath()) + "')";
            sMatlab.eval(string, new CompletionObserver(){

                public void completed(int n, Object object) {
                    if (Matlab.getExecutionStatus((int)n) == 2 || Matlab.getExecutionStatus((int)n) == 1) {
                        MJOptionPane.showMessageDialog((Component)component, (Object)MessageFormat.format(ExplorerResources.getString("open.outside.error"), file.getName()), (String)ExplorerResources.getString("open.outside.error.title"), (int)0);
                    }
                    status.markCompleted();
                }
            });
        } else if (PlatformInfo.isMacintosh()) {
            Object[] objectArray = new String[]{"open '" + file.getAbsolutePath() + "'"};
            sMatlab.feval("unix", objectArray, 2, new CompletionObserver(){

                public void completed(int n, Object object) {
                    Object[] objectArray = (Object[])object;
                    double[] dArray = (double[])objectArray[0];
                    if (dArray[0] != 0.0) {
                        MJOptionPane.showMessageDialog((Component)component, (Object)MessageFormat.format(ExplorerResources.getString("open.outside.error"), file.getName()), (String)ExplorerResources.getString("open.outside.error.title"), (int)0);
                    }
                    status.markCompleted();
                }
            });
        }
    }

    private static Status locateOnDisk(ActionInput actionInput) {
        ArrayList arrayList = new ArrayList();
        List<FileSystemEntry> list = CoreExternalActionProvider.getSelectionOrCurrentLocation(actionInput);
        String string = CoreActionProvider.formatLabel("progress.locating", "progress.locating.multiple", list);
        for (FileSystemEntry fileSystemEntry : FileSystemUtils.getUnderlyingEntries(list)) {
            Status status = new Status(string, true);
            if (!fileSystemEntry.isReal()) continue;
            if (PlatformInfo.isMacintosh()) {
                CoreExternalActionProvider.showInFinder(fileSystemEntry, status);
                continue;
            }
            if (PlatformInfo.isWindows()) {
                NativeJava.shellExecuteExplore((String)fileSystemEntry.getLocation().toString());
                status.markCompleted();
                continue;
            }
            throw new IllegalStateException("locate on disk is not supported on this platform.");
        }
        return new Status(arrayList);
    }

    private static List<FileSystemEntry> getSelectionOrCurrentLocation(ActionInput actionInput) {
        List<FileSystemEntry> list = actionInput.getSelection();
        if (list.isEmpty()) {
            list = Arrays.asList(actionInput.getLocation());
        }
        return list;
    }

    private static void showInFinder(FileSystemEntry fileSystemEntry, final Status status) {
        assert (PlatformInfo.isMacintosh());
        assert (fileSystemEntry.isReal());
        String string = "unix 'osascript -e ''tell app \"Finder\" to select file \"" + fileSystemEntry.getLocation().toString() + "\" as POSIX file'''";
        sMatlab.eval(string, new CompletionObserver(){

            public void completed(int n, Object object) {
                String string = "unix 'osascript -e ''tell app \"Finder\" to activate'''";
                sMatlab.evalNoOutput(string, new CompletionObserver(){

                    public void completed(int n, Object object) {
                        status.markCompleted();
                    }
                });
            }
        });
    }
}

