/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.configeditor.ui;

import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.swing.EventListModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mlwidgets.configeditor.ConfigurationUtils;
import com.mathworks.mlwidgets.configeditor.data.BasePublishOptions;
import com.mathworks.mlwidgets.configeditor.data.DerivedPublishOptions;
import com.mathworks.mlwidgets.configeditor.data.PublishConfiguration;
import com.mathworks.mlwidgets.configeditor.plugin.ConfigurationPluginUtils;
import com.mathworks.mlwidgets.configeditor.plugin.PublishConfigurationPlugin;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTextField;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PublishOptionsSaveDialog {
    private MJDialog fDialog;
    private DerivedPublishOptions fOptions;
    private FilterList<BasePublishOptions> fFilterList;
    private EventListModel<BasePublishOptions> fListModel;
    private MJList fList;
    private MJTextField fNewName = new MJTextField(25);
    private MJButton fSaveButton = new MJButton(ConfigurationUtils.lookup("save.button"));
    private MJButton fCancelButton = new MJButton(ConfigurationUtils.lookup("cancel.button"));
    private boolean fFireNameChangeFromSelectionEvent = true;
    private ListSelectionListener fListSelectionListener;
    private DocumentListener fDocumentListener;
    private WindowAdapter fWindowListener;
    private ActionListener fSaveButtonListener;
    private ActionListener fCancelButtonListener;
    private SaveAsListener fSaveAsListener;

    public PublishOptionsSaveDialog(Frame frame, SaveAsListener saveAsListener, DerivedPublishOptions derivedPublishOptions) {
        this.fDialog = new MJDialog(frame, ConfigurationUtils.lookup("publish.options.save.dialog.title"), true);
        this.fSaveAsListener = saveAsListener;
        this.fOptions = derivedPublishOptions;
        this.init();
    }

    private void init() {
        PublishConfigurationPlugin publishConfigurationPlugin = (PublishConfigurationPlugin)ConfigurationPluginUtils.getPluginManager().getPlugin(PublishConfiguration.TYPE);
        this.fFilterList = new FilterList(publishConfigurationPlugin.getBasePublishOptions(), (Matcher)new FactoryExclusionMatcher());
        this.fListModel = new EventListModel(this.fFilterList);
        this.fList = new MJList(this.fListModel);
        this.fNewName.setOpaque(true);
        this.updateSaveButtonWidth();
        this.doTextFieldUpdated();
        this.initLayout();
        this.initListeners();
        this.fDialog.setCloseOnEscapeEnabled(true);
        this.fDialog.setDefaultCloseOperation(2);
        this.fDialog.getRootPane().setDefaultButton((JButton)this.fSaveButton);
    }

    private void initLayout() {
        FormLayout formLayout = new FormLayout("d, 2dlu, d:grow", "d:grow, 3dlu, d, 5dlu, d");
        CellConstraints cellConstraints = new CellConstraints();
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)this.fDialog.getContentPane());
        panelBuilder.setDefaultDialogBorder();
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fList, 20, 30);
        MJLabel mJLabel = new MJLabel(ConfigurationUtils.lookup("publish.options.label"));
        MJLabel mJLabel2 = new MJLabel(ConfigurationUtils.lookup("publish.options.name.label"));
        panelBuilder.add((Component)mJLabel, cellConstraints.xywh(1, 1, 1, 1, "right, top"));
        panelBuilder.add((Component)mJScrollPane, cellConstraints.xywh(3, 1, 1, 1, "fill, center"));
        panelBuilder.add((Component)mJLabel2, cellConstraints.xywh(1, 3, 1, 1, "right, center"));
        panelBuilder.add((Component)this.fNewName, cellConstraints.xywh(3, 3, 1, 1, "fill, fill"));
        panelBuilder.add((Component)this.buildButtonBar(), cellConstraints.xywh(1, 5, 3, 1, "fill, center"));
    }

    private void cleanup() {
        this.fListModel.dispose();
        this.fFilterList.dispose();
        this.fDialog.removeWindowListener((WindowListener)this.fWindowListener);
        this.fSaveButton.removeActionListener(this.fSaveButtonListener);
        this.fCancelButton.removeActionListener(this.fCancelButtonListener);
        this.fList.removeListSelectionListener(this.fListSelectionListener);
        this.fNewName.getDocument().removeDocumentListener(this.fDocumentListener);
        this.fSaveAsListener = null;
    }

    private JPanel buildButtonBar() {
        return ButtonBarFactory.buildOKCancelBar((JButton)this.fSaveButton, (JButton)this.fCancelButton);
    }

    private void initListeners() {
        this.fListSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n;
                if (!listSelectionEvent.getValueIsAdjusting() && PublishOptionsSaveDialog.this.fFireNameChangeFromSelectionEvent && (n = PublishOptionsSaveDialog.this.fList.getSelectedIndex()) >= 0) {
                    PublishOptionsSaveDialog.this.fNewName.setText(((BasePublishOptions)PublishOptionsSaveDialog.this.fFilterList.get(n)).getName());
                }
            }
        };
        this.fList.addListSelectionListener(this.fListSelectionListener);
        this.fDocumentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                PublishOptionsSaveDialog.this.doTextFieldUpdated();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                PublishOptionsSaveDialog.this.doTextFieldUpdated();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        this.fNewName.getDocument().addDocumentListener(this.fDocumentListener);
        this.fSaveButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PublishOptionsSaveDialog.this.getBaseOptionsForNameInTextField() == null) {
                    PublishOptionsSaveDialog.this.doSave();
                } else {
                    PublishOptionsSaveDialog.this.doOverwrite();
                }
                PublishOptionsSaveDialog.this.fSaveAsListener.saveAsCompleted();
                PublishOptionsSaveDialog.this.fDialog.dispose();
            }
        };
        this.fSaveButton.addActionListener(this.fSaveButtonListener);
        this.fCancelButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PublishOptionsSaveDialog.this.fDialog.dispose();
            }
        };
        this.fCancelButton.addActionListener(this.fCancelButtonListener);
        this.fWindowListener = new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                PublishOptionsSaveDialog.this.cleanup();
            }
        };
        this.fDialog.addWindowListener((WindowListener)this.fWindowListener);
    }

    private void doTextFieldUpdated() {
        BasePublishOptions basePublishOptions = this.getBaseOptionsForNameInTextField();
        this.fFireNameChangeFromSelectionEvent = false;
        if (basePublishOptions == null) {
            this.fList.getSelectionModel().clearSelection();
        } else {
            this.fList.setSelectedValue((Object)basePublishOptions, true);
        }
        this.fFireNameChangeFromSelectionEvent = true;
        this.fSaveButton.setText(basePublishOptions == null ? ConfigurationUtils.lookup("save.button") : ConfigurationUtils.lookup("overwrite.button"));
        this.fSaveButton.setEnabled(!this.fNewName.getText().equals(""));
    }

    private void doSave() {
        BasePublishOptions basePublishOptions = new BasePublishOptions(this.fNewName.getText());
        basePublishOptions.setBeanProperties(this.fOptions);
        PublishConfigurationPlugin publishConfigurationPlugin = (PublishConfigurationPlugin)ConfigurationPluginUtils.getPluginManager().getPlugin(PublishConfiguration.TYPE);
        publishConfigurationPlugin.addBasePublishOptions(basePublishOptions);
        this.fOptions.setBasePublishOptions(basePublishOptions);
    }

    private void doOverwrite() {
        BasePublishOptions basePublishOptions = this.getBaseOptionsForNameInTextField();
        basePublishOptions.setBeanProperties(this.fOptions);
        this.fOptions.setBasePublishOptions(basePublishOptions);
    }

    private BasePublishOptions getBaseOptionsForNameInTextField() {
        PublishConfigurationPlugin publishConfigurationPlugin = (PublishConfigurationPlugin)ConfigurationPluginUtils.getPluginManager().getPlugin(PublishConfiguration.TYPE);
        return publishConfigurationPlugin.getBasePublishOptions(this.fNewName.getText(), false);
    }

    private void updateSaveButtonWidth() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        Integer n = this.fSaveButton.getFontMetrics(this.fSaveButton.getFont()).stringWidth(ConfigurationUtils.lookup("save.button"));
        hashMap.put(n, ConfigurationUtils.lookup("save.button"));
        Integer n2 = this.fSaveButton.getFontMetrics(this.fSaveButton.getFont()).stringWidth(ConfigurationUtils.lookup("overwrite.button"));
        hashMap.put(n2, ConfigurationUtils.lookup("overwrite.button"));
        String string = (String)hashMap.get(n > n2 ? n : n2);
        this.fSaveButton.setText(string);
        this.fSaveButton.setPreferredSize(this.fSaveButton.getPreferredSize());
    }

    public void showDialog() {
        this.fDialog.pack();
        this.fDialog.setLocationRelativeTo((Component)this.fDialog.getOwner());
        this.fDialog.setVisible(true);
        this.fNewName.requestFocusInWindow();
    }

    public static interface SaveAsListener {
        public void saveAsCompleted();
    }

    private static class FactoryExclusionMatcher
    implements Matcher<BasePublishOptions> {
        private FactoryExclusionMatcher() {
        }

        public boolean matches(BasePublishOptions basePublishOptions) {
            return !basePublishOptions.getName().equals(ConfigurationUtils.lookup("publish.options.factory"));
        }
    }
}

