/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.configeditor.plugin;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.grid.Property;
import com.mathworks.common.icons.FileTypeIcon;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.mlservices.MatlabDebugAdapter;
import com.mathworks.mlservices.MatlabDebugObserver;
import com.mathworks.mlservices.MatlabDebugServices;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlservices.MatlabExecutionErrorHandler;
import com.mathworks.mlwidgets.configeditor.ConfigurationJideUtils;
import com.mathworks.mlwidgets.configeditor.ConfigurationUtils;
import com.mathworks.mlwidgets.configeditor.data.BasePublishOptions;
import com.mathworks.mlwidgets.configeditor.data.DerivedPublishOptions;
import com.mathworks.mlwidgets.configeditor.data.PublishConfiguration;
import com.mathworks.mlwidgets.configeditor.data.PublishOptions;
import com.mathworks.mlwidgets.configeditor.plugin.ConfigurationPlugin;
import com.mathworks.mlwidgets.configeditor.plugin.PersistenceUtils;
import com.mathworks.mlwidgets.configeditor.ui.ComponentDetailsEditor;
import com.mathworks.mlwidgets.configeditor.ui.PublishConfigurationDetailsEditor;
import com.mathworks.mlwidgets.configeditor.ui.UiSupport;
import com.mathworks.mwswing.GlobalCursor;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.services.Prefs;
import com.mathworks.util.Log;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.apache.commons.io.IOUtils;

public class PublishConfigurationPlugin
extends ConfigurationPlugin<PublishConfiguration> {
    private EventList<BasePublishOptions> fBasePublishOptions = new BasicEventList();

    public PublishConfigurationPlugin() {
        super(PublishConfiguration.TYPE, ConfigurationUtils.lookup("publishConfiguration.name"), 30);
    }

    @Override
    public ConfigurationPlugin.LoadBundle<PublishConfiguration> pluginsFirstLoad() {
        this.ensureThatFactoryAndDefaultBasePublishOptionsExist();
        return new ConfigurationPlugin.LoadBundle<PublishConfiguration>((EventList<PublishConfiguration>)new BasicEventList(), new HashMap());
    }

    private void ensureThatFactoryAndDefaultBasePublishOptionsExist() {
        BasePublishOptions basePublishOptions = this.getBasePublishOptions(ConfigurationUtils.lookup("publish.options.factory"), false);
        BasePublishOptions basePublishOptions2 = this.getBasePublishOptions(ConfigurationUtils.lookup("publish.options.default"), false);
        if (basePublishOptions == null) {
            this.fBasePublishOptions.add((Object)new BasePublishOptions(ConfigurationUtils.lookup("publish.options.factory")));
        }
        if (basePublishOptions2 == null) {
            this.fBasePublishOptions.add((Object)new BasePublishOptions(ConfigurationUtils.lookup("publish.options.default")));
        }
    }

    public void addBasePublishOptions(BasePublishOptions basePublishOptions) {
        if (!this.fBasePublishOptions.contains((Object)basePublishOptions)) {
            this.fBasePublishOptions.add((Object)basePublishOptions);
        }
    }

    public BasePublishOptions getDefaultPublishOptions() {
        return this.getBasePublishOptions(ConfigurationUtils.lookup("publish.options.default"), true);
    }

    public EventList<BasePublishOptions> getBasePublishOptions() {
        return this.fBasePublishOptions;
    }

    public BasePublishOptions getBasePublishOptions(String string, boolean bl) {
        BasePublishOptions basePublishOptions = null;
        for (BasePublishOptions basePublishOptions2 : this.fBasePublishOptions) {
            if (!basePublishOptions2.getName().equals(string)) continue;
            basePublishOptions = basePublishOptions2;
            break;
        }
        if (basePublishOptions == null && bl) {
            basePublishOptions = this.getBasePublishOptions(ConfigurationUtils.lookup("publish.options.default"), false);
        }
        return basePublishOptions;
    }

    @Override
    public void doConfigurationAction(PublishConfiguration publishConfiguration, Component component, MatlabExecutionErrorHandler matlabExecutionErrorHandler) {
        MatlabMCR matlabMCR = new MatlabMCR();
        DerivedPublishOptions derivedPublishOptions = publishConfiguration.getPublishOptions();
        String string = publishConfiguration.getAssociatedFile() == null ? null : publishConfiguration.getAssociatedFile().getAbsolutePath();
        String string2 = PublishConfigurationPlugin.convertPropertyToString(derivedPublishOptions.getProperty("outputFileFormat"));
        Boolean bl = derivedPublishOptions.getEvaluateCode();
        Boolean bl2 = derivedPublishOptions.getUseNewFigure();
        Boolean bl3 = derivedPublishOptions.getShowCode();
        String string3 = PublishConfigurationPlugin.convertPropertyToString(derivedPublishOptions.getProperty("styleSheet"));
        String string4 = PublishConfigurationPlugin.convertPropertyToString(derivedPublishOptions.getProperty("outputLocation"));
        String string5 = PublishConfigurationPlugin.convertPropertyToString(derivedPublishOptions.getProperty("imageFormat"));
        String string6 = derivedPublishOptions.getFigureCaptureMethod().getFunctionName();
        Integer n = derivedPublishOptions.getMaxHeight();
        Integer n2 = derivedPublishOptions.getMaxWidth();
        Boolean bl4 = derivedPublishOptions.getCreateThumbnail();
        Integer n3 = derivedPublishOptions.getMaxNumberOfOutputLines();
        String string7 = publishConfiguration.getMatlabExpression();
        Boolean bl5 = derivedPublishOptions.getCatchError();
        Object[] objectArray = new Object[]{string, string2, bl, bl2, bl3, string3, string4, string5, string6, n, n2, bl4, n3, string7, bl5};
        MJFrame mJFrame = MJFrame.getFrame((Component)component);
        GlobalCursor.set((Window)mJFrame, (Cursor)Cursor.getPredefinedCursor(3));
        MatlabDesktopServices.getDesktop().setStatusText(ConfigurationUtils.lookup("publish.status"));
        MatlabDebugObserver matlabDebugObserver = PublishConfigurationPlugin.createMatlabDebugObserver((Window)mJFrame);
        MatlabDebugServices.addDefaultObserverListener((MatlabDebugObserver)matlabDebugObserver);
        matlabMCR.fevalConsoleOutput("mdbpublish", objectArray, 0, PublishConfigurationPlugin.createCompletionObserver((Window)mJFrame, matlabDebugObserver));
    }

    private static CompletionObserver createCompletionObserver(final Window window, final MatlabDebugObserver matlabDebugObserver) {
        return new CompletionObserver(){

            public void completed(int n, Object object) {
                GlobalCursor.clear((Window)window);
                MatlabDesktopServices.getDesktop().setStatusText(null);
                if (n >= 0) {
                    Object[] objectArray = new Object[]{(String)object};
                    MatlabMCR matlabMCR = new MatlabMCR();
                    matlabMCR.fevalConsoleOutput("open", objectArray, 0, (CompletionObserver)null);
                }
                MatlabDebugServices.removeDefaultObserverListener((MatlabDebugObserver)matlabDebugObserver);
            }
        };
    }

    private static MatlabDebugObserver createMatlabDebugObserver(final Window window) {
        return new MatlabDebugAdapter(){

            public void doDBStop(String string, int n) {
                GlobalCursor.clear((Window)window);
            }
        };
    }

    public PublishConfigurationUiSupport createUISupport() {
        return new PublishConfigurationUiSupport();
    }

    @Override
    public ConfigurationPlugin.PersistenceSupport<PublishConfiguration> createPersistenceSupport() {
        return new PublishingPersistenceSupport();
    }

    private static String convertPropertyToString(Property property) {
        ConverterContext converterContext = property.getConverterContext() == null ? ConverterContext.DEFAULT_CONTEXT : property.getConverterContext();
        return ObjectConverterManager.toString((Object)property.getValue(), (Class)property.getType(), (ConverterContext)converterContext);
    }

    private class PublishingPersistenceSupport
    extends ConfigurationPlugin.PersistenceSupport<PublishConfiguration> {
        private static final String PUBLISH_FUNCTION_NAME = "publish";
        private static final String PUBLISH_OPTIONS = "publish_options";

        private PublishingPersistenceSupport() {
            super(new File(Prefs.getPropertyDirectory(), "publish_configurations.m"));
            ConfigurationJideUtils.initConverters();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ConfigurationPlugin.LoadBundle<PublishConfiguration> retrieve(FileReader fileReader) throws Exception {
            ConfigurationPlugin.LoadBundle<PublishConfiguration> loadBundle;
            ObjectConverterManager.initDefaultConverter();
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(fileReader);
                PersistenceUtils.readOverFileHeader(bufferedReader);
                loadBundle = this.readConfigurations(bufferedReader);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedReader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)bufferedReader);
            return loadBundle;
        }

        private ConfigurationPlugin.LoadBundle<PublishConfiguration> readConfigurations(BufferedReader bufferedReader) throws IOException {
            BasicEventList basicEventList = new BasicEventList();
            HashMap<File, PublishConfiguration> hashMap = new HashMap<File, PublishConfiguration>();
            while (bufferedReader.ready()) {
                try {
                    Map<PersistenceUtils.Annotation, String> map = PersistenceUtils.readConfigurationHeader(bufferedReader);
                    if (this.isPublishSettingsBlock(map)) {
                        String string = map.get((Object)PersistenceUtils.Annotation.NAME);
                        BasePublishOptions basePublishOptions = new BasePublishOptions(string);
                        this.readInPublishOptions(basePublishOptions, bufferedReader);
                        PublishConfigurationPlugin.this.fBasePublishOptions.add((Object)basePublishOptions);
                        continue;
                    }
                    this.readInPublishConfiguration(map, (EventList<PublishConfiguration>)basicEventList, hashMap, bufferedReader);
                }
                catch (Exception exception) {
                    Log.logException((Exception)exception);
                    PersistenceUtils.readUntilStartOfConfiguration(bufferedReader);
                }
            }
            PublishConfigurationPlugin.this.ensureThatFactoryAndDefaultBasePublishOptionsExist();
            return new ConfigurationPlugin.LoadBundle<PublishConfiguration>((EventList<PublishConfiguration>)basicEventList, (Map<File, PublishConfiguration>)hashMap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void persist(EventList<PublishConfiguration> eventList, Map<File, PublishConfiguration> map, FileWriter fileWriter) throws Exception {
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(fileWriter);
                PersistenceUtils.writePlainCommentAndNewLine(bufferedWriter, ConfigurationUtils.lookup("publishConfigurations.storage.file.header"));
                PersistenceUtils.writePlainCommentAndNewLine(bufferedWriter, (Object)((Object)PersistenceUtils.Annotation.VERSION) + " 1");
                PersistenceUtils.writePlainCommentAndNewLine(bufferedWriter, ConfigurationUtils.lookup("storage.file.disclaimer.1"));
                PersistenceUtils.writePlainCommentAndNewLine(bufferedWriter, ConfigurationUtils.lookup("storage.file.disclaimer.2"));
                PersistenceUtils.writePlainCommentAndNewLine(bufferedWriter, ConfigurationUtils.lookup("storage.file.disclaimer.3"));
                bufferedWriter.newLine();
                this.writeOutBasePublishOptions(bufferedWriter);
                this.writeOutPublishConfigurations(bufferedWriter, eventList, map);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedWriter);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)bufferedWriter);
        }

        private void writeOutBasePublishOptions(BufferedWriter bufferedWriter) throws IOException {
            for (BasePublishOptions basePublishOptions : PublishConfigurationPlugin.this.fBasePublishOptions) {
                PersistenceUtils.writeCommentAndAnnotationAndNewline(bufferedWriter, PersistenceUtils.Comment.CELL, PersistenceUtils.Annotation.NAME, basePublishOptions.getName());
                bufferedWriter.newLine();
                for (Property property : basePublishOptions.getBeanProperties()) {
                    this.writeOutPropertyAndNewLine(property, bufferedWriter);
                }
                bufferedWriter.newLine();
            }
        }

        private void writeOutPublishConfigurations(BufferedWriter bufferedWriter, EventList<PublishConfiguration> eventList, Map<File, PublishConfiguration> map) throws IOException {
            for (PublishConfiguration publishConfiguration : eventList) {
                Boolean bl = publishConfiguration.equals(map.get(publishConfiguration.getAssociatedFile()));
                PersistenceUtils.writeOutRunConfigurationHeader(bufferedWriter, publishConfiguration, bl);
                PersistenceUtils.writeCommentAndAnnotationAndNewline(bufferedWriter, PersistenceUtils.Comment.PLAIN, PersistenceUtils.Annotation.PUBLISH_OPTIONS_BASED_ON, publishConfiguration.getPublishOptions().getBasePublishOptions().getName());
                bufferedWriter.newLine();
                for (Property property : publishConfiguration.getPublishOptions().getBeanProperties()) {
                    this.writeOutPropertyAndNewLine(property, bufferedWriter);
                }
                PersistenceUtils.writeOutMatlabExpressionAsVariableAndNewLine(bufferedWriter, "publish_options.codeToEvaluate", publishConfiguration.getMatlabExpression());
                bufferedWriter.newLine();
                this.writeOutPublishFunctionCallAndNewLine(publishConfiguration.getAssociatedFile(), bufferedWriter);
                bufferedWriter.newLine();
            }
        }

        private void writeOutPropertyAndNewLine(Property property, BufferedWriter bufferedWriter) throws IOException {
            String string = PersistenceUtils.convertPropertyToMatlabString(property);
            bufferedWriter.write("publish_options." + property.getName() + "=" + string + ";");
            bufferedWriter.newLine();
        }

        private void writeOutPublishFunctionCallAndNewLine(File file, BufferedWriter bufferedWriter) throws IOException {
            bufferedWriter.write("publish('" + file.getAbsolutePath() + "'" + "," + PUBLISH_OPTIONS + ");");
            bufferedWriter.newLine();
        }

        private String readInPublishOptions(PublishOptions publishOptions, BufferedReader bufferedReader) throws IOException {
            String string = null;
            Map<String, String> map = PersistenceUtils.readPublishSettings(PUBLISH_OPTIONS, bufferedReader);
            for (String string2 : map.keySet()) {
                String string3 = map.get(string2);
                if (string2.equals("codeToEvaluate")) {
                    string = string3;
                    continue;
                }
                if (string3 == null) continue;
                Property property = publishOptions.getProperty(string2);
                ConverterContext converterContext = property.getConverterContext() == null ? ConverterContext.DEFAULT_CONTEXT : property.getConverterContext();
                property.setValue(ObjectConverterManager.fromString((String)string3, (Class)property.getType(), (ConverterContext)converterContext));
            }
            return string;
        }

        private void readInPublishConfiguration(Map<PersistenceUtils.Annotation, String> map, EventList<PublishConfiguration> eventList, Map<File, PublishConfiguration> map2, BufferedReader bufferedReader) throws IOException {
            String string = map.get((Object)PersistenceUtils.Annotation.NAME);
            String string2 = map.get((Object)PersistenceUtils.Annotation.ASSOCIATED_FILE);
            File file = new File(string2);
            Boolean bl = Boolean.valueOf(map.get((Object)PersistenceUtils.Annotation.MOST_RECENTLY_ACTIONED_ANNOTATION));
            String string3 = map.get((Object)PersistenceUtils.Annotation.UNIQUE_ID);
            String string4 = map.get((Object)PersistenceUtils.Annotation.PUBLISH_OPTIONS_BASED_ON);
            if (string == null || string2 == null || bl == null || string3 == null) {
                throw new IOException("Annotations were missing from the configuration's header.");
            }
            DerivedPublishOptions derivedPublishOptions = new DerivedPublishOptions(PublishConfigurationPlugin.this.getBasePublishOptions(string4, true));
            String string5 = this.readInPublishOptions(derivedPublishOptions, bufferedReader);
            PublishConfiguration publishConfiguration = new PublishConfiguration(string, file, string5, derivedPublishOptions);
            eventList.add((Object)publishConfiguration);
            if (bl.booleanValue()) {
                map2.put(file, publishConfiguration);
            }
            PersistenceUtils.readUntilStartOfConfiguration(bufferedReader);
        }

        private boolean isPublishSettingsBlock(Map<PersistenceUtils.Annotation, String> map) {
            return map.get((Object)PersistenceUtils.Annotation.NAME) != null && map.keySet().size() == 1;
        }
    }

    public static class PublishConfigurationUiSupport
    implements UiSupport<PublishConfiguration> {
        @Override
        public String getDisplayName(PublishConfiguration publishConfiguration) {
            return publishConfiguration.getName();
        }

        @Override
        public Icon getIcon(PublishConfiguration publishConfiguration) {
            return FileTypeIcon.PUBLISH_CONFIGURATION.getIcon();
        }

        @Override
        public Font getFont(Font font, PublishConfiguration publishConfiguration) {
            return font;
        }

        @Override
        public String getActionString() {
            return ConfigurationUtils.lookup("edit.configurations.dynamicMenuitem.publish");
        }

        @Override
        public String getActionName() {
            return ConfigurationUtils.lookup("publish.button");
        }

        @Override
        public String getIncorrectExtensionErrorMessage() {
            return ConfigurationUtils.lookup("publish.language.error");
        }

        @Override
        public String getTooltip(PublishConfiguration publishConfiguration) {
            return "<html><div style=\"margin: 2px;\"><b>" + ConfigurationUtils.lookup("matlabExpression.tooltip.title") + "</b><br>" + "<div style=\"margin: 3px;\">" + "<pre style=\"margin: 0px;\">" + publishConfiguration.getMatlabExpression() + "</pre></div></div></html>";
        }

        @Override
        public ComponentDetailsEditor<PublishConfiguration> createEditorComponent() {
            return new PublishConfigurationDetailsEditor();
        }

        @Override
        public String getHelpKey() {
            return "desktop_publish_config";
        }
    }
}

