/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.workspace.MatlabWorkspaceListener;
import com.mathworks.mlwidgets.workspace.WhosInformation;
import com.mathworks.mlwidgets.workspace.WorkspaceChange;
import com.mathworks.mlwidgets.workspace.WorkspaceMCRProvider;
import com.mathworks.mlwidgets.workspace.WorkspaceObserver;
import com.mathworks.mwswing.undo.MUndoManager;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.UndoableEditEvent;

public class WorkspaceUndoManager
extends MUndoManager {
    private static final Map<String, WorkspaceUndoManager> sVarnameManagerMap = new Hashtable<String, WorkspaceUndoManager>();
    private static final Map<String, Integer> sVarnameCountMap = new Hashtable<String, Integer>();
    private WorkspaceObserver fWO = new WSObserver();
    private boolean fHonor = true;
    private static final double KEY_MULTIPLIER = 1.0E7;
    private List<UndoKey> fCreatedKeys = new Vector<UndoKey>();
    private String fVariableName;

    public static WorkspaceUndoManager getUndoManager(String string) {
        WorkspaceUndoManager workspaceUndoManager;
        if (sVarnameManagerMap.containsKey(string)) {
            workspaceUndoManager = sVarnameManagerMap.get(string);
        } else {
            workspaceUndoManager = new WorkspaceUndoManager(string);
            sVarnameManagerMap.put(string, workspaceUndoManager);
            workspaceUndoManager.setLimit(1);
        }
        WorkspaceUndoManager.incrementKeyCount(string);
        return workspaceUndoManager;
    }

    private static void incrementKeyCount(String string) {
        if (sVarnameCountMap.containsKey(string)) {
            sVarnameCountMap.put(string, sVarnameCountMap.get(string) + 1);
        } else {
            sVarnameCountMap.put(string, 1);
        }
    }

    private WorkspaceUndoManager(String string) {
        this.fVariableName = string;
        this.registerForWorkspaceUpdates();
    }

    private void registerForWorkspaceUpdates() {
        if (Matlab.isMatlabAvailable()) {
            MatlabWorkspaceListener.addWorkspaceChangeObserver(this.fWO);
        }
    }

    private void unregisterForWorkspaceUpdates() {
        if (Matlab.isMatlabAvailable()) {
            MatlabWorkspaceListener.removeWorkspaceChangeObserver(this.fWO);
        }
    }

    public synchronized void receiveNextUndoableEdit() {
        this.fHonor = false;
    }

    public synchronized void doNotReceiveUndoableEdits() {
        this.fHonor = true;
    }

    public synchronized void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        if (this.fHonor) {
            throw new IllegalStateException("UndoableEditEvent received when not ready to receive.");
        }
        super.undoableEditHappened(undoableEditEvent);
    }

    public void release() {
        Integer n = sVarnameCountMap.get(this.fVariableName);
        if (n != null) {
            int n2 = n;
            if (n2 == 1) {
                WorkspaceUndoManager workspaceUndoManager = sVarnameManagerMap.get(this.fVariableName);
                sVarnameManagerMap.remove(this.fVariableName);
                sVarnameCountMap.remove(this.fVariableName);
                workspaceUndoManager.cleanup();
            } else {
                sVarnameCountMap.put(this.fVariableName, n2 - 1);
            }
        }
    }

    private void cleanup() {
        this.doNotReceiveUndoableEdits();
        this.unregisterForWorkspaceUpdates();
        this.discardAllEdits();
        this.cleanupAllKeys();
    }

    public synchronized void discardAllEdits() {
        boolean bl = this.fHonor;
        this.receiveNextUndoableEdit();
        super.discardAllEdits();
        this.fHonor = bl;
    }

    private void cleanupAllKeys() {
        for (UndoKey undoKey : this.fCreatedKeys) {
            undoKey.cleanup();
        }
        this.fCreatedKeys.clear();
    }

    private UndoKey getNewKey() {
        UndoKey undoKey = UndoKey.valueOf("key_" + Integer.toString((int)Math.floor(Math.random() * 1.0E7)));
        this.fCreatedKeys.add(undoKey);
        return undoKey;
    }

    public static UndoKey getNewKey(WorkspaceUndoManager workspaceUndoManager) {
        if (workspaceUndoManager != null) {
            workspaceUndoManager.cleanupAllKeys();
        }
        return workspaceUndoManager != null ? workspaceUndoManager.getNewKey() : null;
    }

    public static class UndoKey {
        private String iKeyString;

        static UndoKey valueOf(String string) {
            return new UndoKey(string);
        }

        private UndoKey(String string) {
            this.iKeyString = string;
        }

        public final String stringValue() {
            return this.iKeyString;
        }

        public final String toString() {
            return this.getClass() + ": " + this.iKeyString;
        }

        public final String getStorageString(String string) {
            return "arrayviewfunc('storeValue', '" + this.stringValue() + "', " + string + ");";
        }

        public final String getRetrieveAndClearValueString(String string) {
            return string + " = arrayviewfunc('retrieveAndClearValue', '" + this.stringValue() + "');";
        }

        public static String translateKeyForMatlab(UndoKey undoKey) {
            return undoKey != null ? '\'' + undoKey.stringValue() + '\'' : "[]";
        }

        public static String getStorageString(UndoKey undoKey, String string) {
            return undoKey != null ? undoKey.getStorageString(string) : ";";
        }

        public static String getRetrieveAndClearValueString(UndoKey undoKey, String string) {
            return undoKey != null ? undoKey.getRetrieveAndClearValueString(string) : ";";
        }

        private void cleanup() {
            WorkspaceMCRProvider.getMCRForUserActions().feval("arrayviewfunc", new Object[]{"clearValueSafely", this.stringValue()}, null);
        }
    }

    private class WSObserver
    implements WorkspaceObserver {
        private WSObserver() {
        }

        @Override
        public synchronized void workspaceUpdate(WorkspaceChange workspaceChange, WhosInformation whosInformation) {
            if (workspaceChange.isUndoTrigger()) {
                if (WorkspaceUndoManager.this.fHonor) {
                    WorkspaceUndoManager.this.discardAllEdits();
                } else {
                    WorkspaceUndoManager.this.doNotReceiveUndoableEdits();
                }
            }
        }
    }
}

