/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.CommonInsDelToolsetSupplier;
import com.mathworks.mlwidgets.array.FormatToolsetSupplier;
import com.mathworks.mlwidgets.array.ISortProvider;
import com.mathworks.mlwidgets.array.ITableController;
import com.mathworks.mlwidgets.array.ITransposeProvider;
import com.mathworks.mlwidgets.array.ValueEditorProvider;
import com.mathworks.mlwidgets.array.VariableCreationSupplier;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.toolstrip.components.TSTextField;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.util.Disposable;
import com.mathworks.widgets.datatransfer.VariableIdentifier;
import com.mathworks.widgets.datatransfer.VariableIdentifierProvider;
import com.mathworks.widgets.desk.DTToolstripFactory;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.widgets.spreadsheet.IRegionOpProvider;
import com.mathworks.widgets.spreadsheet.ISpreadsheetSelectionController;
import com.mathworks.widgets.spreadsheet.RangeSelectionModel;
import com.mathworks.widgets.spreadsheet.SpreadsheetActions;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class VariableToolFactory {
    private VariableToolFactory() {
    }

    static void getTools(String string, Object object, TSToolSet tSToolSet, TSToolSet tSToolSet2) {
        Object object2;
        VariableToolFactory.setupPrintOptions(object, tSToolSet);
        VariableToolFactory.setupRangeSelection(string, object, tSToolSet);
        if (object instanceof IRegionOpProvider) {
            object2 = (IRegionOpProvider)object;
            tSToolSet.addSupplier("insert", (TSToolSet.ToolSupplier)new InsertToolsetSupplier(tSToolSet, (IRegionOpProvider)object2, ArrayUtils.getResource("insert.Title"), new IRegionOpProvider.Scope[]{IRegionOpProvider.Scope.ROWS, IRegionOpProvider.Scope.ROWS_BELOW, IRegionOpProvider.Scope.COLUMNS, IRegionOpProvider.Scope.COLUMNS_TO_THE_RIGHT}));
            tSToolSet.addSupplier("delete", (TSToolSet.ToolSupplier)new DeleteToolsetSupplier(tSToolSet, (IRegionOpProvider)object2, ArrayUtils.getResource("delete.Title"), new IRegionOpProvider.Scope[]{IRegionOpProvider.Scope.ROWS, IRegionOpProvider.Scope.COLUMNS}));
        } else {
            tSToolSet.addSupplier("insert", (TSToolSet.ToolSupplier)new InsertToolsetSupplier(tSToolSet, null, ArrayUtils.getResource("insert.Title"), new IRegionOpProvider.Scope[0]));
            tSToolSet.addSupplier("delete", (TSToolSet.ToolSupplier)new DeleteToolsetSupplier(tSToolSet, null, ArrayUtils.getResource("delete.Title"), new IRegionOpProvider.Scope[0]));
        }
        tSToolSet.addSupplier("create", (TSToolSet.ToolSupplier)new VariableCreationSupplier(object));
        VariableToolFactory.setupSorting(object, tSToolSet);
        VariableToolFactory.setupTranspose(object, tSToolSet, string);
        if (object instanceof ValueEditorProvider) {
            tSToolSet2.addSupplier("format", (TSToolSet.ToolSupplier)new FormatToolsetSupplier(object, ((ValueEditorProvider)object).getFormattableDisplay()));
        }
        if (string != null) {
            tSToolSet2.configureAndAdd("go_up", (Action)((Object)new ArrayUtils.UpAction(string)));
        }
        object2 = DTToolstripFactory.getDocumentArrangementActions((Desktop)MatlabDesktopServices.getDesktop(), (String)"Array Editor");
        for (DTToolstripFactory.DocumentArrangement documentArrangement : DTToolstripFactory.DocumentArrangement.values()) {
            tSToolSet2.configureAndAdd(documentArrangement.name().toLowerCase(), (Action)object2.get(documentArrangement));
        }
    }

    private static void setupPrintOptions(Object object, TSToolSet tSToolSet) {
        tSToolSet.configureAndAdd("print", (Action)new ChildAction(SpreadsheetActions.getPrintAction((Object)object)));
        tSToolSet.configureAndAdd("print_all", SpreadsheetActions.getPrintAction((Object)object));
        tSToolSet.configureAndAdd("print_selection", SpreadsheetActions.getPrintSelectionAction((Object)object));
        tSToolSet.configureAndAdd("page_setup", SpreadsheetActions.getPageSetupAction((Object)object));
    }

    private static void setupRangeSelection(final String string, Object object, TSToolSet tSToolSet) {
        if (object instanceof ISpreadsheetSelectionController) {
            final ISpreadsheetSelectionController iSpreadsheetSelectionController = (ISpreadsheetSelectionController)object;
            final FocusGroup focusGroup = new FocusGroup();
            tSToolSet.addSupplier("row_range", new TSToolSet.ToolSupplier(){

                public JComponent createTool(TSToolSet.ToolLocation toolLocation) {
                    return new RangeSelectionTextField(string, IRegionOpProvider.Scope.ROWS, iSpreadsheetSelectionController.getSpreadsheetRowSelectionModel(), toolLocation == TSToolSet.ToolLocation.QUICK_ACCESS_BAR ? null : focusGroup);
                }
            });
            tSToolSet.addSupplier("column_range", new TSToolSet.ToolSupplier(){

                public JComponent createTool(TSToolSet.ToolLocation toolLocation) {
                    return new RangeSelectionTextField(string, IRegionOpProvider.Scope.COLUMNS, iSpreadsheetSelectionController.getSpreadsheetColumnSelectionModel(), toolLocation == TSToolSet.ToolLocation.QUICK_ACCESS_BAR ? null : focusGroup);
                }
            });
        }
    }

    private static void setupSorting(Object object, TSToolSet tSToolSet) {
        if (object instanceof ISortProvider) {
            tSToolSet.configureAndAdd("sort", (Action)((Object)new SortAction((ISortProvider)object, ITableController.SortDirection.ASCENDING)));
            tSToolSet.configureAndAdd("sort_ascending", (Action)((Object)new SortAction((ISortProvider)object, ITableController.SortDirection.ASCENDING)));
            tSToolSet.configureAndAdd("sort_descending", (Action)((Object)new SortAction((ISortProvider)object, ITableController.SortDirection.DESCENDING)));
        }
    }

    private static void setupTranspose(Object object, TSToolSet tSToolSet, String string) {
        if (object instanceof ITransposeProvider) {
            TransposeVariableAction transposeVariableAction = new TransposeVariableAction((ITransposeProvider)object);
            tSToolSet.configureAndAdd("transpose", (Action)((Object)transposeVariableAction));
            transposeVariableAction.setTip(ArrayUtils.getResource("transpose.Tooltip", string));
        }
    }

    private static class DeleteToolsetSupplier
    extends CommonInsDelToolsetSupplier {
        DeleteToolsetSupplier(TSToolSet tSToolSet, IRegionOpProvider iRegionOpProvider, String string, IRegionOpProvider.Scope[] scopeArray) {
            super(tSToolSet, iRegionOpProvider, string, scopeArray, "delete");
        }

        @Override
        MJAbstractAction getActionForScope(IRegionOpProvider.Scope scope) {
            return (MJAbstractAction)this.fRegionOpProvider.getDeleteAction(scope, 0);
        }
    }

    private static class InsertToolsetSupplier
    extends CommonInsDelToolsetSupplier {
        InsertToolsetSupplier(TSToolSet tSToolSet, IRegionOpProvider iRegionOpProvider, String string, IRegionOpProvider.Scope[] scopeArray) {
            super(tSToolSet, iRegionOpProvider, string, scopeArray, "insert");
        }

        @Override
        MJAbstractAction getActionForScope(IRegionOpProvider.Scope scope) {
            return (MJAbstractAction)this.fRegionOpProvider.getInsertAction(scope, 0);
        }
    }

    private static class FocusGroup {
        private Component iPreviousFocusOwner;
        private final List<Component> iMembers = new ArrayList<Component>();

        private FocusGroup() {
        }

        private Component getNext(Component component) {
            if (this.iMembers.isEmpty()) {
                return component;
            }
            if (component == null) {
                return this.iMembers.get(0);
            }
            int n = this.iMembers.indexOf(component) + 1;
            if (n >= this.iMembers.size()) {
                n = 0;
            }
            return this.iMembers.get(n);
        }

        Component getPreviousFocusOwner() {
            return this.iPreviousFocusOwner;
        }

        void setPreviousFocusOwner(Component component) {
            this.iPreviousFocusOwner = component;
        }

        void add(Component component) {
            this.iMembers.add(component);
        }

        boolean contains(Component component) {
            return this.iMembers.contains(component);
        }
    }

    private static class RangeSelectionTextField
    extends TSTextField
    implements ChangeListener,
    FocusListener,
    ActionListener,
    Disposable {
        private final IRegionOpProvider.Scope iOrientation;
        private final RangeSelectionModel iModel;
        private final FocusGroup iFocusGroup;
        private final String iVarName;
        private MatlabWorker<List<int[]>> iSelectionParseWorker;

        RangeSelectionTextField(String string, IRegionOpProvider.Scope scope, RangeSelectionModel rangeSelectionModel, FocusGroup focusGroup) {
            super("", 7);
            this.iOrientation = scope;
            this.iVarName = string;
            this.iModel = rangeSelectionModel;
            this.iFocusGroup = focusGroup;
            if (focusGroup != null) {
                focusGroup.add((Component)((Object)this));
            }
            rangeSelectionModel.addSelectionRangeListener((ChangeListener)this);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n == 27) {
                        RangeSelectionTextField.this.returnFocus();
                    } else if (n == 10) {
                        RangeSelectionTextField.this.returnFocus();
                    } else if (n == 9) {
                        Component component = null;
                        if (RangeSelectionTextField.this.iFocusGroup != null) {
                            component = RangeSelectionTextField.this.iFocusGroup.getNext((Component)((Object)RangeSelectionTextField.this));
                        }
                        if (component == null) {
                            RangeSelectionTextField.this.transferFocus();
                        } else {
                            component.requestFocusInWindow();
                        }
                    }
                }
            });
            this.addFocusListener(this);
            this.addActionListener(this);
            this.setFocusTraversalKeysEnabled(false);
            if (Matlab.isMatlabAvailable()) {
                this.iSelectionParseWorker = new MatlabWorker<List<int[]>>(){

                    public List<int[]> runOnMatlabThread() {
                        double[] dArray;
                        try {
                            dArray = RangeSelectionTextField.this.iOrientation == IRegionOpProvider.Scope.ROWS ? (double[])Matlab.mtEval((String)("arrayviewfunc('getSelectionIntervals'," + RangeSelectionTextField.this.iVarName + ",'" + RangeSelectionTextField.this.getText() + "','rows')"), (int)1) : (double[])Matlab.mtEval((String)("arrayviewfunc('getSelectionIntervals'," + RangeSelectionTextField.this.iVarName + ",'" + RangeSelectionTextField.this.getText() + "','columns')"), (int)1);
                        }
                        catch (Exception exception) {
                            return null;
                        }
                        ArrayList<int[]> arrayList = new ArrayList<int[]>();
                        for (int i = 0; i < dArray.length / 2; ++i) {
                            arrayList.add(new int[]{(int)dArray[i] - 1, (int)dArray[i + dArray.length / 2] - 1});
                        }
                        return arrayList;
                    }

                    public void runOnAWTEventDispatchThread(List<int[]> list) {
                        RangeSelectionTextField.this.setSelectionIntervals(list);
                    }
                };
            }
        }

        private void setSelectionIntervals(List<int[]> list) {
            if (list == null) {
                this.setText(this.iModel.getSelectionRangeString());
                return;
            }
            this.iModel.setSelectionIntervals(list);
            this.setText(this.iModel.getSelectionRangeString());
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.setText(this.iModel.getSelectionRangeString());
        }

        public void dispose() {
            this.iModel.removeSelectionRangeListener((ChangeListener)this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.iSelectionParseWorker != null && !this.iModel.getSelectionRangeString().equals(this.getText())) {
                this.iSelectionParseWorker.start();
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary() && this.iFocusGroup != null && !this.iFocusGroup.contains(focusEvent.getOppositeComponent())) {
                this.iFocusGroup.setPreviousFocusOwner(focusEvent.getOppositeComponent());
            }
            this.setText(this.iModel.getSelectionRangeString());
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                if (this.iFocusGroup != null && !this.iFocusGroup.contains(focusEvent.getOppositeComponent())) {
                    this.iFocusGroup.setPreviousFocusOwner(null);
                }
                if (this.iSelectionParseWorker != null && !this.iModel.getSelectionRangeString().equals(this.getText())) {
                    this.iSelectionParseWorker.start();
                }
            }
        }

        private void returnFocus() {
            if (this.iFocusGroup == null) {
                this.transferFocus();
            } else if (this.iFocusGroup.getPreviousFocusOwner() != null) {
                this.iFocusGroup.getPreviousFocusOwner().requestFocusInWindow();
                this.iFocusGroup.setPreviousFocusOwner(null);
            }
        }

        public void setText(String string) {
            super.setText(string);
            int n = this.getFontMetrics(this.getFont()).stringWidth(string);
            if (n > this.getWidth()) {
                this.setToolTipText(string);
            } else {
                this.setToolTipText(null);
            }
        }
    }

    private static class SortAction
    extends MJAbstractAction {
        private ISortProvider fProvider = null;
        private final ITableController.SortDirection fSortDirection;

        private SortAction(ISortProvider iSortProvider, ITableController.SortDirection sortDirection) {
            super("sort");
            if (iSortProvider instanceof VariableIdentifierProvider) {
                final VariableIdentifierProvider variableIdentifierProvider = (VariableIdentifierProvider)iSortProvider;
                variableIdentifierProvider.addVariableIdentifierListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        if (!listSelectionEvent.getValueIsAdjusting()) {
                            SortAction.this.updateEnabled(variableIdentifierProvider);
                        }
                    }
                });
                this.updateEnabled(variableIdentifierProvider);
            }
            this.fProvider = iSortProvider;
            this.fSortDirection = sortDirection;
        }

        private void updateEnabled(VariableIdentifierProvider variableIdentifierProvider) {
            VariableIdentifier variableIdentifier = variableIdentifierProvider.getVariableIdentifier();
            String string = variableIdentifier.getVariable();
            if (string == null) {
                string = variableIdentifier.getExpression();
            }
            boolean bl = false;
            if (string != null && variableIdentifierProvider instanceof ISortProvider) {
                bl = ((ISortProvider)variableIdentifierProvider).isSortEnabledForSelection();
            }
            this.setEnabled(bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.fProvider != null) {
                this.fProvider.sortRows(this.fSortDirection);
            }
        }
    }

    private static class TransposeVariableAction
    extends MJAbstractAction {
        private ITransposeProvider fProvider = null;

        private TransposeVariableAction(ITransposeProvider iTransposeProvider) {
            super("transpose");
            this.setEnabled(true);
            this.fProvider = iTransposeProvider;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.fProvider.transposeVariable();
        }
    }
}

