/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlservices.WorkspaceVariableAdaptor;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.IWorkspaceUndoManagerProvider;
import com.mathworks.mlwidgets.array.UpdatableData;
import com.mathworks.mlwidgets.array.ValueDataSection;
import com.mathworks.mlwidgets.array.ValueMetaInfo;
import com.mathworks.mlwidgets.array.WorkspaceUndoManager;
import com.mathworks.mlwidgets.workspace.WorkspaceMCRProvider;
import com.mathworks.mwswing.undo.MUndoManager;
import com.mathworks.widgets.spreadsheet.TableRepaintEvent;
import com.mathworks.widgets.spreadsheet.format.Formatter;
import java.awt.Point;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class ValueTableModel
extends AbstractTableModel
implements UpdatableData,
IWorkspaceUndoManagerProvider {
    private static final int BLOCKSIZE = 64;
    private static final int MAX_BLOCKS = 10;
    protected ValueMetaInfo fValueMetaInfo = null;
    private Map<Point, ValueDataSection> fVDSSectionsHasTemp;
    private final Map<Point, ValueDataSection> fVDSSectionsHas;
    private final Map<Point, Point> fVDSSectionsRequested;
    protected boolean fWindowTheData;
    private static final Map<Integer, RVFMRecipient> RFVM_RECIPIENTS = new Hashtable<Integer, RVFMRecipient>();
    private WorkspaceUndoManager fUndoManager;
    static final int UNINITIALIZED_CLASS = -1;
    private ValueDataSection fVDSForSetting;
    private boolean fIsDirty;
    protected WorkspaceVariable fVariable;

    protected ValueTableModel() {
        this("__dummyVariable__");
    }

    public WorkspaceVariable getVariable() {
        return this.fVariable;
    }

    @Deprecated
    protected ValueTableModel(String string) {
        this((WorkspaceVariable)new WorkspaceVariableAdaptor(string), true);
    }

    @Deprecated
    protected ValueTableModel(String string, boolean bl) {
        this((WorkspaceVariable)new WorkspaceVariableAdaptor(string), bl);
    }

    protected ValueTableModel(WorkspaceVariable workspaceVariable) {
        this(workspaceVariable, true);
    }

    protected ValueTableModel(WorkspaceVariable workspaceVariable, boolean bl) {
        this.fVariable = workspaceVariable;
        this.fWindowTheData = bl;
        this.fVDSSectionsHas = Collections.synchronizedMap(new LinkedHashMap<Point, ValueDataSection>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Point, ValueDataSection> entry) {
                return this.size() > 10;
            }
        });
        this.fVDSSectionsRequested = new Hashtable<Point, Point>();
        this.fUndoManager = bl ? WorkspaceUndoManager.getUndoManager(workspaceVariable.getWorkspaceVariableNameTemp()) : null;
        this.updateData();
    }

    void setVariableName(String string) {
        this.fVariable.setVariableName(string);
    }

    private Point getPointForIndices(int n, int n2) {
        if (this.fWindowTheData) {
            return new Point(n / 64, n2 / 64);
        }
        return new Point(0, 0);
    }

    private int getStartOfBlock(int n) {
        if (this.fWindowTheData) {
            return n / 64 * 64;
        }
        return 0;
    }

    private int getEndOfBlock(int n) {
        if (this.fWindowTheData) {
            return this.getStartOfBlock(n + 64) - 1;
        }
        return -2;
    }

    ValueDataSection getValueDataSection(int n, int n2) {
        Point point = this.getPointForIndices(n, n2);
        if (this.fVDSSectionsHas.containsKey(point)) {
            return this.fVDSSectionsHas.get(point);
        }
        return null;
    }

    private ValueDataSection getTempValueDataSection(int n, int n2) {
        Point point = this.getPointForIndices(n, n2);
        if (this.fVDSSectionsHasTemp != null && this.fVDSSectionsHasTemp.containsKey(point)) {
            return this.fVDSSectionsHasTemp.get(point);
        }
        return null;
    }

    private void valueUpdated(ValueDataSection valueDataSection, ValueMetaInfo valueMetaInfo) {
        this.fVDSForSetting = valueDataSection;
        int n = valueDataSection.getStartRow();
        int n2 = valueDataSection.getStartColumn();
        this.fValueMetaInfo = valueMetaInfo;
        this.fVDSSectionsHas.put(this.getPointForIndices(n, n2), valueDataSection);
        if (this.fIsDirty) {
            SwingUtilities.invokeLater(new FTSCRunnable(1));
        } else {
            SwingUtilities.invokeLater(new FTSCRunnable(3));
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        if (this.fValueMetaInfo != null) {
            return this.fValueMetaInfo.getColumnCount();
        }
        return 0;
    }

    @Override
    public String getColumnName(int n) {
        return Integer.toString(n + 1);
    }

    @Override
    public int getRowCount() {
        if (this.fValueMetaInfo != null) {
            return this.fValueMetaInfo.getRowCount();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.getValueAt(n, n2, false, null);
    }

    String getRODataForSection(int n, int n2) {
        String string = null;
        ValueDataSection valueDataSection = this.getValueDataSection(n, n2);
        if (valueDataSection != null) {
            string = valueDataSection.getReadOnlyDescription();
        }
        return string;
    }

    protected Object getValueAt(int n, int n2, boolean bl, Formatter formatter) {
        Object object = "";
        ValueDataSection valueDataSection = this.getValueDataSection(n, n2);
        if (valueDataSection == null) {
            ValueDataSection valueDataSection2 = this.getTempValueDataSection(n, n2);
            if (n < this.getRowCount() && n2 < this.getColumnCount()) {
                if (valueDataSection2 != null) {
                    object = valueDataSection2.getValueAt(n, n2, bl);
                }
                this.updateTableData(this.getStartOfBlock(n), this.getStartOfBlock(n2), this.getEndOfBlock(n), this.getEndOfBlock(n2));
            }
        } else if (n < this.getRowCount() && n2 < this.getColumnCount()) {
            object = valueDataSection.getValueAt(n, n2, bl);
        }
        if (formatter != null) {
            object = formatter.format(object);
        }
        return object;
    }

    public int getType() {
        if (this.fValueMetaInfo == null) {
            return -1;
        }
        return this.fValueMetaInfo.getClassID();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        String string;
        Object object2 = this.getValueAt(n, n2);
        String string2 = string = object2 == null ? "" : object2.toString();
        if (object.toString().equals(string)) {
            return;
        }
        Object[][] objectArray = new Object[1][1];
        objectArray[0][0] = object;
        this.setValuesAt(objectArray, n, n, n2, n2);
    }

    public void setValuesAt(Object[][] objectArray, int n, int n2, int n3, int n4) {
        this.fVDSForSetting.setValuesAt(objectArray, n, n2, n3, n4, null, this.fUndoManager, new ErrorDialogCO());
    }

    @Override
    public void updateData() {
        this.fIsDirty = true;
        this.fVDSSectionsHasTemp = new LinkedHashMap<Point, ValueDataSection>(this.fVDSSectionsHas);
        this.fVDSSectionsHas.clear();
        this.fVDSSectionsRequested.clear();
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        if (this.fWindowTheData) {
            this.updateTableData(0, 0, 64, 64);
        } else {
            this.updateTableDataFull();
        }
    }

    public void updateData(int n, int n2) {
        int n3 = this.getStartOfBlock(n);
        int n4 = this.getStartOfBlock(n2);
        this.updateTableData(n3, n4, n3 + 64, n4 + 64);
    }

    private void updateTableDataFull() {
        this.updateTableData(0, 0, -2, -2);
    }

    private void updateTableData(int n, int n2, int n3, int n4) {
        this.requestValueFromMatlab(this.fVariable, this.fVariable.getVariableName(), n + 1, n2 + 1, n3 + 1, n4 + 1, this);
    }

    protected void requestValueFromMatlab(WorkspaceVariable workspaceVariable, String string, int n, int n2, int n3, int n4, ValueTableModel valueTableModel) {
        Point point = this.getPointForIndices(n, n2);
        if (!this.fVDSSectionsRequested.containsKey(point)) {
            this.fVDSSectionsRequested.put(point, point);
            int n5 = ValueTableModel.addRVFMKey(valueTableModel, point);
            this.makeCallToMatlab(workspaceVariable, string, n, n2, n3, n4, n5, new RVFMCO(n5, valueTableModel));
        }
    }

    protected boolean useAlternateInputs() {
        return false;
    }

    protected Object[] alternateInputs() {
        return null;
    }

    protected boolean okToCallMatlab() {
        return Matlab.isMatlabAvailable();
    }

    protected void callToMatlabComplete() {
    }

    protected boolean callMatlabOnlyAtPrompt() {
        return true;
    }

    protected MatlabMCR getMatlabMCR() {
        return WorkspaceMCRProvider.getMCRForWorkspaceRefresh();
    }

    private void makeCallToMatlab(WorkspaceVariable workspaceVariable, String string, int n, int n2, int n3, int n4, int n5, final RVFMCO rVFMCO) {
        Object object;
        Object[] objectArray;
        Object object2;
        if (!this.okToCallMatlab()) {
            return;
        }
        Object object3 = workspaceVariable.getVariableName();
        Object object4 = string;
        if (this.useAlternateInputs()) {
            assert (this.alternateInputs() != null);
            object2 = this.alternateInputs();
            assert (((Object[])object2).length == 2);
            object3 = object2[0];
            object4 = object2[1];
        }
        if (workspaceVariable.isDefaultWorkspace() && !this.useAlternateInputs()) {
            objectArray = new Object[]{"arrayviewfunc('reportValuesCallback', '" + object3 + "'," + object4 + ", " + n + ", " + n2 + ", " + n3 + ", " + n4 + ", " + n5 + ");"};
            ArrayUtils.log(this.getClass(), 1, objectArray[0].toString());
            object2 = "eval";
        } else {
            object = "updateValueTableModel";
            ArrayUtils.log(this.getClass(), 1, (String)object);
            objectArray = new Object[]{object, this.fVariable, object3, object4, n, n2, n3, n4, n5, this.useAlternateInputs()};
            object2 = "arrayviewfunc";
        }
        if (this.callMatlabOnlyAtPrompt()) {
            object = new CompletionObserver(){

                public void completed(int n, Object object) {
                    rVFMCO.completed(n, object);
                    ValueTableModel.this.callToMatlabComplete();
                }
            };
            this.getMatlabMCR().feval((String)object2, objectArray, 1, (CompletionObserver)object);
        } else {
            new MatlabWorker(this.getMatlabMCR(), (String)object2, objectArray, rVFMCO, n5){
                final /* synthetic */ String val$function;
                final /* synthetic */ Object[] val$args;
                final /* synthetic */ RVFMCO val$rvfmco;
                final /* synthetic */ int val$code;
                {
                    this.val$function = string;
                    this.val$args = objectArray;
                    this.val$rvfmco = rVFMCO;
                    this.val$code = n;
                    super(matlabMCR);
                }

                public Object runOnMatlabThread() throws Exception {
                    Matlab.mtFeval((String)this.val$function, (Object[])this.val$args, (int)1);
                    return null;
                }

                public void runOnAWTEventDispatchThread(Object object) {
                    this.val$rvfmco.completed(this.val$code, object);
                    ValueTableModel.this.callToMatlabComplete();
                }
            }.start();
        }
    }

    public static int addRVFMKey(ValueTableModel valueTableModel, Point point) {
        RVFMRecipient rVFMRecipient = new RVFMRecipient(valueTableModel, point);
        int n = rVFMRecipient.hashCode();
        RFVM_RECIPIENTS.put(n, rVFMRecipient);
        return n;
    }

    public static void removeRVFMKey(int n) {
        RFVM_RECIPIENTS.remove(n);
    }

    public static void valueRequestCompleted(int n, ValueDataSection valueDataSection, ValueMetaInfo valueMetaInfo) {
        RVFMRecipient rVFMRecipient = RFVM_RECIPIENTS.get(n);
        ValueTableModel.removeRVFMKey(n);
        if (rVFMRecipient != null) {
            rVFMRecipient.done(valueDataSection, valueMetaInfo);
        }
    }

    private void removePoint(Point point) {
        this.fVDSSectionsRequested.remove(point);
    }

    public MUndoManager getUndoManager() {
        return this.getWorkspaceUndoManager();
    }

    @Override
    public WorkspaceUndoManager getWorkspaceUndoManager() {
        return this.fUndoManager;
    }

    public void cleanup() {
        if (this.fUndoManager != null) {
            this.fUndoManager.release();
        }
    }

    private static class RVFMRecipient {
        private ValueTableModel iVR;
        private Point iPoint;

        RVFMRecipient(ValueTableModel valueTableModel, Point point) {
            this.iVR = valueTableModel;
            this.iPoint = point;
        }

        public void done(ValueDataSection valueDataSection, ValueMetaInfo valueMetaInfo) {
            if (this.iVR != null) {
                this.iVR.valueUpdated(valueDataSection, valueMetaInfo);
                this.iVR.removePoint(this.iPoint);
            }
        }
    }

    protected static class RVFMCO
    implements CompletionObserver {
        private int iRVFMHashCode;
        private ValueTableModel iRequester;

        RVFMCO(int n, ValueTableModel valueTableModel) {
            this.iRVFMHashCode = n;
            this.iRequester = valueTableModel;
        }

        public void completed(int n, Object object) {
            ValueTableModel.removeRVFMKey(this.iRVFMHashCode);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RVFMCO.this.iRequester.fireTableDataChanged();
                }
            });
        }
    }

    private class FTSCRunnable
    implements Runnable {
        public static final int DATA_CHANGED = 1;
        public static final int STRUCTURE_CHANGED = 2;
        public static final int REPAINT = 3;
        private int iChangeStyle;

        FTSCRunnable(int n) {
            this.iChangeStyle = n;
        }

        @Override
        public void run() {
            if (this.iChangeStyle == 1) {
                ValueTableModel.this.fireTableDataChanged();
            } else if (this.iChangeStyle == 3) {
                ValueTableModel.this.fireTableChanged((TableModelEvent)new TableRepaintEvent((TableModel)ValueTableModel.this));
            } else if (this.iChangeStyle == 2) {
                ValueTableModel.this.fireTableStructureChanged();
            }
            ValueTableModel.this.fIsDirty = false;
        }
    }

    private class ErrorDialogCO
    implements CompletionObserver {
        private ErrorDialogCO() {
        }

        public void completed(int n, Object object) {
            if (Matlab.getExecutionStatus((int)n) != 0) {
                ValueTableModel.this.updateData();
            }
        }
    }
}

