/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.ArrayEditorProvider;
import com.mathworks.mlwidgets.array.CellEditorProvider;
import com.mathworks.mlwidgets.array.ObjArrayEditorProvider;
import com.mathworks.mlwidgets.array.TabularObjectEditorProvider;
import com.mathworks.mlwidgets.array.UnsupportedEditorProvider;
import com.mathworks.mlwidgets.array.ValueEditorProvider;
import com.mathworks.mlwidgets.array.ValueMetaInfo;
import com.mathworks.mlwidgets.array.editors.MCOSEditorProvider;
import com.mathworks.mlwidgets.array.editors.StructureEditorProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ValueEditorProviderRegistry {
    private static final String TIMESERIES_CLASS = "com.mathworks.toolbox.timeseries.TimeSeriesArrayEditorProvider";

    private ValueEditorProviderRegistry() {
    }

    static void renameValueEditorProvider(String string, ValueEditorProvider valueEditorProvider) {
        valueEditorProvider.rename(string);
    }

    static ValueEditorProvider getValueEditorProvider(WorkspaceVariable workspaceVariable, ValueMetaInfo valueMetaInfo, ValueEditorProvider valueEditorProvider) {
        int n = valueMetaInfo.getAttributes();
        int n2 = valueMetaInfo.getDims();
        if ((n & 2) == 2 || n2 > 2) {
            return ValueEditorProviderRegistry.getUnsupportedViewer(workspaceVariable, valueEditorProvider);
        }
        int n3 = valueMetaInfo.getClassID();
        int n4 = valueMetaInfo.getRowCount();
        int n5 = valueMetaInfo.getColumnCount();
        switch (n3) {
            case 1: {
                return ValueEditorProviderRegistry.getCellViewer(workspaceVariable, valueEditorProvider);
            }
            case 2: {
                if (n4 != 1 || n5 != 1) {
                    return ValueEditorProviderRegistry.getObjArrayViewer(workspaceVariable, valueEditorProvider);
                }
                return ValueEditorProviderRegistry.getStructureViewer(workspaceVariable, valueEditorProvider);
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return ValueEditorProviderRegistry.getArrayViewer(workspaceVariable, valueEditorProvider);
            }
            case 4: {
                if (n4 == 1) {
                    return ValueEditorProviderRegistry.getArrayViewer(workspaceVariable, valueEditorProvider);
                }
                return ValueEditorProviderRegistry.getUnsupportedViewer(workspaceVariable, valueEditorProvider);
            }
        }
        String string = valueMetaInfo.getClassString();
        if (string.equals("dataset")) {
            if (n4 > 0 && n5 > 0 && n5 < 5000 || n4 == 0 && n5 == 0) {
                return ValueEditorProviderRegistry.getDatasetArrayViewer(workspaceVariable, valueEditorProvider);
            }
            return ValueEditorProviderRegistry.getMCOSViewer(workspaceVariable, valueEditorProvider);
        }
        if (string.equals("timeseries")) {
            return ValueEditorProviderRegistry.getTimeseriesViewer(workspaceVariable, valueEditorProvider);
        }
        if (ValueEditorProviderRegistry.revertToUnsupportedForClass(valueMetaInfo)) {
            return ValueEditorProviderRegistry.getUnsupportedViewer(workspaceVariable, valueEditorProvider);
        }
        if (n4 > 1 || n5 > 1) {
            return ValueEditorProviderRegistry.getObjArrayViewer(workspaceVariable, valueEditorProvider);
        }
        if (valueMetaInfo.isMCOS()) {
            return ValueEditorProviderRegistry.getMCOSViewer(workspaceVariable, valueEditorProvider);
        }
        return ValueEditorProviderRegistry.getUnsupportedViewer(workspaceVariable, valueEditorProvider);
    }

    private static boolean revertToUnsupportedForClass(ValueMetaInfo valueMetaInfo) {
        String string = valueMetaInfo.getClassString();
        return valueMetaInfo.isSystemObject() || string.equals("dataset") || string.equals("nominal") || string.equals("ordinal") || string.equals("fints");
    }

    private static UnsupportedEditorProvider getUnsupportedViewer(WorkspaceVariable workspaceVariable, ValueEditorProvider valueEditorProvider) {
        if (valueEditorProvider instanceof UnsupportedEditorProvider) {
            return (UnsupportedEditorProvider)valueEditorProvider;
        }
        return UnsupportedEditorProvider.createProvider(workspaceVariable);
    }

    private static CellEditorProvider getCellViewer(WorkspaceVariable workspaceVariable, ValueEditorProvider valueEditorProvider) {
        if (valueEditorProvider instanceof CellEditorProvider) {
            return (CellEditorProvider)valueEditorProvider;
        }
        return CellEditorProvider.createProvider(workspaceVariable);
    }

    private static ObjArrayEditorProvider getObjArrayViewer(WorkspaceVariable workspaceVariable, ValueEditorProvider valueEditorProvider) {
        if (valueEditorProvider instanceof ObjArrayEditorProvider) {
            return (ObjArrayEditorProvider)valueEditorProvider;
        }
        return ObjArrayEditorProvider.createProvider(workspaceVariable);
    }

    private static ValueEditorProvider getDatasetArrayViewer(WorkspaceVariable workspaceVariable, ValueEditorProvider valueEditorProvider) {
        if (valueEditorProvider instanceof TabularObjectEditorProvider) {
            return valueEditorProvider;
        }
        if (!workspaceVariable.isDefaultWorkspace()) {
            return ValueEditorProviderRegistry.getUnsupportedViewer(workspaceVariable, null);
        }
        return TabularObjectEditorProvider.createProvider(workspaceVariable);
    }

    private static StructureEditorProvider getStructureViewer(WorkspaceVariable workspaceVariable, ValueEditorProvider valueEditorProvider) {
        if (valueEditorProvider instanceof StructureEditorProvider) {
            return (StructureEditorProvider)valueEditorProvider;
        }
        return StructureEditorProvider.createProvider(workspaceVariable);
    }

    private static ArrayEditorProvider getArrayViewer(WorkspaceVariable workspaceVariable, ValueEditorProvider valueEditorProvider) {
        if (valueEditorProvider instanceof ArrayEditorProvider) {
            return (ArrayEditorProvider)valueEditorProvider;
        }
        return ArrayEditorProvider.createProvider(workspaceVariable);
    }

    private static MCOSEditorProvider getMCOSViewer(WorkspaceVariable workspaceVariable, ValueEditorProvider valueEditorProvider) {
        if (valueEditorProvider instanceof MCOSEditorProvider) {
            return (MCOSEditorProvider)valueEditorProvider;
        }
        return MCOSEditorProvider.createProvider(workspaceVariable);
    }

    private static ValueEditorProvider getTimeseriesViewer(WorkspaceVariable workspaceVariable, ValueEditorProvider valueEditorProvider) {
        if (ValueEditorProviderRegistry.isTimeseriesEditorProvider(valueEditorProvider)) {
            return valueEditorProvider;
        }
        if (workspaceVariable.getWorkspaceID() != 0) {
            return ValueEditorProviderRegistry.getUnsupportedViewer(workspaceVariable, null);
        }
        ValueEditorProvider valueEditorProvider2 = ValueEditorProviderRegistry.createTimeseriesEditorProvider(workspaceVariable);
        return valueEditorProvider2 == null ? ValueEditorProviderRegistry.getUnsupportedViewer(workspaceVariable, null) : valueEditorProvider2;
    }

    private static boolean isTimeseriesEditorProvider(ValueEditorProvider valueEditorProvider) {
        return valueEditorProvider != null && valueEditorProvider.getClass().getName().equals(TIMESERIES_CLASS);
    }

    private static ValueEditorProvider createTimeseriesEditorProvider(WorkspaceVariable workspaceVariable) {
        try {
            Class<?> clazz = Class.forName(TIMESERIES_CLASS);
            Class<ValueEditorProvider> clazz2 = clazz.asSubclass(ValueEditorProvider.class);
            Constructor<ValueEditorProvider> constructor = clazz2.getConstructor(String.class);
            return constructor.newInstance(workspaceVariable.getWorkspaceVariableNameTemp());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }
}

