/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.actionbrowser;

import com.mathworks.mlwidgets.actionbrowser.ActionBrowserUtils;
import com.mathworks.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.html.HTMLConfiguration;
import org.xml.sax.SAXException;

public final class NekoHtmlSaxParser
extends AbstractSAXParser {
    private static int MAX_TAG_COUNT = 4000;
    private static int MAX_CHAR_COUNT = 8000;
    private static final String resStr = "com.mathworks.mlwidgets.actionbrowser.resources.RES_ActionBrowser";
    private static final String key = "NekoHtmlSaxParser.";
    private static ResourceBundle resources = ResourceBundle.getBundle("com.mathworks.mlwidgets.actionbrowser.resources.RES_ActionBrowser");
    private boolean fInBody = false;
    private boolean fInSyntax = false;
    private boolean fInDescription = false;
    private boolean fInNote = false;
    private String fFilePath = null;
    private int fTagCount = 0;
    private int fCharCount = 0;
    private boolean fSyntaxOnlyParser = false;
    private boolean fDescriptionOnlyParser = false;
    private boolean fClassConstructorRefPage = false;
    private int fTTSynposisTagDepthCount = 0;
    private boolean fParsed = false;
    private static final String BODY = "body";
    private static final String H2 = "h2";
    private static final char NBSP = '\u00a0';
    private static String[] EXCLUDED_ATTRIBUTES = new String[]{"href"};
    private String[] fFieldInfo = new String[4];
    private static final int SYNTAX_SOURCE = 1;
    private static final int DESCRIPTION_SOURCE = 2;
    private static final int NOTE_SOURCE = 3;
    private StringBuffer fBodyContent = new StringBuffer();
    private String fSyntax;
    private String fDescription;
    private String fNote;
    private boolean fReference = false;
    private boolean fInH2Tag = false;
    private boolean fInNoteTag = false;
    private String fHeadingName;
    private String fHighLightedText = null;
    private boolean fInDescriptionHyperLink = false;
    private boolean fInSyntaxExample = false;

    private NekoHtmlSaxParser() {
        super((XMLParserConfiguration)new HTMLConfiguration());
    }

    private NekoHtmlSaxParser(String string, String string2) {
        this();
        this.fHighLightedText = string2;
        if (FileUtils.fileExists((String)string)) {
            try {
                string = new File(string).toURL().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.fFilePath = string;
        if (this.fFilePath == null) {
            return;
        }
        int n = this.fFilePath.lastIndexOf("/");
        if (n >= 0) {
            this.fFilePath = this.fFilePath.substring(0, n + 1);
        }
    }

    public static NekoHtmlSaxParser getSyntaxParser() {
        NekoHtmlSaxParser nekoHtmlSaxParser = new NekoHtmlSaxParser();
        nekoHtmlSaxParser.fSyntaxOnlyParser = true;
        return nekoHtmlSaxParser;
    }

    public static NekoHtmlSaxParser getDescriptionParser(String string, String string2) {
        NekoHtmlSaxParser nekoHtmlSaxParser = new NekoHtmlSaxParser(string, string2);
        nekoHtmlSaxParser.fDescriptionOnlyParser = true;
        return nekoHtmlSaxParser;
    }

    public void parse(String string) {
        assert (!this.fParsed);
        this.fParsed = true;
        string = ActionBrowserUtils.correctUrlForFileDriveLetter(string);
        try {
            super.parse(string);
        }
        catch (IOException iOException) {
            if (FileUtils.fileExists((String)string)) {
                try {
                    super.parse(new File(string).toURL().toString());
                }
                catch (Exception exception) {}
            }
        }
        catch (ParseOverFlowException parseOverFlowException) {
            this.fFieldInfo[2] = this.fFieldInfo[2] == null ? "<br><b><i>" + resources.getString("NekoHtmlSaxParser.Click") + "</b>>/i>" : this.fFieldInfo[2] + "<br><b><i>" + resources.getString("NekoHtmlSaxParser.Click") + "</b></i>";
            this.complete();
        }
        catch (SyntaxParsedException syntaxParsedException) {
            this.complete();
        }
        catch (SAXException sAXException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkIfDone() {
        if (this.fSyntaxOnlyParser && this.fInSyntax) {
            throw new SyntaxParsedException();
        }
        if (this.fDescriptionOnlyParser && this.fInDescription) {
            throw new SyntaxParsedException();
        }
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        String string;
        String string2 = xMLString.toString().replace('\u00a0', ' ');
        if (string2.length() == 0) {
            return;
        }
        string2 = string2.replaceAll("\\<", "&lt;");
        string2 = string2.replaceAll("\\>", "&gt;");
        if (this.fInH2Tag && (string = string2.replace('\n', ' ').trim()).length() > 0) {
            this.fHeadingName = this.fHeadingName + string;
            return;
        }
        if (this.fInSyntax) {
            this.fFieldInfo[1] = this.fFieldInfo[1] == null ? string2 : this.fFieldInfo[1] + string2;
        }
        if (!(!this.fInDescription || this.fInSyntaxExample && this.fInDescriptionHyperLink)) {
            this.fCharCount += string2.length();
            this.addBufferText(2, ActionBrowserUtils.hiliteKeyword(string2, this.fHighLightedText));
        }
        if (this.fInNote) {
            this.addBufferText(3, ActionBrowserUtils.hiliteKeyword(string2, this.fHighLightedText));
        }
    }

    private void addBufferText(int n, String string) {
        if (this.fFieldInfo[n] == null) {
            this.fFieldInfo[n] = string;
        } else {
            int n2 = n;
            this.fFieldInfo[n2] = this.fFieldInfo[n2] + string;
        }
    }

    private void complete() {
        if (this.fFieldInfo == null) {
            return;
        }
        this.fSyntax = this.fFieldInfo[1];
        this.fDescription = this.fFieldInfo[2];
        this.fNote = this.fFieldInfo[3];
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) {
        if (qName.rawname.equalsIgnoreCase("meta")) {
            String string = xMLAttributes.getValue("name");
            String string2 = xMLAttributes.getValue("content");
            if (string != null && string2 != null) {
                if (string.equalsIgnoreCase("chunktype") && string2.equalsIgnoreCase("refpage")) {
                    this.fReference = true;
                } else if (string.equalsIgnoreCase("refentity") && string2.startsWith("class:")) {
                    this.fClassConstructorRefPage = true;
                }
            }
        } else if (qName.rawname.equalsIgnoreCase(BODY)) {
            this.fInBody = true;
        } else if (this.fInBody) {
            this.startBodyElement(qName, xMLAttributes);
        }
        super.startElement(qName, xMLAttributes, augmentations);
    }

    private void startBodyElement(QName qName, XMLAttributes xMLAttributes) {
        this.fHeadingName = "";
        if (this.fClassConstructorRefPage) {
            if (qName.rawname.equalsIgnoreCase("tt")) {
                if ("synopsis".equals(xMLAttributes.getValue("class")) && !this.fInDescription) {
                    this.fInSyntax = true;
                    this.fInNote = false;
                    this.fTTSynposisTagDepthCount = 0;
                    if (this.fFieldInfo[1] != null) {
                        this.fFieldInfo[1] = this.fFieldInfo[1] + "\n";
                    }
                }
                if (this.fInSyntax) {
                    ++this.fTTSynposisTagDepthCount;
                }
            }
        } else if ("synopsis".equals(xMLAttributes.getValue("class")) && !this.fInDescription) {
            this.fInSyntax = true;
            this.fInNote = false;
        }
        if ("feedbacklinkbot".equals(xMLAttributes.getValue("class")) || "nav".equals(xMLAttributes.getValue("class"))) {
            this.fInDescription = false;
            this.fInSyntax = false;
            this.fInNote = false;
        } else if (qName.rawname.equalsIgnoreCase(H2)) {
            this.checkIfDone();
            this.fInH2Tag = true;
        } else if (!this.fInDescription && qName.rawname.equalsIgnoreCase("table") && "note".equals(xMLAttributes.getValue("class")) && "Note".equals(xMLAttributes.getValue("summary"))) {
            this.checkIfDone();
            this.fInNoteTag = true;
        } else if (this.fInDescription) {
            this.fInH2Tag = false;
            this.fInNoteTag = false;
            this.fInDescriptionHyperLink = false;
            if (this.fFieldInfo[2] == null) {
                this.fFieldInfo[2] = "";
            }
            if (xMLAttributes != null && "img".equalsIgnoreCase(qName.rawname)) {
                int n;
                String string = " ";
                double d = -1.0;
                double d2 = -1.0;
                boolean bl = false;
                for (n = 0; n < xMLAttributes.getLength(); ++n) {
                    if (!xMLAttributes.getLocalName(n).equals("width")) continue;
                    try {
                        d = Double.parseDouble(xMLAttributes.getValue(n));
                        bl = true;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        break;
                    }
                }
                if (d < 0.0) {
                    for (n = 0; n < xMLAttributes.getLength(); ++n) {
                        if (!"src".equalsIgnoreCase(xMLAttributes.getLocalName(n))) continue;
                        try {
                            ImageIcon imageIcon = this.fFilePath != null ? new ImageIcon(new URL(this.fFilePath + xMLAttributes.getValue(n))) : new ImageIcon(new URL(xMLAttributes.getValue(n)));
                            if (imageIcon == null) continue;
                            d = imageIcon.getIconWidth();
                            d2 = imageIcon.getIconHeight();
                            continue;
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                    }
                }
                double d3 = 1.0;
                boolean bl2 = false;
                if (d > 300.0) {
                    d3 = 300.0 / d;
                    bl2 = true;
                    if (!bl) {
                        string = string + "width='300' height='" + Integer.toString((int)(d3 * d2)) + "'";
                    }
                }
                for (int i = 0; i < xMLAttributes.getLength(); ++i) {
                    if (bl2 && bl && (xMLAttributes.getLocalName(i).equals("width") || xMLAttributes.getLocalName(i).equals("height"))) {
                        string = string + xMLAttributes.getLocalName(i) + "='" + new Integer((int)(Double.parseDouble(xMLAttributes.getValue(i)) * d3)).toString() + "' ";
                        continue;
                    }
                    if (xMLAttributes.getLocalName(i).equals("src") && this.fFilePath != null) {
                        string = string + xMLAttributes.getLocalName(i) + "='" + this.fFilePath + xMLAttributes.getValue(i) + "' ";
                        continue;
                    }
                    if (!xMLAttributes.getType(i).equals("CDATA") || this.isInStringArray(xMLAttributes.getLocalName(i), EXCLUDED_ATTRIBUTES)) continue;
                    string = string + xMLAttributes.getLocalName(i) + "='" + xMLAttributes.getValue(i) + "' ";
                }
                this.fFieldInfo[2] = this.fFieldInfo[2] + "<" + qName.rawname.toLowerCase() + string + ">";
            } else if (xMLAttributes != null) {
                String string = "";
                boolean bl = "a".equals(qName.rawname.toLowerCase());
                boolean bl3 = "span".equals(qName.rawname.toLowerCase());
                for (int i = 0; i < xMLAttributes.getLength(); ++i) {
                    if (xMLAttributes.getLocalName(i) == null) continue;
                    string = string + xMLAttributes.getLocalName(i) + "='" + xMLAttributes.getValue(i) + "' ";
                    if (bl && "href".equalsIgnoreCase(xMLAttributes.getLocalName(i))) {
                        this.fInDescriptionHyperLink = true;
                    }
                    if (!bl3 || !"class".equalsIgnoreCase(xMLAttributes.getLocalName(i)) || !"syntax_example".equalsIgnoreCase(xMLAttributes.getValue(i))) continue;
                    this.fInSyntaxExample = true;
                }
                if (!this.fInDescriptionHyperLink) {
                    this.fFieldInfo[2] = this.fFieldInfo[2] + "<" + qName.rawname.toLowerCase() + " " + string + ">";
                }
            } else {
                this.fFieldInfo[2] = this.fFieldInfo[2] + "<" + qName.rawname.toLowerCase() + ">";
            }
        } else if (this.fInSyntax && qName.rawname.equalsIgnoreCase("br") && this.fFieldInfo[1] != null) {
            this.fFieldInfo[1] = this.fFieldInfo[1] + "\n";
        }
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        if (this.fTagCount > MAX_TAG_COUNT || this.fCharCount > MAX_CHAR_COUNT) {
            throw new ParseOverFlowException();
        }
        ++this.fTagCount;
        if (qName.rawname.equalsIgnoreCase(BODY)) {
            this.fInBody = false;
        } else if (!this.fClassConstructorRefPage && this.fInSyntax && qName.rawname.equalsIgnoreCase("p")) {
            this.fInSyntax = false;
        } else if (this.fInH2Tag) {
            this.fInH2Tag = false;
            this.fInNote = false;
            if (this.fHeadingName.equals("Description") || this.fHeadingName.equals(new String(new char[]{'\u8a73', '\u7d30'})) || this.fHeadingName.equals(new String(new char[]{'\u8aac', '\u660e'}))) {
                this.fInDescription = true;
                this.fInSyntax = false;
                this.fHeadingName = "";
            } else {
                this.fInDescription = false;
                this.fInSyntax = false;
                this.fHeadingName = "";
            }
        } else if (!this.fInDescription && this.fInNoteTag) {
            this.fInNoteTag = false;
            this.fInNote = true;
            this.fInSyntax = false;
            this.fHeadingName = "";
        } else if (this.fInDescription) {
            if (this.fInDescriptionHyperLink && "a".equals(qName.rawname.toLowerCase())) {
                this.fInDescriptionHyperLink = false;
            } else {
                this.fFieldInfo[2] = this.fFieldInfo[2] + "</" + qName.rawname.toLowerCase() + ">";
            }
            this.fInH2Tag = false;
            this.fInNoteTag = false;
        } else if (this.fInNote && qName.rawname.equalsIgnoreCase("table")) {
            this.fInNote = false;
        }
        if (this.fClassConstructorRefPage) {
            if (this.fInSyntax && qName.rawname.equalsIgnoreCase("tt")) {
                --this.fTTSynposisTagDepthCount;
            }
            if (this.fInSyntax && this.fTTSynposisTagDepthCount <= 0) {
                this.fInSyntax = false;
            }
        }
        if (this.fInSyntaxExample) {
            this.fInSyntaxExample = false;
        }
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
        super.endDocument(augmentations);
        this.complete();
    }

    public String getNote() {
        return this.fNote;
    }

    public String getSyntax() {
        return this.fSyntax;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String getBody() {
        return this.fBodyContent.toString().replaceAll("\\s+", " ");
    }

    public boolean isReferencePage() {
        return this.fReference;
    }

    private boolean isInStringArray(String string, String[] stringArray) {
        if (string == null || stringArray == null || stringArray.length == 0) {
            return false;
        }
        for (String string2 : stringArray) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    class SyntaxParsedException
    extends RuntimeException {
    }

    class ParseOverFlowException
    extends RuntimeException {
    }
}

