/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool.propertyeditor.controls;

import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.page.plottool.ErrorHandler;
import com.mathworks.page.plottool.propertyeditor.BeanManager;
import com.mathworks.page.plottool.propertyeditor.PropertyEditorResources;
import com.mathworks.page.plottool.propertyeditor.controls.PropertyControl;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyDescriptor;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.event.CellEditorListener;

public class MixedComboControl
extends PropertyControl {
    protected static String STR_NO_VALUE = null;
    protected static String STR_AUTO = PropertyEditorResources.getBundle().getString("value.auto");
    protected static String STR_MANUAL = PropertyEditorResources.getBundle().getString("value.manual");
    protected static int NUM_NO_VALUE = -1;
    protected static int NUM_MANUAL = 0;
    protected static int NUM_AUTO = 1;
    protected EventHackedComboBox fCombo = new EventHackedComboBox(new Object[]{STR_AUTO, STR_MANUAL});
    protected int fModeValue = NUM_NO_VALUE;
    private Object fPrevValue = null;
    protected String fModePropertyName = null;
    protected PropertyDescriptor fModeProperty;

    public MixedComboControl(String string, CellEditorListener cellEditorListener, String string2) {
        super(string, cellEditorListener);
        this.constructorHelper();
        this.fCombo.setName(string2 + "." + string);
    }

    private void constructorHelper() {
        this.fCombo.setEditable(true);
        this.setCustomEditor((JComponent)((Object)this.fCombo));
        this.fCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                String string = (String)itemEvent.getItem();
                if (itemEvent.getStateChange() == 1) {
                    if (string.equals(STR_AUTO)) {
                        MixedComboControl.this.fModeValue = NUM_AUTO;
                        MixedComboControl.this.fCombo.willFireActionEvents = false;
                        MixedComboControl.this.fCombo.setSelectedItem(STR_AUTO);
                        MixedComboControl.this.fCombo.willFireActionEvents = true;
                    } else if (string.equals(STR_MANUAL)) {
                        MixedComboControl.this.fModeValue = NUM_MANUAL;
                        MixedComboControl.this.fCombo.setSelectedItem(null);
                    } else {
                        MixedComboControl.this.fModeValue = NUM_MANUAL;
                    }
                }
            }
        });
    }

    @Override
    public void initialize(Object object, String string) {
        super.initialize(object, string);
        this.fModeProperty = BeanManager.getProperty(object, this.fModePropertyName);
    }

    @Override
    public void initialize(Object object, String string, Object object2) {
        super.initialize(object, string, object2);
        this.fModeProperty = BeanManager.getProperty(object, this.fModePropertyName);
    }

    @Override
    public String getName() {
        if (this.fCombo != null) {
            return this.fCombo.getName() + "." + this.getClass().getSimpleName();
        }
        return null;
    }

    public void setModePropertyName(String string) {
        this.fModePropertyName = string;
    }

    public String getModePropertyname() {
        return this.fModePropertyName;
    }

    @Override
    public void applyChanges(Object[] objectArray) {
        super.applyChanges(objectArray);
        if (this.fModeValue != -1) {
            final Object[] objectArray2 = objectArray;
            try {
                Matlab.whenMatlabReady((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < objectArray2.length; ++i) {
                            BeanManager.setPropertyValue(objectArray2[i], MixedComboControl.this.fModeProperty, new Integer(MixedComboControl.this.fModeValue));
                        }
                    }
                });
            }
            catch (Exception exception) {
                Throwable throwable = exception.getCause();
                if (throwable instanceof RuntimeException) {
                    ErrorHandler.showJavaException("BeanManager.setPropertyValue (\"" + this.fModeProperty.getName() + "\")", (Exception)throwable);
                }
                ErrorHandler.showJavaException("BeanManager.setPropertyValue (\"" + this.fModeProperty.getName() + "\")", exception);
            }
        }
    }

    @Override
    public void setDisplayedValue(Object object) {
        this.fCombo.willFireActionEvents = false;
        if (object == PropertyControl.MIXED_VALUES) {
            this.fPrevValue = PropertyControl.MIXED_VALUES;
        } else {
            String string;
            String string2 = string = object instanceof String ? (String)object : this.valueToString(object);
            if (string == null) {
                this.fPrevValue = STR_AUTO;
                this.fModeValue = NUM_AUTO;
            } else if (string.equals(STR_AUTO)) {
                this.fPrevValue = STR_AUTO;
                this.fModeValue = NUM_AUTO;
            } else {
                this.fPrevValue = string;
                this.fModeValue = NUM_MANUAL;
            }
        }
        this.fCombo.setSelectedItem(this.fPrevValue);
        this.fCombo.willFireActionEvents = true;
    }

    @Override
    public Object getDisplayedValue() {
        Object object = this.fCombo.getSelectedItem();
        String string = (String)object;
        Object object2 = null;
        if (string == null || string.equals(STR_AUTO)) {
            return null;
        }
        try {
            String string2 = this.getPropertyType().getName();
            if (string2.equals("double")) {
                object2 = Double.valueOf(string);
            } else if (string2.equals("float")) {
                object2 = Float.valueOf(string);
            } else if (string2.equals("int")) {
                object2 = Integer.valueOf(string);
            } else if (string2.endsWith("String")) {
                object2 = string;
            }
        }
        catch (NumberFormatException numberFormatException) {
            ErrorHandler.showSimpleError(MessageFormat.format(PropertyEditorResources.getBundle().getString("PropertyControl.error.parse"), string), this.getTopLevelAncestor());
            this.fCombo.willFireActionEvents = false;
            this.fCombo.setSelectedItem(this.fPrevValue);
            this.fCombo.willFireActionEvents = true;
            this.fCombo.requestFocus();
            return null;
        }
        return object2;
    }

    @Override
    public void addEditStoppedSupport() {
        this.fCombo.addActionListener(this.action);
    }

    class EventHackedComboBox
    extends MJComboBox {
        protected boolean willFireActionEvents;

        EventHackedComboBox(Object[] objectArray) {
            super(objectArray);
            this.willFireActionEvents = true;
        }

        protected void fireActionEvent() {
            if (this.willFireActionEvents) {
                super.fireActionEvent();
            }
        }
    }
}

