/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.page.plottool.AbstractPlotTool;
import com.mathworks.page.plottool.ErrorHandler;
import com.mathworks.page.plottool.MatlabSelectionEvent;
import com.mathworks.page.plottool.MatlabSelectionListener;
import com.mathworks.page.plottool.propertyeditor.PropertyEditorResources;
import com.mathworks.page.plottool.propertyeditor.panels.AbstractSeriesPropPanel;
import com.mathworks.page.plottool.propertyeditor.panels.AxesPropPanel;
import com.mathworks.page.plottool.propertyeditor.panels.IPropertyPanel;
import com.mathworks.page.plottool.propertyeditor.panels.PropertyPanel;
import com.mathworks.util.DebugUtils;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.Desktop;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;

public class PropertyEditor
extends AbstractPlotTool {
    protected static final Hashtable<String, String> fClassToPanelClass = new Hashtable();
    protected final Hashtable<String, IPropertyPanel> fClassToPanel = new Hashtable();
    private static final HashMap<String, String[]> fGrapicClassToSwitchProps = new HashMap();
    protected final CardLayout fCardLayout = new CardLayout();
    protected final MJPanel fCardPanel = new MJPanel((LayoutManager)this.fCardLayout);
    protected static final String NAME = "Property Editor";
    protected static final String TITLE = ResourceBundle.getBundle("com.mathworks.mde.desk.resources.RES_Desktop").getString("title.PropertyEditor");
    public static final String TITLE_NO_SELECTION = TITLE + " - " + PropertyEditorResources.getBundle().getString("title.nothingselected");
    public static final String TITLE_ONE_SELECTION = TITLE + " - {0}";
    public static final String TITLE_MULTI_SELECTION = TITLE + " - " + PropertyEditorResources.getBundle().getString("title.multipleobjects");
    private boolean fShowDataSources = true;
    private boolean fShowPlotType = true;
    private boolean fShowInspectorButton = true;
    private boolean fShowRefreshDataButton = true;
    private boolean fShowZAxisControls = true;
    private Vector fSelectedObjs;
    private final Runnable fUpdateMatlabRunnable = new UpdateObjectsMatlabRunnable();
    private static volatile boolean sIsHGUsingMATLABClasses = false;
    private final MatlabSelectionListener selectionLsnr = new MatlabSelectionListener(){

        @Override
        public void selectionChanged(MatlabSelectionEvent matlabSelectionEvent) {
            Vector vector = matlabSelectionEvent.getSelectedObjs();
            Vector vector2 = matlabSelectionEvent.getSelectedCustomPanelObjs();
            if (vector2 != null) {
                for (int i = 0; i < vector2.size(); ++i) {
                    if (vector2.elementAt(i) == null) continue;
                    vector.set(i, vector2.elementAt(i));
                }
            }
            PropertyEditor.this.updateForSelectedObjects(vector);
        }
    };
    private final Hashtable<String, String> classesAndParents = new Hashtable();

    public PropertyEditor() {
        this.constructorHelper();
    }

    public PropertyEditor(SimpleElement simpleElement) {
        super(simpleElement);
        this.constructorHelper();
    }

    public PropertyEditor(String string, Desktop desktop) {
        super(string, desktop);
        this.constructorHelper();
    }

    public static boolean isHGUsingMATLABClasses() {
        return sIsHGUsingMATLABClasses;
    }

    public static void setHGUsingMATLABClasses(boolean bl) {
        sIsHGUsingMATLABClasses = bl;
    }

    public static Component addAsDesktopClient(final Desktop desktop, final String string) {
        final AtomicReference atomicReference = new AtomicReference();
        if (SwingUtilities.isEventDispatchThread()) {
            return PropertyEditor.utAddAsDesktopClient(desktop, string);
        }
        Runnable runnable = new Runnable(){
            public Object iReturnObj;

            @Override
            public void run() {
                atomicReference.set(PropertyEditor.utAddAsDesktopClient(desktop, string));
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
            return (Component)atomicReference.get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Component utAddAsDesktopClient(Desktop desktop, String string) {
        Object object = desktop.getClient(NAME, string);
        if (object == null) {
            object = new PropertyEditor(string, desktop);
            desktop.addClient(object, NAME, false, DTLocation.create((String)"S"), false);
        }
        return object;
    }

    private static void buildDefaultSwitchPropMapping() {
        PropertyEditor.putSwitchPropMapping("matlab_graphics_chart_primitive_Line", new String[]{"LineWidth", "LineStyle", "Color", "MarkerEdgeColor", "MarkerFaceColor", "Marker", "MarkerSize", "Visible", "XDataSource", "YDataSource", "ZDataSource", "DisplayName"});
        PropertyEditor.putSwitchPropMapping("matlab_graphics_chart_primitive_Bar", new String[]{"EdgeColor", "BarLayout", "BarWidth", "LineWidth", "LineStyle", "BaseValue", "ShowBaseLine", "DisplayName", "Visible", "FaceColor", "XDataSource", "YDataSource"});
        PropertyEditor.putSwitchPropMapping("matlab_graphics_chart_primitive_Area", new String[]{"EdgeColor", "LineWidth", "LineStyle", "BaseValue", "FaceColor", "DisplayName", "Visible", "XDataSource", "YDataSource"});
        PropertyEditor.putSwitchPropMapping("matlab_graphics_chart_primitive_Stem", new String[]{"LineWidth", "LineStyle", "Color", "MarkerEdgeColor", "MarkerFaceColor", "Marker", "MarkerSize", "DisplayName", "Visible", "BaseValue", "ShowBaseLine", "YDataSource", "XDataSource", "ZDataSource"});
        PropertyEditor.putSwitchPropMapping("matlab_graphics_chart_primitive_Stair", new String[]{"LineWidth", "LineStyle", "Color", "MarkerEdgeColor", "MarkerFaceColor", "Marker", "MarkerSize", "DisplayName", "Visible", "YDataSource", "XDataSource"});
    }

    private void constructorHelper() {
        this.setName(NAME);
        this.setClientName(NAME);
        this.setShortTitle(TITLE);
        this.setCursor(Cursor.getPredefinedCursor(0));
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.FigurePropPanel", "figure", "matlab_ui_Figure");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.AxesPropPanel", "axes", "matlab_graphics_axis_Axes");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.LineSeriesPropPanel", "graph2d_lineseries", "matlab_graphics_chart_primitive_Line");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.AreaSeriesPropPanel", "specgraph_areaseries", "matlab_graphics_chart_primitive_Area");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.BarSeriesPropPanel", "specgraph_barseries", "matlab_graphics_chart_primitive_Bar");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.StairSeriesPropPanel", "specgraph_stairseries", "matlab_graphics_chart_primitive_Stair");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.StemSeriesPropPanel", "specgraph_stemseries", "matlab_graphics_chart_primitive_Stem");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.SurfaceChartPropPanel", "graph3d_surfaceplot", "matlab_graphics_chart_primitive_Surface");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.ScatterGroupPropPanel", "specgraph_scattergroup", "matlab_graphics_chart_primitive_Scatter");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.ContourGroupPropPanel", "specgraph_contourgroup", "matlab_graphics_chart_primitive_Contour");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.QuiverGroupPropPanel", "specgraph_quivergroup", "matlab_graphics_chart_primitive_Quiver");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.PatchPropPanel", "patch", "matlab_graphics_primitive_Patch");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.RectanglePropPanel", "rectangle", "matlab_graphics_primitive_Rectangle");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.ArrowPropPanel", "scribe_arrow", "matlab_graphics_shape_internal_Arrow");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.ScribeLinePropPanel", "scribe_line", "matlab_graphics_shape_internal_Line");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.DoubleArrowPropPanel", "scribe_doublearrow", "matlab_graphics_shape_internal_DoubleEndArrow");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.TextArrowPropPanel", "scribe_textarrow", "matlab_graphics_shape_internal_TextArrow");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.TextboxPropPanel", "scribe_textbox", "matlab_graphics_shape_internal_TextBox");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.ScribeRectPropPanel", "scribe_scriberect", "matlab_graphics_shape_internal_Rectangle");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.ErrorbarSeriesPropPanel", "specgraph_errorbarseries", "matlab_graphics_chart_primitive_ErrorBar");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.LightPropPanel", "light", "matlab_graphics_primitive_Light");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.ScribeEllipsePropPanel", "scribe_scribeellipse", "matlab_graphics_shape_internal_Ellipse");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.ImagePropPanel", "image", "matlab_graphics_primitive_Image");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.TextPropPanel", "text", "matlab_graphics_primitive_Text");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.UIPanelPropPanel", "uipanel", "matlab_ui_container_Panel");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.UIControlPropPanel", "uicontrol", "matlab_ui_control_StyleControl");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.OtherObjectPropPanel", "uitable", "matlab_ui_control_Table", "root", "other");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.LinePropPanel", "line", "graph2d_functionline", "graph2d_constantlineseries", "matlab_graphics_chart_primitive_ConstantLine", "matlab_graphics_chart_primitive_FunctionLine", "matlab_graphics_primitive_Line");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.SurfacePropPanel", "surface", "matlab_graphics_primitive_Surface");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.LegendPropPanel", "scribe_legend", "matlab_graphics_illustration_Legend");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.ColorbarPropPanel", "scribe_colorbar", "matlab_graphics_illustration_ColorBar");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.page.plottool.propertyeditor.panels.NonePropPanel", "none");
        PropertyEditor.registerGraphicsToPropPanel("com.mathworks.toolbox.timeseries.UITsPanelPropPanel", "tsguis_uitspanel");
        PropertyEditor.buildDefaultSwitchPropMapping();
        this.makePanel("none");
        this.setLayout(new BorderLayout());
        this.add((Component)this.fCardPanel, "Center");
        this.setBorder(BorderFactory.createEtchedBorder());
        this.fCardLayout.show((Container)this.fCardPanel, "none");
    }

    public void setTitle(String string) {
        super.setTitle(string);
    }

    @Override
    protected void respondToNullFigure() {
        if (this.fSelectionMgr != null) {
            this.fSelectionMgr.removeMatlabSelectionListener(this.selectionLsnr);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PropertyEditor.this.fCardLayout != null && PropertyEditor.this.fCardPanel != null) {
                    PropertyEditor.this.fCardLayout.show((Container)PropertyEditor.this.fCardPanel, "none");
                }
                PropertyEditor.this.setTitle(TITLE);
            }
        });
    }

    @Override
    protected void respondToDifferentFigure() {
        Vector vector = null;
        if (this.fSelectionMgr != null) {
            this.fSelectionMgr.addMatlabSelectionListener(this.selectionLsnr);
            vector = this.fSelectionMgr.getSelectedObjects();
        }
        if (vector != null && vector.size() > 0) {
            this.updateForSelectedObjects(vector);
        } else if (this.fCardLayout != null && this.fCardPanel != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PropertyEditor.this.fCardLayout.show((Container)PropertyEditor.this.fCardPanel, "none");
                }
            });
        }
    }

    public boolean isShowDataSources() {
        return this.fShowDataSources;
    }

    public void setShowDataSources(boolean bl) {
        final boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PropertyEditor.this.fShowDataSources = bl2;
                Enumeration<IPropertyPanel> enumeration = PropertyEditor.this.fClassToPanel.elements();
                while (enumeration.hasMoreElements()) {
                    IPropertyPanel iPropertyPanel = enumeration.nextElement();
                    if (!(iPropertyPanel instanceof AbstractSeriesPropPanel)) continue;
                    ((AbstractSeriesPropPanel)iPropertyPanel).setShowDataSources(bl2);
                }
                PropertyEditor.this.revalidate();
            }
        });
    }

    public boolean isShowPlotType() {
        return this.fShowPlotType;
    }

    public boolean isShowInspectorButton() {
        return this.fShowInspectorButton;
    }

    public void setShowInspectorButton(boolean bl) {
        final boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PropertyEditor.this.fShowInspectorButton = bl2;
                Enumeration<IPropertyPanel> enumeration = PropertyEditor.this.fClassToPanel.elements();
                while (enumeration.hasMoreElements()) {
                    IPropertyPanel iPropertyPanel = enumeration.nextElement();
                    if (!(iPropertyPanel instanceof PropertyPanel)) continue;
                    ((PropertyPanel)iPropertyPanel).setShowInspectorButton(bl2);
                }
                PropertyEditor.this.revalidate();
            }
        });
    }

    public boolean isShowRefreshDataButton() {
        return this.fShowRefreshDataButton;
    }

    public void setShowRefreshDataButton(boolean bl) {
        final boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PropertyEditor.this.fShowRefreshDataButton = bl2;
                Enumeration<IPropertyPanel> enumeration = PropertyEditor.this.fClassToPanel.elements();
                while (enumeration.hasMoreElements()) {
                    IPropertyPanel iPropertyPanel = enumeration.nextElement();
                    if (!(iPropertyPanel instanceof PropertyPanel)) continue;
                    ((PropertyPanel)iPropertyPanel).setShowRefreshDataButton(bl2);
                }
                PropertyEditor.this.revalidate();
            }
        });
    }

    public boolean isShowZAxisControls() {
        return this.fShowZAxisControls;
    }

    public void setShowZAxisControls(boolean bl) {
        final boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PropertyEditor.this.fShowZAxisControls = bl2;
                Enumeration<IPropertyPanel> enumeration = PropertyEditor.this.fClassToPanel.elements();
                while (enumeration.hasMoreElements()) {
                    IPropertyPanel iPropertyPanel = enumeration.nextElement();
                    if (!(iPropertyPanel instanceof AxesPropPanel)) continue;
                    ((AxesPropPanel)iPropertyPanel).setShowZAxisControls(bl2);
                }
                PropertyEditor.this.revalidate();
            }
        });
    }

    public void setVisible(boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            super.setVisible(bl);
        } else {
            final boolean bl2 = bl;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PropertyEditor.super.setVisible(bl2);
                }
            });
        }
    }

    public void setObject(Object object) {
        Vector<Object> vector = new Vector<Object>(1);
        vector.add(object);
        this.updateForSelectedObjects(vector);
    }

    public void setObjects(Object[] objectArray) {
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        vector.addAll(Arrays.asList(objectArray));
        this.updateForSelectedObjects(vector);
    }

    public static void registerGraphicsToPropPanel(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            fClassToPanelClass.put(string2, string);
        }
    }

    public static void putSwitchPropMapping(String string, String[] stringArray) {
        fGrapicClassToSwitchProps.put(string, stringArray);
    }

    public static String[] getSwitchPropMapping(String string) {
        if (fGrapicClassToSwitchProps.isEmpty()) {
            PropertyEditor.buildDefaultSwitchPropMapping();
        }
        return fGrapicClassToSwitchProps.get(string.replace('.', '_'));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPropertyPanel getPanelForObject_EventThread(String string) {
        IPropertyPanel iPropertyPanel;
        if (this.fClassToPanel == null || string == null) {
            return null;
        }
        Hashtable<String, IPropertyPanel> hashtable = this.fClassToPanel;
        synchronized (hashtable) {
            iPropertyPanel = this.fClassToPanel.containsKey(string) ? this.fClassToPanel.get(string) : this.makePanel(string);
        }
        return iPropertyPanel;
    }

    private IPropertyPanel makePanel(final String string) {
        Class<?> clazz;
        String string2;
        block13: {
            if (StringUtils.isBlank((String)string)) {
                return null;
            }
            string2 = fClassToPanelClass.get(string);
            if (string2 == null) {
                return null;
            }
            clazz = null;
            try {
                clazz = Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if ($assertionsDisabled || DebugUtils.warning((String)("Class " + string2 + " cannot be located"))) break block13;
                throw new AssertionError();
            }
        }
        if (clazz == null) {
            try {
                string2 = fClassToPanelClass.get("other");
                assert (string2 != null);
                clazz = Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                assert (DebugUtils.outputException((Throwable)classNotFoundException));
                return null;
            }
        }
        try {
            final Object obj = clazz.newInstance();
            assert (obj instanceof IPropertyPanel && obj instanceof Component) : obj != null ? obj.getClass().getName() : "null";
            IPropertyPanel iPropertyPanel = (IPropertyPanel)obj;
            this.fClassToPanel.put(string, iPropertyPanel);
            iPropertyPanel.setPropertyEditor(this);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PropertyEditor.this.fCardPanel.add((Component)obj, (Object)string);
                }
            });
            return iPropertyPanel;
        }
        catch (Exception exception) {
            assert (DebugUtils.outputException((Throwable)exception));
            return null;
        }
    }

    public void updateForSelectedObjects(Vector vector) {
        this.fSelectedObjs = vector;
        if (Matlab.isMatlabAvailable()) {
            Matlab.whenMatlabIdle((Runnable)this.fUpdateMatlabRunnable);
        }
    }

    private void updateForSelectedObjects_MatlabThread() {
        final String string = this.choosePropPanelKey(this.fSelectedObjs);
        if (string == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IPropertyPanel iPropertyPanel = PropertyEditor.this.getPanelForObject_EventThread(string);
                if (iPropertyPanel != null && PropertyEditor.this.fSelectedObjs != null) {
                    UpdateObjectsWorker updateObjectsWorker = new UpdateObjectsWorker(iPropertyPanel, (Vector)PropertyEditor.this.fSelectedObjs.clone(), string);
                    updateObjectsWorker.start();
                }
            }
        });
    }

    protected String choosePropPanelKey(Vector vector) {
        if (vector.isEmpty()) {
            return null;
        }
        String string = this.choosePropPanelKey(vector.get(0));
        if (vector.size() > 1) {
            for (int i = 1; i < vector.size(); ++i) {
                String string2 = this.choosePropPanelKey(vector.get(i));
                if (string.equals(string2)) continue;
                return "other";
            }
        }
        return string;
    }

    protected String choosePropPanelKey(Object object) {
        Object object2 = null;
        String string = object.getClass().getName();
        string = string.substring(0, string.indexOf("BeanAdapter"));
        for (String string2 : fClassToPanelClass.keySet()) {
            if (!string.equals(string2)) continue;
            object2 = string2;
            break;
        }
        if (object2 == null) {
            Object object3 = null;
            if (this.classesAndParents.containsKey(string)) {
                object3 = this.classesAndParents.get(string);
            } else {
                try {
                    object3 = (String)Matlab.mtFeval((String)"plottoolfunc", (Object[])new Object[]{"getNearestKnownParentClass", object}, (int)1);
                    if (((String)object3).length() > 0) {
                        object3 = ((String)object3).replace('.', '_');
                        this.classesAndParents.put(string, (String)object3);
                    }
                }
                catch (Exception exception) {
                    ErrorHandler.showJavaException("choosePropPanelKey", exception);
                }
            }
            object2 = object3;
        }
        return object2 == null ? "other" : object2;
    }

    public static ImageIcon makeImage(String string) {
        if (StringUtils.isBlank((String)string)) {
            return new EmptyIcon();
        }
        URL uRL = PropertyEditor.class.getResource("resources/" + string);
        if (uRL == null) {
            return new EmptyIcon();
        }
        return new ImageIcon(uRL);
    }

    private static final class EmptyIcon
    extends ImageIcon {
        private EmptyIcon() {
        }

        @Override
        public int getIconHeight() {
            return 0;
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }
    }

    private class UpdateObjectsWorker
    extends MatlabWorker {
        IPropertyPanel fPanel = null;
        Vector fLocalSelObjects;
        String fTitle = null;
        String fPanelKey = null;

        public UpdateObjectsWorker(IPropertyPanel iPropertyPanel, Vector vector, String string) {
            this.fPanel = iPropertyPanel;
            this.fPanelKey = string;
            this.fLocalSelObjects = vector;
        }

        public Object runOnMatlabThread() {
            if (this.fPanel != null) {
                this.fPanel.setObject(this.fLocalSelObjects.toArray());
                if (PropertyEditor.this.fSelectedObjs.isEmpty()) {
                    this.fTitle = TITLE_NO_SELECTION;
                } else if (this.fLocalSelObjects.size() == 1) {
                    String string = this.fLocalSelObjects.get(0).getClass().getName();
                    StringBuffer stringBuffer = new StringBuffer((string = string.substring(0, string.indexOf("BeanAdapter"))).indexOf(95) > -1 ? string.substring(string.indexOf(95) + 1) : string);
                    stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
                    this.fTitle = MessageFormat.format(TITLE_ONE_SELECTION, stringBuffer);
                } else {
                    this.fTitle = TITLE_MULTI_SELECTION;
                }
            }
            return null;
        }

        public void runOnAWTEventDispatchThread(Object object) {
            if (PropertyEditor.this.fCardLayout != null && PropertyEditor.this.fCardPanel != null && this.fPanelKey != null) {
                PropertyEditor.this.fCardLayout.show((Container)PropertyEditor.this.fCardPanel, this.fPanelKey);
                PropertyEditor.this.setTitle(this.fTitle);
            }
        }
    }

    private class UpdateObjectsMatlabRunnable
    implements Runnable {
        private UpdateObjectsMatlabRunnable() {
        }

        @Override
        public void run() {
            PropertyEditor.this.updateForSelectedObjects_MatlabThread();
        }
    }
}

