/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.phoenix;

import com.sun.jini.phoenix.AccessILFactory;
import com.sun.jini.phoenix.ActivationGroupData;
import com.sun.jini.phoenix.InactiveGroupException;
import com.sun.jini.phoenix.MonitorPermission;
import com.sun.jini.proxy.BasicProxyTrustVerifier;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationInstantiator;
import java.rmi.activation.ActivationMonitor;
import java.rmi.activation.ActivationSystem;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.ExportException;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.export.Exporter;
import net.jini.export.ProxyAccessor;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.InvocationLayerFactory;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.Security;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;

public class ActivationGroupImpl
extends net.jini.activation.ActivationGroup
implements ServerProxyTrust {
    private static final long serialVersionUID = 5758693559430427303L;
    private static final String PHOENIX = "com.sun.jini.phoenix";
    private static final int UNUSED = 0;
    private static final int CREATING = 1;
    private static final int CREATED = 2;
    private static final int ACTIVE = 3;
    private static final int INACTIVE = 4;
    private static Class[] paramTypes = new Class[]{ActivationID.class, MarshalledObject.class};
    private static final ObjectStreamField[] serialPersistentFields = ObjectStreamClass.NO_FIELDS;
    private static int state = 0;
    private static long incarnation;
    private static ActivationGroupID groupID;
    private static LoginContext login;
    private static Exporter exporter;
    private static boolean refuseCalls;
    private static ProxyPreparer monPreparer;
    private static ActivationMonitor monitor;
    private static long unexportTimeout;
    private static long unexportWait;
    private static Map active;
    private static List lockedIDs;
    private static boolean inheritGroupSubject;
    private static final Permission activeObjectPermission;
    private static Permission inactiveObjectPermission;
    private ActivationInstantiator proxy;
    static /* synthetic */ Class class$net$jini$export$Exporter;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized ActivationGroup createGroup(final ActivationGroupID activationGroupID, final ActivationGroupDesc activationGroupDesc, final long l) throws ActivationException {
        ActivationGroup activationGroup;
        if (state != 0) {
            throw new ActivationException("group previously created");
        }
        try {
            try {
                final Configuration configuration = ActivationGroupImpl.getConfiguration(activationGroupDesc.getData());
                login = (LoginContext)configuration.getEntry(PHOENIX, "loginContext", LoginContext.class, null);
                if (login != null) {
                    login.login();
                }
                inheritGroupSubject = (Boolean)configuration.getEntry(PHOENIX, "inheritGroupSubject", Boolean.TYPE, (Object)Boolean.FALSE);
                activationGroup = (ActivationGroup)ActivationGroupImpl.doAction(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        ProxyPreparer proxyPreparer = ActivationGroupImpl.getPreparer(configuration, "systemPreparer");
                        monPreparer = ActivationGroupImpl.getPreparer(configuration, "monitorPreparer");
                        TcpServerEndpoint tcpServerEndpoint = TcpServerEndpoint.getInstance((int)0);
                        BasicJeriExporter basicJeriExporter = new BasicJeriExporter((ServerEndpoint)tcpServerEndpoint, (InvocationLayerFactory)new AccessILFactory());
                        ActivationGroupImpl.exporter = (Exporter)configuration.getEntry(ActivationGroupImpl.PHOENIX, "instantiatorExporter", class$net$jini$export$Exporter == null ? (class$net$jini$export$Exporter = ActivationGroupImpl.class$("net.jini.export.Exporter")) : class$net$jini$export$Exporter, (Object)basicJeriExporter);
                        if (exporter == null) {
                            ActivationGroupImpl.exporter = new AlreadyExportedExporter();
                        }
                        refuseCalls = !(exporter instanceof AlreadyExportedExporter);
                        unexportTimeout = ActivationGroupImpl.getInt(configuration, "unexportTimeout", 60000);
                        unexportWait = ActivationGroupImpl.getInt(configuration, "unexportWait", 10);
                        ActivationSystem activationSystem = (ActivationSystem)proxyPreparer.prepareProxy((Object)activationGroupID.getSystem());
                        incarnation = l;
                        groupID = activationGroupID;
                        state = 1;
                        ActivationGroupID activationGroupID2 = activationSystem == activationGroupID.getSystem() ? activationGroupID : new WrappedGID(activationGroupID, activationSystem);
                        ActivationGroup activationGroup = net.jini.activation.ActivationGroup.createGroup((ActivationGroupID)activationGroupID2, (ActivationGroupDesc)activationGroupDesc, (long)l);
                        state = 3;
                        return activationGroup;
                    }
                });
                Object var7_7 = null;
                if (state == 3) return activationGroup;
            }
            catch (ActivationException activationException) {
                throw activationException;
            }
            catch (Exception exception) {
                throw new ActivationException("creation failed", (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (state == 3) throw throwable;
            ActivationGroupImpl.checkInactiveGroup();
            throw throwable;
        }
        ActivationGroupImpl.checkInactiveGroup();
        return activationGroup;
    }

    private static Configuration getConfiguration(MarshalledObject marshalledObject) throws ConfigurationException, IOException, ClassNotFoundException {
        ClassLoader classLoader;
        ActivationGroupData activationGroupData = (ActivationGroupData)marshalledObject.get();
        ClassLoader classLoader2 = ActivationGroupImpl.class.getClassLoader();
        if (!ActivationGroupImpl.covers(classLoader2, classLoader = Thread.currentThread().getContextClassLoader())) {
            classLoader2 = classLoader;
        }
        return ConfigurationProvider.getInstance((String[])activationGroupData.getConfig(), (ClassLoader)classLoader2);
    }

    private static boolean covers(ClassLoader classLoader, ClassLoader classLoader2) {
        if (classLoader2 == null) {
            return true;
        }
        if (classLoader == null) {
            return false;
        }
        do {
            if (classLoader != classLoader2) continue;
            return true;
        } while ((classLoader = classLoader.getParent()) != null);
        return false;
    }

    private static ProxyPreparer getPreparer(Configuration configuration, String string) throws ConfigurationException {
        return (ProxyPreparer)configuration.getEntry(PHOENIX, string, ProxyPreparer.class, (Object)new BasicProxyPreparer());
    }

    private static int getInt(Configuration configuration, String string, int n) throws ConfigurationException {
        return (Integer)configuration.getEntry(PHOENIX, string, Integer.TYPE, (Object)new Integer(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ActivationGroupImpl(ActivationGroupID activationGroupID, MarshalledObject marshalledObject) throws ActivationException, RemoteException {
        super(activationGroupID);
        Class clazz = ActivationGroupImpl.class;
        // MONITORENTER : clazz
        if (state != 1) {
            throw new ActivationException("not called from createGroup");
        }
        // MONITOREXIT : clazz
        if (refuseCalls) {
            ActivationGroupImpl.unexportObject((Remote)((Object)this), (boolean)true);
            refuseCalls = false;
        }
        this.proxy = (ActivationInstantiator)exporter.export((Remote)((Object)this));
        try {
            monitor = (ActivationMonitor)monPreparer.prepareProxy((Object)activationGroupID.getSystem().activeGroup(activationGroupID, this.proxy, incarnation));
            state = 2;
            Object var6_4 = null;
            if (state != 2) {
                exporter.unexport(true);
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (state == 2) throw throwable;
            exporter.unexport(true);
            throw throwable;
        }
        monPreparer = null;
    }

    public TrustVerifier getProxyVerifier() {
        return new BasicProxyTrustVerifier(this.proxy);
    }

    protected Object writeReplace() {
        return this.proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireLock(ActivationID activationID) {
        while (true) {
            ActivationID activationID2 = activationID;
            synchronized (activationID2) {
                List list = lockedIDs;
                synchronized (list) {
                    int n = lockedIDs.indexOf(activationID);
                    if (n < 0) {
                        lockedIDs.add(activationID);
                        return;
                    }
                    ActivationID activationID3 = (ActivationID)lockedIDs.get(n);
                    if (activationID3 != activationID) {
                        activationID = activationID3;
                        continue;
                    }
                }
                try {
                    activationID.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLock(ActivationID activationID) {
        List list = lockedIDs;
        synchronized (list) {
            activationID = (ActivationID)lockedIDs.remove(lockedIDs.indexOf(activationID));
        }
        list = activationID;
        synchronized (list) {
            activationID.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public MarshalledObject newInstance(final ActivationID activationID, final ActivationDesc activationDesc) throws ActivationException {
        Object object = ActivationGroupImpl.class;
        // MONITORENTER : object
        if (refuseCalls) {
            throw new SecurityException("call refused");
        }
        // MONITOREXIT : object
        this.acquireLock(activationID);
        try {
            Object object2;
            try {
                Object object3 = ActivationGroupImpl.class;
                // MONITORENTER : object3
                if (state != 3) {
                    throw new InactiveGroupException("group not active");
                }
                object = (ActiveEntry)active.get(activationID);
                // MONITOREXIT : object3
                if (object != null) {
                    object3 = ((ActiveEntry)object).mobj;
                    Object var13_10 = null;
                    this.releaseLock(activationID);
                    ActivationGroupImpl.checkInactiveGroup();
                    return object3;
                }
                object3 = activationDesc.getClassName();
                final Class<?> clazz = RMIClassLoader.loadClass(activationDesc.getLocation(), (String)object3);
                final Thread thread = Thread.currentThread();
                final ClassLoader classLoader = thread.getContextClassLoader();
                final ClassLoader classLoader2 = ActivationGroupImpl.covers(clazz.getClassLoader(), classLoader) ? clazz.getClassLoader() : classLoader;
                Remote remote = null;
                try {
                    object2 = new PrivilegedExceptionAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Object run() throws InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, ActivationException {
                            Object[] objectArray = new Object[]{activationID, activationDesc.getData()};
                            Constructor constructor = clazz.getDeclaredConstructor(paramTypes);
                            constructor.setAccessible(true);
                            try {
                                thread.setContextClassLoader(classLoader2);
                                Object t = constructor.newInstance(objectArray);
                                Object var5_4 = null;
                                thread.setContextClassLoader(classLoader);
                                return t;
                            }
                            catch (Throwable throwable) {
                                Object var5_5 = null;
                                thread.setContextClassLoader(classLoader);
                                throw throwable;
                            }
                        }
                    };
                    remote = (Remote)(inheritGroupSubject ? Security.doPrivileged((PrivilegedExceptionAction)object2) : AccessController.doPrivileged(object2));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
                object = new ActiveEntry(remote);
                object2 = ActivationGroupImpl.class;
                // MONITORENTER : object2
                active.put(activationID, object);
                // MONITOREXIT : object2
                object2 = ((ActiveEntry)object).mobj;
                Object var13_11 = null;
                this.releaseLock(activationID);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ActivationException("activation constructor not defined", (Throwable)noSuchMethodException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                throw new ActivationException("activation constructor not defined", (Throwable)noSuchMethodError);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ActivationException("exception constructing object", invocationTargetException.getTargetException());
            }
            catch (ActivationException activationException) {
                throw activationException;
            }
            catch (Exception exception) {
                throw new ActivationException("unable to activate object", (Throwable)exception);
            }
            ActivationGroupImpl.checkInactiveGroup();
            return object2;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            this.releaseLock(activationID);
            ActivationGroupImpl.checkInactiveGroup();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean inactiveObject(final ActivationID activationID) throws ActivationException, RemoteException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(inactiveObjectPermission);
        }
        this.acquireLock(activationID);
        try {
            Class clazz;
            block13: {
                boolean bl;
                clazz = ActivationGroupImpl.class;
                // MONITORENTER : clazz
                if (state != 3) {
                    throw new InactiveGroupException("group not active");
                }
                ActiveEntry activeEntry = (ActiveEntry)active.get(activationID);
                // MONITOREXIT : clazz
                if (activeEntry == null) {
                    throw new UnknownObjectException("object not active");
                }
                try {
                    if (Activatable.unexportObject((Remote)activeEntry.impl, (boolean)false)) break block13;
                    bl = false;
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    // empty catch block
                }
                Object var8_8 = null;
                this.releaseLock(activationID);
                ActivationGroupImpl.checkInactiveGroup();
                return bl;
            }
            try {
                ActivationGroupImpl.doAction(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        monitor.inactiveObject(activationID);
                        return null;
                    }
                });
            }
            catch (UnknownObjectException unknownObjectException) {
                // empty catch block
            }
            clazz = ActivationGroupImpl.class;
            // MONITORENTER : clazz
            active.remove(activationID);
            // MONITOREXIT : clazz
            Object var8_9 = null;
            this.releaseLock(activationID);
            ActivationGroupImpl.checkInactiveGroup();
            return true;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.releaseLock(activationID);
            ActivationGroupImpl.checkInactiveGroup();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inactiveObject(final ActivationID activationID, Exporter exporter) throws ActivationException, RemoteException {
        Class clazz;
        block14: {
            boolean bl;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(inactiveObjectPermission);
            }
            this.acquireLock(activationID);
            try {
                ActiveEntry activeEntry;
                clazz = ActivationGroupImpl.class;
                synchronized (clazz) {
                    if (state != 3) {
                        throw new InactiveGroupException("group not active");
                    }
                    activeEntry = (ActiveEntry)active.get(activationID);
                }
                if (activeEntry == null) {
                    throw new UnknownObjectException("object not active");
                }
                if (exporter.unexport(false)) break block14;
                bl = false;
                Object var9_9 = null;
                this.releaseLock(activationID);
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                this.releaseLock(activationID);
                ActivationGroupImpl.checkInactiveGroup();
                throw throwable;
            }
            ActivationGroupImpl.checkInactiveGroup();
            return bl;
        }
        try {
            ActivationGroupImpl.doAction(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    monitor.inactiveObject(activationID);
                    return null;
                }
            });
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
        clazz = ActivationGroupImpl.class;
        synchronized (clazz) {
            active.remove(activationID);
        }
        Object var9_10 = null;
        this.releaseLock(activationID);
        ActivationGroupImpl.checkInactiveGroup();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkInactiveGroup() {
        Object object = ActivationGroupImpl.class;
        synchronized (object) {
            if (state == 3) {
                if (!active.isEmpty() || !lockedIDs.isEmpty()) {
                    return;
                }
                state = 4;
            } else {
                if (state == 4) {
                    return;
                }
                if (state == 2) {
                    state = 0;
                } else {
                    if (login != null) {
                        try {
                            login.logout();
                        }
                        catch (LoginException loginException) {
                            // empty catch block
                        }
                        login = null;
                    }
                    state = 0;
                    return;
                }
            }
        }
        try {
            ActivationGroupImpl.doAction(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    monitor.inactiveGroup(groupID, incarnation);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new Runnable(){

            public void run() {
                long l = System.currentTimeMillis() + unexportTimeout;
                boolean bl = false;
                while (!exporter.unexport(bl)) {
                    long l2 = l - System.currentTimeMillis();
                    if (l2 <= 0L) {
                        bl = true;
                        continue;
                    }
                    try {
                        Thread.sleep(Math.min(l2, unexportWait));
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (login != null) {
                    try {
                        login.logout();
                    }
                    catch (LoginException loginException) {
                        // empty catch block
                    }
                }
            }
        };
        if (state == 0) {
            object.run();
        } else {
            Executor executor = (Executor)AccessController.doPrivileged(login == null ? new GetThreadPoolAction(false) : new PrivilegedAction(){

                public Object run() {
                    return Subject.doAsPrivileged(login.getSubject(), new GetThreadPoolAction(false), null);
                }
            });
            executor.execute((Runnable)object, "UnexportGroup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void activeObject(final ActivationID activationID, Remote remote) throws ActivationException {
        block11: {
            block10: {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkPermission(activeObjectPermission);
                }
                final ActiveEntry activeEntry = new ActiveEntry(remote);
                this.acquireLock(activationID);
                try {
                    Class clazz = ActivationGroupImpl.class;
                    synchronized (clazz) {
                        if (state != 3) {
                            throw new InactiveGroupException("group not active");
                        }
                        if (active.containsKey(activationID)) {
                            // MONITOREXIT @DISABLED, blocks:[0, 4, 9] lbl12 : MonitorExitStatement: MONITOREXIT : var5_5
                            Object var8_7 = null;
                            this.releaseLock(activationID);
                            break block10;
                        }
                        active.put(activationID, activeEntry);
                    }
                    try {
                        ActivationGroupImpl.doAction(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                monitor.activeObject(activationID, activeEntry.mobj);
                                return null;
                            }
                        });
                    }
                    catch (RemoteException remoteException) {
                    }
                    break block11;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    this.releaseLock(activationID);
                    ActivationGroupImpl.checkInactiveGroup();
                    throw throwable;
                }
            }
            ActivationGroupImpl.checkInactiveGroup();
            return;
        }
        Object var8_8 = null;
        this.releaseLock(activationID);
        ActivationGroupImpl.checkInactiveGroup();
    }

    private static Object doAction(final PrivilegedExceptionAction privilegedExceptionAction) throws ActivationException, RemoteException {
        try {
            if (login == null) {
                return AccessController.doPrivileged(privilegedExceptionAction);
            }
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        return Subject.doAsPrivileged(login.getSubject(), privilegedExceptionAction, null);
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw privilegedActionException.getException();
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof RemoteException) {
                throw (RemoteException)exception;
            }
            if (exception instanceof ActivationException) {
                throw (ActivationException)((Object)exception);
            }
            throw new ActivationException("unexpected failure", (Throwable)exception);
        }
    }

    static {
        refuseCalls = false;
        active = new HashMap();
        lockedIDs = new ArrayList();
        activeObjectPermission = new MonitorPermission("java.rmi.activation.ActivationMonitor.activeObject");
        inactiveObjectPermission = new MonitorPermission("java.rmi.activation.ActivationMonitor.inactiveObject");
    }

    private static class ActiveEntry {
        Remote impl;
        MarshalledObject mobj;

        ActiveEntry(Remote remote) throws ActivationException {
            this.impl = remote;
            try {
                Object object;
                if (remote instanceof ProxyAccessor) {
                    object = ((ProxyAccessor)remote).getProxy();
                    if (object == null) {
                        throw new ActivationException("ProxyAccessor.getProxy returned null");
                    }
                } else {
                    object = remote;
                }
                this.mobj = new MarshalledObject<Object>(object);
            }
            catch (IOException iOException) {
                throw new ActivationException("failed to marshal remote object", (Throwable)iOException);
            }
        }
    }

    private static class AlreadyExportedExporter
    implements Exporter {
        private Remote impl;

        AlreadyExportedExporter() {
        }

        public synchronized Remote export(Remote remote) throws ExportException {
            this.impl = remote;
            try {
                return RemoteObject.toStub(remote);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                throw new ExportException("no stub found", noSuchObjectException);
            }
        }

        public synchronized boolean unexport(boolean bl) {
            try {
                if (this.impl != null && !UnicastRemoteObject.unexportObject(this.impl, bl)) {
                    return false;
                }
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
            this.impl = null;
            return true;
        }
    }

    private static class WrappedGID
    extends ActivationGroupID {
        private final ActivationGroupID id;
        private final ActivationSystem sys;

        WrappedGID(ActivationGroupID activationGroupID, ActivationSystem activationSystem) {
            super(activationSystem);
            this.id = activationGroupID;
            this.sys = activationSystem;
        }

        public ActivationSystem getSystem() {
            return this.sys;
        }

        private Object writeReplace() {
            return this.id;
        }
    }
}

