/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.wizard;

import com.mathworks.instutil.wizard.WizardPanelBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;

public abstract class AbstractPanelBuilder<T extends WizardPanelBuilder<T>>
implements WizardPanelBuilder<T> {
    private final List<RowOfComponents> rows = new ArrayList<RowOfComponents>();
    private int vFillRow = -1;

    @Override
    public T addRow(JComponent ... jComponentArray) {
        this.addRowOfComponents(new LeftAnchoredRowOfComponents(jComponentArray));
        return this.getThis();
    }

    @Override
    public T addLeftWeightedRow(JComponent ... jComponentArray) {
        this.addRowOfComponents(new LeftWeightedRowOfComponents(jComponentArray));
        return this.getThis();
    }

    @Override
    public T addSubRow(JComponent ... jComponentArray) {
        this.addRowOfComponents(new SubRowOfComponents(jComponentArray));
        return this.getThis();
    }

    @Override
    public T addRightAnchoredRow(JComponent ... jComponentArray) {
        this.addRowOfComponents(new RightAnchoredRowOfComponents(jComponentArray));
        return this.getThis();
    }

    @Override
    public T addEqualWeightedRow(JComponent ... jComponentArray) {
        JPanel jPanel = this.createPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        for (JComponent jComponent : jComponentArray) {
            jPanel.add((Component)jComponent, gridBagConstraints);
        }
        this.addRow(jPanel);
        return this.getThis();
    }

    @Override
    public T addVerticalFillRow(JComponent ... jComponentArray) {
        return this.addVerticalFillRowOfComponents(new LeftAnchoredRowOfComponents(jComponentArray));
    }

    @Override
    public T addVerticalFillSubRow(JComponent ... jComponentArray) {
        return this.addVerticalFillRowOfComponents(new SubRowOfComponents(jComponentArray));
    }

    private T addVerticalFillRowOfComponents(RowOfComponents rowOfComponents) {
        if (this.vFillRow >= 0) {
            throw new IllegalStateException("Vertical fill can only be inserted once.");
        }
        this.addRowOfComponents(rowOfComponents);
        this.vFillRow = this.rows.size() - 1;
        return this.getThis();
    }

    private void addRowOfComponents(RowOfComponents rowOfComponents) {
        this.rows.add(rowOfComponents);
    }

    @Override
    public JPanel buildPanel() {
        return AbstractPanelBuilder.addImageToContentPanel(this.createContentPanel(), this.createImage());
    }

    private JPanel createContentPanel() {
        return this.createPanel(5);
    }

    private static JPanel addImageToContentPanel(JPanel jPanel, JComponent jComponent) {
        jPanel.add((Component)jComponent, "East");
        return jPanel;
    }

    @Override
    public JPanel buildPanelWithPrivacyPolicyLink() {
        JPanel jPanel = this.createPanel(new BorderLayout());
        jPanel.add((Component)this.createImage(), "North");
        JComponent jComponent = this.createPrivacyPolicyLabel();
        jComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        jPanel.add((Component)jComponent, "South");
        return AbstractPanelBuilder.addImageToContentPanel(this.createContentPanel(), jPanel);
    }

    @Override
    public JPanel buildImagelessPanel() {
        return this.createContentPanel();
    }

    private JPanel createPanel(int n) {
        if (this.vFillRow < 0) {
            this.addVerticalFillRow(new JComponent[0]);
        }
        JPanel jPanel = this.createBackgroundPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = this.createContentPanel(n);
        jPanel.add((Component)jPanel2, "Center");
        this.vFillRow = -1;
        return jPanel;
    }

    private JPanel createContentPanel(int n) {
        int n2 = this.rows.size();
        JPanel jPanel = this.createPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, n, 5, 5));
        int n3 = this.getMaxColumns(this.rows);
        for (int i = 0; i < n2; ++i) {
            RowOfComponents rowOfComponents = this.rows.remove(0);
            this.addRowToPanel(jPanel, n3, i, rowOfComponents);
        }
        return jPanel;
    }

    protected abstract T getThis();

    protected abstract JPanel createPanel(LayoutManager var1);

    protected abstract JComponent createPrivacyPolicyLabel();

    protected abstract JPanel createBackgroundPanel();

    protected abstract JComponent createMainImage();

    private JComponent createImage() {
        JPanel jPanel = this.createPanel(new BorderLayout());
        JComponent jComponent = this.createMainImage();
        jPanel.add((Component)jComponent, "North");
        return jPanel;
    }

    private void addRowToPanel(JPanel jPanel, int n, int n2, RowOfComponents rowOfComponents) {
        int n3 = rowOfComponents.size();
        boolean bl = n2 == this.vFillRow;
        List<JComponent> list = rowOfComponents.getComponents();
        for (int i = 0; i < n3; ++i) {
            JComponent jComponent = list.get(i);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            AbstractPanelBuilder.addGridy(n2, gridBagConstraints);
            AbstractPanelBuilder.addVerticalFill(bl, gridBagConstraints);
            rowOfComponents.addConstraintsForColumn(gridBagConstraints, i, n);
            jPanel.add((Component)jComponent, gridBagConstraints);
        }
    }

    private static void addVerticalFill(boolean bl, GridBagConstraints gridBagConstraints) {
        if (bl) {
            gridBagConstraints.fill = 3;
            gridBagConstraints.weighty = 1.0;
        }
    }

    private static void addGridy(int n, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridy = n;
    }

    private int getMaxColumns(List<RowOfComponents> list) {
        int n = 0;
        for (RowOfComponents rowOfComponents : list) {
            n = Math.max(n, rowOfComponents.size());
        }
        return n;
    }

    private static int getIndentWidth() {
        return UIManager.getIcon("CheckBox.icon").getIconWidth() + UIManager.getInsets((Object)"CheckBox.margin").left + UIManager.getInsets((Object)"CheckBox.margin").right + UIManager.getInt("CheckBox.textIconGap");
    }

    private final class RightAnchoredRowOfComponents
    extends RowOfComponents {
        RightAnchoredRowOfComponents(JComponent ... jComponentArray) {
            super(jComponentArray);
        }

        @Override
        protected int getGridWidth(int n, int n2) {
            return 2;
        }

        @Override
        protected boolean isFillColumn(int n) {
            return false;
        }

        @Override
        protected int getAnchor() {
            return 13;
        }
    }

    private final class SubRowOfComponents
    extends LeftAnchoredRowOfComponents {
        SubRowOfComponents(JComponent ... jComponentArray) {
            super(new Insets(0, AbstractPanelBuilder.getIndentWidth() + 5, 5, 10), jComponentArray);
        }
    }

    private final class LeftWeightedRowOfComponents
    extends AbstractLeftAnchoredRowOfComponents {
        LeftWeightedRowOfComponents(JComponent ... jComponentArray) {
            super(jComponentArray);
        }

        @Override
        protected boolean isFillColumn(int n) {
            return n == 0;
        }
    }

    private class LeftAnchoredRowOfComponents
    extends AbstractLeftAnchoredRowOfComponents {
        LeftAnchoredRowOfComponents(Insets insets, JComponent ... jComponentArray) {
            super(insets, jComponentArray);
        }

        LeftAnchoredRowOfComponents(JComponent ... jComponentArray) {
            super(jComponentArray);
        }

        @Override
        protected final boolean isFillColumn(int n) {
            return n == this.size() - 1;
        }
    }

    private abstract class AbstractLeftAnchoredRowOfComponents
    extends RowOfComponents {
        AbstractLeftAnchoredRowOfComponents(JComponent ... jComponentArray) {
            super(jComponentArray);
        }

        AbstractLeftAnchoredRowOfComponents(Insets insets, JComponent ... jComponentArray) {
            super(insets, jComponentArray);
        }

        @Override
        protected final int getGridWidth(int n, int n2) {
            if (this.size() == 1) {
                return n2;
            }
            return n;
        }

        @Override
        protected final int getAnchor() {
            return 17;
        }
    }

    private abstract class RowOfComponents {
        private final List<JComponent> comps;
        private final Insets insets;

        RowOfComponents(JComponent ... jComponentArray) {
            this(new Insets(5, 5, 5, 5), jComponentArray);
        }

        RowOfComponents(Insets insets, JComponent ... jComponentArray) {
            if (jComponentArray.length == 0) {
                this.comps = new ArrayList<JComponent>();
                this.comps.add(AbstractPanelBuilder.this.createPanel(new BorderLayout()));
            } else {
                this.comps = Arrays.asList(jComponentArray);
            }
            this.insets = insets;
        }

        final List<JComponent> getComponents() {
            return new ArrayList<JComponent>(this.comps);
        }

        final int size() {
            return this.comps.size();
        }

        final void addConstraintsForColumn(GridBagConstraints gridBagConstraints, int n, int n2) {
            gridBagConstraints.gridwidth = this.getGridWidth(gridBagConstraints.gridwidth, n2);
            boolean bl = this.isFillColumn(n);
            if (bl) {
                gridBagConstraints.fill = gridBagConstraints.fill == 3 ? 1 : 2;
                gridBagConstraints.weightx = 1.0;
            }
            gridBagConstraints.insets = this.insets;
            gridBagConstraints.anchor = this.getAnchor();
        }

        protected abstract int getGridWidth(int var1, int var2);

        protected abstract boolean isFillColumn(int var1);

        protected abstract int getAnchor();
    }
}

