/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.text;

import com.mathworks.mwt.MWContainer;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.text.MWKeyMap;
import com.mathworks.mwt.text.MWTextEvent;
import com.mathworks.mwt.text.MWTextListener;
import com.mathworks.mwt.text.MWTextModel;
import com.mathworks.mwt.text.MWTextView;
import com.mathworks.mwt.undo.UndoListener;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public abstract class MWTextComponent
extends MWContainer {
    public static final int SCROLLBAR_NEVER = 1;
    public static final int SCROLLBAR_ALWAYS = 2;
    private MWTextModel fModel = new MWTextModel();
    private MWTextView fView;
    private boolean fBevelOn = true;
    private boolean fTextChangeOn = true;
    private FocusListener fFocusMulticaster;
    private KeyListener fKeyMulticaster;
    private MouseListener fMouseMulticaster;
    private MouseMotionListener fMouseMotionMulticaster;
    private TextListener fTextMulticaster;
    private FocusListener fFocusListener;
    private KeyListener fKeyListener;
    private MouseListener fMouseListener;
    private MouseMotionListener fMouseMotionListener;
    private MWTextListener fTextListener;

    public MWTextComponent() {
        this("");
    }

    public MWTextComponent(String string) {
        this.fModel.setSpacesPerTab(4);
        this.fModel.setText(string);
        this.fView = this.fModel.createNewView();
        if (PlatformInfo.isWindows()) {
            this.fView.setColorMode(1);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.fView, "Center");
    }

    public void setModel(MWTextModel mWTextModel) {
        this.fModel = mWTextModel;
        this.fView.setModel(mWTextModel);
    }

    public boolean isBevelOn() {
        return this.fBevelOn;
    }

    public void setBevelOn(boolean bl) {
        if (bl != this.fBevelOn) {
            this.fBevelOn = bl;
            this.invalidate();
        }
    }

    public void setCRMode(boolean bl) {
        this.fModel.setCRMode(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String string) {
        try {
            if (string == null) {
                string = "";
            }
            this.fTextChangeOn = false;
            this.fModel.setText(string);
        }
        finally {
            this.fTextChangeOn = true;
        }
    }

    public String getText() {
        return this.fModel.getText();
    }

    public String getSelText() {
        return this.fView.getSelText();
    }

    public int getSelStart() {
        return this.fView.getSelStart();
    }

    public int getSelEnd() {
        return this.fView.getSelEnd();
    }

    public void setSel(int n, int n2) {
        this.fView.setSel(n, n2);
    }

    public void selectAll() {
        this.fView.bufferSelect();
    }

    public int getCaretPosition() {
        return this.getSelEnd();
    }

    public void setCaretPosition(int n) {
        this.setSel(n, n);
    }

    public void dispatchTextComponentEvent(AWTEvent aWTEvent) {
        this.fView.dispatchTextComponentEvent(aWTEvent);
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        if (this.fFocusMulticaster == null) {
            if (this.fFocusListener == null) {
                this.fFocusListener = new TextComponentFocusListener();
            }
            this.fView.addFocusListener(this.fFocusListener);
        }
        this.fFocusMulticaster = AWTEventMulticaster.add(this.fFocusMulticaster, focusListener);
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        this.fFocusMulticaster = AWTEventMulticaster.remove(this.fFocusMulticaster, focusListener);
        if (this.fFocusMulticaster == null) {
            this.fView.removeFocusListener(this.fFocusListener);
        }
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        if (this.fKeyMulticaster == null) {
            if (this.fKeyListener == null) {
                this.fKeyListener = new TextComponentKeyListener();
            }
            this.fView.addKeyListener(this.fKeyListener);
        }
        this.fKeyMulticaster = AWTEventMulticaster.add(this.fKeyMulticaster, keyListener);
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        this.fKeyMulticaster = AWTEventMulticaster.remove(this.fKeyMulticaster, keyListener);
        if (this.fKeyMulticaster == null) {
            this.fView.removeKeyListener(this.fKeyListener);
        }
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        if (this.fMouseMulticaster == null) {
            if (this.fMouseListener == null) {
                this.fMouseListener = new TextComponentMouseListener();
            }
            this.fView.addMouseListener(this.fMouseListener);
        }
        this.fMouseMulticaster = AWTEventMulticaster.add(this.fMouseMulticaster, mouseListener);
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        this.fMouseMulticaster = AWTEventMulticaster.remove(this.fMouseMulticaster, mouseListener);
        if (this.fMouseMulticaster == null) {
            this.fView.removeMouseListener(this.fMouseListener);
        }
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (this.fMouseMotionMulticaster == null) {
            if (this.fMouseMotionListener == null) {
                this.fMouseMotionListener = new TextComponentMouseMotionListener();
            }
            this.fView.addMouseMotionListener(this.fMouseMotionListener);
        }
        this.fMouseMotionMulticaster = AWTEventMulticaster.add(this.fMouseMotionMulticaster, mouseMotionListener);
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.fMouseMotionMulticaster = AWTEventMulticaster.remove(this.fMouseMotionMulticaster, mouseMotionListener);
        if (this.fMouseMotionMulticaster == null) {
            this.fView.removeMouseMotionListener(this.fMouseMotionListener);
        }
    }

    public void addTextListener(TextListener textListener) {
        if (this.fTextMulticaster == null) {
            if (this.fTextListener == null) {
                this.fTextListener = new TextComponentTextListener();
            }
            this.fModel.addTextListener(this.fTextListener);
        }
        this.fTextMulticaster = AWTEventMulticaster.add(this.fTextMulticaster, textListener);
    }

    public void removeTextListener(TextListener textListener) {
        this.fTextMulticaster = AWTEventMulticaster.remove(this.fTextMulticaster, textListener);
        if (this.fTextMulticaster == null) {
            this.fModel.removeTextListener(this.fTextListener);
        }
    }

    public void addUndoListener(UndoListener undoListener) {
        this.fModel.addUndoListener(undoListener);
    }

    public void removeUndoListener(UndoListener undoListener) {
        this.fModel.removeUndoListener(undoListener);
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.fView.setCursor(cursor);
    }

    public boolean isEditable() {
        return this.fModel.isEditable();
    }

    public void setEditable(boolean bl) {
        if (bl != this.fModel.isEditable()) {
            this.fModel.setEditable(bl);
            if (PlatformInfo.getPlatform() == 1) {
                this.setBackground(this.fView.getBackground());
                this.repaint();
            }
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled()) {
            super.setEnabled(bl);
            this.fView.setEnabled(bl);
            this.setBackground(this.fView.getBackground());
            this.repaint();
        }
    }

    public void setDimBGWhenNotEditable(boolean bl) {
        if (bl != this.fView.getDimBGWhenNotEditable()) {
            this.fView.setDimBGWhenNotEditable(bl);
            this.setBackground(this.fView.getBackground());
            this.repaint();
        }
    }

    public void setDimBGWhenDisabled(boolean bl) {
        if (bl != this.fView.getDimBGWhenDisabled()) {
            this.fView.setDimBGWhenDisabled(bl);
            this.setBackground(this.fView.getBackground());
            this.repaint();
        }
    }

    public void setDimFGWhenDisabled(boolean bl) {
        this.fView.setDimFGWhenDisabled(bl);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.fView.setBackground(color);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.fView.setForeground(color);
    }

    public MWTextModel getModel() {
        return this.fModel;
    }

    public MWTextView getView() {
        return this.fView;
    }

    @Override
    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null font not allowed for MWTextComponent");
        }
        super.setFont(font);
        this.fModel.setDefaultFont(font);
    }

    public int getGutterWidth() {
        return this.fView.getGutterWidth();
    }

    public void setGutterWidth(int n) {
        this.fView.setGutterWidth(n);
    }

    public int getVScrollStyle() {
        return this.fView.getVScrollStyle();
    }

    public void setVScrollStyle(int n) {
        this.fView.setVScrollStyle(n);
    }

    public int getHScrollStyle() {
        return this.fView.getHScrollStyle();
    }

    public void setHScrollStyle(int n) {
        this.fView.setHScrollStyle(n);
    }

    public MWKeyMap getKeyMap() {
        return this.fView.getKeyMap();
    }

    public void setKeyMap(MWKeyMap mWKeyMap) {
        this.fView.setKeyMap(mWKeyMap);
    }

    protected int getBorderWidth() {
        if (this.fBevelOn) {
            return PlatformInfo.isWindowsModernAppearance() ? 1 : 2;
        }
        return 0;
    }

    @Override
    public Insets getInsets() {
        int n = this.getBorderWidth();
        return new Insets(n, n, n, n);
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.fBevelOn) {
            Dimension dimension = this.getSize();
            Decorations.drawBevelFrame(graphics, 0, 0, dimension.width, dimension.height);
        }
        super.paint(graphics);
    }

    @Override
    public void requestFocus() {
        this.fView.requestFocus();
    }

    @Override
    public boolean isFocusTraversable() {
        return this.fView.isFocusTraversable();
    }

    private class TextComponentTextListener
    implements MWTextListener {
        private TextComponentTextListener() {
        }

        @Override
        public void textChanged(MWTextEvent mWTextEvent) {
            if (MWTextComponent.this.fTextChangeOn) {
                TextEvent textEvent = new TextEvent(MWTextComponent.this, 900);
                MWTextComponent.this.fTextMulticaster.textValueChanged(textEvent);
            }
        }

        @Override
        public void lineChange(MWTextEvent mWTextEvent) {
        }

        @Override
        public void textInserted(MWTextEvent mWTextEvent) {
        }

        @Override
        public void textDeleted(MWTextEvent mWTextEvent) {
        }

        @Override
        public void styleChanged(MWTextEvent mWTextEvent) {
        }

        @Override
        public void commandStarted(MWTextEvent mWTextEvent) {
        }

        @Override
        public void commandEnded(MWTextEvent mWTextEvent) {
        }
    }

    private class TextComponentMouseMotionListener
    implements MouseMotionListener {
        private TextComponentMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            MouseEvent mouseEvent2 = new MouseEvent(MWTextComponent.this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            MWTextComponent.this.fMouseMotionMulticaster.mouseDragged(mouseEvent2);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            MouseEvent mouseEvent2 = new MouseEvent(MWTextComponent.this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            MWTextComponent.this.fMouseMotionMulticaster.mouseMoved(mouseEvent2);
        }
    }

    private class TextComponentMouseListener
    implements MouseListener {
        private TextComponentMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            MouseEvent mouseEvent2 = new MouseEvent(MWTextComponent.this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            MWTextComponent.this.fMouseMulticaster.mouseClicked(mouseEvent2);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            MouseEvent mouseEvent2 = new MouseEvent(MWTextComponent.this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            MWTextComponent.this.fMouseMulticaster.mouseEntered(mouseEvent2);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            MouseEvent mouseEvent2 = new MouseEvent(MWTextComponent.this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            MWTextComponent.this.fMouseMulticaster.mouseExited(mouseEvent2);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            MouseEvent mouseEvent2 = new MouseEvent(MWTextComponent.this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            if (MWTextComponent.this.fMouseMulticaster != null) {
                MWTextComponent.this.fMouseMulticaster.mousePressed(mouseEvent2);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            MouseEvent mouseEvent2 = new MouseEvent(MWTextComponent.this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            MWTextComponent.this.fMouseMulticaster.mouseReleased(mouseEvent2);
        }
    }

    private class TextComponentKeyListener
    implements KeyListener {
        private TextComponentKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            KeyEvent keyEvent2 = new KeyEvent(MWTextComponent.this, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
            MWTextComponent.this.fKeyMulticaster.keyPressed(keyEvent2);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            KeyEvent keyEvent2 = new KeyEvent(MWTextComponent.this, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
            MWTextComponent.this.fKeyMulticaster.keyReleased(keyEvent2);
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            KeyEvent keyEvent2 = new KeyEvent(MWTextComponent.this, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
            MWTextComponent.this.fKeyMulticaster.keyTyped(keyEvent2);
        }
    }

    private class TextComponentFocusListener
    implements FocusListener {
        private TextComponentFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            FocusEvent focusEvent2 = new FocusEvent(MWTextComponent.this, focusEvent.getID(), focusEvent.isTemporary());
            MWTextComponent.this.fFocusMulticaster.focusGained(focusEvent2);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            FocusEvent focusEvent2 = new FocusEvent(MWTextComponent.this, focusEvent.getID(), focusEvent.isTemporary());
            MWTextComponent.this.fFocusMulticaster.focusLost(focusEvent2);
        }
    }
}

