/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.table;

import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.table.Style;
import com.mathworks.mwt.table.TableUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;

class TableDecorations {
    public static final int COLUMN_HEADER = 0;
    public static final int ROW_HEADER = 1;
    public static final int COLUMN_FILLER = 2;
    public static final int ROW_FILLER = 2;
    private static final Color LT_BLUE = new Color(204, 204, 255);
    private static final Color BLUE = new Color(153, 153, 255);
    private static final Color DK_BLUE = new Color(102, 102, 204);
    private static final Color DK_DK_BLUE = new Color(51, 51, 204);
    private static final Color DK_GRAY = new Color(136, 136, 136);
    private static final Color LT_GRAY = new Color(187, 187, 187);
    private static final Color XP_BORDER = new Color(120, 152, 181);
    private static final Color XP_CORNER = new Color(176, 194, 211);
    private static final Color XP_GRAY1 = new Color(195, 186, 170);
    private static final Color XP_GRAY2 = new Color(210, 204, 192);
    private static final Color XP_GRAY3 = new Color(237, 237, 231);
    private static Color fExcelColor = null;
    private static final int WIN_BOX_SIZE = 9;
    private static final int MAC_BOX_SIZE = 11;

    TableDecorations() {
    }

    static void getTreeControlBounds(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2 != null) {
            int n = TableUtils.getTreeIndent();
            if (TableUtils.isMac()) {
                rectangle2.x = rectangle.x + (n - 11) / 2;
                rectangle2.width = 11;
                rectangle2.y = rectangle.y + (rectangle.height - 11) / 2;
                rectangle2.height = 11;
            } else {
                rectangle2.x = rectangle.x + rectangle.width - n + (n - 9) / 2 + 1;
                rectangle2.width = 9;
                rectangle2.y = rectangle.y + (rectangle.height - 9) / 2 + 1;
                rectangle2.height = 9;
            }
        }
    }

    static void renderTreeControl(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2) {
        switch (PlatformInfo.getAppearance()) {
            case 1: {
                TableDecorations.renderWinTreeCtl(graphics, rectangle, bl, bl2);
                break;
            }
            case 2: {
                TableDecorations.renderUnixTreeCtl(graphics, rectangle, bl, bl2);
                break;
            }
            case 0: {
                TableDecorations.renderMacTreeCtl(graphics, rectangle, bl, bl2);
            }
        }
    }

    private static void renderMacTreeCtl(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2) {
        graphics.translate(rectangle.x, rectangle.y);
        if (bl) {
            graphics.setColor(Color.black);
            graphics.drawLine(0, 3, 10, 3);
            graphics.drawLine(10, 3, 5, 8);
            graphics.drawLine(5, 8, 0, 3);
            if (bl2) {
                graphics.setColor(DK_DK_BLUE);
            }
            if (!bl2) {
                graphics.setColor(LT_BLUE);
            }
            graphics.drawLine(2, 4, 7, 4);
            if (!bl2) {
                graphics.setColor(BLUE);
            }
            graphics.drawLine(3, 5, 6, 5);
            graphics.drawLine(4, 6, 5, 6);
            graphics.drawLine(8, 4, 8, 4);
            if (!bl2) {
                graphics.setColor(DK_BLUE);
            }
            graphics.drawLine(5, 7, 7, 5);
            graphics.setColor(DK_GRAY);
            graphics.drawLine(6, 8, 10, 4);
            graphics.setColor(LT_GRAY);
            graphics.drawLine(6, 9, 11, 4);
        } else {
            graphics.setColor(Color.black);
            graphics.drawLine(3, 0, 3, 10);
            graphics.drawLine(3, 10, 8, 5);
            graphics.drawLine(8, 5, 3, 0);
            if (bl2) {
                graphics.setColor(DK_DK_BLUE);
            }
            if (!bl2) {
                graphics.setColor(LT_BLUE);
            }
            graphics.drawLine(4, 2, 4, 7);
            if (!bl2) {
                graphics.setColor(BLUE);
            }
            graphics.drawLine(5, 3, 5, 6);
            graphics.drawLine(6, 4, 6, 5);
            graphics.drawLine(4, 8, 4, 8);
            if (!bl2) {
                graphics.setColor(DK_BLUE);
            }
            graphics.drawLine(7, 5, 5, 7);
            graphics.setColor(DK_GRAY);
            graphics.drawLine(8, 6, 4, 10);
            graphics.setColor(LT_GRAY);
            graphics.drawLine(9, 6, 4, 11);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    private static void renderWinTreeCtl(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2) {
        int n = rectangle.width;
        int n2 = rectangle.height;
        graphics.translate(rectangle.x, rectangle.y);
        if (bl2) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(Color.white);
        }
        graphics.fillRect(1, 1, n - 2, n2 - 2);
        if (!PlatformInfo.useWindowsXPAppearance()) {
            graphics.setColor(Decorations.getColor(9));
            graphics.drawRect(0, 0, n - 1, n2 - 1);
        } else {
            graphics.setColor(XP_BORDER);
            graphics.drawRect(0, 0, n - 1, n2 - 1);
            graphics.setColor(XP_CORNER);
            graphics.drawLine(0, 0, 0, 0);
            graphics.drawLine(0, n2 - 1, 0, n2 - 1);
            graphics.drawLine(n - 1, 0, n - 1, 0);
            graphics.drawLine(n - 1, n2 - 1, n - 1, n2 - 1);
            if (!bl2) {
                graphics.setColor(XP_GRAY1);
                graphics.drawLine(2, n2 - 2, n - 2, n2 - 2);
                graphics.setColor(XP_GRAY2);
                graphics.drawLine(2, n2 - 3, n - 3, n2 - 3);
                graphics.drawLine(n - 2, 3, n - 2, n2 - 3);
                graphics.drawLine(1, n2 - 2, 1, n2 - 2);
                graphics.setColor(XP_GRAY3);
                graphics.fillRect(1, 3, 6, 3);
                graphics.drawLine(1, n2 - 3, 1, n2 - 3);
                graphics.drawLine(n - 2, 2, n - 2, 2);
            }
        }
        if (bl2) {
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(Color.black);
        }
        graphics.drawLine(n / 4, n2 / 2, 3 * n / 4, n2 / 2);
        if (!bl) {
            graphics.drawLine(n / 2, n2 / 4, n / 2, 3 * n2 / 4);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    private static void renderUnixTreeCtl(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2) {
        int n = rectangle.width;
        int n2 = rectangle.height;
        Decorations.drawButtonBevel(graphics, rectangle, bl2, false, true);
        graphics.translate(rectangle.x, rectangle.y);
        graphics.setColor(Color.black);
        graphics.drawLine(n / 4, n2 / 2, 3 * n / 4, n2 / 2);
        if (!bl) {
            graphics.drawLine(n / 2, n2 / 4, n / 2, 3 * n2 / 4);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    static void renderHeaderBackground(Graphics graphics, Rectangle rectangle, int n) {
        if (TableUtils.isMac()) {
            --rectangle.x;
            --rectangle.y;
            ++rectangle.width;
            ++rectangle.height;
        }
        if (PlatformInfo.useWindowsXPAppearance()) {
            TableDecorations.drawXPButtonBevel(graphics, rectangle, false, false, true, n);
        } else {
            Decorations.drawButtonBevel(graphics, rectangle, false, false, true);
        }
    }

    private static void drawXPButtonBevel(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3, int n) {
        Color color = new Color(239, 231, 222);
        Color color2 = new Color(231, 235, 222);
        Color color3 = new Color(222, 219, 206);
        Color color4 = new Color(214, 207, 189);
        Color color5 = new Color(206, 199, 181);
        Color color6 = new Color(198, 195, 181);
        Color color7 = Color.white;
        graphics.translate(rectangle.x, rectangle.y);
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        graphics.setColor(color);
        graphics.fillRect(0, 1, n2, n3);
        graphics.setColor(color2);
        graphics.drawLine(0, 0, n2 - 1, 0);
        graphics.setColor(color5);
        graphics.drawLine(0, n3 - 1, n2 - 1, n3 - 1);
        graphics.setColor(color4);
        graphics.drawLine(0, n3 - 2, n2 - 1, n3 - 2);
        graphics.setColor(color3);
        graphics.drawLine(0, n3 - 3, n2 - 1, n3 - 3);
        if (n == 0 | n == 2) {
            graphics.setColor(color7);
            graphics.drawLine(0, 3, 0, n3 - 5);
            graphics.setColor(color6);
            graphics.drawLine(n2 - 1, 3, n2 - 1, n3 - 5);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    static void renderCellBackground(Graphics graphics, Rectangle rectangle, Style style, boolean bl, boolean bl2, boolean bl3, Color color) {
        TableDecorations.renderCellBackground(graphics, rectangle, style, bl, bl2, bl3, false, color);
    }

    static void renderCellBackground(Graphics graphics, Rectangle rectangle, Style style, boolean bl, boolean bl2, boolean bl3, boolean bl4, Color color) {
        int n = rectangle.width;
        int n2 = rectangle.height;
        int n3 = 0;
        int n4 = 0;
        Insets insets = style.getMargins();
        graphics.translate(rectangle.x, rectangle.y);
        if (style.isHGridVisible()) {
            graphics.setColor(style.getHGridColor());
            graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
            n4 = 1;
        }
        if (style.isVGridVisible()) {
            graphics.setColor(style.getVGridColor());
            graphics.drawLine(n - 1, 0, n - 1, n2 - 1 - n4);
            n3 = 1;
        }
        if (bl && (!style.getCustomHilite() || bl4)) {
            graphics.setColor(TableDecorations.getBackgoundSelColor(bl3, bl4, color));
        } else {
            graphics.setColor(style.getBackground());
        }
        graphics.fillRect(0, 0, n - n3, n2 - n4);
        if (bl2) {
            graphics.setColor(style.getBackground());
            graphics.fillRect(insets.left, insets.top, n - n3 - (insets.right + insets.left), n2 - n4 - (insets.bottom + insets.top));
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    static Color getBackgoundSelColor(boolean bl, boolean bl2, Color color) {
        if (bl2) {
            if (fExcelColor == null) {
                int n;
                int n2;
                fExcelColor = new Color(165, 165, 165);
                Color color2 = Decorations.getColor(4, bl, color);
                int n3 = color2.getRed();
                double d = (double)n3 * 0.299 + (double)(n2 = color2.getGreen()) * 0.587 + (double)(n = color2.getBlue()) * 0.114;
                if (d < (double)231.6f) {
                    fExcelColor = new Color((float)((0.3529 * (double)n3 + 165.0) / 255.0), (float)((0.3529 * (double)n2 + 165.0) / 255.0), (float)((0.3529 * (double)n + 165.0) / 255.0));
                }
            }
            return fExcelColor;
        }
        return Decorations.getColor(4, bl, color);
    }
}

