/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.decorations;

import com.mathworks.mwt.MWImageResource;
import com.mathworks.mwt.decorations.HiliteFilter;
import com.mathworks.mwt.decorations.PlatformDecorations;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.image.FilteredImageSource;

class WindowsDecorations
extends PlatformDecorations {
    private static final int kUp = 0;
    private static final int kLeft = 1;
    private static final int kDown = 2;
    private static final int kRight = 3;
    private static final Font DEFAULT_FONT;
    private static Color sWindow;
    private static Color sWindowText;
    private static Color sDialog;
    private static Color sControl;
    private static Color sControlText;
    private static Color sControlLtHilite;
    private static Color sControlHilite;
    private static Color sControlShadow;
    private static Color sControlDkShadow;
    private static Color sScrollbar;
    private static Color sTextHighlight;
    private static Color sTextHighlightText;
    private static Color sText;
    private static Color sTextText;
    private static Color sInactiveText;
    private int fChecksize = 13;
    private static final int RB_EMPTY = 0;
    private static final int RB_EMPTY_HILITE = 1;
    private static final int RB_EMPTY_DISABLED = 2;
    private static final int RB_CHECKED = 3;
    private static final int RB_CHECKED_HILITE = 4;
    private static final int RB_CHECKED_DISABLED = 5;
    private static final byte[] RB_OUTLINE;
    private MWImageResource[] fRBImages;

    WindowsDecorations() {
    }

    @Override
    Font getFont(int n) {
        Font font = null;
        switch (n) {
            case 0: {
                font = DEFAULT_FONT;
            }
        }
        return font;
    }

    @Override
    Color getColor(int n) {
        Color color = null;
        switch (n) {
            case 0: 
            case 2: {
                color = sWindow;
                break;
            }
            case 1: {
                color = sControl;
                break;
            }
            case 3: {
                color = Color.gray;
                break;
            }
            case 4: {
                color = sTextHighlight;
                break;
            }
            case 5: {
                color = sTextHighlightText;
                break;
            }
            case 6: {
                color = sControl;
                break;
            }
            case 7: {
                color = sControlLtHilite;
                break;
            }
            case 8: {
                color = sControlHilite;
                break;
            }
            case 9: {
                color = sControlShadow;
                break;
            }
            case 10: {
                color = sControlDkShadow;
                break;
            }
            case 11: {
                color = sControlText;
                break;
            }
            case 12: {
                color = sWindowText;
                break;
            }
            case 13: {
                color = sText;
                break;
            }
            case 14: {
                color = sTextText;
                break;
            }
            case 15: {
                color = sInactiveText;
                break;
            }
            case 17: {
                color = SystemColor.activeCaptionText;
                break;
            }
            case 16: {
                color = SystemColor.activeCaption;
                break;
            }
            case 19: {
                color = SystemColor.inactiveCaptionText;
                break;
            }
            case 18: {
                color = SystemColor.inactiveCaption;
            }
        }
        return color;
    }

    @Override
    void drawLabel(Graphics graphics, String string, int n, int n2, boolean bl, boolean bl2) {
        this.drawLabel(graphics, string, n, n2, bl, bl2, false, sWindowText);
    }

    @Override
    void drawButtonLabel(Graphics graphics, String string, int n, int n2, boolean bl, boolean bl2) {
        this.drawLabel(graphics, string, n, n2, bl, bl2, false, sControlText);
    }

    private void drawLabel(Graphics graphics, String string, int n, int n2, boolean bl, boolean bl2, boolean bl3, Color color) {
        if (string != null) {
            if (bl2) {
                if (bl3) {
                    graphics.setColor(sTextHighlightText);
                } else {
                    graphics.setColor(color);
                }
                if (bl) {
                    graphics.drawString(string, n + 1, n2 + 1);
                } else {
                    graphics.drawString(string, n, n2);
                }
            } else {
                graphics.setColor(sControlLtHilite);
                graphics.drawString(string, n + 1, n2 + 1);
                graphics.setColor(sControlShadow);
                graphics.drawString(string, n, n2);
            }
        }
    }

    @Override
    void drawButtonBevel(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3) {
        Color color = bl2 ? sControlLtHilite : sControl;
        Color color2 = bl || bl2 ? sControlDkShadow : sControlLtHilite;
        Color color3 = bl || bl2 ? sControlShadow : sControlHilite;
        Color color4 = bl || bl2 ? sControlLtHilite : sControlDkShadow;
        Color color5 = bl || bl2 ? sControlHilite : sControlShadow;
        graphics.translate(rectangle.x, rectangle.y);
        int n = rectangle.width;
        int n2 = rectangle.height;
        graphics.setColor(color2);
        graphics.drawLine(0, n2 - 2, 0, 0);
        graphics.drawLine(1, 0, n - 2, 0);
        graphics.setColor(color4);
        graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
        graphics.drawLine(n - 2, n2 - 1, 0, n2 - 1);
        graphics.setColor(color3);
        graphics.drawLine(1, n2 - 3, 1, 1);
        graphics.drawLine(2, 1, n - 3, 1);
        graphics.setColor(color5);
        graphics.drawLine(n - 2, 1, n - 2, n2 - 2);
        graphics.drawLine(n - 3, n2 - 2, 1, n2 - 2);
        graphics.setColor(color);
        graphics.fillRect(2, 2, n - 4, n2 - 4);
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    @Override
    void drawTBButtonBevel(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3) {
        Color color = bl2 ? sControlLtHilite : sControl;
        Color color2 = bl || bl2 ? sControlDkShadow : sControlLtHilite;
        Color color3 = bl || bl2 ? sControlHilite : sControlShadow;
        graphics.translate(rectangle.x, rectangle.y);
        int n = rectangle.width;
        int n2 = rectangle.height;
        graphics.setColor(color2);
        graphics.drawLine(0, n2, 0, 0);
        graphics.drawLine(1, 0, n, 0);
        graphics.setColor(color3);
        graphics.drawLine(n - 1, 1, n - 1, n2 - 1);
        graphics.drawLine(n - 1, n2 - 1, 1, n2 - 1);
        graphics.setColor(color);
        graphics.fillRect(1, 1, n - 2, n2 - 2);
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    @Override
    MWImageResource[] drawButtonImage(MWImageResource[] mWImageResourceArray, Graphics graphics, MWImageResource mWImageResource, int n, int n2, boolean bl, boolean bl2) {
        MWImageResource[] mWImageResourceArray2 = mWImageResourceArray;
        if (mWImageResource != null) {
            if (bl) {
                graphics.drawImage(mWImageResource.getImage(), n + 1, n2 + 1, this);
            } else if (bl2) {
                graphics.drawImage(mWImageResource.getImage(), n, n2, this);
            } else {
                mWImageResourceArray2 = this.buildCache(mWImageResource, mWImageResourceArray2);
                graphics.drawImage(mWImageResourceArray2[0].getImage(), n + 1, n2 + 1, this);
                graphics.drawImage(mWImageResourceArray2[1].getImage(), n, n2, this);
            }
        }
        return mWImageResourceArray2;
    }

    @Override
    Image[] drawButtonImage(Image[] imageArray, Graphics graphics, Image image, int n, int n2, boolean bl, boolean bl2) {
        Image[] imageArray2 = imageArray;
        if (image != null) {
            if (bl) {
                graphics.drawImage(image, n + 1, n2 + 1, this);
            } else if (bl2) {
                graphics.drawImage(image, n, n2, this);
            } else {
                imageArray2 = this.buildCache(image, imageArray2);
                graphics.drawImage(imageArray2[0], n + 1, n2 + 1, this);
                graphics.drawImage(imageArray2[1], n, n2, this);
            }
        }
        return imageArray2;
    }

    private MWImageResource[] buildCache(MWImageResource mWImageResource, MWImageResource[] mWImageResourceArray) {
        FilteredImageSource filteredImageSource;
        if (mWImageResourceArray == null) {
            mWImageResourceArray = new MWImageResource[2];
        }
        if (mWImageResourceArray[0] == null) {
            filteredImageSource = new FilteredImageSource(mWImageResource.getImage().getSource(), new HiliteFilter(sControlLtHilite));
            mWImageResourceArray[0] = new MWImageResource(mWImageResource.getResourceName() + "0", filteredImageSource);
        }
        if (mWImageResourceArray[1] == null) {
            filteredImageSource = new FilteredImageSource(mWImageResource.getImage().getSource(), new HiliteFilter(sControlShadow));
            mWImageResourceArray[1] = new MWImageResource(mWImageResource.getResourceName() + "1", filteredImageSource);
        }
        return mWImageResourceArray;
    }

    private Image[] buildCache(Image image, Image[] imageArray) {
        FilteredImageSource filteredImageSource;
        if (imageArray == null) {
            imageArray = new Image[2];
        }
        if (imageArray[0] == null) {
            filteredImageSource = new FilteredImageSource(image.getSource(), new HiliteFilter(sControlLtHilite));
            imageArray[0] = this.createImage(filteredImageSource);
            this.waitForImage(imageArray[0]);
        }
        if (imageArray[1] == null) {
            filteredImageSource = new FilteredImageSource(image.getSource(), new HiliteFilter(sControlShadow));
            imageArray[1] = this.createImage(filteredImageSource);
            this.waitForImage(imageArray[1]);
        }
        return imageArray;
    }

    @Override
    void drawButtonImage(Graphics graphics, Image image, int n, int n2, boolean bl, boolean bl2) {
        this.drawButtonImage(null, graphics, image, n, n2, bl, bl2);
    }

    private boolean waitForImage(Image image) {
        boolean bl = true;
        if (image != null) {
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(image, 2013);
            try {
                mediaTracker.waitForID(2013);
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    int getChecksize() {
        return this.fChecksize;
    }

    @Override
    void drawCheckbox(Graphics graphics, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        graphics.translate(n, n2);
        if (bl4 && bl || !bl4) {
            graphics.setColor(sControlHilite);
        } else {
            graphics.setColor(sWindow);
        }
        graphics.fillRect(2, 2, this.fChecksize - 4, this.fChecksize - 4);
        graphics.setColor(sControlShadow);
        graphics.drawLine(0, this.fChecksize - 2, 0, 0);
        graphics.drawLine(1, 0, this.fChecksize - 2, 0);
        graphics.setColor(sControlDkShadow);
        graphics.drawLine(1, this.fChecksize - 3, 1, 1);
        graphics.drawLine(2, 1, this.fChecksize - 3, 1);
        graphics.setColor(sControlLtHilite);
        graphics.drawLine(0, this.fChecksize - 1, this.fChecksize - 1, this.fChecksize - 1);
        graphics.drawLine(this.fChecksize - 1, this.fChecksize - 2, this.fChecksize - 1, 0);
        graphics.setColor(sControlHilite);
        graphics.drawLine(1, this.fChecksize - 2, this.fChecksize - 2, this.fChecksize - 2);
        graphics.drawLine(this.fChecksize - 2, this.fChecksize - 3, this.fChecksize - 2, 1);
        if (bl2 || bl3) {
            if (bl4 && !bl3) {
                graphics.setColor(sWindowText);
            } else {
                graphics.setColor(sControlShadow);
            }
            graphics.drawLine(3, 5, 5, 7);
            graphics.drawLine(6, 6, 9, 3);
            graphics.drawLine(3, 6, 5, 8);
            graphics.drawLine(6, 7, 9, 4);
            graphics.drawLine(3, 7, 5, 9);
            graphics.drawLine(6, 8, 9, 5);
        }
        graphics.translate(-n, -n2);
    }

    private int[] newRBMap(int n) {
        int[] nArray = new int[]{0, sControlShadow.getRGB() | 0xFF000000, sControlDkShadow.getRGB() | 0xFF000000, sControlLtHilite.getRGB() | 0xFF000000, sControlHilite.getRGB() | 0xFF000000, n | 0xFF000000};
        return nArray;
    }

    private void addRBCheck(int[] nArray, int n) {
        nArray[53] = nArray[54] = (n |= 0xFF000000);
        nArray[66] = nArray[67] = n;
        nArray[65] = nArray[67];
        nArray[64] = nArray[67];
        nArray[78] = nArray[79] = n;
        nArray[77] = nArray[79];
        nArray[76] = nArray[79];
        nArray[89] = nArray[90] = n;
    }

    private void buildRBImages() {
        if (this.fRBImages == null) {
            this.fRBImages = new MWImageResource[6];
            int[] nArray = this.newRBMap(sWindow.getRGB());
            int[] nArray2 = this.newRBInts(RB_OUTLINE, nArray);
            this.fRBImages[0] = new MWImageResource(12, 12, nArray2);
            nArray2 = this.cloneRBInts(nArray2);
            this.addRBCheck(nArray2, sWindowText.getRGB());
            this.fRBImages[3] = new MWImageResource(12, 12, nArray2);
            nArray = this.newRBMap(sControlHilite.getRGB());
            nArray2 = this.newRBInts(RB_OUTLINE, nArray);
            this.fRBImages[1] = new MWImageResource(12, 12, nArray2);
            this.fRBImages[2] = this.fRBImages[1];
            nArray2 = this.cloneRBInts(nArray2);
            this.addRBCheck(nArray2, sWindowText.getRGB());
            this.fRBImages[4] = new MWImageResource(12, 12, nArray2);
            nArray2 = this.cloneRBInts(nArray2);
            this.addRBCheck(nArray2, sControlShadow.getRGB());
            this.fRBImages[5] = new MWImageResource(12, 12, nArray2);
        }
    }

    @Override
    void drawRadiobutton(Graphics graphics, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        graphics.translate(n, n2);
        this.buildRBImages();
        if (this.fRBImages != null) {
            if (!bl2 || bl3) {
                if (!bl4) {
                    graphics.drawImage(this.fRBImages[2].getImage(), 0, 0, this);
                } else if (bl) {
                    graphics.drawImage(this.fRBImages[1].getImage(), 0, 0, this);
                } else {
                    graphics.drawImage(this.fRBImages[0].getImage(), 0, 0, this);
                }
                if (bl3) {
                    graphics.setColor(sControlShadow);
                    graphics.drawLine(5, 4, 6, 4);
                    graphics.drawLine(4, 5, 7, 5);
                    graphics.drawLine(4, 6, 7, 6);
                    graphics.drawLine(5, 7, 6, 7);
                }
            } else if (!bl4) {
                graphics.drawImage(this.fRBImages[5].getImage(), 0, 0, this);
            } else if (bl) {
                graphics.drawImage(this.fRBImages[4].getImage(), 0, 0, this);
            } else {
                graphics.drawImage(this.fRBImages[3].getImage(), 0, 0, this);
            }
        } else {
            if (bl4 && bl || !bl4) {
                graphics.setColor(sControlHilite);
            } else {
                graphics.setColor(sWindow);
            }
            graphics.fillOval(1, 1, this.fChecksize - 3, this.fChecksize - 3);
            graphics.setColor(sControlShadow);
            graphics.drawArc(0, 0, this.fChecksize - 1, this.fChecksize - 1, 45, 180);
            graphics.setColor(sControlDkShadow);
            graphics.drawArc(1, 1, this.fChecksize - 3, this.fChecksize - 3, 45, 185);
            graphics.setColor(sControlLtHilite);
            graphics.drawArc(0, 0, this.fChecksize - 1, this.fChecksize - 1, 225, 180);
            graphics.setColor(sControlHilite);
            graphics.drawArc(1, 1, this.fChecksize - 3, this.fChecksize - 3, 225, 185);
            if (bl2 || bl3) {
                if (bl4 && !bl3) {
                    graphics.setColor(sWindowText);
                } else {
                    graphics.setColor(sControlShadow);
                }
                graphics.fillOval(4, 4, this.fChecksize - 9, this.fChecksize - 9);
            }
        }
        graphics.translate(-n, -n2);
    }

    @Override
    void drawScrollTrack(Graphics graphics, Rectangle rectangle, int n, int n2, boolean bl, boolean bl2) {
        if (rectangle.isEmpty()) {
            return;
        }
        graphics.setColor(sScrollbar);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    void drawScrollThumb(Graphics graphics, Rectangle rectangle, int n, boolean bl, boolean bl2, boolean bl3) {
        if (rectangle.isEmpty()) {
            return;
        }
        this.drawScrollBevel(graphics, rectangle, false);
    }

    @Override
    int sliderThumbLength() {
        return 11;
    }

    @Override
    void drawSliderThumb(Graphics graphics, Rectangle rectangle, int n, boolean bl, boolean bl2, boolean bl3) {
        if (rectangle.isEmpty()) {
            return;
        }
        graphics.translate(rectangle.x, rectangle.y);
        boolean bl4 = false;
        boolean bl5 = true;
        int n2 = rectangle.width;
        int n3 = rectangle.height - 2;
        if (bl2) {
            if (n == 0) {
                graphics.setColor(this.getColor(7));
                graphics.drawLine(0, 0, 9, 0);
                graphics.drawLine(0, 0, 0, 10);
                graphics.drawLine(0, 10, 4, 14);
                graphics.setColor(this.getColor(8));
                graphics.drawLine(1, 1, 8, 1);
                graphics.drawLine(1, 1, 1, 10);
                graphics.drawLine(1, 10, 4, 13);
                graphics.setColor(this.getColor(10));
                graphics.drawLine(10, 0, 10, 10);
                graphics.drawLine(10, 10, 5, 15);
                graphics.setColor(this.getColor(9));
                graphics.drawLine(9, 1, 9, 10);
                graphics.drawLine(9, 10, 5, 14);
                graphics.setColor(this.getColor(6));
                graphics.fillRect(2, 2, 7, 9);
                for (int i = 0; i < 3; ++i) {
                    graphics.drawLine(3 + i, 11 + i, 7 - i, 11 + i);
                }
            } else {
                graphics.setColor(this.getColor(7));
                graphics.drawLine(0, 0, 0, 9);
                graphics.drawLine(0, 0, 10, 0);
                graphics.drawLine(10, 0, 14, 4);
                graphics.setColor(this.getColor(8));
                graphics.drawLine(1, 1, 1, 8);
                graphics.drawLine(1, 1, 10, 1);
                graphics.drawLine(10, 1, 13, 4);
                graphics.setColor(this.getColor(10));
                graphics.drawLine(0, 10, 10, 10);
                graphics.drawLine(10, 10, 15, 5);
                graphics.setColor(this.getColor(9));
                graphics.drawLine(1, 9, 10, 9);
                graphics.drawLine(10, 9, 14, 5);
                graphics.setColor(this.getColor(6));
                graphics.fillRect(2, 2, 9, 7);
                for (int i = 0; i < 3; ++i) {
                    graphics.drawLine(11 + i, 3 + i, 11 - i, 7 + i);
                }
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    @Override
    void drawSliderTrack(Graphics graphics, Rectangle rectangle, int n, int n2, boolean bl) {
        if (rectangle.isEmpty()) {
            return;
        }
        graphics.translate(rectangle.x, rectangle.y);
        graphics.setColor(Color.black);
        if (bl) {
            if (n == 2) {
                if (n2 == 0) {
                    graphics.setColor(this.getColor(9));
                    graphics.drawLine(0, 4, rectangle.width - 1, 4);
                    graphics.setColor(this.getColor(10));
                    graphics.drawLine(0, 5, rectangle.width - 1, 5);
                    graphics.setColor(this.getColor(8));
                    graphics.drawLine(0, 6, rectangle.width - 1, 6);
                    graphics.setColor(this.getColor(7));
                    graphics.drawLine(0, 7, rectangle.width - 1, 7);
                } else {
                    graphics.setColor(this.getColor(9));
                    graphics.drawLine(4, 0, 4, rectangle.height - 1);
                    graphics.setColor(this.getColor(10));
                    graphics.drawLine(5, 0, 5, rectangle.height - 1);
                    graphics.setColor(this.getColor(8));
                    graphics.drawLine(6, 0, 6, rectangle.height - 1);
                    graphics.setColor(this.getColor(7));
                    graphics.drawLine(7, 0, 7, rectangle.height - 1);
                }
            } else if (n2 == 0) {
                graphics.setColor(this.getColor(9));
                graphics.drawLine(1, 4, rectangle.width, 4);
                graphics.setColor(this.getColor(10));
                graphics.drawLine(1, 5, rectangle.width, 5);
                graphics.setColor(this.getColor(8));
                graphics.drawLine(1, 6, rectangle.width, 6);
                graphics.setColor(this.getColor(7));
                graphics.drawLine(1, 7, rectangle.width, 7);
            } else {
                graphics.setColor(this.getColor(9));
                graphics.drawLine(4, 1, 4, rectangle.height);
                graphics.setColor(this.getColor(10));
                graphics.drawLine(5, 1, 5, rectangle.height);
                graphics.setColor(this.getColor(8));
                graphics.drawLine(6, 1, 6, rectangle.height);
                graphics.setColor(this.getColor(7));
                graphics.drawLine(7, 1, 7, rectangle.height);
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    @Override
    void drawScrollArrowButton(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3, int n, int n2) {
        if (rectangle.isEmpty()) {
            return;
        }
        this.drawScrollBevel(graphics, rectangle, bl);
        int n3 = n == 0 ? (n2 == 0 ? 0 : 2) : (n2 == 0 ? 1 : 3);
        if (bl2) {
            if (bl) {
                ++rectangle.x;
                ++rectangle.y;
                graphics.setColor(sControlText);
                this.drawScrollArrow(graphics, rectangle, n3, 0);
                --rectangle.x;
                --rectangle.y;
            } else {
                graphics.setColor(sControlText);
                this.drawScrollArrow(graphics, rectangle, n3, 0);
            }
        } else {
            graphics.setColor(sControlLtHilite);
            this.drawScrollArrow(graphics, rectangle, n3, 1);
            graphics.setColor(sControlShadow);
            this.drawScrollArrow(graphics, rectangle, n3, 0);
        }
    }

    private void drawScrollBevel(Graphics graphics, Rectangle rectangle, boolean bl) {
        graphics.translate(rectangle.x, rectangle.y);
        if (!bl) {
            if (rectangle.width > 4 && rectangle.height > 4) {
                graphics.setColor(sControl);
                graphics.fillRect(2, 2, rectangle.width - 4, rectangle.height - 4);
            }
            graphics.setColor(sControlHilite);
            graphics.drawLine(0, rectangle.height - 2, 0, 0);
            graphics.drawLine(1, 0, rectangle.width - 2, 0);
            graphics.setColor(sControlDkShadow);
            graphics.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height - 1);
            graphics.drawLine(rectangle.width - 2, rectangle.height - 1, 0, rectangle.height - 1);
            graphics.setColor(sControlLtHilite);
            graphics.drawLine(1, rectangle.height - 3, 1, 1);
            graphics.drawLine(2, 1, rectangle.width - 3, 1);
            graphics.setColor(sControlShadow);
            graphics.drawLine(rectangle.width - 2, 1, rectangle.width - 2, rectangle.height - 2);
            graphics.drawLine(rectangle.width - 3, rectangle.height - 2, 1, rectangle.height - 2);
        } else {
            graphics.setColor(sControl);
            graphics.fillRect(1, 1, rectangle.width - 2, rectangle.width - 2);
            graphics.setColor(sControlShadow);
            graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    private void drawScrollArrow(Graphics graphics, Rectangle rectangle, int n, int n2) {
        int n3;
        int n4 = rectangle.width / 2;
        boolean bl = n4 % 2 == 0;
        int n5 = bl ? n4 / 2 : n4 / 2 + 1;
        int[] nArray = new int[n5];
        int[] nArray2 = new int[n5];
        nArray[0] = n5 - 1;
        nArray2[0] = n5 - 1;
        for (n3 = 1; n3 < n5; ++n3) {
            nArray[n3] = nArray[n3 - 1] - 1;
            nArray2[n3] = nArray2[n3 - 1] + 1;
        }
        int n6 = n2 + (rectangle.width - n4) / 2;
        int n7 = n2 + (rectangle.width - n5) / 2;
        if (n == 0 || n == 2) {
            graphics.translate(n6 += rectangle.x, n7 += rectangle.y);
            for (n3 = 0; n3 < n5; ++n3) {
                int n8 = n == 0 ? n3 : n5 - n3 - 1;
                graphics.drawLine(nArray[n8], n3, nArray2[n8], n3);
            }
            graphics.translate(-n6, -n7);
        } else {
            graphics.translate(n7 += rectangle.x, n6 += rectangle.y);
            for (n3 = 0; n3 < n5; ++n3) {
                int n9 = n == 1 ? n3 : n5 - n3 - 1;
                graphics.drawLine(n3, nArray[n9], n3, nArray2[n9]);
            }
            graphics.translate(-n7, -n6);
        }
    }

    @Override
    void drawPopupControl(Graphics graphics, Rectangle rectangle, String string, boolean bl, boolean bl2, boolean bl3) {
        this.drawPopupControl(graphics, rectangle, string, bl, bl2, bl3, false);
    }

    void drawPopupControl(Graphics graphics, Rectangle rectangle, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = rectangle.width;
        int n2 = rectangle.height;
        Rectangle rectangle2 = new Rectangle(n - n2 + 2, 2, n2 - 4, n2 - 4);
        if ((rectangle2.width & 1) != 0) {
            ++rectangle2.x;
            --rectangle2.width;
        }
        graphics.translate(rectangle.x, rectangle.y);
        this.drawBevelFrame(graphics, 0, 0, n, n2);
        this.drawScrollArrowButton(graphics, rectangle2, bl, bl2, bl3, 0, 4);
        if (bl2) {
            if (bl4 || bl) {
                graphics.setColor(this.getColor(4));
            } else {
                graphics.setColor(this.getColor(2));
            }
        } else {
            graphics.setColor(this.getColor(6));
        }
        graphics.fillRect(2, 2, rectangle2.x - 2, n2 - 4);
        if ((bl4 || bl) && bl2) {
            bl4 = true;
            graphics.setColor(this.getColor(2));
            graphics.drawRect(2, 2, rectangle2.x - 3, n2 - 5);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
        if (string != null) {
            graphics.setColor(sWindowText);
            string = this.shortenString(string, fontMetrics, rectangle.width - rectangle.height - 4);
            this.drawLabel(graphics, string, rectangle.x + 4, rectangle.y + fontMetrics.getAscent() + fontMetrics.getLeading() + 2, false, bl2, bl4, sWindowText);
        }
    }

    @Override
    void drawComboControl(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3) {
        graphics.translate(rectangle.x, rectangle.y);
        int n = rectangle.width;
        int n2 = rectangle.height;
        Rectangle rectangle2 = new Rectangle(n - n2 + 2, 2, n2 - 4, n2 - 4);
        if ((rectangle2.width & 1) != 0) {
            ++rectangle2.x;
            --rectangle2.width;
        }
        this.drawBevelFrame(graphics, 0, 0, n, n2);
        this.drawScrollArrowButton(graphics, rectangle2, bl, bl2, bl3, 0, 4);
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    static {
        boolean bl;
        DEFAULT_FONT = new Font("Dialog", 0, 12);
        boolean bl2 = bl = PlatformInfo.getPlatform() == 1;
        if (bl) {
            sWindow = SystemColor.window;
            sWindowText = SystemColor.windowText;
            sDialog = SystemColor.control;
            sControl = SystemColor.control;
            sControlText = SystemColor.controlText;
            sControlLtHilite = SystemColor.controlLtHighlight;
            sControlHilite = SystemColor.controlHighlight;
            sControlShadow = SystemColor.controlShadow;
            sControlDkShadow = SystemColor.controlDkShadow;
            if (System.getProperty("os.name").indexOf("95") != -1) {
                sScrollbar = SystemColor.scrollbar;
            } else {
                int n = SystemColor.scrollbar.getRed();
                int n2 = SystemColor.scrollbar.getGreen();
                int n3 = SystemColor.scrollbar.getBlue();
                n += (255 - n) / 2;
                n2 += (255 - n2) / 2;
                n3 += (255 - n3) / 2;
                sScrollbar = new Color(n, n2, n3);
            }
            sTextHighlight = SystemColor.textHighlight;
            sTextHighlightText = SystemColor.textHighlightText;
            sText = SystemColor.window;
            sTextText = SystemColor.textText;
            sInactiveText = SystemColor.textInactiveText;
        } else {
            sWindow = Color.white;
            sWindowText = Color.black;
            sDialog = new Color(195, 195, 195);
            sControl = new Color(195, 195, 195);
            sControlText = Color.black;
            sControlLtHilite = Color.white;
            sControlHilite = new Color(195, 195, 195);
            sControlShadow = new Color(130, 130, 130);
            sControlDkShadow = Color.black;
            sScrollbar = new Color(225, 225, 225);
            sTextHighlight = new Color(0, 0, 128);
            sTextHighlightText = Color.white;
            sText = Color.white;
            sTextText = Color.black;
            sInactiveText = new Color(130, 130, 130);
        }
        RB_OUTLINE = new byte[]{0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 2, 2, 2, 2, 1, 1, 0, 0, 0, 1, 2, 2, 5, 5, 5, 5, 2, 2, 3, 0, 0, 1, 2, 5, 5, 5, 5, 5, 5, 4, 3, 0, 1, 2, 5, 5, 5, 5, 5, 5, 5, 5, 4, 3, 1, 2, 5, 5, 5, 5, 5, 5, 5, 5, 4, 3, 1, 2, 5, 5, 5, 5, 5, 5, 5, 5, 4, 3, 1, 2, 5, 5, 5, 5, 5, 5, 5, 5, 4, 3, 0, 1, 2, 5, 5, 5, 5, 5, 5, 4, 3, 0, 0, 1, 4, 4, 5, 5, 5, 5, 4, 5, 3, 0, 0, 0, 3, 3, 4, 4, 4, 4, 3, 3, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 0, 0, 0, 0};
    }
}

