/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.table;

import com.mathworks.mwt.table.CellImageResource;
import com.mathworks.mwt.table.LabeledImageResource;
import com.mathworks.mwt.table.Style;
import com.mathworks.mwt.table.Table;
import com.mathworks.mwt.table.TableUtils;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.File;

public class CellFile
extends CellImageResource {
    private static final int DISK_PIC = 0;
    private static final int FOLDER_PIC = 1;
    private static final int DOC_PIC = 2;
    private static final int M_PIC = 3;
    private static final int MAT_PIC = 4;
    private static final int MEX_PIC = 5;
    private static final int P_PIC = 6;
    private static final int PIC_COUNT = 7;
    private static final String[] IMAGES = new String[]{"/com/mathworks/resources/disk.gif", "/com/mathworks/resources/folder.gif", "/com/mathworks/resources/document.gif", "/com/mathworks/resources/m.gif", "/com/mathworks/resources/mat.gif", "/com/mathworks/resources/mex.gif", "/com/mathworks/resources/p.gif", "/com/mathworks/resources/diskwin.gif", "/com/mathworks/resources/folderwin.gif", "/com/mathworks/resources/documentwin.gif", "/com/mathworks/resources/mwin.gif", "/com/mathworks/resources/matwin.gif", "/com/mathworks/resources/mexwin.gif", "/com/mathworks/resources/pwin.gif"};
    private LabeledImageResource fWorkRsrc;

    public CellFile(Table table) {
        super(table);
    }

    @Override
    public void render(Graphics graphics, int n, int n2, Rectangle rectangle, Object object, Style style, boolean bl) {
        if (object instanceof File) {
            LabeledImageResource labeledImageResource = this.getImageResource((File)object);
            super.render(graphics, n, n2, rectangle, labeledImageResource, style, bl);
        }
    }

    private LabeledImageResource getImageResource(File file) {
        int n;
        int n2 = n = TableUtils.isMac() ? 0 : 7;
        if (this.fWorkRsrc == null) {
            this.fWorkRsrc = new LabeledImageResource("", "");
        }
        this.fWorkRsrc.setLabel(file.getName());
        if (file.getParent() == null && file.isDirectory()) {
            this.fWorkRsrc.setResourceName(IMAGES[0 + n]);
        } else if (file.isDirectory()) {
            this.fWorkRsrc.setResourceName(IMAGES[1 + n]);
        } else if (file.getName().endsWith(".m")) {
            this.fWorkRsrc.setResourceName(IMAGES[3 + n]);
        } else if (file.getName().endsWith(".mat")) {
            this.fWorkRsrc.setResourceName(IMAGES[4 + n]);
        } else if (file.getName().endsWith(".mex")) {
            this.fWorkRsrc.setResourceName(IMAGES[5 + n]);
        } else if (file.getName().endsWith(".p")) {
            this.fWorkRsrc.setResourceName(IMAGES[6 + n]);
        } else {
            this.fWorkRsrc.setResourceName(IMAGES[2 + n]);
        }
        return this.fWorkRsrc;
    }
}

