/*
 * Decompiled with CFR 0.152.
 */
package ice.crypto;

import ice.crypto.AlgorithmParameterSpec;
import ice.crypto.DHPrivateKey;
import ice.crypto.DHPublicKey;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import xjava.security.SecretKey;

public class DHKeyAgreement {
    private SecureRandom random;
    private DHPrivateKey x;
    private BigInteger secret;

    public void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        if (!(key instanceof DHPrivateKey)) {
            throw new InvalidKeyException("key must be an instance of DHPrivateKey");
        }
        this.x = (DHPrivateKey)key;
        this.random = random;
        this.secret = null;
    }

    public void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException {
        this.engineInit(key, random);
        this.secret = null;
    }

    public Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (!lastPhase) {
            return null;
        }
        if (!(key instanceof DHPublicKey)) {
            throw new InvalidKeyException("key must be an instance of DHPublicKey");
        }
        BigInteger secret = ((DHPublicKey)key).getY().modPow(this.x.getX(), this.x.getParams().getP());
        return null;
    }

    public byte[] engineGenerateSecret() throws IllegalStateException {
        if (this.secret == null) {
            throw new IllegalStateException("method DoPhase with propoer public key must be called first");
        }
        byte[] toReturn = this.secret.toByteArray();
        this.secret = null;
        return toReturn;
    }

    public int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException {
        if (this.secret == null) {
            throw new IllegalStateException("method doPhase with propoer public key must be called first");
        }
        if (this.secret.toByteArray().length > sharedSecret.length + offset) {
            throw new IllegalArgumentException("sharedSecret too small");
        }
        System.arraycopy(this.secret.toByteArray(), offset, sharedSecret, 0, this.secret.toByteArray().length);
        int toReturn = this.secret.toByteArray().length;
        this.secret = null;
        return toReturn;
    }

    public SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        throw new NoSuchAlgorithmException("the algorithm is not supported");
    }
}

