/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services;

import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;

public class AntialiasedFontPrefs {
    private static final String ANTIALIAS_DESKTOP_FONTS = "AntialiasDesktopFonts";

    private AntialiasedFontPrefs() {
    }

    public static boolean isDesktopFontAntialiased() {
        if (AntialiasedFontPrefs.isJavaUsingSystemAntialiasing()) {
            return false;
        }
        return Prefs.getBooleanPref("GeneralAntialiasDesktopFonts");
    }

    public static void setDesktopFontAntialiased(boolean bl) {
        if (AntialiasedFontPrefs.isJavaUsingSystemAntialiasing()) {
            throw new IllegalStateException("should only be setting antialiasing if  GraphicsUtils.isJavaUsingSystemAntialiasing() == false");
        }
        if (bl != Prefs.getBooleanPref("GeneralAntialiasDesktopFonts")) {
            Prefs.setBooleanPref("GeneralAntialiasDesktopFonts", bl);
        }
    }

    public static boolean isJavaUsingSystemAntialiasing() {
        return PlatformInfo.isMacintosh() || !PlatformInfo.isVersion15() && PlatformInfo.isWindows();
    }

    static {
        if (PlatformInfo.isXWindows() && AntialiasedFontPrefs.isDesktopFontAntialiased()) {
            System.setProperty("awt.useSystemAAFontSettings", "lcd");
        }
    }
}

