/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import com.sun.jini.action.GetLongAction;
import com.sun.jini.jeri.internal.http.HttpClientConnection;
import com.sun.jini.jeri.internal.http.HttpClientManager;
import com.sun.jini.jeri.internal.http.HttpClientSocketFactory;
import com.sun.jini.jeri.internal.http.HttpSettings;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.jeri.Endpoint;
import net.jini.jeri.OutboundRequest;
import net.jini.jeri.OutboundRequestIterator;
import net.jini.jeri.connection.Connection;
import net.jini.jeri.connection.OutboundRequestHandle;
import net.jini.jeri.ssl.CallContext;
import net.jini.jeri.ssl.SslConnection;
import net.jini.jeri.ssl.SslEndpointImpl;
import net.jini.security.Security;
import net.jini.security.proxytrust.TrustEquivalence;

public final class HttpsEndpoint
implements Endpoint,
Serializable,
TrustEquivalence {
    private static final long serialVersionUID = -3438786823613900804L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("serverHost", String.class), new ObjectStreamField("port", Integer.TYPE), new ObjectStreamField("socketFactory", SocketFactory.class)};
    static final Map endpointMap = new HashMap();
    static final long IDLE_TIMEOUT = (Long)Security.doPrivileged(new GetLongAction("com.sun.jini.jeri.https.idleConnectionTimeout", 15000L));
    static final Executor systemExecutor = (Executor)Security.doPrivileged(new GetThreadPoolAction(false));
    private static final long ACK_TIMEOUT = (Long)Security.doPrivileged(new GetLongAction("com.sun.jini.jeri.https.responseAckTimeout", 15000L));
    static final HttpClientManager httpClientManager = new HttpClientManager(ACK_TIMEOUT);
    private transient HttpsEndpointImpl impl;

    public static HttpsEndpoint getInstance(String string, int n) {
        return new HttpsEndpoint(string, n, null);
    }

    public static HttpsEndpoint getInstance(String string, int n, SocketFactory socketFactory) {
        return new HttpsEndpoint(string, n, socketFactory);
    }

    private HttpsEndpoint(String string, int n, SocketFactory socketFactory) {
        this.impl = new HttpsEndpointImpl(this, string, n, socketFactory);
    }

    public String getHost() {
        return this.impl.serverHost;
    }

    public int getPort() {
        return this.impl.port;
    }

    public SocketFactory getSocketFactory() {
        return this.impl.socketFactory;
    }

    public String toString() {
        return "HttpsEndpoint" + this.impl.fieldsToString();
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof HttpsEndpoint && this.impl.equals(((HttpsEndpoint)object).impl);
    }

    public OutboundRequestIterator newRequest(InvocationConstraints invocationConstraints) {
        return this.impl.newRequest(invocationConstraints);
    }

    public boolean checkTrustEquivalence(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof HttpsEndpoint && this.impl.equals(((HttpsEndpoint)object).impl);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("serverHost", this.impl.serverHost);
        putField.put("port", this.impl.port);
        putField.put("socketFactory", this.impl.socketFactory);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        String string = (String)getField.get("serverHost", null);
        int n = getField.get("port", 0);
        SocketFactory socketFactory = (SocketFactory)getField.get("socketFactory", null);
        if (string == null) {
            throw new InvalidObjectException("serverHost cannot be null");
        }
        if (n <= 0 || n > 65535) {
            throw new InvalidObjectException("Invalid port: " + n);
        }
        this.impl = new HttpsEndpointImpl(this, string, n, socketFactory);
    }

    private static final class Reaper
    implements Runnable {
        Reaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl;
            ArrayList arrayList = new ArrayList(1);
            do {
                try {
                    Thread.sleep(IDLE_TIMEOUT);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                long l = System.currentTimeMillis();
                Map map = endpointMap;
                synchronized (map) {
                    Iterator iterator = endpointMap.values().iterator();
                    while (iterator.hasNext()) {
                        EndpointInfo endpointInfo = (EndpointInfo)iterator.next();
                        if (!endpointInfo.checkIdle(l, arrayList)) continue;
                        iterator.remove();
                    }
                    bl = endpointMap.isEmpty();
                }
                int n = arrayList.size();
                while (--n >= 0) {
                    try {
                        ((HttpsConnection)arrayList.get(n)).close();
                    }
                    catch (IOException iOException) {}
                }
                arrayList.clear();
            } while (!bl);
        }
    }

    private static final class HttpsOutboundRequest
    implements OutboundRequest {
        private final OutboundRequest request;
        private final HttpsConnection connection;
        private final OutboundRequestHandle handle;

        HttpsOutboundRequest(OutboundRequest outboundRequest, HttpsConnection httpsConnection, OutboundRequestHandle outboundRequestHandle) {
            this.connection = httpsConnection;
            this.request = outboundRequest;
            this.handle = outboundRequestHandle;
        }

        public void populateContext(Collection collection) {
            this.connection.populateContext(this.handle, collection);
        }

        public InvocationConstraints getUnfulfilledConstraints() {
            return this.connection.getUnfulfilledConstraints(this.handle);
        }

        public OutputStream getRequestOutputStream() {
            return this.request.getRequestOutputStream();
        }

        public InputStream getResponseInputStream() {
            return this.request.getResponseInputStream();
        }

        public boolean getDeliveryStatus() {
            return this.request.getDeliveryStatus();
        }

        public void abort() {
            this.request.abort();
        }
    }

    private static final class EndpointInfo {
        private final HttpsEndpointImpl endpoint;
        private final List idle = new ArrayList(1);
        private final List inUse = new ArrayList(1);

        EndpointInfo(HttpsEndpointImpl httpsEndpointImpl) {
            this.endpoint = httpsEndpointImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        HttpsConnection connect(CallContext callContext) throws IOException {
            HttpsConnection httpsConnection;
            ArrayList arrayList = new ArrayList(0);
            this.checkIdle(System.currentTimeMillis(), arrayList);
            int n = arrayList.size();
            while (--n >= 0) {
                try {
                    ((HttpsConnection)arrayList.get(n)).close();
                }
                catch (IOException iOException) {}
            }
            Object object = this;
            synchronized (object) {
                httpsConnection = (HttpsConnection)this.endpoint.connect(callContext, Collections.EMPTY_SET, this.idle);
                if (httpsConnection != null) {
                    this.idle.remove(httpsConnection);
                } else {
                    httpsConnection = (HttpsConnection)this.endpoint.connect(callContext);
                }
            }
            object = endpointMap;
            synchronized (object) {
                EndpointInfo endpointInfo = (EndpointInfo)endpointMap.get(this.endpoint);
                if (endpointInfo == null) {
                    if (endpointMap.isEmpty()) {
                        systemExecutor.execute(new Reaper(), "HttpsEndpointReaper");
                    }
                    endpointMap.put(this.endpoint, this);
                    endpointInfo = this;
                }
                endpointInfo.noteInUse(httpsConnection);
            }
            return httpsConnection;
        }

        synchronized void noteInUse(HttpsConnection httpsConnection) {
            this.inUse.add(httpsConnection);
        }

        synchronized void noteClosed(HttpsConnection httpsConnection) {
            this.inUse.remove(httpsConnection);
        }

        synchronized void noteIdle(HttpsConnection httpsConnection) {
            this.inUse.remove(httpsConnection);
            this.idle.add(httpsConnection);
        }

        synchronized boolean checkIdle(long l, List list) {
            int n = this.idle.size();
            while (--n >= 0) {
                HttpsConnection httpsConnection = (HttpsConnection)this.idle.get(n);
                if (!httpsConnection.checkIdle(l)) continue;
                list.add(httpsConnection);
                this.idle.remove(httpsConnection);
            }
            return this.idle.isEmpty() && this.inUse.isEmpty();
        }
    }

    private static final class HttpClient
    extends HttpClientConnection {
        private final HttpsConnection connection;

        HttpClient(String string, int n, HttpsConnection httpsConnection) throws IOException {
            super(string, n, httpsConnection, httpClientManager);
            this.connection = httpsConnection;
        }

        HttpClient(String string, int n, String string2, int n2, HttpsConnection httpsConnection) throws IOException {
            super(string, n, string2, n2, true, httpsConnection, httpClientManager);
            this.connection = httpsConnection;
        }

        protected void idle() {
            this.connection.noteIdle();
        }

        public boolean shutdown(boolean bl) {
            boolean bl2 = super.shutdown(bl);
            if (bl2) {
                try {
                    this.connection.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return bl2;
        }
    }

    private static final class HttpsConnection
    extends SslConnection
    implements HttpClientSocketFactory {
        private final HttpsEndpointImpl endpoint;
        private final String proxyHost;
        private final int proxyPort;
        private HttpClientConnection httpClient;
        private long idleTime = 0L;

        HttpsConnection(HttpsEndpointImpl httpsEndpointImpl, CallContext callContext, String string, int n, SocketFactory socketFactory) throws IOException {
            super(callContext, string, n, socketFactory);
            this.endpoint = httpsEndpointImpl;
            HttpSettings httpSettings = (HttpSettings)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return HttpSettings.getHttpSettings();
                }
            });
            this.proxyHost = httpSettings.nonProxied(string, false) ? null : httpSettings.getHttpsProxyHost(null);
            this.proxyPort = this.proxyHost == null ? 0 : httpSettings.getHttpsProxyPort(443);
        }

        void establishNewSocket() throws IOException {
            this.httpClient = this.proxyHost == null ? new HttpClient(this.serverHost, this.port, this) : new HttpClient(this.serverHost, this.port, this.proxyHost, this.proxyPort, this);
        }

        OutboundRequest newRequest(CallContext callContext) throws IOException {
            HttpsOutboundRequest httpsOutboundRequest = new HttpsOutboundRequest(this.httpClient.newRequest(), this, callContext);
            this.idleTime = 0L;
            return httpsOutboundRequest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            HttpsConnection httpsConnection = this;
            synchronized (httpsConnection) {
                if (this.closed) {
                    return;
                }
            }
            super.close();
            if (this.httpClient != null) {
                this.httpClient.shutdown(true);
                this.httpClient = null;
            }
        }

        boolean checkIdle(long l) {
            if (this.idleTime == 0L) {
                this.idleTime = l;
                return false;
            }
            return l - this.idleTime > IDLE_TIMEOUT;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void noteIdle() {
            Map map = endpointMap;
            synchronized (map) {
                EndpointInfo endpointInfo = (EndpointInfo)endpointMap.get(this.endpoint);
                if (endpointInfo != null) {
                    endpointInfo.noteIdle(this);
                }
                this.idleTime = 0L;
            }
        }

        public Socket createSocket(String string, int n) throws IOException {
            Socket socket = this.createPlainSocket(string, n);
            if (this.proxyHost == null) {
                socket = this.setSSLSocket((SSLSocket)this.sslSocketFactory.createSocket(socket, string, n, true));
            }
            return socket;
        }

        public Socket createTunnelSocket(Socket socket) throws IOException {
            return this.setSSLSocket((SSLSocket)this.sslSocketFactory.createSocket(socket, socket.getInetAddress().getHostName(), socket.getPort(), true));
        }

        private Socket setSSLSocket(SSLSocket sSLSocket) throws IOException {
            this.sslSocket = sSLSocket;
            this.establishSuites();
            return this.sslSocket;
        }
    }

    private static final class HttpsEndpointImpl
    extends SslEndpointImpl {
        HttpsEndpointImpl(Endpoint endpoint, String string, int n, SocketFactory socketFactory) {
            super(endpoint, string, n, socketFactory);
        }

        OutboundRequestIterator newRequest(final CallContext callContext) {
            return new OutboundRequestIterator(){
                private boolean done;

                public synchronized boolean hasNext() {
                    return !this.done;
                }

                public synchronized OutboundRequest next() throws IOException {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.done = true;
                    return HttpsEndpointImpl.this.getOutboundRequest(callContext);
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        OutboundRequest getOutboundRequest(CallContext callContext) throws IOException {
            EndpointInfo endpointInfo;
            HttpsConnection httpsConnection = null;
            Map map = endpointMap;
            synchronized (map) {
                endpointInfo = (EndpointInfo)endpointMap.get(this);
                if (endpointInfo == null) {
                    endpointInfo = new EndpointInfo(this);
                }
            }
            httpsConnection = endpointInfo.connect(callContext);
            boolean bl = false;
            try {
                OutboundRequest outboundRequest = httpsConnection.newRequest(callContext);
                bl = true;
                logger.log(Level.FINE, "using {0}", httpsConnection);
                OutboundRequest outboundRequest2 = outboundRequest;
                Object var8_9 = null;
                if (!bl) {
                    endpointInfo.noteClosed(httpsConnection);
                }
                return outboundRequest2;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var8_10 = null;
                    if (bl) break block7;
                    endpointInfo.noteClosed(httpsConnection);
                }
                throw throwable;
            }
        }

        public Connection connect(OutboundRequestHandle outboundRequestHandle) throws IOException {
            HttpsConnection httpsConnection = new HttpsConnection(this, CallContext.coerce(outboundRequestHandle, this.endpoint), this.serverHost, this.port, this.socketFactory);
            httpsConnection.establishCallContext();
            return httpsConnection;
        }
    }
}

