/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.thread;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;

public final class NewThreadAction
implements PrivilegedAction {
    static final String NAME_PREFIX = "(JSK) ";
    static final ThreadGroup systemThreadGroup = (ThreadGroup)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            ThreadGroup threadGroup;
            ThreadGroup threadGroup2 = Thread.currentThread().getThreadGroup();
            while ((threadGroup = threadGroup2.getParent()) != null) {
                threadGroup2 = threadGroup;
            }
            return threadGroup2;
        }
    });
    static final ThreadGroup userThreadGroup = (ThreadGroup)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return new ThreadGroup(systemThreadGroup, "(JSK) Runtime");
        }
    });
    private static final Permission getClassLoaderPermission = new RuntimePermission("getClassLoader");
    private final ThreadGroup group;
    private final Runnable runnable;
    private final String name;
    private final boolean daemon;

    NewThreadAction(ThreadGroup threadGroup, Runnable runnable, String string, boolean bl) {
        this.group = threadGroup;
        this.runnable = runnable;
        this.name = string;
        this.daemon = bl;
    }

    public NewThreadAction(Runnable runnable, String string, boolean bl) {
        this(systemThreadGroup, runnable, string, bl);
    }

    public NewThreadAction(Runnable runnable, String string, boolean bl, boolean bl2) {
        this(bl2 ? userThreadGroup : systemThreadGroup, runnable, string, bl);
    }

    public Object run() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(getClassLoaderPermission);
        }
        Thread thread = new Thread(this.group, this.runnable, NAME_PREFIX + this.name);
        thread.setContextClassLoader(ClassLoader.getSystemClassLoader());
        thread.setDaemon(this.daemon);
        return thread;
    }
}

