/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.runtime;

import com.sun.jini.jeri.internal.runtime.AbstractDgcClient;
import com.sun.jini.jeri.internal.runtime.DgcServer;
import com.sun.jini.jeri.internal.runtime.Jeri;
import com.sun.jini.logging.Levels;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.jeri.BasicInvocationHandler;
import net.jini.jeri.BasicObjectEndpoint;
import net.jini.jeri.Endpoint;

public final class DgcClient
extends AbstractDgcClient {
    private static final Logger logger;
    private static final Class[] proxyInterfaces;
    private static final Uuid clientID;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void registerRefs(Endpoint endpoint, Collection collection) {
        super.registerRefs(endpoint, collection);
    }

    protected AbstractDgcClient.DgcProxy getDgcProxy(Object object) {
        Endpoint endpoint = (Endpoint)object;
        BasicObjectEndpoint basicObjectEndpoint = new BasicObjectEndpoint(endpoint, Jeri.DGC_ID, false);
        BasicInvocationHandler basicInvocationHandler = new BasicInvocationHandler(basicObjectEndpoint, null);
        DgcServer dgcServer = (DgcServer)Proxy.newProxyInstance(this.getClass().getClassLoader(), proxyInterfaces, (InvocationHandler)basicInvocationHandler);
        return new DgcProxyImpl(dgcServer);
    }

    protected void freeEndpoint(Object object) {
    }

    protected Object getRefEndpoint(Object object) {
        BasicObjectEndpoint basicObjectEndpoint = (BasicObjectEndpoint)object;
        if (!$assertionsDisabled && !basicObjectEndpoint.getEnableDGC()) {
            throw new AssertionError();
        }
        return basicObjectEndpoint.getEndpoint();
    }

    protected Object getRefObjectID(Object object) {
        BasicObjectEndpoint basicObjectEndpoint = (BasicObjectEndpoint)object;
        if (!$assertionsDisabled && !basicObjectEndpoint.getEnableDGC()) {
            throw new AssertionError();
        }
        return basicObjectEndpoint.getObjectIdentifier();
    }

    static {
        $assertionsDisabled = !DgcClient.class.desiredAssertionStatus();
        logger = Logger.getLogger("net.jini.jeri.BasicObjectEndpoint");
        proxyInterfaces = new Class[]{DgcServer.class};
        clientID = UuidFactory.generate();
    }

    private class DgcProxyImpl
    implements AbstractDgcClient.DgcProxy {
        private final DgcServer dgcServer;

        DgcProxyImpl(DgcServer dgcServer) {
            this.dgcServer = dgcServer;
        }

        public long dirty(final long l, Object[] objectArray, long l2) throws RemoteException {
            final Uuid[] uuidArray = new Uuid[objectArray.length];
            System.arraycopy(objectArray, 0, uuidArray, 0, objectArray.length);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "sequenceNum={0}, ids={1} (clientID={2})", new Object[]{new Long(l), Arrays.asList(uuidArray), clientID});
            }
            try {
                return (Long)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws RemoteException {
                        long l2 = DgcProxyImpl.this.dgcServer.dirty(clientID, l, uuidArray);
                        return new Long(l2);
                    }
                }, null);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (logger.isLoggable(Levels.HANDLED)) {
                    logger.log(Levels.HANDLED, "exception occurred", privilegedActionException.getCause());
                }
                throw (RemoteException)privilegedActionException.getCause();
            }
        }

        public void clean(final long l, Object[] objectArray, final boolean bl) throws RemoteException {
            final Uuid[] uuidArray = new Uuid[objectArray.length];
            System.arraycopy(objectArray, 0, uuidArray, 0, objectArray.length);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "sequenceNum={0}, ids={1}, strong={2} (clientID={3})", new Object[]{new Long(l), Arrays.asList(uuidArray), bl, clientID});
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws RemoteException {
                        DgcProxyImpl.this.dgcServer.clean(clientID, l, uuidArray, bl);
                        return null;
                    }
                }, null);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (logger.isLoggable(Levels.HANDLED)) {
                    logger.log(Levels.HANDLED, "exception occurred", privilegedActionException.getCause());
                }
                throw (RemoteException)privilegedActionException.getCause();
            }
        }
    }
}

