/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.mux;

import com.sun.jini.action.GetIntegerAction;
import com.sun.jini.jeri.internal.mux.Mux;
import com.sun.jini.jeri.internal.mux.ProtocolException;
import com.sun.jini.jeri.internal.mux.Session;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.InboundRequest;
import net.jini.jeri.RequestDispatcher;
import net.jini.security.Security;
import net.jini.security.SecurityContext;

public class MuxServer
extends Mux {
    private static final int serverInitialInboundRation;
    private static final Executor userThreadPool;
    private final RequestDispatcher requestDispatcher;
    private final SecurityContext securityContext;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MuxServer(OutputStream outputStream, InputStream inputStream, RequestDispatcher requestDispatcher) throws IOException {
        super(outputStream, inputStream, 1, serverInitialInboundRation, 1024);
        this.requestDispatcher = requestDispatcher;
        this.securityContext = Security.getContext();
    }

    public MuxServer(SocketChannel socketChannel, RequestDispatcher requestDispatcher) throws IOException {
        super(socketChannel, 1, serverInitialInboundRation, 1024);
        this.requestDispatcher = requestDispatcher;
        this.securityContext = Security.getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(String string) {
        Object object = this.muxLock;
        synchronized (object) {
            if (this.serverConnectionReady && this.busySessions.isEmpty()) {
                this.asyncSendShutdown(null);
            }
            this.setDown(string, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdownGracefully() {
        Object object = this.muxLock;
        synchronized (object) {
            if (this.busySessions.isEmpty()) {
                this.asyncSendShutdown(null);
                this.setDown("mux connection shut down gracefully", null);
                return true;
            }
            return false;
        }
    }

    protected void checkPermissions() {
    }

    protected InvocationConstraints checkConstraints(InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
        if (invocationConstraints.requirements().isEmpty()) {
            return InvocationConstraints.EMPTY;
        }
        throw new UnsupportedConstraintException("cannot satisfy constraints: " + invocationConstraints);
    }

    protected void populateContext(Collection collection) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleOpen(int n) throws ProtocolException {
        Session session;
        if (!$assertionsDisabled && Thread.holdsLock(this.muxLock)) {
            throw new AssertionError();
        }
        Object object = this.muxLock;
        synchronized (object) {
            if (!this.busySessions.get(n)) {
                this.dispatchNewRequest(n);
                return;
            }
            session = (Session)this.sessions.get(new Integer(n));
            if (!$assertionsDisabled && session == null) {
                throw new AssertionError();
            }
        }
        session.handleOpen();
        object = this.muxLock;
        synchronized (object) {
            this.dispatchNewRequest(n);
        }
    }

    private void dispatchNewRequest(int n) throws ProtocolException {
        if (!$assertionsDisabled && !Thread.holdsLock(this.muxLock)) {
            throw new AssertionError();
        }
        if (this.muxDown) {
            throw new ProtocolException("connection down, cannot add new session");
        }
        final Session session = new Session(this, n, 1);
        this.addSession(n, session);
        userThreadPool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                final InboundRequest inboundRequest = session.getInboundRequest();
                try {
                    AccessController.doPrivileged(MuxServer.this.securityContext.wrap(new PrivilegedAction(){

                        public Object run() {
                            MuxServer.this.requestDispatcher.dispatch(inboundRequest);
                            return null;
                        }
                    }), MuxServer.this.securityContext.getAccessControlContext());
                    Object var3_2 = null;
                    inboundRequest.abort();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    inboundRequest.abort();
                    throw throwable;
                }
            }
        }, "Mux request dispatch");
    }

    static {
        $assertionsDisabled = !MuxServer.class.desiredAssertionStatus();
        serverInitialInboundRation = (Integer)AccessController.doPrivileged(new GetIntegerAction("com.sun.jini.jeri.connection.mux.server.initialInboundRation", 32768));
        userThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(true));
    }
}

