/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.http;

import com.sun.jini.jeri.internal.http.HttpParseException;
import com.sun.jini.jeri.internal.http.MessageReader;
import com.sun.jini.jeri.internal.http.MessageWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;

class Header {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'");
    private Map fields = new HashMap(5);

    Header() {
    }

    Header(InputStream inputStream) throws IOException {
        String string = MessageReader.readLine(inputStream);
        while (string != null && string.length() > 0) {
            String string2 = MessageReader.readLine(inputStream);
            while (string2 != null && string2.length() > 0 && Header.isSpaceOrTab(string2.charAt(0))) {
                string = string + string2;
                string2 = MessageReader.readLine(inputStream);
            }
            int n = string.indexOf(58);
            if (n < 0) {
                throw new HttpParseException("header line missing separator");
            }
            String string3 = string.substring(0, n).trim();
            String string4 = string.substring(n + 1).trim();
            if (string3.length() == 0) {
                throw new HttpParseException("invalid header field name");
            }
            this.addField(string3, string4);
            string = string2;
        }
        if (string == null) {
            throw new HttpParseException("unexpected EOF in message header");
        }
    }

    String getField(String string) {
        return (String)this.fields.get(new FieldKey(string));
    }

    void setField(String string, String string2) {
        FieldKey fieldKey = new FieldKey(string);
        if (string2 != null) {
            this.fields.put(fieldKey, string2);
        } else {
            this.fields.remove(fieldKey);
        }
    }

    boolean containsValue(String string, String string2, boolean bl) {
        String string3 = this.getField(string);
        if (string3 != null) {
            string2 = string2.trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken().trim();
                if (!(bl ? string2.equalsIgnoreCase(string4) : string2.equals(string4))) continue;
                return true;
            }
        }
        return false;
    }

    int size() {
        return this.fields.size();
    }

    void merge(Header header) {
        if (header != null) {
            Iterator iterator = header.fields.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.addField(((FieldKey)entry.getKey()).name, (String)entry.getValue());
            }
        }
    }

    void write(OutputStream outputStream) throws IOException {
        Iterator iterator = this.fields.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            MessageWriter.writeLine(outputStream, ((FieldKey)entry.getKey()).name + ": " + (String)entry.getValue());
        }
        MessageWriter.writeLine(outputStream, "");
    }

    static String getDateString(long l) {
        return dateFormat.format(new Date(l));
    }

    private static boolean isSpaceOrTab(char c) {
        return c == ' ' || c == '\t';
    }

    private void addField(String string, String string2) {
        if (string2 != null) {
            FieldKey fieldKey = new FieldKey(string);
            String string3 = (String)this.fields.get(fieldKey);
            String string4 = string3 != null ? string3 + ", " + string2 : string2;
            this.fields.put(fieldKey, string4);
        }
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private static class FieldKey {
        final String name;
        private final int hash;

        FieldKey(String string) {
            this.name = string;
            this.hash = string.toLowerCase().hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof FieldKey) {
                return this.name.equalsIgnoreCase(((FieldKey)object).name);
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

