/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.CSSManager;
import ice.pilots.html4.CSSMatcher;
import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.ComponentFactory;
import ice.pilots.html4.CoordsList;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DFormElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DNodeListeners;
import ice.pilots.html4.DOM;
import ice.pilots.html4.DOMBuilder;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DOptionElement;
import ice.pilots.html4.DSelectElement;
import ice.pilots.html4.DStyleSheet;
import ice.pilots.html4.DTextAreaElement;
import ice.pilots.html4.DefaultActionHandler;
import ice.pilots.html4.DefaultEventHandler;
import ice.pilots.html4.DocAction;
import ice.pilots.html4.DocPaneXml;
import ice.pilots.html4.FormTypeElement;
import ice.pilots.html4.FramesDivider;
import ice.pilots.html4.FramesetData;
import ice.pilots.html4.Lex2;
import ice.pilots.html4.LexCallback;
import ice.pilots.html4.ObjectPool;
import ice.pilots.html4.OnresizeListener;
import ice.pilots.html4.RefreshItem;
import ice.pilots.html4.Search;
import ice.pilots.html4.StormData;
import ice.pilots.html4.ThePrinter;
import ice.pilots.html4.TheView;
import ice.storm.ContentLoader;
import ice.storm.DocPane;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.storm.Pilot;
import ice.storm.Scripter;
import ice.storm.StormBase;
import ice.storm.StormPrinter;
import ice.storm.Viewport;
import ice.util.Defs;
import ice.util.ICEException;
import ice.util.alg.CharKit;
import ice.util.alg.HashArray;
import ice.util.io.IOKit;
import ice.util.security.BoxedCode;
import ice.util.security.SecurityKit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.EventListener;

public class ThePilot
extends Pilot {
    private Object clearContextLock = new Object();
    private boolean contextCleared = false;
    private boolean wasDisposed;
    StormData sdata;
    boolean isFromHistory = false;
    boolean isLoadedSynchronously = false;
    private DDocument doc;
    private CSSLayout cssLayout;
    ObjectPool objectPool;
    private ComponentFactory componentFactory;
    FramesetData framesetData;
    private boolean loadSingleOnly = false;
    public static final boolean viewNoframes = Defs.booleanProperty((String)"ice.pilots.html4.view_noframes");
    private String defaultEncoding = null;
    private String encoding = null;
    private boolean lockedEncoding = false;
    Object[] persistentDomListeners;
    DefaultEventHandler defaultEventHandler;
    private Lex2 currentLexer;
    private boolean lexerShouldFinishOnScriptEnd;
    private boolean allowedToLoadImages = true;
    volatile int noLayoutUpdate;
    HashArray tmpBodyEventHandlers;
    private static final int Field_DOMImplementation = 1;
    private static final int Field_event = 2;
    private static final int Field_pageXOffset = 3;
    private static final int Field_pageYOffset = 4;
    private static final int Method_ActiveXObject = -1;
    private static final int Method_Option = -2;

    public void init(String string) {
        block3: {
            super.init(string);
            this.sdata = StormData.get(this.getStorm());
            this.loadSingleOnly = this.sdata.getLoadSingleOnly();
            if (!"none".equalsIgnoreCase(string)) {
                try {
                    this.componentFactory = (ComponentFactory)Class.forName("ice.pilots.html4." + string + ".TheFactory").newInstance();
                }
                catch (Exception exception) {
                    if (!Debug.ex) break block3;
                    Debug.ex((Throwable)exception);
                }
            }
        }
        this.defaultEncoding = Defs.sysProperty((String)"ice.pilots.html4.defaultEncoding");
        this.doc = DOM.getInstance(this.sdata).createDDocument(this, true);
        this.objectPool = new ObjectPool(this);
        String string2 = this.componentFactory == null ? "none" : this.componentFactory.getMedia();
        this.cssLayout = this.createCSSLayout(string2, this.doc);
        this.defaultEventHandler = new DefaultActionHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isDisposed() {
        ThePilot thePilot = this;
        synchronized (thePilot) {
            return this.wasDisposed;
        }
    }

    public void beforeUnload() {
        DElement dElement = !this.doc.isFrameset ? this.doc.getDBody() : ThePilot.search_unload_frameset_r(this.doc.getDocumentDElement());
        this.doc.processEvent(14, dElement);
    }

    private static DElement search_unload_frameset_r(DElement dElement) {
        DElement dElement2 = null;
        DNode dNode = dElement.getLastDChild();
        while (dNode != null) {
            if (dNode.getNameId() == 34) {
                DElement dElement3 = (DElement)dNode;
                dElement2 = ThePilot.search_unload_frameset_r(dElement3);
                if (dElement2 != null) break;
                String string = dElement3.getAttribute("onunload");
                if (string != null) {
                    dElement2 = dElement3;
                    break;
                }
            }
            dNode = dNode.prev;
        }
        return dElement2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this;
        synchronized (object) {
            if (this.wasDisposed) {
                if (Debug.trace) {
                    Debug.traceStack((String)"Double dispose, please report this to ICEsoft");
                }
                return;
            }
            this.wasDisposed = true;
        }
        object = this.framesetData;
        if (object != null) {
            ((FramesetData)object).dispose();
        }
        this.framesetData = null;
        this.persistentDomListeners = null;
        this.defaultEventHandler = null;
        if (this.componentFactory != null) {
            this.componentFactory.dispose();
        }
        this.cssLayout.clear();
        this.objectPool.dispose();
        this.doc.clear();
        super.dispose();
    }

    protected CSSLayout createCSSLayout(String string, DDocument dDocument) {
        CSSMatcher cSSMatcher = new CSSMatcher(string, this.sdata, dDocument);
        CSSLayout cSSLayout = null;
        if (string.equals("screen") || string.equals("none")) {
            cSSLayout = new CSSLayout(this.sdata, dDocument, cSSMatcher);
        } else if (string.equals("print")) {
            cSSLayout = new ThePrinter(this.sdata, dDocument, cSSMatcher).getCSSLayout();
        } else {
            throw new IllegalArgumentException();
        }
        return cSSLayout;
    }

    public Dimension getDocumentDimension(Dimension dimension) {
        dimension.width = this.cssLayout.getWidth();
        dimension.height = this.cssLayout.getHeight();
        return dimension;
    }

    public Dimension getViewDimension(Dimension dimension) {
        if (this.cssLayout.docPane != null) {
            dimension.width = this.cssLayout.docPane.getPaneWidth();
            dimension.height = this.cssLayout.docPane.getPaneHeight();
        }
        return dimension;
    }

    public void setEncoding(String string) {
        this.defaultEncoding = string;
    }

    public String getEncoding() {
        return this.defaultEncoding;
    }

    public String getPageInfo(String string) {
        return this.doc.getHttpProperty("_http_" + string);
    }

    public Component createComponent() {
        DocPaneXml docPaneXml;
        String string = (String)this.getViewportProperty("encoding");
        if (string != null) {
            this.defaultEncoding = string;
        }
        if (this.componentFactory != null && (docPaneXml = this.componentFactory.createDocPane()) != null) {
            int n = 0;
            String string2 = (String)this.getViewportProperty("scrolling");
            if (string2 != null) {
                if (string2.equalsIgnoreCase("yes")) {
                    n = 1;
                } else if (string2.equalsIgnoreCase("no")) {
                    n = 2;
                }
            }
            docPaneXml.init(n);
            docPaneXml.bind(this, this.cssLayout);
            return docPaneXml.getPaneComponent();
        }
        return null;
    }

    public StormPrinter createPrinter() {
        CSSLayout cSSLayout = this.createCSSLayout("print", this.doc);
        return new ThePrinter(cSSLayout, this.getPilotViewport());
    }

    void putBaseUrl(String string) {
        this.getPilotViewport().setBaseUrl(string);
    }

    public boolean refExists(String string) {
        return this.cssLayout.refExists(string);
    }

    public void gotoRef(String string) {
        DocPaneXml docPaneXml = this.cssLayout.docPane;
        if (docPaneXml == null) {
            return;
        }
        DNode dNode = null;
        if (string == null) {
            docPaneXml.setScrollPosition(0, 0);
            dNode = this.doc.getDBody();
        } else {
            int n = this.cssLayout.getRefPos(string);
            if (n >= 0) {
                docPaneXml.setScrollPosition(0, n);
                dNode = string != null ? this.cssLayout.getRefNode(string) : this.doc.getDBody();
            } else if ("top".equalsIgnoreCase(string)) {
                docPaneXml.setScrollPosition(0, 0);
                dNode = this.doc.getDBody();
            }
        }
        if (dNode != null) {
            this.doc.processEvent(30, dNode);
        }
    }

    public final Document getDocument() {
        return this.getDDocument();
    }

    public DDocument getDDocument() {
        return this.doc;
    }

    final CSSLayout getCSSLayout() {
        return this.cssLayout;
    }

    public TheView getView() {
        return this.cssLayout.theView;
    }

    public DocPane getDocPane() {
        return this.cssLayout.docPane;
    }

    public String getSelectedText() {
        return this.cssLayout.selection.toString();
    }

    public Search getSearch() {
        return new Search(this.doc, this.cssLayout);
    }

    Object doScriptEval(String string, String string2, String string3, int n) {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        Scripter scripter = this.getStorm().getScripter(string);
        if (scripter == null) {
            return null;
        }
        return scripter.eval(this.getPilotViewport(), string2, string3, n);
    }

    private boolean doScriptHandlerEval(String string, Object object, DynamicObject dynamicObject, DynamicObject dynamicObject2) {
        Scripter scripter = this.getStorm().getScripter(string);
        if (scripter == null) {
            return true;
        }
        return scripter.evalEventHandler(this.getPilotViewport(), dynamicObject2, object, dynamicObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void do_document_write(String string) {
        boolean bl = false;
        if (this.currentLexer == null) {
            Object object;
            Viewport viewport = this.getPilotViewport();
            Viewport viewport2 = viewport.getContextViewport();
            String string2 = null;
            if (viewport2 != null) {
                string2 = viewport2.getBaseUrl();
            }
            this.getStorm().clearViewportContent("text/html", viewport);
            if (viewport == viewport2) {
                object = this.clearContextLock;
                synchronized (object) {
                    this.contextCleared = true;
                }
            }
            viewport.setLocationUrl(string2);
            object = new DOMBuilder(this.doc, this);
            this.currentLexer = new Lex2((LexCallback)object);
            this.lexerShouldFinishOnScriptEnd = true;
            bl = true;
        }
        this.currentLexer.appendGeneratedContent(string);
        try {
            this.currentLexer.parse(bl, false);
        }
        catch (IOException iOException) {
            Debug.ex((Throwable)iOException);
        }
    }

    void do_document_close() {
        if (this.currentLexer != null && this.lexerShouldFinishOnScriptEnd) {
            block3: {
                this.lexerShouldFinishOnScriptEnd = false;
                try {
                    this.currentLexer.parse(false, true);
                }
                catch (IOException iOException) {
                    if (!Debug.ex) break block3;
                    Debug.ex((Throwable)iOException);
                }
            }
            this.currentLexer = null;
            this.finalize_parsing(null);
        }
    }

    private void checkLayoutProperties() {
        this.cssLayout.doImageAnimation = Defs.sysPropertyBoolean((String)"ice.pilots.html4.imageAnimation", (boolean)true);
        try {
            int n;
            String string = Defs.sysProperty((String)"ice.pilots.html4.minFontSize");
            if (string != null && (n = CSSUtil.parseInt(string, -1)) >= 4) {
                this.sdata.fontCache.setMinFontSize(n);
            }
            if ((string = Defs.sysProperty((String)"ice.pilots.html4.baseFontSize")) != null && (n = CSSUtil.parseInt(string, -1)) >= 4) {
                this.sdata.fontCache.setBaseFontSize(n);
            }
            if ((string = Defs.sysProperty((String)"ice.pilots.html4.baseFontFamily")) != null) {
                this.sdata.fontCache.setBaseFontFamily(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void refresh() {
        this.checkLayoutProperties();
        this.doc.mutate();
        this.cssLayout.validateLayout();
    }

    protected void setZoom(int n) {
        this.cssLayout.setLayoutZoom(n);
    }

    public void suspend() {
        if (this.cssLayout != null) {
            this.cssLayout.clear();
        }
    }

    public void resume() {
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(String string) {
        ThePilot thePilot;
        ThePilot thePilot2 = this;
        synchronized (thePilot2) {
            ++this.noLayoutUpdate;
        }
        try {
            this.do_clear(string);
            Object var5_4 = null;
            thePilot = this;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ThePilot thePilot3 = this;
            synchronized (thePilot3) {
                --this.noLayoutUpdate;
            }
            throw throwable;
        }
        synchronized (thePilot) {
            --this.noLayoutUpdate;
        }
    }

    private void do_clear(String string) {
        this.allowedToLoadImages = true;
        FramesetData framesetData = this.framesetData;
        if (framesetData != null) {
            framesetData.dispose();
        }
        this.framesetData = null;
        this.cssLayout.clear();
        this.objectPool.dispose();
        this.objectPool = new ObjectPool(this);
        this.doc.clear();
        if (CSSLayout.forceGC) {
            System.gc();
        }
        String string2 = string.toLowerCase();
        if (Debug.trace) {
            Debug.trace((String)("contentType ==" + string + " tmp == " + string2));
        }
        if (string2.indexOf("html") > 0 || string2.indexOf("unknown") >= 0) {
            this.doc.setHtmlMode(true);
        } else {
            this.doc.setHtmlMode(false);
        }
        this.encoding = this.defaultEncoding;
        int n = string2.indexOf("charset");
        if (n > 0 && (n = string.indexOf(61, n)) > 0) {
            this.encoding = string.substring(n + 1).trim();
        }
        this.lockedEncoding = false;
        this.checkLayoutProperties();
        this.firePropertyChange("title", null, "");
    }

    public void stopImageAnimation() {
        this.cssLayout.doImageAnimation = false;
    }

    public void stopLoading() {
        this.allowedToLoadImages = false;
        this.objectPool.stopImageLoading();
    }

    public void onLowMemory() {
        this.stopLoading();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPersistentDOMEventListener(String string, EventListener eventListener, boolean bl) {
        ThePilot thePilot = this;
        synchronized (thePilot) {
            this.persistentDomListeners = DNodeListeners.addEventListener(this.persistentDomListeners, string, bl, eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePersistentDOMEventListener(String string, EventListener eventListener, boolean bl) {
        ThePilot thePilot = this;
        synchronized (thePilot) {
            this.persistentDomListeners = DNodeListeners.removeEventListener(this.persistentDomListeners, string, bl, eventListener);
        }
    }

    public DefaultEventHandler getDefaultEventHandler() {
        return this.defaultEventHandler;
    }

    public void setDefaultEventHandler(DefaultEventHandler defaultEventHandler) {
        if (defaultEventHandler == null) {
            throw new IllegalArgumentException();
        }
        this.defaultEventHandler = defaultEventHandler;
    }

    public void setKeyHandler(KeyAdapter keyAdapter) {
        if (this.defaultEventHandler != null) {
            this.defaultEventHandler.setKeyHandler(keyAdapter);
        }
    }

    public void setCursorChangeable(boolean bl) {
        if (this.cssLayout.theView != null && this.cssLayout.docPane != null) {
            this.cssLayout.docPane.setCursorChangeable(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(ContentLoader contentLoader) throws IOException {
        ThePilot thePilot;
        this.isFromHistory = contentLoader.isFromHistory();
        ThePilot thePilot2 = this;
        synchronized (thePilot2) {
            ++this.noLayoutUpdate;
        }
        try {
            this.setCursor(3);
            this.do_parse(contentLoader);
            Object var5_4 = null;
            thePilot = this;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ThePilot thePilot3 = this;
            synchronized (thePilot3) {
                --this.noLayoutUpdate;
            }
            throw throwable;
        }
        synchronized (thePilot) {
            --this.noLayoutUpdate;
        }
        if (!this.getPilotViewport().isStopRequested()) {
            this.finalize_parsing(contentLoader.getLocation());
        }
        this.setCursor(0);
    }

    public void setCursor(int n) {
        DocPane docPane = this.getDocPane();
        if (docPane == null) {
            return;
        }
        docPane.setCursor(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void do_parse(ContentLoader contentLoader) throws IOException {
        Lex2 lex2;
        DOMBuilder dOMBuilder = new DOMBuilder(this.doc, this);
        this.currentLexer = lex2 = new Lex2(dOMBuilder);
        this.doc.cookieSet = contentLoader.getCookieSet();
        if (this.doc.cookieSet == null) {
            this.doc.cookieSet = this.sdata.getCookieSet();
        }
        try {
            Object object;
            String string;
            String string2 = this.extractCharset(contentLoader.getContentType());
            if (string2 != null) {
                this.encoding = string2;
                this.lockedEncoding = true;
            }
            int n = 1;
            while (true) {
                string = contentLoader.getHeaderFieldKey(n);
                String string3 = contentLoader.getHeaderField(n);
                if (string == null || string3 == null) break;
                if (string.equalsIgnoreCase("set-cookie")) {
                    this.doc.setCookie(string3);
                } else {
                    String string4 = System.getProperty("http.useCharset");
                    if (string4 != null && string4.equalsIgnoreCase("true") && !this.lockedEncoding && string.equalsIgnoreCase("content-type") && (string2 = this.extractCharset(string3)) != null) {
                        this.encoding = string2;
                    }
                    this.doc.setHttpProperty("_http_" + string.toLowerCase(), string3);
                }
                ++n;
            }
            try {
                object = contentLoader.getRequestProperty("referer");
                if (object != null) {
                    this.doc.setHttpProperty("_http_referer", (String)object);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            object = contentLoader.getInputStream();
            if (object == null) {
                throw new IOException("Could not connect to: " + contentLoader.getLocation());
            }
            string = contentLoader.getLocation();
            if (string != null) {
                this.firePropertyChange("location", null, string);
            }
            this.doc.setDefaultCharset(this.encoding);
            lex2.setInputStream((InputStream)object, this.encoding);
            lex2.setLockedEncoding(this.lockedEncoding);
            try {
                lex2.parse();
                if (Debug.trace && this.doc == null) {
                    Debug.trace((String)"do_parse: Document is null");
                }
                if (this.doc != null) {
                    this.doc.setDefaultCharset(lex2.getEncoding());
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new ICEException(1, 3, 2);
            }
            catch (RuntimeException runtimeException) {
                if (Debug.ex) {
                    Debug.ex((Throwable)runtimeException);
                }
                if (Debug.trace) {
                    Debug.trace((String)"Do not be scared - this exception is caught!");
                }
                throw new IOException("Parsing problem");
            }
            catch (IOException iOException) {
                throw iOException;
            }
            finally {
                ((InputStream)object).close();
            }
        }
        finally {
            this.currentLexer = null;
        }
    }

    private String extractCharset(String string) {
        String string2 = null;
        int n = string.toLowerCase().indexOf("charset");
        if (n != -1 && (n = string.indexOf(61, n)) != -1 && n != string.length() - 1) {
            string2 = string.substring(++n).trim();
        }
        return string2;
    }

    public void parsingDone() {
        if (this.doc != null && this.doc.isFrameset) {
            this.firePropertyChange("contentRendering", null, "end");
            this.firePropertyChange("outstandingImages", null, "0");
        } else if (this.doc != null) {
            this.cssLayout.refresh(true);
        }
    }

    private void finalize_parsing(String string) {
        DElement dElement;
        Object object;
        Object object2;
        if (Debug.trace && this.doc == null) {
            Debug.trace((String)"finalize_parsing: Document is null");
        }
        if (this.doc == null) {
            return;
        }
        if (this.doc.isFrameset && !viewNoframes && !this.loadSingleOnly) {
            this.processFrameset();
        } else {
            int n;
            if (string != null && (n = string.indexOf(35) + 1) > 0 && n < string.length()) {
                object2 = string.substring(n);
                this.cssLayout.setWaitForRef((String)object2);
            }
            object = (String)this.getViewportProperty("marginwidth");
            object2 = (String)this.getViewportProperty("marginheight");
            if ((object != null || object2 != null) && (dElement = this.doc.getDBody()) != null) {
                if (object != null) {
                    dElement.setAttribute(58, (String)object);
                }
                if (object2 != null) {
                    dElement.setAttribute(57, (String)object2);
                }
                this.doc.mutate();
            }
        }
        object = this.doc.getHead();
        if (object != null) {
            object2 = ((DNode)object).getFirstDChild();
            while (object2 != null) {
                String string2;
                if (((DNode)object2).getNameId() == 57 && (string2 = (dElement = (DElement)object2).getAttribute(49)) != null && string2.equalsIgnoreCase("refresh") && (string2 = dElement.getAttribute(31)) != null) {
                    this.setupRefresh(string2);
                }
                object2 = ((DNode)object2).next;
            }
        }
    }

    void onLayoutEnd() {
        DElement dElement;
        this.firePropertyChange("contentRendering", null, "end");
        if (this.currentLexer == null && (dElement = this.doc.getDBody()) != null && this.cssLayout.docPane != null) {
            this.cssLayout.docPane.updateScrollbars(this.doc.isRTL());
        }
    }

    public void onLoadingDone() {
        this.firePropertyChange("contentRendering", null, "finished");
        this.objectPool.fireOutstandingImagesEvent();
        DElement dElement = this.doc.getDBody();
        if (dElement != null) {
            this.doc.processEvent(this.doc.createDOMEvent(13, dElement));
        } else {
            FramesetData framesetData = this.framesetData;
            if (framesetData != null) {
                framesetData.sendFramesetOnload();
            }
        }
    }

    boolean canLoadImages() {
        return this.allowedToLoadImages;
    }

    void updateFrameset(DElement dElement) {
        if (dElement != null) {
            int[] nArray;
            int[] nArray2;
            int[] nArray3;
            Object object;
            FramesetData framesetData = this.framesetData;
            if (framesetData == null) {
                return;
            }
            String string = dElement.getAttribute(28);
            String string2 = dElement.getAttribute(92);
            if (string != null) {
                object = new CoordsList(string);
                nArray3 = ((CoordsList)object).getListOfValues();
                nArray2 = ((CoordsList)object).getListOfTypes();
            } else {
                nArray3 = new int[]{100};
                nArray2 = new int[]{1};
            }
            if (string2 != null) {
                CoordsList coordsList = new CoordsList(string2);
                object = coordsList.getListOfValues();
                nArray = coordsList.getListOfTypes();
            } else {
                object = new int[]{100};
                nArray = new int[]{1};
            }
            framesetData.updateFramesetInfo(dElement, nArray3, nArray2, (int[])object, nArray);
        }
    }

    protected void processFrameset() {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        DNode dNode;
        NodeList nodeList = this.doc.getElementsByTagName("frameset");
        if (nodeList.getLength() == 0) {
            return;
        }
        FramesetData framesetData = this.framesetData;
        if (framesetData != null) {
            framesetData.dispose();
        }
        framesetData = new FramesetData(this);
        StormBase stormBase = this.getStorm();
        Vector<String> vector = new Vector<String>();
        Vector<Object> vector2 = new Vector<Object>();
        DNode dNode2 = dNode = (DNode)nodeList.item(0);
        boolean bl = true;
        do {
            Object object5;
            Object object6;
            String string;
            String string2;
            object4 = (DElement)dNode2;
            if (((DElement)object4).tagId == 34) {
                Object object7;
                Object object8;
                string2 = ((DElement)object4).getAttribute(123);
                if (string2 != null) {
                    this.getViewportContainer().addComponentListener(new OnresizeListener((DElement)object4, this.doc));
                }
                string = ((DElement)object4).getAttribute(28);
                object3 = ((DElement)object4).getAttribute(92);
                if (string != null) {
                    object6 = new CoordsList(string);
                    object2 = ((CoordsList)object6).getListOfValues();
                    object = ((CoordsList)object6).getListOfTypes();
                } else {
                    object2 = new int[1];
                    object = new int[1];
                    object2[0] = 100;
                    object[0] = 1;
                }
                if (object3 != null) {
                    object8 = new CoordsList((String)object3);
                    object6 = ((CoordsList)object8).getListOfValues();
                    object5 = ((CoordsList)object8).getListOfTypes();
                } else {
                    object6 = new int[1];
                    object5 = new int[1];
                    object6[0] = 100;
                    object5[0] = 1;
                }
                object8 = null;
                if (bl) {
                    bl = false;
                } else {
                    DElement dElement;
                    object7 = this.cssLayout.docPane.createFramesDividerComponent();
                    object8 = new FramesDivider((Component)object7);
                    String string3 = ((DElement)object4).getAttribute(65);
                    if (object7 != null && (string3 == null || string3.equalsIgnoreCase("false"))) {
                        ((Component)object7).addMouseListener((MouseListener)object8);
                        ((Component)object7).addMouseMotionListener((MouseMotionListener)object8);
                    }
                    if ((string3 = (dElement = (DElement)((DNode)object4).getDParent()).getAttribute(43)) != null) {
                        ((FramesDivider)object8).setProperty("frameborder", string3);
                    }
                    if ((string3 = dElement.getAttribute(13)) != null) {
                        ((FramesDivider)object8).setProperty("border", string3);
                    }
                }
                object7 = this.getPilotViewport();
                framesetData.beginFrameset((DElement)object4, (int[])object2, (int[])object, (int[])object6, (int[])object5, (FramesDivider)object8, ((Viewport)object7).getName());
            } else if (((DElement)object4).tagId == 33) {
                string2 = ((DElement)object4).getAttribute(102);
                string = ((DElement)object4).getAttribute(63);
                if (string2 == null) {
                    string2 = "";
                }
                if (string2.length() > 0) {
                    string2 = this.doc.resolveUrl(string2);
                }
                if (string != null && string.length() == 0) {
                    string = null;
                }
                object3 = new Viewport(this.getStorm(), string);
                ((Viewport)object3).setFrameArrayMember();
                object2 = this.cssLayout.docPane.createFramesDividerComponent();
                object = new FramesDivider((Component)object2);
                if (framesetData.addFramesetChild((Viewport)object3, (FramesDivider)object)) {
                    vector2.addElement(object3);
                    vector.addElement(string2);
                    object6 = ((DElement)object4).getAttribute(97);
                    if (object6 != null) {
                        ((Viewport)object3).setProperty("scrolling", object6);
                    }
                    if ((object6 = ((DElement)object4).getAttribute(58)) != null) {
                        ((Viewport)object3).setProperty("marginwidth", object6);
                    }
                    if ((object6 = ((DElement)object4).getAttribute(57)) != null) {
                        ((Viewport)object3).setProperty("marginheight", object6);
                    }
                    if ((object6 = ((DElement)(object5 = (Object)((DElement)((DNode)object4).getDParent()))).getAttribute(43)) != null) {
                        ((FramesDivider)object).setProperty("frameborder", (String)object6);
                    }
                    if ((object6 = ((DElement)object5).getAttribute(13)) != null) {
                        ((FramesDivider)object).setProperty("border", (String)object6);
                    }
                    object6 = ((DElement)object4).getAttribute(65);
                    if (object2 != null && (object6 == null || ((String)object6).equalsIgnoreCase("false"))) {
                        ((Component)object2).addMouseListener((MouseListener)object);
                        ((Component)object2).addMouseMotionListener((MouseMotionListener)object);
                    }
                }
            }
            if (((DElement)object4).tagId != 34 || dNode2.getFirstDChild() == null) {
                while (dNode2 != dNode && dNode2.next == null) {
                    dNode2 = dNode2.parent;
                    if (dNode2.getNameId() != 34) continue;
                    framesetData.endFrameset();
                }
                if (dNode2 == dNode) continue;
                dNode2 = dNode2.next;
                continue;
            }
            dNode2 = dNode2.getFirstDChild();
        } while (dNode2 != dNode);
        object4 = this.getPilotViewport();
        ((Viewport)object4).removePilotComponent();
        int n2 = vector2.size();
        for (n = 0; n != n2; ++n) {
            object3 = (Viewport)vector2.elementAt(n);
            ((Viewport)object3).setContainer(((Viewport)object4).getContainer());
            ((Viewport)object4).addChild((Viewport)object3);
        }
        this.framesetData = framesetData;
        n2 = vector2.size();
        for (n = 0; n != n2; ++n) {
            object3 = (Viewport)vector2.elementAt(n);
            object2 = (String)vector.elementAt(n);
            stormBase.clearViewportContent("text/html", (Viewport)object3);
            if (((String)object2).length() == 0 || this.isFromHistory) continue;
            object = this.getUrlMaster().createLoader((String)object2);
            ((ContentLoader)object).setReferer(this.doc.getBaseUrl());
            if (this.isLoadedSynchronously) {
                stormBase.renderViewportContentFully((ContentLoader)object, (Viewport)object3);
                continue;
            }
            stormBase.renderViewportContent((ContentLoader)object, (Viewport)object3);
        }
        if (this.isFromHistory) {
            this.firePropertyChange("viewport", null, "childrenReady");
        }
    }

    protected boolean allowedToRunHandler(DOMEvent dOMEvent, DNode dNode) {
        switch (dOMEvent.getTypeId()) {
            case 19: {
                if (!(dNode instanceof DFormElement) || dOMEvent.getTarget() == dNode) break;
                return false;
            }
        }
        return true;
    }

    protected DynamicObject getScriptHandlerThis(DNode dNode, DOMEvent dOMEvent) {
        DNode dNode2 = dNode;
        if (!(dNode.tagId != 13 && dNode.tagId != 34 || dOMEvent.typeId != 13 && dOMEvent.typeId != 14)) {
            dNode2 = null;
        }
        return dNode2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evalScriptHandlerListeners(DNode dNode, DOMEvent dOMEvent, Object object) {
        if (object != null && this.allowedToRunHandler(dOMEvent, dNode)) {
            boolean bl;
            DynamicObject dynamicObject = this.getScriptHandlerThis(dNode, dOMEvent);
            Object object2 = this.clearContextLock;
            synchronized (object2) {
                if (this.contextCleared) {
                    this.contextCleared = false;
                }
                bl = this.doScriptHandlerEval("ECMAScript", object, dOMEvent, dynamicObject);
                if (this.contextCleared) {
                    dOMEvent.cancel = true;
                    this.contextCleared = false;
                }
            }
            if (dOMEvent.typeId == 5 || dOMEvent.typeId == 7) {
                boolean bl2 = bl = !bl;
            }
            if (!bl) {
                dOMEvent.preventDefault();
            }
        }
    }

    public static void addColorDefinition(String string, Color color) {
        CSSUtil.addColorDefinition(string, color);
    }

    public static DStyleSheet getUserStyleSheet(StormBase stormBase) {
        return CSSManager.getUserStyle(StormData.get(stormBase));
    }

    protected Object script_createOption(Object[] objectArray) {
        DOptionElement dOptionElement = (DOptionElement)this.doc.createElement(63);
        if (objectArray.length >= 1) {
            Object object = objectArray[0];
            String string = object == null ? "" : object.toString();
            dOptionElement.setText(string);
            if (objectArray.length >= 2) {
                object = objectArray[1];
                String string2 = object == null ? "" : object.toString();
                dOptionElement.setValue(string2);
            }
        }
        return dOptionElement;
    }

    protected Object script_createActiveXObject(String string) {
        if ("Msxml2.DOMDocument".equals(string)) {
            if (Debug.trace) {
                Debug.trace((String)"WindowObj.script_ActiveXObject 2");
            }
            return this.doc.getDom().createDDocument(this, false);
        }
        return null;
    }

    protected Object script_getDOMImplementation() {
        return this.doc.getDom();
    }

    public final DynamicObject getDocumentObject() {
        return this.getDDocument();
    }

    public void updateFrameList() {
        this.getView().updateFrameList();
    }

    private int IE_nameToWinBodySharedAttr(String string) {
        int n = 0;
        String string2 = null;
        int n2 = string.length();
        if (n2 == 6) {
            char c = string.charAt(2);
            if (c == 'b') {
                string2 = "onblur";
                n = 70;
            } else if (c == 'l') {
                string2 = "onload";
                n = 78;
            }
        } else if (n2 == 7) {
            string2 = "onfocus";
            n = 74;
        } else if (n2 == 8) {
            string2 = "onunload";
            n = 87;
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n - 1;
    }

    private void tmpStoreBodyEventHandlers(int n, Object object) {
        if (this.tmpBodyEventHandlers == null) {
            this.tmpBodyEventHandlers = new HashArray();
        }
        this.tmpBodyEventHandlers.put(n, object);
    }

    private Object getTmpStoredBodyEventHandlers(int n) {
        HashArray hashArray = this.tmpBodyEventHandlers;
        return hashArray != null ? hashArray.get(n) : null;
    }

    void moveToBodyTmpBodyEventHandlers() {
        DElement dElement;
        HashArray hashArray = this.tmpBodyEventHandlers;
        this.tmpBodyEventHandlers = null;
        if (hashArray != null && (dElement = this.doc.getDBody()) != null) {
            HashArray.Iterator iterator = hashArray.newIterator();
            iterator.start();
            while (!iterator.done()) {
                HashArray.Entry entry = iterator.entry();
                int n = entry.index();
                Object object = entry.value;
                dElement.setDAttr(n, object, false);
                iterator.next();
            }
        }
    }

    public Object getDynamicValueOnWindow(DynamicObject dynamicObject, String string, DynEnv dynEnv) {
        int n = ThePilot.toDynamicId(string);
        if (n < 0) {
            return dynEnv.wrapMethod(dynamicObject, string);
        }
        if (n > 0) {
            return this.getDynamicValueOnWindow(n, dynEnv);
        }
        int n2 = this.IE_nameToWinBodySharedAttr(string);
        if (n2 >= 0) {
            DElement dElement = this.doc.getDBody();
            Object object = dElement != null ? dElement.getSlot(string, dynEnv) : this.getTmpStoredBodyEventHandlers(n2);
            return object;
        }
        return super.getDynamicValueOnWindow(dynamicObject, string, dynEnv);
    }

    public int setDynamicValueOnWindow(DynamicObject dynamicObject, String string, Object object, DynEnv dynEnv) {
        int n = ThePilot.toDynamicId(string);
        if (n < 0) {
            return 2;
        }
        if (n > 0) {
            return this.setDynamicValueOnWindow(n, object, dynEnv);
        }
        int n2 = this.IE_nameToWinBodySharedAttr(string);
        if (n2 >= 0) {
            DElement dElement = this.doc.getDBody();
            if (dElement != null) {
                dElement.setDAttr(n2, object, false);
            } else {
                this.tmpStoreBodyEventHandlers(n2, object);
            }
            return 1;
        }
        return super.setDynamicValueOnWindow(dynamicObject, string, object, dynEnv);
    }

    public Object execDynamicMethodOnWindow(DynamicObject dynamicObject, String string, Object[] objectArray, DynEnv dynEnv) {
        int n = ThePilot.toDynamicId(string);
        if (n < 0) {
            return this.execDynamicMethodOnWindow(n, objectArray, dynEnv);
        }
        return super.execDynamicMethodOnWindow(dynamicObject, string, objectArray, dynEnv);
    }

    private Object getDynamicValueOnWindow(int n, DynEnv dynEnv) {
        switch (n) {
            case 2: {
                return this.doc.currentEvent;
            }
            case 1: {
                return this.script_getDOMImplementation();
            }
        }
        return null;
    }

    private int setDynamicValueOnWindow(int n, Object object, DynEnv dynEnv) {
        return 1;
    }

    private Object execDynamicMethodOnWindow(int n, Object[] objectArray, DynEnv dynEnv) {
        if (n == -2) {
            return this.script_createOption(objectArray);
        }
        if (n == -1) {
            return this.script_createActiveXObject(dynEnv.toStr(objectArray, 0));
        }
        return dynEnv.wrapVoid();
    }

    private static int toDynamicId(String string) {
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 5: {
                string2 = "event";
                n = 2;
                break;
            }
            case 6: {
                string2 = "Option";
                n = -2;
                break;
            }
            case 11: {
                char c = string.charAt(4);
                if (c == 'X') {
                    string2 = "pageXOffset";
                    n = 3;
                    break;
                }
                if (c != 'Y') break;
                string2 = "pageYOffset";
                n = 4;
                break;
            }
            case 13: {
                string2 = "ActiveXObject";
                n = -1;
                break;
            }
            case 17: {
                string2 = "DOMImplementation";
                n = 1;
                break;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }

    public Object getSnapshot() {
        FormTypeElement formTypeElement;
        int n;
        DDocument dDocument = (DDocument)this.getDocument();
        if (dDocument == null) {
            return null;
        }
        HashArray hashArray = new HashArray(Defs.NO_SYNCHRONIZATION);
        String string = null;
        String string2 = null;
        NodeList nodeList = dDocument.getElementsByTagName("input");
        if (nodeList != null) {
            for (n = 0; n < nodeList.getLength(); ++n) {
                formTypeElement = (DInputElement)nodeList.item(n);
                string = formTypeElement.getName();
                string2 = ((DInputElement)formTypeElement).getType();
                if (string == null || string2 == null) continue;
                if (string2.equals("text") || string2.equals("hidden")) {
                    hashArray.put((Object)string, (Object)((DInputElement)formTypeElement).getValue());
                    continue;
                }
                if (string2.equals("checkbox")) {
                    hashArray.put((Object)string, (Object)new Boolean(((DInputElement)formTypeElement).getChecked()));
                    continue;
                }
                if (!string2.equals("radio") || formTypeElement.getAttribute("value") == null) continue;
                hashArray.put((Object)(string + "_" + formTypeElement.getAttribute("value")), (Object)new Boolean(((DInputElement)formTypeElement).getChecked()));
            }
        }
        if ((nodeList = dDocument.getElementsByTagName("textarea")) != null) {
            for (n = 0; n < nodeList.getLength(); ++n) {
                String string3;
                formTypeElement = (DTextAreaElement)nodeList.item(n);
                string = formTypeElement.getName();
                if (string == null || (string3 = ((DTextAreaElement)formTypeElement).getValue()) == null) continue;
                hashArray.put((Object)string, (Object)string3);
            }
        }
        if ((nodeList = dDocument.getElementsByTagName("select")) != null) {
            for (n = 0; n < nodeList.getLength(); ++n) {
                formTypeElement = (DSelectElement)nodeList.item(n);
                string = formTypeElement.getName();
                if (string == null) continue;
                for (int i = 0; i < ((DSelectElement)formTypeElement).getLength(); ++i) {
                    DOptionElement dOptionElement = (DOptionElement)((DSelectElement)formTypeElement).item(i);
                    hashArray.put((Object)(string + "_" + i), (Object)new Boolean(dOptionElement.getSelected()));
                }
            }
        }
        hashArray.sealObject();
        Snapshot snapshot = new Snapshot();
        snapshot.inputNames = hashArray;
        snapshot.scrollX = this.getDocPane().getScrollX();
        snapshot.scrollY = this.getDocPane().getScrollY();
        return snapshot;
    }

    public void applySnapshot(Object object) {
        Object object2;
        FormTypeElement formTypeElement;
        int n;
        DDocument dDocument = (DDocument)this.getDocument();
        Snapshot snapshot = (Snapshot)object;
        HashArray hashArray = snapshot.inputNames;
        if (dDocument == null || hashArray == null) {
            return;
        }
        String string = null;
        String string2 = null;
        NodeList nodeList = dDocument.getElementsByTagName("input");
        for (n = 0; n < nodeList.getLength(); ++n) {
            formTypeElement = (DInputElement)nodeList.item(n);
            string = formTypeElement.getName();
            string2 = ((DInputElement)formTypeElement).getType();
            if (string == null || string2 == null) continue;
            if (string2.equals("text") || string2.equals("hidden")) {
                object2 = (String)hashArray.get((Object)string);
                if (object2 == null) continue;
                ((DInputElement)formTypeElement).setValue((String)object2);
                continue;
            }
            if (string2.equals("checkbox")) {
                object2 = (Boolean)hashArray.get((Object)string);
                if (object2 == null) continue;
                ((DInputElement)formTypeElement).setChecked((Boolean)object2);
                continue;
            }
            if (!string2.equals("radio") || formTypeElement.getAttribute("value") == null || (object2 = (Boolean)hashArray.get((Object)(string + "_" + formTypeElement.getAttribute("value")))) == null) continue;
            ((DInputElement)formTypeElement).setChecked((Boolean)object2);
        }
        nodeList = dDocument.getElementsByTagName("textarea");
        for (n = 0; n < nodeList.getLength(); ++n) {
            formTypeElement = (DTextAreaElement)nodeList.item(n);
            string = formTypeElement.getName();
            if (string == null || (object2 = (String)hashArray.get((Object)string)) == null) continue;
            ((DTextAreaElement)formTypeElement).setValue((String)object2);
        }
        nodeList = dDocument.getElementsByTagName("select");
        for (n = 0; n < nodeList.getLength(); ++n) {
            formTypeElement = (DSelectElement)nodeList.item(n);
            string = formTypeElement.getName();
            if (string == null) continue;
            for (int i = 0; i < ((DSelectElement)formTypeElement).getLength(); ++i) {
                DOptionElement dOptionElement = (DOptionElement)((DSelectElement)formTypeElement).item(i);
                Boolean bl = (Boolean)hashArray.get((Object)(string + "_" + i));
                if (bl == null) continue;
                dOptionElement.setSelected(bl);
            }
        }
        this.cssLayout.setPresetScrollPosition(snapshot.scrollX, snapshot.scrollY);
    }

    static boolean prepareImage(final Image image, final ImageObserver imageObserver) {
        final Toolkit toolkit = Toolkit.getDefaultToolkit();
        return Boolean.TRUE == SecurityKit.doPrivileged((BoxedCode)new BoxedCode(){

            public Object run() {
                boolean bl = toolkit.prepareImage(image, -1, -1, imageObserver);
                return bl ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    void setupRefresh(String string) {
        String string2;
        int n;
        char c;
        int n2 = 0;
        int n3 = string.length();
        n2 = CharKit.trimStart((String)string, (int)n2, (int)n3);
        n3 = CharKit.trimEnd((String)string, (int)n2, (int)n3);
        int n4 = string.indexOf(59, n2);
        if (n4 < 0) {
            n4 = string.indexOf(44, n2);
        }
        int n5 = -1;
        if (n4 >= 0) {
            n5 = CSSUtil.parseInt(string, n2, n4, -1);
            n2 = n4 + 1;
            n2 = CharKit.trimStart((String)string, (int)n2, (int)n3);
        }
        if (string.regionMatches(true, n2, "url=", 0, 4)) {
            n2 += 4;
            n2 = CharKit.trimStart((String)string, (int)n2, (int)n3);
        }
        if (n2 != n3 && ((c = string.charAt(n2)) == '\'' || c == '\"') && (n = string.indexOf(c, ++n2)) >= 0) {
            n3 = n;
        }
        if (n5 < 0 && (n5 = CSSUtil.parseInt(string, n2, n3, -1)) >= 0) {
            n2 = n3;
        }
        if ((string2 = n2 == n3 ? this.doc.getBaseUrl() : this.doc.resolveUrl(string.substring(n2, n3))) == null) {
            return;
        }
        n5 = n5 >= 0 ? (n5 *= 1000) : 0;
        RefreshItem refreshItem = new RefreshItem(this.doc, string2, n5);
        refreshItem.postToEventThread(n5);
    }

    void startDownload(final String string, final Object object, final Scripter scripter) {
        final int n = this.getPilotViewport().getDocumentId();
        Thread thread = new Thread(){

            public void run() {
                SecurityKit.doPrivileged((BoxedCode)new BoxedCode(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Object run() {
                        2.access$500(this.this$1).do_download(2.access$100(this.this$1), 2.access$200(this.this$1), 2.access$300(this.this$1), 2.access$400(this.this$1));
                        return null;
                    }
                });
            }

            static /* synthetic */ String access$100(2 var0) {
                return var0.string;
            }

            static /* synthetic */ Object access$200(2 var0) {
                return var0.object;
            }

            static /* synthetic */ Scripter access$300(2 var0) {
                return var0.scripter;
            }

            static /* synthetic */ int access$400(2 var0) {
                return var0.n;
            }

            static /* synthetic */ ThePilot access$500(2 var0) {
                return var0.ThePilot.this;
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void do_download(String string, final Object object, final Scripter scripter, int n) {
        String string2;
        Object object2;
        if (n != this.getPilotViewport().getDocumentId()) {
            return;
        }
        string = this.doc.resolveUrl(string);
        try {
            object2 = this.doc.openUrlReader(string);
            try {
                if (n != this.getPilotViewport().getDocumentId()) {
                    return;
                }
                string2 = IOKit.readAllStr((Reader)object2, (int)4096);
            }
            finally {
                ((Reader)object2).close();
            }
        }
        catch (IOException iOException) {
            if (Debug.ex) {
                Debug.ex((Throwable)iOException);
            }
            return;
        }
        if (n != this.getPilotViewport().getDocumentId()) {
            return;
        }
        object2 = new DocAction(this.doc, n){

            protected void doit(DDocument dDocument) {
                Object[] objectArray = new Object[]{string2};
                scripter.evalCallback(ThePilot.this.getPilotViewport(), object, objectArray);
            }
        };
        ((DocAction)object2).postToEventThread(0L);
    }

    private static class Snapshot {
        HashArray inputNames;
        int scrollX;
        int scrollY;

        private Snapshot() {
        }
    }
}

