/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DHrefElement;
import ice.storm.DynEnv;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import org.w3c.dom.html.HTMLAreaElement;

public class DAreaElement
extends DHrefElement
implements HTMLAreaElement {
    private String curCoords = "";
    int[] coords;
    private static final int Field_accessKey = 1;
    private static final int Field_alt = 2;
    private static final int Field_coords = 3;
    private static final int Field_noHref = 4;
    private static final int Field_shape = 5;
    private static final int Field_tabIndex = 6;
    private static final int Field_target = 7;

    protected DAreaElement(DDocument dDocument, int n) {
        super(dDocument, n);
    }

    public String getAccessKey() {
        return this.getAttribute(4);
    }

    public void setAccessKey(String string) {
        this.setAttribute(4, string);
    }

    public String getAlt() {
        return this.getAttribute(8);
    }

    public void setAlt(String string) {
        this.setAttribute(8, string);
    }

    public String getCoords() {
        return this.getAttribute(32);
    }

    public void setCoords(String string) {
        this.setAttribute(32, string);
    }

    public boolean getNoHref() {
        return false;
    }

    public void setNoHref(boolean bl) {
    }

    public String getShape() {
        return this.getAttribute(99);
    }

    public void setShape(String string) {
        this.setAttribute(99, string);
    }

    public int getTabIndex() {
        return -1;
    }

    public void setTabIndex(int n) {
    }

    public String getTarget() {
        return this.getAttribute(108);
    }

    public void setTarget(String string) {
        this.setAttribute(108, string);
    }

    void findBoundingBox(Rectangle rectangle) {
        if (!this.checkCoords()) {
            return;
        }
        String string = this.getShape();
        if (string == null || string.equalsIgnoreCase("rect")) {
            int n;
            int n2 = this.coords[0];
            int n3 = this.coords[1];
            int n4 = this.coords[2];
            int n5 = this.coords[3];
            if (n4 < n2) {
                n = n2;
                n2 = n4;
                n4 = n;
            }
            if (n5 < n3) {
                n = n3;
                n3 = n5;
                n5 = n;
            }
            rectangle.x = n2;
            rectangle.y = n3;
            rectangle.width = n4 - n2;
            rectangle.height = n5 - n3;
        }
    }

    boolean isInside(int n, int n2, int n3, int n4) {
        if (!this.checkCoords()) {
            return false;
        }
        String string = this.getShape();
        if (string == null || string.equalsIgnoreCase("rect")) {
            int n5;
            int n6;
            int n7;
            int n8 = this.coords[0];
            if (n8 < 0) {
                n8 = -n8 * n3 / 100;
            }
            if ((n7 = this.coords[1]) < 0) {
                n7 = -n7 * n4 / 100;
            }
            if ((n6 = this.coords[2]) < 0) {
                n6 = -n6 * n3 / 100;
            }
            if ((n5 = this.coords[3]) < 0) {
                n5 = -n5 * n4 / 100;
            }
            if (n >= n8 && n < n6 && n2 >= n7 && n2 < n5) {
                return true;
            }
        } else if (string.equalsIgnoreCase("circle")) {
            int n9;
            int n10;
            int n11 = this.coords[0];
            if (n11 < 0) {
                n11 = -n11 * n3 / 100;
            }
            if ((n10 = this.coords[1]) < 0) {
                n10 = -n10 * n4 / 100;
            }
            if ((n9 = this.coords[2]) < 0) {
                n9 = n3 < n4 ? -n9 * n3 / 100 : -n9 * n4 / 100;
            }
            if ((n -= n11) * n + (n2 -= n10) * n2 < n9 * n9) {
                return true;
            }
        } else if (string.equalsIgnoreCase("poly") || string.equalsIgnoreCase("polygon")) {
            int n12;
            int n13;
            int n14 = 0;
            int n15 = 0;
            if ((n13 = this.coords[n15++]) < 0) {
                n13 = -n13 * n3 / 100;
            }
            if ((n12 = this.coords[n15++]) < 0) {
                n12 = -n12 * n4 / 100;
            }
            int n16 = n13 -= n;
            int n17 = n12 -= n2;
            while (n15 < this.coords.length) {
                int n18;
                int n19;
                if ((n19 = this.coords[n15++]) < 0) {
                    n19 = -n19 * n3 / 100;
                }
                if ((n18 = this.coords[n15++]) < 0) {
                    n18 = -n18 * n4 / 100;
                }
                if (this.checkEdge(n16, n17, n19 -= n, n18 -= n2)) {
                    ++n14;
                }
                n16 = n19;
                n17 = n18;
            }
            if (this.checkEdge(n16, n17, n13, n12)) {
                ++n14;
            }
            if ((n14 & 1) > 0) {
                return true;
            }
        }
        return false;
    }

    private final boolean checkEdge(int n, int n2, int n3, int n4) {
        if (n2 <= 0 && n4 > 0 || n2 > 0 && n4 <= 0) {
            if (n >= 0 && n3 >= 0) {
                return true;
            }
            if ((n > 0 || n3 > 0) && n + (n3 - n) * (0 - n2) / (n4 - n2) > 0) {
                return true;
            }
        }
        return false;
    }

    boolean checkCoords() {
        String string = this.getCoords();
        if (string == null) {
            return false;
        }
        if (!string.equals(this.curCoords)) {
            String string2 = this.getShape();
            string = string.replace(',', ' ');
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = stringTokenizer.countTokens();
            if (string2 == null || string2.equalsIgnoreCase("rect")) {
                if (n < 4) {
                    return false;
                }
                n = 4;
            } else if (string2.equalsIgnoreCase("circle")) {
                if (n < 3) {
                    return false;
                }
                n = 3;
            } else if (string2.equalsIgnoreCase("poly") || string2.equalsIgnoreCase("polygon")) {
                if ((n & 1) > 0) {
                    n ^= 1;
                }
                if (n < 6) {
                    return false;
                }
            }
            this.coords = new int[n];
            for (int i = 0; stringTokenizer.hasMoreTokens() && i < n; ++i) {
                String string3 = stringTokenizer.nextToken();
                int n2 = CSSUtil.parseLength(string3);
                if (n2 == Integer.MIN_VALUE) {
                    n2 = 0;
                }
                this.coords[i] = n2;
            }
        }
        return true;
    }

    public Object getDynamicValue(String string, DynEnv dynEnv) {
        int n = DAreaElement.toDynamicId(string);
        if (n < 0) {
            return dynEnv.wrapMethod(this, string);
        }
        if (n > 0) {
            return this.getDynamicValue(n, dynEnv);
        }
        return super.getDynamicValue(string, dynEnv);
    }

    public int setDynamicValue(String string, Object object, DynEnv dynEnv) {
        int n = DAreaElement.toDynamicId(string);
        if (n < 0) {
            return 2;
        }
        if (n > 0) {
            return this.setDynamicValue(n, object, dynEnv);
        }
        return super.setDynamicValue(string, object, dynEnv);
    }

    private Object getDynamicValue(int n, DynEnv dynEnv) {
        switch (n) {
            case 1: {
                return this.getAccessKey();
            }
            case 2: {
                return this.getAlt();
            }
            case 3: {
                return this.getCoords();
            }
            case 4: {
                return dynEnv.wrapBoolean(this.getNoHref());
            }
            case 5: {
                return this.getShape();
            }
            case 6: {
                return dynEnv.wrapInt(this.getTabIndex());
            }
            case 7: {
                return this.getTarget();
            }
        }
        return null;
    }

    private int setDynamicValue(int n, Object object, DynEnv dynEnv) {
        switch (n) {
            case 1: {
                this.setAccessKey(dynEnv.toStr(object));
                return 1;
            }
            case 2: {
                this.setAlt(dynEnv.toStr(object));
                return 1;
            }
            case 3: {
                this.setCoords(dynEnv.toStr(object));
                return 1;
            }
            case 4: {
                this.setNoHref(dynEnv.toBoolean(object));
                return 1;
            }
            case 5: {
                this.setShape(dynEnv.toStr(object));
                return 1;
            }
            case 6: {
                this.setTabIndex(dynEnv.toInt(object));
                return 1;
            }
            case 7: {
                this.setTarget(dynEnv.toStr(object));
                return 1;
            }
        }
        return 2;
    }

    private static int toDynamicId(String string) {
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 3: {
                string2 = "alt";
                n = 2;
                break;
            }
            case 5: {
                string2 = "shape";
                n = 5;
                break;
            }
            case 6: {
                char c = string.charAt(0);
                if (c == 'c') {
                    string2 = "coords";
                    n = 3;
                    break;
                }
                if (c == 'n') {
                    string2 = "noHref";
                    n = 4;
                    break;
                }
                if (c != 't') break;
                string2 = "target";
                n = 7;
                break;
            }
            case 8: {
                string2 = "tabIndex";
                n = 6;
                break;
            }
            case 9: {
                string2 = "accessKey";
                n = 1;
                break;
            }
        }
        if (string2 != null && (string2 == string || string2.equals(string))) {
            return n;
        }
        return 0;
    }
}

