/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.guiutil;

import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class ObjectCreationDialog
extends JPanel
implements ActionListener,
FocusListener {
    private static ResourceBundle RES = ResourceBundle.getBundle("com.mathworks.toolbox.testmeas.guiutil.resources.RES_ObjectCreationDialog");
    private static final String ACTION = "ACTION";
    public static final int CANCEL = 0;
    public static final int OK = 1;
    private static final int CREATE = 2;
    private static final int TYPE = 3;
    private static final int PROPERTY = 4;
    private MJDialog dialog;
    private JComboBox type;
    private JPanel configureObjectCreatePanel;
    private boolean needsToBeAdded = true;
    private JButton okButton;
    private MJFrame frame;

    public abstract String getObjectTypeLabel();

    public abstract JPanel getPanel(int var1);

    public abstract void createObject(int var1);

    public abstract String[] getObjectTypes();

    public void layoutPanel() {
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.add((Component)this.createDefineObjectBox(), "North");
        this.configureObjectCreatePanel = new JPanel(new BorderLayout(0, 0));
        this.configureObjectCreatePanel.add((Component)this.getPanel(0), "North");
        jPanel.add((Component)this.configureObjectCreatePanel, "Center");
        jPanel.add((Component)this.createButtonPanel(), "South");
        this.add((Component)jPanel, "Center");
    }

    public void showAsDialog(MJFrame mJFrame) {
        this.frame = mJFrame;
        this.dialog = new MJDialog((Frame)this.frame, RES.getString("frame.title"), true);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.getContentPane().add(this);
        this.dialog.setSize(this.getDialogSize());
        Point point = this.frame.getLocation();
        this.dialog.setLocation(point.x, point.y);
        this.dialog.getRootPane().setDefaultButton(this.okButton);
        this.dialog.show();
    }

    public Dimension getDialogSize() {
        return new Dimension(404, 240);
    }

    public MJFrame getFrame() {
        return this.frame;
    }

    public JPanel createPanel(String[] stringArray, JComponent[] jComponentArray, String[] stringArray2, int n) {
        JPanel jPanel = new JPanel(new BorderLayout(n, 0));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), RES.getString("groupbox.title2")), BorderFactory.createEmptyBorder(0, 4, 4, 4)));
        JPanel jPanel2 = new JPanel(new GridLayout(stringArray.length, 1, 0, 2));
        for (int i = 0; i < stringArray.length; ++i) {
            jPanel2.add(new JLabel(stringArray[i]));
        }
        JPanel jPanel3 = new JPanel(new GridLayout(jComponentArray.length, 1, 0, 2));
        for (int i = 0; i < jComponentArray.length; ++i) {
            JComponent jComponent = jComponentArray[i];
            jPanel3.add(jComponent);
            jComponent.setName(stringArray2[i]);
            this.configureCallbacks(jComponent);
        }
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    private JPanel createDefineObjectBox() {
        JPanel jPanel = new JPanel(new BorderLayout(8, 0));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), RES.getString("groupbox.title1")), BorderFactory.createEmptyBorder(0, 4, 4, 4)));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1, 0, 2));
        jPanel2.add(new JLabel(this.getObjectTypeLabel()));
        jPanel.add((Component)jPanel2, "West");
        JPanel jPanel3 = new JPanel(new GridLayout(1, 1, 0, 2));
        this.type = new JComboBox<String>(this.getObjectTypes());
        this.type.setName("Object Type ComboBox");
        jPanel3.add(this.type);
        this.type.addActionListener(this);
        this.type.putClientProperty(ACTION, new Integer(3));
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 4, 5, 0));
        this.okButton = new JButton(RES.getString("button.ok"));
        this.okButton.addActionListener(this);
        this.okButton.putClientProperty(ACTION, new Integer(1));
        this.okButton.setName("OK Button");
        JButton jButton = new JButton(RES.getString("button.cancel"));
        jButton.addActionListener(this);
        jButton.putClientProperty(ACTION, new Integer(0));
        jButton.setName("Cancel Button");
        JButton jButton2 = new JButton(RES.getString("button.create"));
        jButton2.setMnemonic(67);
        jButton2.addActionListener(this);
        jButton2.putClientProperty(ACTION, new Integer(2));
        jButton2.setName("Create Button");
        jPanel2.add(this.okButton);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private void configureCallbacks(JComponent jComponent) {
        if (jComponent instanceof JTextField) {
            ((JTextField)jComponent).addActionListener(this);
            jComponent.addFocusListener(this);
            jComponent.putClientProperty(ACTION, new Integer(4));
        } else if (jComponent instanceof JComboBox) {
            ((JComboBox)jComponent).addActionListener(this);
            jComponent.putClientProperty(ACTION, new Integer(4));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        switch (n) {
            case 1: {
                if (this.needsToBeAdded) {
                    this.createObject(this.type.getSelectedIndex());
                }
                this.dialog.dispose();
                break;
            }
            case 0: {
                this.dialog.dispose();
                break;
            }
            case 2: {
                this.createObject(this.type.getSelectedIndex());
                this.needsToBeAdded = false;
                break;
            }
            case 3: {
                this.updateObjectCreationPanel();
                this.needsToBeAdded = true;
                break;
            }
            case 4: {
                this.needsToBeAdded = true;
            }
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.needsToBeAdded = true;
    }

    public void update() {
        this.type.removeAllItems();
        String[] stringArray = this.getObjectTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            this.type.addItem(stringArray[i]);
        }
        this.type.setSelectedIndex(0);
        this.updateObjectCreationPanel();
    }

    private void updateObjectCreationPanel() {
        JPanel jPanel = this.getPanel(this.type.getSelectedIndex());
        if (jPanel == null) {
            return;
        }
        this.configureObjectCreatePanel.removeAll();
        this.configureObjectCreatePanel.add((Component)jPanel, "North");
        this.validate();
        this.repaint();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }
}

