/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.browser;

import com.mathworks.common.icons.ApplicationIcon;
import com.mathworks.common.icons.CommonIcon;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.mlwidgets.help.HelpPanel;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCornerGrip;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuBar;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJStatusBar;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.window.MJFullWindowRegistry;
import com.mathworks.toolbox.testmeas.browser.BrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserConfigFileReader;
import com.mathworks.toolbox.testmeas.browser.BrowserConfigFileWriter;
import com.mathworks.toolbox.testmeas.browser.BrowserDecoration;
import com.mathworks.toolbox.testmeas.browser.BrowserListener;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeDetail;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.toolbox.testmeas.browser.DetailView;
import com.mathworks.toolbox.testmeas.browser.GlassPane;
import com.mathworks.toolbox.testmeas.browser.TreeView;
import com.mathworks.toolbox.testmeas.browser.TreeViewEditorListener;
import com.mathworks.toolbox.testmeas.util.Print;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import com.mathworks.util.NativeJava;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.tree.TreePath;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Browser
extends JPanel
implements Runnable,
ActionListener,
WindowListener,
ComponentListener,
BrowserListener,
MenuListener {
    private static final long serialVersionUID = 1L;
    public static ImageIcon matlabImage = ApplicationIcon.MATLAB.getIcon();
    public static ImageIcon scanImage = CommonIcon.REFRESH.getIcon();
    private static ImageIcon printIcon = CommonIcon.PRINT.getIcon();
    private static final String ACTION = "ACTION";
    private static final int CLOSE = 0;
    private static final int PRINT = 1;
    private static final int COLLAPSE = 2;
    private static final int EXPAND = 3;
    private static final int SCAN = 4;
    private static final int PRINT_DETAIL = 5;
    private static final int NODE_HELP = 6;
    public static final int COMPLETE = 0;
    public static final int COMPLETE_WITH_HELP = 1;
    public static final int TREE = 2;
    private static boolean sFirstTimeUpdatingHelp = true;
    private MJFrame jframe;
    private String frameTitle = "";
    private Vector<BrowserTreeDetail> allBrowserTreeDetail = new Vector();
    private BrowserTreeDetail currentBTD = null;
    private boolean okToAddToolbar = true;
    private boolean okToAddButtonsToToolbar = true;
    private boolean toolbarAdded = false;
    private boolean okToAddMenubar = true;
    private boolean okToAddMenusToMenubar = true;
    private boolean menubarAdded = false;
    private boolean okToAddStatusbar = true;
    private boolean statusbarAdded = false;
    private int browserLayout = 1;
    private JSplitPane outerPane = null;
    private GlassPane glassPane;
    private MJMenuBar menubar;
    private MJToolBar toolbar;
    private MJStatusBar statusbar;
    private JPanel statusbarPanel = null;
    private JPanel southPanel = null;
    private JPanel northPanel = null;
    private TreeView treeView;
    private JPanel treePanel;
    private DetailView detailView;
    private JPanel detailPanel;
    private BrowserDecoration helpDecoration = null;
    private static int NOT_OK = 0;
    private static int OK = 1;
    private HelpPanel helpView;
    private JSplitPane helpPane;
    private boolean lastShowHelpState = true;
    private boolean lastShowDetailView = true;
    private int lastShowHelpStateUpdate = NOT_OK;
    private MJMenu fileMenu = new MJMenu("File");
    private MJMenu editMenu = new MJMenu("Edit");
    private MJMenu viewMenu = new MJMenu("View");
    private MJMenu toolsMenu = new MJMenu("Tools");
    private MJMenu helpMenu = new MJMenu("Help");
    private Vector<JMenu> menusToAdd = new Vector();
    private int[] menuCount = new int[20];
    private MJMenuItem printMenuItem;
    private MJMenuItem printDetailMenuItem;
    private MJMenuItem scanMenuItem;
    private MJButton printToolbarButton;
    private MJButton scanToolbarButton;
    private int[] nodeMenuCount;
    private String[] menusToRemove;
    private JMenu[] nodeMenusAdded = null;
    private JMenuItem helpMenuBasedOnNode;
    private boolean addedHelpMenuBasedOnNode = false;
    private BrowserTreeNode currentNode;
    private Print printer;
    private String configFileName = "";
    private int frameWidth = 930;
    private int frameHeight = 498;
    private int frameX = 0;
    private int frameY = 0;
    private boolean frameMaximized = false;
    private int helpPaneTotalWidth = 559;
    private int outerPaneDividerLoc = 159;
    private int helpPaneWidth;
    private int oldHelpPaneWidth = this.helpPaneWidth = 180;

    public Browser(String string) {
        this.frameTitle = string;
        this.setLayout(new BorderLayout(0, 0));
    }

    public Browser(String string, int n) {
        this.frameTitle = string;
        this.browserLayout = n;
        this.setLayout(new BorderLayout(0, 0));
    }

    public Browser(String string, int n, String string2) {
        this.frameTitle = string;
        this.browserLayout = n;
        this.configFileName = string2;
        this.setLayout(new BorderLayout(0, 0));
    }

    public BrowserTreeDetail addClients(String string, String string2, ImageIcon imageIcon, int n, BrowserTreeNode browserTreeNode, boolean bl) {
        String[] stringArray = string != null ? new String[]{string} : new String[]{};
        return this.addClients(stringArray, string2, imageIcon, n, browserTreeNode, bl);
    }

    public BrowserTreeDetail addClients(String[] stringArray, String string, ImageIcon imageIcon, int n, BrowserTreeNode browserTreeNode, boolean bl) {
        BrowserClient[] browserClientArray = this.instantiateClients(stringArray);
        return this.addClients(browserClientArray, string, imageIcon, n, browserTreeNode, bl);
    }

    public BrowserTreeDetail addClients(BrowserClient browserClient, String string, ImageIcon imageIcon, int n, BrowserTreeNode browserTreeNode, boolean bl) {
        BrowserClient[] browserClientArray = new BrowserClient[]{browserClient};
        return this.addClients(browserClientArray, string, imageIcon, n, browserTreeNode, bl);
    }

    public BrowserTreeDetail addClients(BrowserClient[] browserClientArray, String string, ImageIcon imageIcon, int n, BrowserTreeNode browserTreeNode, boolean bl) {
        BrowserTreeDetail browserTreeDetail = this.createBrowserTreeDetail(browserClientArray, n, browserTreeNode);
        browserTreeDetail.setTitle(string);
        browserTreeDetail.setIcon(imageIcon);
        browserTreeDetail.showRootNode(bl);
        return browserTreeDetail;
    }

    private BrowserClient[] instantiateClients(String[] stringArray) {
        BrowserClient[] browserClientArray = new BrowserClient[stringArray.length];
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                Class<?> clazz = Class.forName(stringArray[i]);
                browserClientArray[i] = (BrowserClient)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            System.out.println("Client Exception: " + exception.getMessage());
        }
        return browserClientArray;
    }

    private BrowserTreeDetail createBrowserTreeDetail(BrowserClient[] browserClientArray, int n, BrowserTreeNode browserTreeNode) {
        BrowserTreeDetail browserTreeDetail = new BrowserTreeDetail(this, n, browserClientArray, browserTreeNode);
        this.allBrowserTreeDetail.addElement(browserTreeDetail);
        return browserTreeDetail;
    }

    public static MJFrame findInstance(String string) {
        Enumeration enumeration = MJFullWindowRegistry.windows();
        while (enumeration.hasMoreElements()) {
            try {
                MJFrame mJFrame = (MJFrame)enumeration.nextElement();
                if (!mJFrame.getTitle().equals(string)) continue;
                return mJFrame;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public void layoutBrowser() {
        this.setLayout(new BorderLayout(0, 0));
        BrowserConfigFileReader browserConfigFileReader = null;
        if (!this.configFileName.equals("")) {
            browserConfigFileReader = new BrowserConfigFileReader(this.configFileName);
        }
        this.detailPanel = this.layoutDetailPanel();
        this.treePanel = new JPanel(new GridLayout(this.allBrowserTreeDetail.size(), 1));
        switch (this.browserLayout) {
            case 1: {
                this.helpPane = new JSplitPane();
                this.createHelpViewer();
                this.helpPane.setLeftComponent(this.detailPanel);
                this.helpPane.setRightComponent((Component)this.helpView);
                this.helpPane.setResizeWeight(0.5);
                this.outerPane = new JSplitPane();
                this.outerPane.setLeftComponent(this.treePanel);
                this.outerPane.setRightComponent(this.addDecorationToFirstPanel(this.helpPane, true));
                this.add((Component)this.outerPane, "Center");
                break;
            }
            case 0: {
                this.outerPane = new JSplitPane();
                this.outerPane.setLeftComponent(this.treePanel);
                this.outerPane.setRightComponent(this.detailPanel);
                this.add((Component)this.outerPane, "Center");
                break;
            }
            case 2: {
                this.add((Component)this.allBrowserTreeDetail.elementAt(0).getTreeView(), "Center");
            }
        }
        for (int i = 0; i < this.allBrowserTreeDetail.size() && this.outerPane != null; ++i) {
            BrowserTreeDetail browserTreeDetail = this.allBrowserTreeDetail.elementAt(i);
            this.treePanel.add(browserTreeDetail.getTreeViewComponent());
            browserTreeDetail.init(this, browserConfigFileReader);
        }
        this.loadConfigurationFile(browserConfigFileReader);
        if (this.helpDecoration != null) {
            this.helpDecoration.setIsHelpShown(this.lastShowHelpState);
        }
        this.currentBTD = this.allBrowserTreeDetail.elementAt(0);
        this.treeView = this.currentBTD.getTreeView();
        this.detailView = this.currentBTD.getDetailView();
        this.currentBTD.selectTreeView(true);
        try {
            this.currentNode = this.treeView.selectFirstNode();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addToSouthPanel(JComponent jComponent, String string) {
        if (this.southPanel == null) {
            this.southPanel = new JPanel(new BorderLayout(0, 0));
            this.add((Component)this.southPanel, "South");
        }
        this.southPanel.add((Component)jComponent, string);
    }

    public void addToNorthPanel(JPanel jPanel, String string) {
        if (this.northPanel == null) {
            this.northPanel = new JPanel(new BorderLayout(0, 0));
            this.add((Component)this.northPanel, "North");
        }
        this.northPanel.add((Component)jPanel, string);
    }

    private JPanel layoutDetailPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        boolean bl = false;
        for (int i = 0; i < this.allBrowserTreeDetail.size(); ++i) {
            JComponent jComponent;
            BrowserTreeDetail browserTreeDetail = this.allBrowserTreeDetail.elementAt(i);
            if (browserTreeDetail.getLayout() != 1) continue;
            if (!bl && this.browserLayout == 1) {
                jComponent = browserTreeDetail.getDetailViewComponent();
                gridBagLayout.setConstraints(jComponent, gridBagConstraints);
                jPanel.add(jComponent);
                bl = true;
                continue;
            }
            jComponent = this.addDecorationToPanel(browserTreeDetail, false, i);
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            jPanel.add(jComponent);
        }
        return jPanel;
    }

    private JPanel addDecorationToFirstPanel(JComponent jComponent, boolean bl) {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        this.helpDecoration = new BrowserDecoration("Test", matlabImage, bl);
        this.helpDecoration.setName("Help Decoration");
        BrowserTreeDetail browserTreeDetail = this.allBrowserTreeDetail.elementAt(0);
        browserTreeDetail.setDecorationOnDetailPanel(this.helpDecoration);
        this.helpDecoration.setBrowser(this);
        jPanel.add((Component)this.helpDecoration, "North");
        jPanel.add((Component)jComponent, "Center");
        return jPanel;
    }

    private JPanel addDecorationToPanel(BrowserTreeDetail browserTreeDetail, boolean bl, int n) {
        JComponent jComponent = browserTreeDetail.getDetailViewComponent();
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        BrowserDecoration browserDecoration = new BrowserDecoration("Test", matlabImage, bl);
        browserDecoration.setName("Detail View Decoration - " + n);
        browserTreeDetail.setDecorationOnDetailPanel(browserDecoration);
        jPanel.add((Component)browserDecoration, "North");
        jPanel.add((Component)jComponent, "Center");
        return jPanel;
    }

    public void addToFrame() {
        this.jframe = new MJFrame();
        this.jframe.getContentPane().add(this);
        this.jframe.setDefaultCloseOperation(0);
        for (int i = 0; i < this.allBrowserTreeDetail.size(); ++i) {
            this.allBrowserTreeDetail.elementAt(i).setBrowser(this);
        }
        this.configureToolbar();
        this.configureMenubar();
        this.configureStatusbar();
        this.createGlassPane();
        this.jframe.setTitle(this.frameTitle);
        this.jframe.setSize(this.frameWidth, this.frameHeight);
        this.jframe.setLocation(this.frameX, this.frameY);
        this.jframe.addWindowListener((WindowListener)this);
        this.jframe.addComponentListener((ComponentListener)this);
        this.jframe.show();
        if (this.frameMaximized) {
            NativeJava.setMaximized((Window)this.jframe, (boolean)true);
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Browser.this.outerPane.setDividerLocation(Browser.this.outerPaneDividerLoc);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.helpPane != null) {
                try {
                    AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Browser.this.restoreHelpPaneWidth(Browser.this.helpPaneTotalWidth);
                        }
                    });
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.currentNode != null) {
                    try {
                        AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                Browser.this.updateHelp(Browser.this.currentNode);
                            }
                        });
                    }
                    catch (Throwable throwable) {}
                }
            } else if (this.currentNode.getShowHelpOnly() && this.getBrowserLayout() != 1) {
                BrowserTreeNode[] browserTreeNodeArray = new BrowserTreeNode[]{this.currentNode};
                this.currentBTD.update(this.currentNode.getClient(), this.currentNode, null, browserTreeNodeArray);
            }
        } else {
            this.outerPane.setDividerLocation(this.outerPaneDividerLoc);
            if (this.helpPane != null) {
                this.restoreHelpPaneWidth(this.helpPaneTotalWidth);
                if (this.currentNode != null) {
                    this.updateHelp(this.currentNode);
                }
            } else if (this.currentNode.getShowHelpOnly() && this.getBrowserLayout() != 1) {
                BrowserTreeNode[] browserTreeNodeArray = new BrowserTreeNode[]{this.currentNode};
                this.currentBTD.update(this.currentNode.getClient(), this.currentNode, null, browserTreeNodeArray);
            }
        }
        this.helpPaneWidth = this.oldHelpPaneWidth;
    }

    public void updateScrollPaneLocations() {
        this.outerPane.setDividerLocation(this.outerPaneDividerLoc);
        if (this.helpPane != null) {
            this.restoreHelpPaneWidth(this.helpPaneTotalWidth);
        }
    }

    public void configureSavedFrameSize(MJFrame mJFrame) {
        mJFrame.setSize(this.frameWidth, this.frameHeight);
        mJFrame.setLocation(this.frameX, this.frameY);
    }

    public void configureSavedFrameMaximized(MJFrame mJFrame) {
        if (this.frameMaximized) {
            NativeJava.setMaximized((Window)this.jframe, (boolean)true);
        }
    }

    public void addAsDockedFrame() {
        for (int i = 0; i < this.allBrowserTreeDetail.size(); ++i) {
            this.allBrowserTreeDetail.elementAt(i).setBrowser(this);
        }
        this.createStatusbar();
        this.createDockedToolbar();
        this.createDockedMenubar();
    }

    private void loadConfigurationFile(BrowserConfigFileReader browserConfigFileReader) {
        if (browserConfigFileReader == null) {
            return;
        }
        Node node = browserConfigFileReader.getToolboxNode("Browser");
        if (node == null) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = nodeList.item(i).getNodeName();
            if (!string.equals("Layout")) continue;
            Element element = (Element)nodeList.item(i);
            if (element.hasAttribute("ShowHelp")) {
                this.lastShowHelpState = TMStringUtil.str2bool(element.getAttribute("ShowHelp"));
            }
            if (element.hasAttribute("IsMaximized")) {
                this.frameMaximized = TMStringUtil.str2bool(element.getAttribute("IsMaximized"));
            }
            if (element.hasAttribute("FrameWidth")) {
                this.frameWidth = new Integer(element.getAttribute("FrameWidth"));
            }
            if (element.hasAttribute("FrameHeight")) {
                this.frameHeight = new Integer(element.getAttribute("FrameHeight"));
            }
            if (element.hasAttribute("FrameX")) {
                this.frameX = new Integer(element.getAttribute("FrameX"));
            }
            if (element.hasAttribute("FrameY")) {
                this.frameY = new Integer(element.getAttribute("FrameY"));
            }
            if (element.hasAttribute("HelpPaneTotalWidth")) {
                this.helpPaneTotalWidth = new Integer(element.getAttribute("HelpPaneTotalWidth"));
            }
            if (element.hasAttribute("HelpPaneWidth")) {
                this.helpPaneWidth = new Integer(element.getAttribute("HelpPaneWidth"));
            }
            if (!element.hasAttribute("OuterPaneDividerLoc")) continue;
            this.outerPaneDividerLoc = new Integer(element.getAttribute("OuterPaneDividerLoc"));
        }
        this.lastShowHelpStateUpdate = NOT_OK;
        if (!this.lastShowHelpState) {
            this.helpPaneWidth = 180;
        }
        this.oldHelpPaneWidth = this.helpPaneWidth;
    }

    public void addMenubar(boolean bl) {
        this.okToAddMenubar = bl;
    }

    public void addMenubarAndMenus(boolean bl) {
        this.okToAddMenusToMenubar = bl;
    }

    public void addStatusbar(boolean bl) {
        this.okToAddStatusbar = bl;
    }

    public void addToolbar(boolean bl) {
        this.okToAddToolbar = bl;
    }

    public void addToolbarAndButtons(boolean bl) {
        this.okToAddButtonsToToolbar = bl;
    }

    public void setConfigurationFileName(String string) {
        this.configFileName = string;
    }

    public String getConfigurationFileName() {
        return this.configFileName;
    }

    public MJFrame getFrame() {
        return this.jframe;
    }

    public void setFrameTitle(String string) {
        this.frameTitle = string;
        if (this.jframe != null) {
            this.jframe.setTitle(this.frameTitle);
        }
    }

    public String getFrameTitle() {
        if (this.jframe != null) {
            this.frameTitle = this.jframe.getTitle();
        }
        return this.frameTitle;
    }

    public void setBrowserLayout(int n) {
        this.browserLayout = n;
    }

    public int getBrowserLayout() {
        return this.browserLayout;
    }

    public void setBrowserLocation(int n, int n2) {
        this.frameX = n;
        this.frameY = n2;
    }

    public void setBrowserSize(int n, int n2) {
        this.frameWidth = n;
        this.frameHeight = n2;
    }

    public TreeView getCurrentTreeView() {
        return this.treeView;
    }

    public JPanel getTreePanel() {
        return this.treePanel;
    }

    public TreeView getTreeView(BrowserClient browserClient) {
        BrowserTreeDetail browserTreeDetail = this.findBTD(browserClient);
        if (browserTreeDetail != null) {
            return browserTreeDetail.getTreeView();
        }
        return null;
    }

    public void addTreeViewEditorListener(TreeViewEditorListener treeViewEditorListener) {
        this.treeView.addTreeViewEditorListener(treeViewEditorListener);
    }

    public void removeTreeViewEditorListener(TreeViewEditorListener treeViewEditorListener) {
        this.treeView.removeTreeViewEditorListener(treeViewEditorListener);
    }

    public BrowserTreeNode getSelectedNode() {
        return this.currentNode;
    }

    private BrowserTreeNode[] getAllNodesSelected() {
        TreePath[] treePathArray = this.treeView.getSelectionPaths();
        BrowserTreeNode[] browserTreeNodeArray = new BrowserTreeNode[treePathArray.length];
        for (int i = 0; i < treePathArray.length; ++i) {
            browserTreeNodeArray[i] = (BrowserTreeNode)treePathArray[i].getLastPathComponent();
        }
        return browserTreeNodeArray;
    }

    public DetailView getCurrentDetailView() {
        return this.detailView;
    }

    public DetailView getDetailView(BrowserClient browserClient) {
        BrowserTreeDetail browserTreeDetail = this.findBTD(browserClient);
        if (browserTreeDetail != null) {
            return browserTreeDetail.getDetailView();
        }
        return null;
    }

    protected void updateDetailView(BrowserTreeNode browserTreeNode) {
        BrowserTreeNode browserTreeNode2 = this.currentNode;
        this.currentNode = browserTreeNode;
        BrowserClient browserClient = browserTreeNode.getClient();
        this.findCurrentBTD(browserClient);
        if (this.treeView == null) {
            return;
        }
        BrowserTreeNode[] browserTreeNodeArray = this.getAllNodesSelected();
        this.currentBTD.update(browserClient, this.currentNode, browserTreeNode2, browserTreeNodeArray);
        if (this.helpPane != null) {
            if (this.currentNode.getShowHelpOnly()) {
                this.helpPane.setDividerSize(0);
            } else {
                this.helpPane.setDividerSize(5);
            }
        }
        if (browserTreeNode2 == browserTreeNode) {
            return;
        }
        if (browserTreeNode2 != null && this.currentNode != null && browserClient != browserTreeNode2.getClient()) {
            this.currentBTD.selectTreeView(true);
            BrowserTreeDetail browserTreeDetail = this.findBTD(browserTreeNode2.getClient());
            if (browserTreeDetail != null) {
                browserTreeDetail.selectTreeView(false);
            }
        }
        if (browserTreeNode.isHelpUpdated() && this.browserLayout == 1) {
            this.updateHelp(browserTreeNode);
        }
        if (browserClient != null) {
            this.updateMenusBasedOnCurrentNode(browserClient, browserTreeNode, browserTreeNode2, browserTreeNodeArray);
        }
    }

    private void findCurrentBTD(BrowserClient browserClient) {
        if (this.currentBTD != null && this.currentBTD.contains(browserClient)) {
            return;
        }
        BrowserTreeDetail browserTreeDetail = this.findBTD(browserClient);
        if (browserTreeDetail != null) {
            this.currentBTD = browserTreeDetail;
            this.treeView = this.currentBTD.getTreeView();
            this.detailView = this.currentBTD.getDetailView();
        }
    }

    private BrowserTreeDetail findBTD(BrowserClient browserClient) {
        for (int i = 0; i < this.allBrowserTreeDetail.size(); ++i) {
            BrowserTreeDetail browserTreeDetail = this.allBrowserTreeDetail.elementAt(i);
            if (!browserTreeDetail.contains(browserClient)) continue;
            return browserTreeDetail;
        }
        return null;
    }

    private void configureMenubar() {
        if (this.jframe == null) {
            return;
        }
        if (this.okToAddMenubar && !this.menubarAdded) {
            this.createMenubar();
            this.jframe.setJMenuBar((JMenuBar)this.menubar);
            this.menubarAdded = true;
        } else if (!this.okToAddMenubar && this.menubarAdded) {
            this.jframe.setJMenuBar(null);
            this.menubarAdded = false;
        }
    }

    private void createMenubar() {
        this.menubar = new MJMenuBar();
        this.menubar.setName("MenuBar");
        if (this.okToAddMenusToMenubar) {
            this.addDefaultMenus();
        }
        this.addClientMenus();
        if (this.okToAddMenusToMenubar) {
            this.addHelpMenu();
        }
        this.sortMenus();
        this.fileMenu.setMnemonic(70);
        this.editMenu.setMnemonic(69);
        this.viewMenu.setMnemonic(86);
        this.toolsMenu.setMnemonic(84);
        this.helpMenu.setMnemonic(72);
        this.fileMenu.addMenuListener((MenuListener)this);
        this.editMenu.addMenuListener((MenuListener)this);
        this.viewMenu.addMenuListener((MenuListener)this);
        this.toolsMenu.addMenuListener((MenuListener)this);
        this.helpMenu.addMenuListener((MenuListener)this);
        if (this.printer == null) {
            this.printer = new Print(this);
        }
    }

    private void createDockedMenubar() {
        this.menubar = new MJMenuBar();
        this.scanMenuItem = new MJMenuItem("Scan For All Hardware");
        this.scanMenuItem.addActionListener((ActionListener)this);
        this.scanMenuItem.putClientProperty((Object)ACTION, (Object)new Integer(4));
        this.toolsMenu.add((JMenuItem)this.scanMenuItem);
        this.addClientMenus();
        this.addHelpMenu();
        this.sortMenus();
        DTMenuMergeTag.FILE.setTag((JMenuItem)this.fileMenu);
        DTMenuMergeTag.EDIT.setTag((JMenuItem)this.editMenu);
        DTMenuMergeTag.HELP.setTag((JMenuItem)this.helpMenu);
    }

    public MJMenuBar getMenubar() {
        return this.menubar;
    }

    private void addDefaultMenus() {
        this.printMenuItem = new MJMenuItem("Print...");
        this.printMenuItem.addActionListener((ActionListener)this);
        this.printMenuItem.putClientProperty((Object)ACTION, (Object)new Integer(1));
        this.printMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.printDetailMenuItem = new MJMenuItem("Print Detail View...");
        this.printDetailMenuItem.addActionListener((ActionListener)this);
        this.printDetailMenuItem.putClientProperty((Object)ACTION, (Object)new Integer(5));
        this.printDetailMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        MJMenuItem mJMenuItem = new MJMenuItem("Close");
        mJMenuItem.addActionListener((ActionListener)this);
        mJMenuItem.putClientProperty((Object)ACTION, (Object)new Integer(0));
        this.fileMenu.add((JMenuItem)this.printMenuItem);
        this.fileMenu.add((JMenuItem)this.printDetailMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add((JMenuItem)mJMenuItem);
        MJMenuItem mJMenuItem2 = new MJMenuItem("Collapse All");
        mJMenuItem2.addActionListener((ActionListener)this);
        mJMenuItem2.putClientProperty((Object)ACTION, (Object)new Integer(2));
        MJMenuItem mJMenuItem3 = new MJMenuItem("Expand All");
        mJMenuItem3.addActionListener((ActionListener)this);
        mJMenuItem3.putClientProperty((Object)ACTION, (Object)new Integer(3));
        this.viewMenu.add((JMenuItem)mJMenuItem2);
        this.viewMenu.add((JMenuItem)mJMenuItem3);
        this.scanMenuItem = new MJMenuItem("Scan For All Hardware");
        this.scanMenuItem.addActionListener((ActionListener)this);
        this.scanMenuItem.putClientProperty((Object)ACTION, (Object)new Integer(4));
        this.toolsMenu.add((JMenuItem)this.scanMenuItem);
    }

    private void addClientMenus() {
        for (int i = 0; i < this.allBrowserTreeDetail.size(); ++i) {
            BrowserTreeDetail browserTreeDetail = this.allBrowserTreeDetail.elementAt(i);
            BrowserClient[] browserClientArray = browserTreeDetail.getBrowserClients();
            for (int j = 0; j < browserClientArray.length; ++j) {
                if (browserClientArray[j].getMenus() == null) continue;
                this.addMenus(browserClientArray[j].getMenus());
            }
        }
    }

    private void addMenus(JMenu[] jMenuArray) {
        for (int i = 0; i < jMenuArray.length; ++i) {
            JMenu jMenu = jMenuArray[i];
            JMenu jMenu2 = this.getMenu(jMenu.getText());
            if (jMenu2 != null) {
                this.appendMenuItems(jMenu2, jMenu);
                continue;
            }
            this.menusToAdd.addElement(jMenu);
            this.menuCount[this.menusToAdd.size() - 1] = 1;
        }
    }

    private void addHelpMenu() {
        BrowserTreeDetail browserTreeDetail;
        int n;
        int n2 = 0;
        for (n = 0; n < this.allBrowserTreeDetail.size(); ++n) {
            browserTreeDetail = this.allBrowserTreeDetail.elementAt(n);
            int n3 = browserTreeDetail.addHelpMenu((JMenu)this.helpMenu, n2);
            n2 += n3;
        }
        this.helpMenu.addSeparator();
        for (n = 0; n < this.allBrowserTreeDetail.size(); ++n) {
            browserTreeDetail = this.allBrowserTreeDetail.elementAt(n);
            browserTreeDetail.addAboutMenu((JMenu)this.helpMenu);
        }
    }

    private void appendMenuItems(JMenu jMenu, JMenu jMenu2) {
        int n = jMenu.getItemCount();
        for (int i = jMenu2.getItemCount() - 1; i >= 0; --i) {
            JMenuItem jMenuItem = jMenu2.getItem(i);
            if (jMenuItem != null) {
                jMenu.insert(jMenuItem, n);
                continue;
            }
            jMenu.insertSeparator(n);
        }
    }

    private JMenu getMenu(String string) {
        if (string.equals("File")) {
            return this.fileMenu;
        }
        if (string.equals("Help")) {
            return this.helpMenu;
        }
        if (string.equals("Edit")) {
            return this.editMenu;
        }
        if (string.equals("View")) {
            return this.viewMenu;
        }
        if (string.equals("Tools")) {
            return this.toolsMenu;
        }
        for (int i = 0; i < this.menusToAdd.size(); ++i) {
            if (!this.menusToAdd.elementAt(i).getText().equals(string)) continue;
            this.menuCount[i] = this.menuCount[i] + 1;
            return this.menusToAdd.elementAt(i);
        }
        return null;
    }

    public void enableMenuItem(String string, String string2, boolean bl) {
        JMenu jMenu = this.getMenu(string);
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null || !jMenuItem.getText().equals(string2)) continue;
            jMenuItem.setEnabled(bl);
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    AWTUtilities.invokeAndWait((Runnable)this);
                }
                catch (Throwable throwable) {}
                continue;
            }
            this.run();
        }
    }

    public void renameMenuItem(String string, String string2, String string3) {
        JMenu jMenu = this.getMenu(string);
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null || !jMenuItem.getText().equals(string2)) continue;
            jMenuItem.setText(string3);
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    AWTUtilities.invokeAndWait((Runnable)this);
                }
                catch (Throwable throwable) {}
                continue;
            }
            this.run();
        }
    }

    @Override
    public void run() {
        String string;
        if (this.printMenuItem.isEnabled() != this.printToolbarButton.isEnabled()) {
            this.printToolbarButton.setEnabled(this.printMenuItem.isEnabled());
        }
        if (this.scanMenuItem.isEnabled() != this.scanToolbarButton.isEnabled()) {
            this.scanToolbarButton.setEnabled(this.scanMenuItem.isEnabled());
        }
        if (!(string = this.removeTrailingEllipse(this.printMenuItem.getText())).equals(this.printToolbarButton.getToolTipText())) {
            this.printToolbarButton.setToolTipText(string);
        }
        if (!(string = this.removeTrailingEllipse(this.scanMenuItem.getText())).equals(this.scanToolbarButton.getToolTipText())) {
            this.scanToolbarButton.setToolTipText(string);
        }
    }

    private String removeTrailingEllipse(String string) {
        return string.endsWith("...") ? string.substring(0, string.length() - 3) : string;
    }

    private void sortMenus() {
        int n;
        if (this.fileMenu.getItemCount() > 0) {
            this.menubar.add((JMenu)this.fileMenu);
        }
        if (this.editMenu.getItemCount() > 0) {
            this.menubar.add((JMenu)this.editMenu);
        }
        if (this.viewMenu.getItemCount() > 0) {
            this.menubar.add((JMenu)this.viewMenu);
        }
        Vector<JMenu> vector = new Vector<JMenu>();
        for (n = 0; n < this.menusToAdd.size(); ++n) {
            int n2 = this.getMenuCountMaxIndex();
            int n3 = this.menuCount[n2];
            if (n3 == 0) continue;
            this.menuCount[n2] = 0;
            vector.addElement(this.menusToAdd.elementAt(n2));
        }
        for (n = 0; n < vector.size(); ++n) {
            this.menubar.add((JMenu)vector.elementAt(n));
        }
        if (this.toolsMenu.getItemCount() > 0) {
            this.menubar.add((JMenu)this.toolsMenu);
        }
        if (this.helpMenu.getItemCount() > 0) {
            this.menubar.add((JMenu)this.helpMenu);
        }
    }

    private int getMenuCountMaxIndex() {
        int n = this.menuCount[0];
        int n2 = 0;
        for (int i = 1; i < this.menuCount.length; ++i) {
            if (this.menuCount[i] <= n) continue;
            n = this.menuCount[i];
            n2 = i;
        }
        return n2;
    }

    private void updateMenusBasedOnCurrentNode(BrowserClient browserClient, BrowserTreeNode browserTreeNode, BrowserTreeNode browserTreeNode2, BrowserTreeNode[] browserTreeNodeArray) {
        JMenu[] jMenuArray = browserClient.getMenus(browserTreeNode, browserTreeNode2, browserTreeNodeArray);
        if (!browserTreeNode.isMenuUpdated()) {
            return;
        }
        this.removeNodeMenus();
        this.menusToRemove = null;
        if (jMenuArray != null) {
            this.addNodeMenus(jMenuArray);
        }
        this.updateHelpMenuBasedOnCurrentNode(browserTreeNode);
    }

    private void removeNodeMenus() {
        if (this.menusToRemove == null) {
            return;
        }
        for (int i = 0; i < this.menusToRemove.length; ++i) {
            JMenu jMenu = this.getMenu(this.menusToRemove[i]);
            JMenu jMenu2 = this.nodeMenusAdded[i];
            jMenu2.removeAll();
            if (jMenu == null) continue;
            for (int j = 0; j < this.nodeMenuCount[i]; ++j) {
                JMenuItem jMenuItem = jMenu.getItem(i);
                if (jMenuItem != null) {
                    jMenu2.insert(jMenuItem, j);
                    continue;
                }
                jMenu2.insertSeparator(j);
            }
            try {
                JMenuItem jMenuItem = jMenu.getItem(0);
                while (jMenuItem == null) {
                    jMenu.remove(0);
                    jMenuItem = jMenu.getItem(0);
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addNodeMenus(JMenu[] jMenuArray) {
        this.nodeMenuCount = new int[jMenuArray.length];
        this.menusToRemove = new String[jMenuArray.length];
        this.nodeMenusAdded = jMenuArray;
        for (int i = 0; i < jMenuArray.length; ++i) {
            JMenu jMenu = jMenuArray[i];
            JMenu jMenu2 = this.getMenu(jMenu.getText());
            if (jMenu2 != null) {
                this.nodeMenuCount[i] = jMenu.getItemCount();
                this.menusToRemove[i] = jMenu.getText();
                this.appendNodeMenuItems(jMenu2, jMenu);
                continue;
            }
            this.nodeMenuCount[i] = 0;
            this.menusToRemove[i] = "";
        }
    }

    private void appendNodeMenuItems(JMenu jMenu, JMenu jMenu2) {
        for (int i = jMenu2.getItemCount() - 1; i >= 0; --i) {
            JMenuItem jMenuItem = jMenu2.getItem(i);
            if (jMenuItem != null) {
                jMenu.insert(jMenuItem, 0);
                continue;
            }
            jMenu.insertSeparator(0);
        }
    }

    private void updateHelpMenuBasedOnCurrentNode(BrowserTreeNode browserTreeNode) {
        String string = browserTreeNode.getHelpMenuLabel();
        if (!this.addedHelpMenuBasedOnNode && string == null) {
            this.addedHelpMenuBasedOnNode = false;
            return;
        }
        if (this.addedHelpMenuBasedOnNode && string == null) {
            this.helpMenu.remove(0);
            this.helpMenu.remove(0);
            this.addedHelpMenuBasedOnNode = false;
            return;
        }
        if (this.addedHelpMenuBasedOnNode && string != null) {
            this.helpMenu.getItem(0).setText(string);
            this.addedHelpMenuBasedOnNode = true;
            return;
        }
        if (!this.addedHelpMenuBasedOnNode && string != null) {
            this.helpMenuBasedOnNode = new JMenuItem(string);
            this.helpMenu.insertSeparator(0);
            this.helpMenu.insert(this.helpMenuBasedOnNode, 0);
            this.helpMenuBasedOnNode.putClientProperty(ACTION, new Integer(6));
            this.helpMenuBasedOnNode.addActionListener(this);
            this.addedHelpMenuBasedOnNode = true;
        }
    }

    private void configureStatusbar() {
        if (this.jframe == null) {
            return;
        }
        boolean bl = false;
        if (this.statusbarPanel == null) {
            bl = true;
            this.statusbarPanel = new JPanel(new BorderLayout(0, 0));
        }
        if (this.okToAddStatusbar && !this.statusbarAdded) {
            this.createStatusbar();
            this.statusbarPanel.add((Component)this.statusbar, "Center");
            this.addToSouthPanel(this.statusbarPanel, "South");
            this.statusbarAdded = true;
        } else if (!this.okToAddStatusbar && this.statusbarAdded) {
            this.remove(this.statusbarPanel);
            this.statusbarAdded = false;
        }
        if (bl) {
            MJCornerGrip mJCornerGrip = new MJCornerGrip();
            mJCornerGrip.setComponentToResize((Component)this.jframe);
            this.statusbarPanel.add((Component)mJCornerGrip, "East");
        }
    }

    private void createStatusbar() {
        if (this.statusbar != null) {
            return;
        }
        this.statusbar = new MJStatusBar();
        this.statusbar.setText("Ready");
    }

    public MJStatusBar getStatusbar() {
        return this.statusbar;
    }

    @Override
    public void postStatusBarMessage(String string) {
        if (this.statusbar != null) {
            if (string == null || string.length() == 0) {
                this.statusbar.setText(" ");
            } else {
                this.statusbar.setText(string);
            }
        }
    }

    private void configureToolbar() {
        if (this.jframe == null) {
            return;
        }
        if (this.okToAddToolbar && !this.toolbarAdded) {
            this.createToolbar();
            this.add((Component)this.toolbar, "North");
            this.toolbarAdded = true;
        } else if (!this.okToAddToolbar && this.toolbarAdded) {
            this.remove((Component)this.toolbar);
            this.toolbarAdded = false;
        }
    }

    private void createToolbar() {
        if (this.toolbar != null) {
            return;
        }
        this.toolbar = new MJToolBar();
        this.toolbar.setFloatable(true);
        this.addToolbarButtons();
        if (this.printer == null) {
            this.printer = new Print(this);
        }
    }

    private void createDockedToolbar() {
        this.toolbar = new MJToolBar();
        this.scanToolbarButton = this.createToolbarButton(scanImage, "Scan For All Hardware", 4);
        this.toolbar.add((Component)this.scanToolbarButton);
        for (int i = 0; i < this.allBrowserTreeDetail.size(); ++i) {
            this.allBrowserTreeDetail.elementAt(i).addToolbarButtons(this.toolbar);
        }
    }

    public MJToolBar getToolbar() {
        return this.toolbar;
    }

    private void addToolbarButtons() {
        if (this.okToAddButtonsToToolbar) {
            this.printToolbarButton = this.createToolbarButton(printIcon, "Print", 1);
            this.scanToolbarButton = this.createToolbarButton(scanImage, "Scan For All Hardware", 4);
            this.toolbar.add((Component)this.printToolbarButton);
            this.toolbar.addSeparator();
            this.toolbar.add((Component)this.scanToolbarButton);
        }
        for (int i = 0; i < this.allBrowserTreeDetail.size(); ++i) {
            this.allBrowserTreeDetail.elementAt(i).addToolbarButtons(this.toolbar);
        }
    }

    private MJButton createToolbarButton(ImageIcon imageIcon, String string, int n) {
        MJButton mJButton = new MJButton((Icon)imageIcon);
        mJButton.setToolTipText(string);
        mJButton.setFlyOverAppearance(true);
        mJButton.setFocusTraversable(false);
        mJButton.setPreferredSize(new Dimension(30, 22));
        mJButton.setMinimumSize(new Dimension(30, 22));
        mJButton.setMaximumSize(new Dimension(30, 22));
        mJButton.addActionListener((ActionListener)this);
        mJButton.putClientProperty((Object)ACTION, (Object)new Integer(n));
        return mJButton;
    }

    public void createGlassPane() {
        this.glassPane = new GlassPane(this.jframe);
        this.jframe.setGlassPane((Component)this.glassPane);
        this.glassPane.setVisible(false);
    }

    @Override
    public void blockEvents(boolean bl) {
        try {
            this.getRootPane().getGlassPane().setVisible(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createHelpViewer() {
        if (this.helpView != null) {
            return;
        }
        this.helpView = new HelpPanel();
    }

    public HelpPanel getHelpPanel() {
        return this.helpView;
    }

    public void setDetailPanel(JPanel jPanel) {
        this.detailPanel = jPanel;
    }

    public JSplitPane getHelpPane() {
        return this.helpPane;
    }

    public JSplitPane getOuterPane() {
        return this.outerPane;
    }

    public void setHelpView(HelpPanel helpPanel) {
        this.helpView = helpPanel;
    }

    protected void updateHelp() {
        this.updateHelp(this.currentNode);
    }

    private void updateHelp(BrowserTreeNode browserTreeNode) {
        boolean bl;
        boolean bl2;
        if (this.helpDecoration == null) {
            return;
        }
        boolean bl3 = bl2 = this.browserLayout == 1;
        if (bl2) {
            bl2 = this.helpDecoration.isHelpShown();
        }
        boolean bl4 = bl = !browserTreeNode.getShowHelpOnly();
        if (!bl) {
            bl2 = true;
        }
        if (this.lastShowHelpState == bl2 && this.lastShowDetailView == bl) {
            this.updateHtmlPage(browserTreeNode.getHelpDirectory(), browserTreeNode.getHelpPage());
            if (!this.lastShowHelpState && this.helpPane.getRightComponent() == null || this.lastShowHelpState && this.helpPane.getRightComponent() != null) {
                return;
            }
        }
        if (this.lastShowHelpState && this.lastShowDetailView && !sFirstTimeUpdatingHelp) {
            this.helpPaneWidth = this.helpPane.getSize().width - this.helpPane.getDividerLocation();
        }
        sFirstTimeUpdatingHelp = false;
        if (this.lastShowHelpStateUpdate == NOT_OK && bl) {
            this.lastShowHelpStateUpdate = OK;
        }
        if (!bl2 && bl) {
            this.setHelpPaneLeftComponent(this.detailPanel);
            this.setHelpPaneRightComponent(null);
            this.helpDecoration.showHelpButton(true);
        } else if (bl2 && !bl) {
            this.setHelpPaneLeftComponent(null);
            this.setHelpPaneRightComponent((Component)this.helpView);
            this.helpDecoration.showHelpButton(false);
            this.updateHtmlPage(browserTreeNode.getHelpDirectory(), browserTreeNode.getHelpPage());
            this.restoreHelpPaneWidth();
        } else if (bl2 && bl) {
            this.setHelpPaneLeftComponent(this.detailPanel);
            this.setHelpPaneRightComponent((Component)this.helpView);
            this.helpDecoration.showHelpButton(true);
            this.updateHtmlPage(browserTreeNode.getHelpDirectory(), browserTreeNode.getHelpPage());
            this.restoreHelpPaneWidth();
        }
        if (this.lastShowHelpStateUpdate == OK) {
            this.lastShowHelpState = bl2;
        }
        this.lastShowDetailView = bl;
    }

    private void setHelpPaneRightComponent(Component component) {
        if (this.helpPane.getRightComponent() != component) {
            this.helpPane.setRightComponent(component);
        }
    }

    private void setHelpPaneLeftComponent(Component component) {
        if (this.helpPane.getLeftComponent() != component) {
            this.helpPane.setLeftComponent(component);
        }
    }

    private void updateHtmlPage(String string, String string2) {
        if (string2 != null && !string2.equals("")) {
            this.helpView.showHelpPage(string, string2);
        } else {
            this.helpView.setHtmlText("<html></html>");
        }
    }

    private void restoreHelpPaneWidth() {
        this.restoreHelpPaneWidth(this.helpPane.getSize().width);
    }

    private void restoreHelpPaneWidth(int n) {
        if (n > this.helpPaneWidth && this.helpPaneWidth > 0) {
            this.helpPane.setDividerLocation(n - this.helpPaneWidth);
        } else {
            this.helpPane.setDividerLocation(n / 2);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = (Integer)((JComponent)actionEvent.getSource()).getClientProperty(ACTION);
        switch (n) {
            case 0: {
                this.closeBrowserWindow();
                break;
            }
            case 1: {
                this.printer.setComponentToPrint(this.outerPane);
                this.printer.print();
                break;
            }
            case 5: {
                this.printer.setComponentToPrint(this.outerPane.getRightComponent());
                this.printer.print();
                break;
            }
            case 2: {
                this.treeView.collapseAll();
                break;
            }
            case 3: {
                this.treeView.expandAll();
                break;
            }
            case 6: {
                this.currentNode.getClient().helpMenuActionPerformed(this.helpMenuBasedOnNode.getText());
                break;
            }
            case 4: {
                this.refresh();
            }
        }
    }

    private void refresh() {
        this.scanToolbarButton.setEnabled(false);
        for (int i = 0; i < this.allBrowserTreeDetail.size(); ++i) {
            this.allBrowserTreeDetail.elementAt(i).refresh();
        }
        this.scanToolbarButton.setEnabled(true);
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        if (this.currentNode != null && this.currentNode.getClient() != null) {
            this.currentNode.getClient().menuSelected(((JMenu)menuEvent.getSource()).getText(), (JMenu)menuEvent.getSource(), this.currentNode);
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        if (!NativeJava.isMaximized((Window)this.jframe)) {
            this.frameX = this.jframe.getX();
            this.frameY = this.jframe.getY();
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (!NativeJava.isMaximized((Window)this.jframe)) {
            this.frameWidth = this.jframe.getWidth();
            this.frameHeight = this.jframe.getHeight();
        }
    }

    protected void displayCannotCloseDialog() {
        MJOptionPane.showConfirmDialog((Component)this.jframe, (Object)"The window cannot be closed until the current operation completes.", (String)this.jframe.getTitle(), (int)-1, (int)1);
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (this.getRootPane().getGlassPane().isVisible()) {
            Thread thread = new Thread(new DialogRunnable());
            thread.start();
            return;
        }
        this.closeBrowserWindow();
    }

    public void closeBrowserWindow() {
        this.cleanup(this.jframe);
        this.jframe.removeWindowListener((WindowListener)this);
        this.jframe.removeComponentListener((ComponentListener)this);
        this.jframe.dispose();
        this.jframe = null;
    }

    public void cleanup(MJFrame mJFrame) {
        BrowserConfigFileWriter browserConfigFileWriter = null;
        if (!this.configFileName.equals("")) {
            browserConfigFileWriter = new BrowserConfigFileWriter(this.configFileName);
        }
        this.saveBrowserSettingsBeforeClosing(browserConfigFileWriter, mJFrame);
        for (int i = 0; i < this.allBrowserTreeDetail.size(); ++i) {
            BrowserTreeDetail browserTreeDetail = this.allBrowserTreeDetail.elementAt(i);
            browserTreeDetail.cleanup(this, browserConfigFileWriter);
        }
        if (browserConfigFileWriter != null) {
            browserConfigFileWriter.saveToFile();
        }
        if (this.helpDecoration != null) {
            this.helpDecoration.cleanup();
        }
        if (this.printer != null) {
            this.printer.cleanup();
        }
        if (this.outerPane != null) {
            this.outerPane.removeAll();
        }
        if (this.helpPane != null) {
            this.helpPane.removeAll();
        }
        this.helpView.dispose();
        this.outerPane = null;
        this.helpView = null;
        this.detailView = null;
        this.helpPane = null;
        this.toolbar = null;
        this.menubar = null;
    }

    private void saveBrowserSettingsBeforeClosing(BrowserConfigFileWriter browserConfigFileWriter, MJFrame mJFrame) {
        if (browserConfigFileWriter == null) {
            return;
        }
        Element element = browserConfigFileWriter.addToolboxNode("Browser");
        Element element2 = browserConfigFileWriter.addNode(element, "Layout");
        element2.setAttribute("ShowHelp", TMStringUtil.bool2str(this.lastShowHelpState));
        if (mJFrame == null) {
            return;
        }
        if (mJFrame != this.jframe) {
            Dimension dimension = mJFrame.getSize();
            Point point = mJFrame.getLocation();
            this.frameWidth = dimension.width;
            this.frameHeight = dimension.height;
            this.frameX = point.x;
            this.frameY = point.y;
        }
        element2.setAttribute("IsMaximized", TMStringUtil.bool2str(NativeJava.isMaximized((Window)mJFrame)));
        element2.setAttribute("FrameWidth", String.valueOf(this.frameWidth));
        element2.setAttribute("FrameHeight", String.valueOf(this.frameHeight));
        element2.setAttribute("FrameX", String.valueOf(this.frameX));
        element2.setAttribute("FrameY", String.valueOf(this.frameY));
        if (this.helpPane != null) {
            if (this.currentNode == null || !this.currentNode.getShowHelpOnly()) {
                element2.setAttribute("HelpPaneWidth", String.valueOf(this.helpPane.getSize().width - this.helpPane.getDividerLocation()));
            } else {
                element2.setAttribute("HelpPaneWidth", String.valueOf(this.helpPaneWidth));
            }
            element2.setAttribute("HelpPaneTotalWidth", String.valueOf(this.helpPane.getSize().width));
        }
        if (this.outerPane != null) {
            int n = this.outerPane.getLastDividerLocation();
            if (n == -1) {
                element2.setAttribute("OuterPaneDividerLoc", String.valueOf(this.outerPaneDividerLoc));
            } else {
                element2.setAttribute("OuterPaneDividerLoc", String.valueOf(n));
            }
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    private class DialogRunnable
    implements Runnable {
        private DialogRunnable() {
        }

        @Override
        public void run() {
            Browser.this.displayCannotCloseDialog();
        }
    }
}

