/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.source.impl;

import com.mathworks.comparisons.collection.ComparisonCollection;
import com.mathworks.comparisons.collection.ComparisonCollectionFactory;
import com.mathworks.comparisons.collection.impl.ZipFileCollection;
import com.mathworks.comparisons.source.impl.ComparisonSourceImpl;
import com.mathworks.comparisons.source.info.CSPInfoIncludeRelativeFrom;
import com.mathworks.comparisons.source.info.CSPInfoIncludeSubFolders;
import com.mathworks.comparisons.source.type.CSTypeFile;
import com.mathworks.comparisons.source.type.CSTypeFolder;
import com.mathworks.comparisons.util.LocalIOUtils;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class ZipEntrySource
extends ComparisonSourceImpl {
    private static final int DEFAULT_BUFFER_SIZE = 16384;
    private final File mFile;
    private final String mFileName;
    private final ZipEntry mEntry;
    private final String mEntryName;
    private ZipFile mZipFile = null;
    private File mTempFile = null;
    private InputStream mInputStream = null;

    public ZipEntrySource(File file, String string, ZipEntry zipEntry) {
        this(file, string, zipEntry, zipEntry.getName());
    }

    public ZipEntrySource(File file, String string, ZipEntry zipEntry, String string2) {
        this.mFile = file;
        this.mFileName = string;
        this.mEntry = zipEntry;
        this.mEntryName = string2;
        if (this.mEntry.isDirectory()) {
            this.setType(new CSTypeFolder());
        } else {
            this.setType(new CSTypeFile());
        }
    }

    public static ZipEntrySource createFolderPlaceholder(File file, String string, String string2) {
        ZipEntry zipEntry = new ZipEntry(string);
        return new ZipEntrySource(file, string, zipEntry, string2);
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    @Override
    public void refresh() {
        this.dispose();
    }

    @Override
    public void dispose() {
        if (this.mZipFile != null) {
            try {
                this.mZipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mZipFile = null;
            this.mInputStream = null;
        }
        if (this.mTempFile != null) {
            this.mTempFile.delete();
            this.mTempFile = null;
        }
    }

    private String getName() {
        return this.mEntryName;
    }

    private long getSize() {
        return this.mEntry.getSize();
    }

    private Date getLastModifiedDate() {
        return new Date(this.mEntry.getTime());
    }

    private String getTitle() {
        return LocalIOUtils.truncatePathName(this.mEntry.getName());
    }

    private String getShortTitle() {
        String string = this.mEntry.getName();
        if (this.mEntry.isDirectory()) {
            return LocalIOUtils.getFileName(string.substring(0, string.length() - 1)) + "/";
        }
        return LocalIOUtils.getFileName(string);
    }

    private synchronized File getReadableLocation() {
        if (this.mTempFile == null) {
            String string = this.mEntry.getName().replace(File.separator, "_");
            if (!File.separator.equals("/")) {
                string = string.replace('/', '_');
            }
            try {
                this.mTempFile = LocalIOUtils.createTempFile("zip_entry_", string);
                LocalIOUtils.copyStreamToFile(this.getInputStream(), this.mTempFile);
            }
            catch (IOException iOException) {
                Log.logException((Exception)iOException);
            }
        }
        return this.mTempFile;
    }

    private String getAbsoluteName() {
        return ResourceManager.format("zipentrysource.absolutename", this.mEntry.getName(), this.mFile.getAbsolutePath());
    }

    private synchronized InputStream getInputStream() {
        this.initZipFile();
        if (this.mInputStream == null) {
            try {
                this.mInputStream = this.mZipFile.getInputStream(this.mEntry);
            }
            catch (IOException iOException) {
                Log.logException((Exception)iOException);
            }
        }
        return this.mInputStream;
    }

    private ComparisonCollection getComparisonCollection(CSPInfoIncludeSubFolders cSPInfoIncludeSubFolders, CSPInfoIncludeRelativeFrom cSPInfoIncludeRelativeFrom) {
        assert (this.mEntry.isDirectory());
        CSPInfoIncludeRelativeFrom cSPInfoIncludeRelativeFrom2 = new CSPInfoIncludeRelativeFrom(cSPInfoIncludeRelativeFrom.getValue() + this.mEntry.getName());
        return ComparisonCollectionFactory.createFromFile(ZipFileCollection.class, this.mFileName, this.mFile, cSPInfoIncludeSubFolders, cSPInfoIncludeRelativeFrom2);
    }

    private void initZipFile() {
        if (this.mZipFile == null) {
            try {
                this.mZipFile = new ZipFile(this.mFile);
            }
            catch (IOException iOException) {
                Log.logException((Exception)iOException);
            }
        }
    }
}

