/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.source.impl;

import com.mathworks.comparisons.collection.ComparisonCollection;
import com.mathworks.comparisons.collection.ComparisonCollectionFactory;
import com.mathworks.comparisons.collection.impl.LocalFolderCollection;
import com.mathworks.comparisons.source.impl.ComparisonSourceImpl;
import com.mathworks.comparisons.source.info.CSPInfoIncludeRelativeFrom;
import com.mathworks.comparisons.source.info.CSPInfoIncludeSubFolders;
import com.mathworks.comparisons.source.type.CSTypeFile;
import com.mathworks.comparisons.source.type.CSTypeFolder;
import com.mathworks.comparisons.util.ExceptionHandler;
import com.mathworks.comparisons.util.LocalIOUtils;
import com.mathworks.comparisons.util.ResourceManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Date;

public final class LocalFileSource
extends ComparisonSourceImpl {
    private final String mName;
    private final File mFile;
    private InputStream mInputStream = null;

    public LocalFileSource(File file, String string) throws FileNotFoundException, IllegalArgumentException {
        this.checkArgument(file);
        this.mFile = file;
        this.mName = string;
        if (this.mFile.isDirectory()) {
            this.setType(new CSTypeFolder());
        } else {
            this.setType(new CSTypeFile());
        }
    }

    @Override
    public synchronized void refresh() {
        this.dispose();
    }

    @Override
    public synchronized void dispose() {
        if (this.mInputStream != null) {
            LocalIOUtils.closeQuietly(this.mInputStream);
            this.mInputStream = null;
        }
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    private String getName() {
        return this.mName;
    }

    private String getAbsoluteName() {
        return this.mFile.getAbsolutePath();
    }

    private long getSize() {
        long l = 0L;
        if (this.mFile.exists() && !this.mFile.isDirectory()) {
            l = this.mFile.length();
        }
        return l;
    }

    private Date getLastModifiedDate() {
        Date date = null;
        if (this.mFile.exists()) {
            long l = this.mFile.lastModified();
            date = new Date(l);
        }
        return date;
    }

    private String getTitle() {
        return LocalIOUtils.truncatePathName(this.mName);
    }

    private String getShortTitle() {
        return this.mFile.getName();
    }

    private File getReadableLocation() {
        return this.mFile;
    }

    private synchronized InputStream getInputStream() {
        if (this.mInputStream == null) {
            try {
                this.mInputStream = new BufferedInputStream(new FileInputStream(this.mFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = ResourceManager.format("exception.readfilefailure", fileNotFoundException.getMessage());
                throw new RuntimeException(string);
            }
        }
        return this.mInputStream;
    }

    private ComparisonCollection getComparisonCollection(CSPInfoIncludeSubFolders cSPInfoIncludeSubFolders, CSPInfoIncludeRelativeFrom cSPInfoIncludeRelativeFrom) {
        if (!this.mFile.exists()) {
            ExceptionHandler.rethrow(new FileNotFoundException(ResourceManager.format("exception.filenotfound", this.mFile.getPath())));
        }
        return ComparisonCollectionFactory.createFromFile(LocalFolderCollection.class, this.mName, this.mFile, cSPInfoIncludeSubFolders, cSPInfoIncludeRelativeFrom);
    }

    private void checkArgument(File file) throws FileNotFoundException, IllegalArgumentException {
        if (!file.exists()) {
            throw new FileNotFoundException(ResourceManager.format("exception.filenotfound", file.getPath()));
        }
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException(ResourceManager.format("exception.absolutefilename", file.getPath()));
        }
    }
}

