/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.selection.dialog;

import com.mathworks.comparisons.event.ComparisonEvent;
import com.mathworks.comparisons.event.ComparisonEventListener;
import com.mathworks.comparisons.event.ComparisonEventSupport;
import com.mathworks.comparisons.event.data.CEventDataSelectionDialogCreated;
import com.mathworks.comparisons.event.data.CEventDataSelectionDialogDisposed;
import com.mathworks.comparisons.event.data.CEventDataSelectionReady;
import com.mathworks.comparisons.register.ComparisonTypeRegister;
import com.mathworks.comparisons.selection.ComparisonSelection;
import com.mathworks.comparisons.selection.SelectionPoliciesRegister;
import com.mathworks.comparisons.selection.dialog.SourceSelectionListModel;
import com.mathworks.comparisons.selection.dialog.SourceSelectionPanelBuilder;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;

public final class SourceSelectionDialog {
    public static final String SOURCE_SELECTION_DIALOG = "SourceSelectionDialog";
    private final ComparisonEventSupport mEventSupport = new ComparisonEventSupport();
    private final SourceSelectionPanelBuilder mPanelBuilder;
    private MJPanel mPanel = null;
    private MJDialog mDialog = null;
    private Frame mParentFrame = null;

    public SourceSelectionDialog(ComparisonEventListener comparisonEventListener, ComparisonTypeRegister comparisonTypeRegister, SelectionPoliciesRegister selectionPoliciesRegister, SourceSelectionListModel sourceSelectionListModel, ComparisonSelection comparisonSelection) {
        this.mEventSupport.addComparisonEventListener(comparisonEventListener);
        this.mPanelBuilder = new SourceSelectionPanelBuilder(comparisonTypeRegister, selectionPoliciesRegister, sourceSelectionListModel, comparisonSelection);
    }

    public void showDialog() {
        if (this.mDialog != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SourceSelectionDialog.this.doShowDialog();
                }
            });
        }
    }

    private synchronized void doShowDialog() {
        if (this.mDialog != null) {
            this.mPanelBuilder.setInitialSelections();
            this.mDialog.setVisible(true);
        }
    }

    public void attach(final Frame frame) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (frame != SourceSelectionDialog.this.mParentFrame) {
                    boolean bl = SourceSelectionDialog.this.mDialog == null ? true : SourceSelectionDialog.this.mDialog.isVisible();
                    SourceSelectionDialog.this.mParentFrame = frame;
                    SourceSelectionDialog.this.destroy();
                    SourceSelectionDialog.this.create();
                    if (bl) {
                        SourceSelectionDialog.this.mEventSupport.fireComparisonEvent(new ComparisonEvent(this, CEventDataSelectionDialogCreated.getInstance()));
                    }
                }
            }
        });
    }

    public void dispose() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SourceSelectionDialog.this.destroy();
                SourceSelectionDialog.this.mPanelBuilder.dispose();
                SourceSelectionDialog.this.mPanel = null;
                SourceSelectionDialog.this.mEventSupport.fireComparisonEvent(new ComparisonEvent(this, CEventDataSelectionDialogDisposed.getInstance()));
                SourceSelectionDialog.this.mEventSupport.removeAllComparisonEventListeners();
            }
        });
    }

    private synchronized void create() {
        assert (SwingUtilities.isEventDispatchThread()) : "Wrong thread";
        if (this.mDialog == null) {
            if (this.mPanel == null) {
                this.mPanelBuilder.createPanel();
                this.mPanelBuilder.addCompareActionListener(new CompareAction());
                this.mPanelBuilder.addCancelActionListener(new CancelAction());
                this.mPanel = (MJPanel)this.mPanelBuilder.getComponent();
            }
            this.mDialog = new MJDialog(this.mParentFrame, false);
            this.mDialog.setDefaultCloseOperation(1);
            this.mDialog.setContentPane((Container)this.mPanel);
            this.mDialog.setName(SOURCE_SELECTION_DIALOG);
            this.mDialog.setTitle(ResourceManager.getString("selectiondialog.title"));
            this.mDialog.pack();
            this.mDialog.setMinimumSize(this.mDialog.getPreferredSize());
            this.mDialog.setLocationRelativeTo((Component)this.mParentFrame);
            this.mPanelBuilder.setInitialFocus();
        }
    }

    private synchronized void destroy() {
        assert (SwingUtilities.isEventDispatchThread()) : "Wrong thread";
        if (this.mDialog != null) {
            this.mDialog.dispose();
            this.mDialog = null;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SourceSelectionDialog.this.mDialog.setNonBlockingVisible(false);
        }
    }

    private class CompareAction
    implements ActionListener {
        private CompareAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SourceSelectionDialog.this.mDialog.setNonBlockingVisible(false);
            SourceSelectionDialog.this.mEventSupport.fireComparisonEvent(new ComparisonEvent(this, CEventDataSelectionReady.getInstance()));
        }
    }
}

