/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.report;

import com.mathworks.comparisons.main.ComparisonUtilities;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuBar;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.widgets.desk.DTGroupBase;
import com.mathworks.widgets.desk.DTGroupProperty;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTMenuOmission;
import com.mathworks.widgets.desk.DTProperty;
import com.mathworks.widgets.desk.Desktop;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;

public class ComparisonReportGroup
extends DTGroupBase {
    public static final String COMPONENT_GROUP_NAME = "File Comparisons";
    public static final String COMPONENT_NEW_COMPARISON = "New";
    private static ComparisonReportGroup sInstance = null;
    private Action mNewAction = null;
    private MJToolBar mGroupToolBar = null;
    private MJMenuBar mGroupMenuBar = null;

    public static synchronized ComparisonReportGroup getInstance() {
        if (sInstance == null) {
            sInstance = new ComparisonReportGroup();
        }
        return sInstance;
    }

    private ComparisonReportGroup() {
        this.initProperties();
        this.initActionsAndListeners();
        this.initLayout();
    }

    public Desktop getDesktop() {
        Desktop desktop = this.getParentDesktop();
        if (desktop == null && Matlab.isMatlabAvailable()) {
            desktop = MatlabDesktopServices.getDesktop();
        }
        return desktop;
    }

    private void initProperties() {
        this.setGroupName(COMPONENT_GROUP_NAME);
        this.setNeverReopenEmpty(true);
        this.setTitle(ResourceManager.getString("comparisonreportgroup.title"));
        this.setWillSupplyToolstripTabs(false);
        this.putGroupProperty((DTProperty)DTGroupProperty.LEGACY_TOOLSTRIP_TAB_TITLE, ResourceManager.getString("comparisonreportgroup.tabtitle"));
    }

    private void initLayout() {
        if (this.mGroupToolBar == null) {
            this.mGroupToolBar = this.createGroupToolBar();
        }
        if (this.mGroupMenuBar == null) {
            this.mGroupMenuBar = this.createGroupMenuBar();
        }
        this.setToolBar((JToolBar)this.mGroupToolBar);
        this.setMenuBar((JMenuBar)this.mGroupMenuBar);
    }

    private void initActionsAndListeners() {
        this.setDropListener(new IgnoreAllListener());
        this.mNewAction = new NewComparisonFromGroup();
    }

    static MJToolBar createEmptyToolBar() {
        MJToolBar mJToolBar = new MJToolBar(ResourceManager.getString("comparisonreport.toolbarname"));
        mJToolBar.setFloatable(false);
        return mJToolBar;
    }

    private MJToolBar createGroupToolBar() {
        MJToolBar mJToolBar = ComparisonReportGroup.createEmptyToolBar();
        mJToolBar.add(this.mNewAction);
        return mJToolBar;
    }

    private MJMenuBar createGroupMenuBar() {
        MJMenuBar mJMenuBar = new MJMenuBar();
        MJMenu mJMenu = new MJMenu();
        DTMenuMergeTag.FILE.setTag((JMenuItem)mJMenu);
        DTMenuMergeTag.NEW.setTag(this.mNewAction);
        mJMenu.add(this.mNewAction);
        mJMenu.add((JMenuItem)new DTMenuOmission(DTMenuMergeTag.OPEN));
        mJMenuBar.add((JMenu)mJMenu);
        return mJMenuBar;
    }

    private class IgnoreAllListener
    implements DropTargetListener {
        private IgnoreAllListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            dropTargetDragEvent.rejectDrag();
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            dropTargetDragEvent.rejectDrag();
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }
    }

    private class NewComparisonFromGroup
    extends MJAbstractAction {
        public NewComparisonFromGroup() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("comparisons", "comparisons-new", (ExtendedAction)this);
            this.setComponentName(ComparisonReportGroup.COMPONENT_NEW_COMPARISON);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ComparisonUtilities.startEmptyComparison();
        }
    }
}

